<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package PridMag
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'pridmag-single' ); ?>>
	<header class="entry-header">
		<?php
			if( true === get_theme_mod( 'pridmag_post_category_list', true) ) {
				pridmag_category_list(); 
			}
		?>
		<?php
			if ( is_singular() ) :
				the_title( '<h1 class="entry-title">', '</h1>' );
			else :
				the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
			endif;

		if ( 'post' === get_post_type() ) :
			?>
			<div class="entry-meta">
				<?php
					pridmag_entry_meta();
				?>
			</div><!-- .entry-meta -->
		<?php endif; ?>
	</header><!-- .entry-header -->

	<?php 
		if ( true === get_theme_mod( 'pridmag_single_thumbnail', true ) ) {
			pridmag_post_thumbnail( 'pridmag-featured' ); 
		}
	?>

	<div class="entry-content">
		<?php
		the_content( sprintf(
			wp_kses(
				/* translators: %s: Name of current post. Only visible to screen readers */
				__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'pridmag' ),
				array(
					'span' => array(
						'class' => array(),
					),
				)
			),
			get_the_title()
		) );

		wp_link_pages( array(
			'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'pridmag' ),
			'after'  => '</div>',
		) );
		?>
	</div><!-- .entry-content -->

	<footer class="entry-footer">
		<?php
			if ( true === get_theme_mod( 'pridmag_tags_list', true ) ) {
				pridmag_tags_list(); 
			}
		?>
		<?php pridmag_entry_footer(); ?>
	</footer><!-- .entry-footer -->
</article><!-- #post-<?php the_ID(); ?> -->