<?php

// The below lines are called "ternary operators".  They are required for your security.
// Basically, it defines the "$foo" value like so (if you want the English translation):
// 
// "If the posting of $foo exists, then the value of $foo is taken : otherwise, the value
// if $foo is nothing."
//
// Basically, in versions PHP 4 and older, it would not throw out an error when an expected
// variable that needed a definition was not defined.  PHP 4 and older would let it slide.
// However, it was discovered that "letting it slide" posed a security risk.  This brings
// it up to par, and assists in the security of this form by not allowing any variables come
// through undefined.
//
// So, after that explanation, you should know that for EVERY variable you have in the form, 
// you MUST have a line like this that matches it.  I already have the lines that already occur
// in the HTML document as you have downloaded it - but shoudl you ever add a field, you must
// be sure you add the line here to match that variable so the form will remain secure.
 
isset($_POST['action']) ? $action = $_POST['action'] : $action = '';
isset($_POST['name']) ? $name = $_POST['name'] : $name = '';
isset($_POST['email']) ? $email = $_POST['email'] : $email = '';
isset($_POST['tel']) ? $tel = $_POST['tel'] : $tel = '';
isset($_POST['comments']) ? $comments = $_POST['comments'] : $comments = '';

isset($_POST['error']) ? $error = $_POST['error'] : $error = '';
isset($_POST['name_error']) ? $name_error = $_POST['name_error'] : $name_error = '';
isset($_POST['email_error']) ? $email_error = $_POST['email_error'] : $email_error = '';
isset($_POST['comments_error']) ? $comments_error = $_POST['comments_error'] : $comments_error = '';
isset($_POST['injection_error']) ? $injection_error = $_POST['injection_error'] : $injection_error = '';
isset($_POST['send']) ? $send = $_POST['send'] : $send = '';


// The following section basically says:
//
// "If the end user comes to the page for the first time (by opening it in a browser window),
// then display the file "simple.html", but take no other action yet."

if($action !="sendmail"){
    include ("simple.html");
    exit;
}

// The rest of this file is the action taken when the end user fills out the form and hits
// "submit".  It will cycle through all of these requirements below to see if everything
// will pass muster before it is passed through as a valid email attempt.
//
// So, the first part says..."if the end user hits the "submit" button, we must first check the
// input of the required fields in the form."

if ($action == "sendmail") {


// The PHP will look at the required fields, and if any of them have been left blank, then it
// will assign the variable a number - being "1", and then move on to the "send" function, 
// defined as the last varible in this section.  "Send = no" basically says:
//
// "If $foo = 1, then return the end user to the "simple.html" page, and show the corresponding 
// error messages."
//
// In the case of the email address, not only will it return an error if the field is left
// blank, it will also check that the email address is entered in the proper format.  In other
// words, any version other than "name@domain.extension", then it will return an error. 
// This, however, will NOT validate whether or not it's a real, actual email address that works.

	    if ($name == "") {

		$name_error = "1";

        	$send = "no";

	    		     }



	    if (!ereg('^[-!#$%&\'*+\\./0-9=?A-Z^_`a-z{|}~]+'.'@'.'[-!#$%&\'*+\\/0-9=?A-Z^_`a-z{|}~]+\.'.'[-!#$%&\'*+\\./0-9=?A-Z^_`a-z{|}~]+$', $email) || ereg("'", $email)) {
		$email_error = "1";

        	$send = "no";

	    		     }



	    if ($comments == "") {

		$comments_error = "1";

        	$send = "no";

	    		     }



	    if ($send == "no") {

		$error = "1";

        	include("simple.html");
		exit;

	    		     }



// Here is where we prevent form mail injection.  Basically, it searches for common header
// injection attempts, which require the use of /r, /n, Bcc: and so on.  (you will note that
// it's not necessary to check the "email" input, as it is already checked for valid formatting
// above - it already will not accept these types of input). It will search for these  
// injection attempts within the end user's input...


    $find = array("/\r/", "/\n/", "/bcc\:/i", "/Content\-Type\:/i", "/cc\:/i", "/to\:/i");
    $test_name = preg_replace($find, "", $name);

// Here, it will allow \r and \n in textarea input, so if the end user puts in a long message
// to you with carriage returns, it won't reject it simply because the guy hit "enter" to 
// create a line break.  It *will* however, still search for the other fields that are
// recognized as in jection attempts...

    $find = array("/bcc\:/i", "/Content\-Type\:/i", "/cc\:/i", "/to\:/i");
    $test_comments = preg_replace($find, "", $comments);

    if (($name != $test_name) || ($comments != $test_comments) ) {

// Now, if an injection attempt is detected, it will return the end user to error message, in
// this case, a new page that contains your message to the would-be spammer.

        include ("spam.html");
        exit;

// If you'd rather have the end user be returned to the form with an error message displayed, 
// then comment out the above two lines, and uncomment the following four lines:
//
//	$error = "1";
//	$injection_error = "1";
//	include("simple.php");
//	exit;

// Now, if all of the above passes muster, and it's valid input, then....

    } else {

// ..send the mail!  The $message is basically the body of the email, with all of the end user's
// input stuck in here.

	$subject = "Asesorias-Juridicas";
    	$message = nl2br("Nombre: $name

			Correo: $email
Telefono: $tel
			Su Mensaje: $comments");


// This line is to remove the slashes that PHP puts in when it gets " or ' within the message.
// Typically, if the end user write the word "it's", for example, it will come through to your
// mailbox as "it/'s.  Kind of annoying.  The below removes those slashes to reduce the
// amount of annoyance. :)

	$message = stripSlashes($message);

// Here is your important information: *where* the email will go.  (See? no need to a hidden
// input field in the HTML document, so that stuff is picked up by spammers.  Let's leave the 
// spammers out of it!)



	$mailheader = "From: $name <$email>\nContent-Type: text/html";


	mail(" <guerramoreno.abogados@gmail.com>","$subject","$message","$mailheader");
}

//   Return the end user to a "Thank you!" page to let them know the email came through.

		   
{
	include("accept.html");

	exit;

}


}

// THE END!
?>


