<?php
/**
 * Custom template tags for this theme.
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package Accesspress Basic
 */

if ( ! function_exists( 'the_posts_navigation' ) ) :
/**
 * Display navigation to next/previous set of posts when applicable.
 *
 * @todo Remove this function when WordPress 4.3 is released.
 */
function the_posts_navigation() {
	// Don't print empty markup if there's only one page.
	if ( $GLOBALS['wp_query']->max_num_pages < 2 ) {
		return;
	}
	?>
	<nav class="navigation posts-navigation" role="navigation">
		<h2 class="screen-reader-text"><?php esc_html_e( 'Posts navigation', 'accesspress-basic' ); ?></h2>
		<div class="nav-links">

			<?php if ( get_next_posts_link() ) : ?>
			<div class="nav-previous"><?php next_posts_link( __( 'Older posts', 'accesspress-basic' ) ); ?></div>
			<?php endif; ?>

			<?php if ( get_previous_posts_link() ) : ?>
			<div class="nav-next"><?php previous_posts_link( __( 'Newer posts', 'accesspress-basic' ) ); ?></div>
			<?php endif; ?>

		</div><!-- .nav-links -->
	</nav><!-- .navigation -->
	<?php
}
endif;

if ( ! function_exists( 'the_post_navigation' ) ) :
/**
 * Display navigation to next/previous post when applicable.
 *
 * @todo Remove this function when WordPress 4.3 is released.
 */
function the_post_navigation() {
	// Don't print empty markup if there's nowhere to navigate.
	$previous = ( is_attachment() ) ? get_post( get_post()->post_parent ) : get_adjacent_post( false, '', true );
	$next     = get_adjacent_post( false, '', false );

	if ( ! $next && ! $previous ) {
		return;
	}
	?>
	<nav class="navigation post-navigation" role="navigation">
		<h2 class="screen-reader-text"><?php esc_html_e( 'Post navigation', 'accesspress-basic' ); ?></h2>
		<div class="nav-links">
			<?php
				previous_post_link( '<div class="nav-previous">%link</div>', '%title' );
				next_post_link( '<div class="nav-next">%link</div>', '%title' );
			?>
		</div><!-- .nav-links -->
	</nav><!-- .navigation -->
	<?php
}
endif;

if ( ! function_exists( 'accesspress_basic_posted_on' ) ) :
/**
 * Prints HTML with meta information for the current post-date/time and author.
 */
function accesspress_basic_posted_on() {
	$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
	if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
		$time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
	}

	$time_string = sprintf( $time_string,
		esc_attr( get_the_date( 'c' ) ),
		esc_html( get_the_date() ),
		esc_attr( get_the_modified_date( 'c' ) ),
		esc_html( get_the_modified_date() )
	);
    
    global $apbasic_options;
    $apbasic_settings = get_option('apbasic_options',$apbasic_options);
	$posted_on_text = isset($apbasic_settings['posted_on_text'])? $apbasic_settings['posted_on_text'] : '';
	$by_text = isset($apbasic_settings['by_text'])? $apbasic_settings['by_text'] : '';
    $posted_on_custom = $posted_on_text.' '.'<a href="' . esc_url( get_permalink() ) . '" rel="bookmark">' . $time_string . '</a>';

	$posted_on = sprintf(
		/* translators: %s : post date */
		_x( 'Posted on %s', 'post date', 'accesspress-basic' ),
		'<a href="' . esc_url( get_permalink() ) . '" rel="bookmark">' . $time_string . '</a>'
	);
    
    $byline_custom = $by_text.' '.'<span class="author vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a></span>';

	$byline = sprintf(
		/* translators: %s : author */
		_x( 'by %s', 'post author', 'accesspress-basic' ),
		'<span class="author vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a></span>'
	);
    
    $posted_on1 = ($posted_on_text == '') ? $posted_on : $posted_on_custom;
    $by1 = ($by_text == '') ? $byline : $byline_custom;

	echo '<span class="posted-on">' . $posted_on1 . '</span><span class="byline"> ' . $by1 . '</span>';

}
endif;

if ( ! function_exists( 'accesspress_basic_entry_footer' ) ) :
/**
 * Prints HTML with meta information for the categories, tags and comments.
 */
function accesspress_basic_entry_footer() {
    global $apbasic_options;
    $apbasic_settings = get_option('apbasic_options',$apbasic_options);
    
    $posted_in_text = isset($apbasic_settings['posted_in_text'])? $apbasic_settings['posted_in_text'] : '';
    $tagged_text = isset($apbasic_settings['tagged_text'])? $apbasic_settings['tagged_text'] : '';
    
	// Hide category and tag text for pages.
	if ( 'post' == get_post_type() ) {
		/* translators: used between list items, there is a space after the comma */
		$categories_list = get_the_category_list( __( ', ', 'accesspress-basic' ) );
		if ( $categories_list && accesspress_basic_categorized_blog() ) {
            if(empty($posted_in_text)){
            	/* translators: %1$s : category list */
                printf( '<span class="cat-links">' . __( 'Posted in %1$s', 'accesspress-basic' ) . '</span>', wp_kses($categories_list, array( 'a' => array( 'href' => array(), 'rel' => array() ) )) );
            }else{
                echo '<span class="cat-links">' . esc_html($posted_in_text) .' '. wp_kses($categories_list, array( 'a' => array( 'href' => array(), 'rel' => array() ) )).'</span>';                
            }
		}

		/* translators: used between list items, there is a space after the comma */
		$tags_list = get_the_tag_list( '', __( ', ', 'accesspress-basic' ) );
		if ( $tags_list ) {
            if(empty($tagged_text)){
            	/* translators: %1$s : tag list */
                printf( '<span class="tags-links">' . __( 'Tagged %1$s', 'accesspress-basic' ) . '</span>', wp_kses($tags_list, array( 'a' => array( 'href' => array(), 'rel' => array() ) )) );
            }else{
                echo '<span class="tags-links">' . esc_html($tagged_text) . ' ' . wp_kses($tags_list, array( 'a' => array( 'href' => array(), 'rel' => array() ) )).'</span>';
            }
		}
	}

	if ( ! is_single() && ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
		echo '<span class="comments-link">';
		comments_popup_link( __( 'Leave a comment', 'accesspress-basic' ), __( '1 Comment', 'accesspress-basic' ), __( '% Comments', 'accesspress-basic' ) );
		echo '</span>';
	}

	edit_post_link( __( 'Edit', 'accesspress-basic' ), '<span class="edit-link">', '</span>' );
}
endif;

if ( ! function_exists( 'the_archive_title' ) ) :
/**
 * Shim for `the_archive_title()`.
 *
 * Display the archive title based on the queried object.
 *
 * @todo Remove this function when WordPress 4.3 is released.
 *
 * @param string $before Optional. Content to prepend to the title. Default empty.
 * @param string $after  Optional. Content to append to the title. Default empty.
 */
function the_archive_title( $before = '', $after = '' ) {
	if ( is_category() ) {
		/* translators: %s : single category title */
		$title = sprintf( __( 'Category: %s', 'accesspress-basic' ), single_cat_title( '', false ) );
	} elseif ( is_tag() ) {
		/* translators: %s : single tag title */
		$title = sprintf( __( 'Tag: %s', 'accesspress-basic' ), single_tag_title( '', false ) );
	} elseif ( is_author() ) {
		/* translators: %s : author */
		$title = sprintf( __( 'Author: %s', 'accesspress-basic' ), '<span class="vcard">' . get_the_author() . '</span>' );
	} elseif ( is_year() ) {
		/* translators: %s : year */
		$title = sprintf( __( 'Year: %s', 'accesspress-basic' ), get_the_date( _x( 'Y', 'yearly archives date format', 'accesspress-basic' ) ) );
	} elseif ( is_month() ) {
		/* translators: %s : month */
		$title = sprintf( __( 'Month: %s', 'accesspress-basic' ), get_the_date( _x( 'F Y', 'monthly archives date format', 'accesspress-basic' ) ) );
	} elseif ( is_day() ) {
		/* translators: %s : day */
		$title = sprintf( __( 'Day: %s', 'accesspress-basic' ), get_the_date( _x( 'F j, Y', 'daily archives date format', 'accesspress-basic' ) ) );
	} elseif ( is_tax( 'post_format' ) ) {
		if ( is_tax( 'post_format', 'post-format-aside' ) ) {
			$title = _x( 'Asides', 'post format archive title', 'accesspress-basic' );
		} elseif ( is_tax( 'post_format', 'post-format-gallery' ) ) {
			$title = _x( 'Galleries', 'post format archive title', 'accesspress-basic' );
		} elseif ( is_tax( 'post_format', 'post-format-image' ) ) {
			$title = _x( 'Images', 'post format archive title', 'accesspress-basic' );
		} elseif ( is_tax( 'post_format', 'post-format-video' ) ) {
			$title = _x( 'Videos', 'post format archive title', 'accesspress-basic' );
		} elseif ( is_tax( 'post_format', 'post-format-quote' ) ) {
			$title = _x( 'Quotes', 'post format archive title', 'accesspress-basic' );
		} elseif ( is_tax( 'post_format', 'post-format-link' ) ) {
			$title = _x( 'Links', 'post format archive title', 'accesspress-basic' );
		} elseif ( is_tax( 'post_format', 'post-format-status' ) ) {
			$title = _x( 'Statuses', 'post format archive title', 'accesspress-basic' );
		} elseif ( is_tax( 'post_format', 'post-format-audio' ) ) {
			$title = _x( 'Audio', 'post format archive title', 'accesspress-basic' );
		} elseif ( is_tax( 'post_format', 'post-format-chat' ) ) {
			$title = _x( 'Chats', 'post format archive title', 'accesspress-basic' );
		}
	} elseif ( is_post_type_archive() ) {
		/* translators: %s : post archive title */
		$title = sprintf( __( 'Archives: %s', 'accesspress-basic' ), post_type_archive_title( '', false ) );
	} elseif ( is_tax() ) {
		$tax = get_taxonomy( get_queried_object()->taxonomy );
		/* translators: 1: Taxonomy singular name, 2: Current taxonomy term */
		$title = sprintf( __( '%1$s: %2$s', 'accesspress-basic' ), $tax->labels->singular_name, single_term_title( '', false ) );
	} else {
		$title = __( 'Archives', 'accesspress-basic' );
	}

	/**
	 * Filter the archive title.
	 *
	 * @param string $title Archive title to be displayed.
	 */
	$title = apply_filters( 'get_the_archive_title', $title );

	if ( ! empty( $title ) ) {
		echo wp_kses_post($before . $title . $after);
	}
}
endif;

if ( ! function_exists( 'the_archive_description' ) ) :
/**
 * Shim for `the_archive_description()`.
 *
 * Display category, tag, or term description.
 *
 * @todo Remove this function when WordPress 4.3 is released.
 *
 * @param string $before Optional. Content to prepend to the description. Default empty.
 * @param string $after  Optional. Content to append to the description. Default empty.
 */
function the_archive_description( $before = '', $after = '' ) {
	$description = apply_filters( 'get_the_archive_description', term_description() );

	if ( ! empty( $description ) ) {
		/**
		 * Filter the archive description.
		 *
		 * @see term_description()
		 *
		 * @param string $description Archive description to be displayed.
		 */
		echo wp_kses_post($before . $description . $after);
	}
}
endif;

/**
 * Returns true if a blog has more than 1 category.
 *
 * @return bool
 */
function accesspress_basic_categorized_blog() {
	if ( false === ( $all_the_cool_cats = get_transient( 'accesspress_basic_categories' ) ) ) {
		// Create an array of all the categories that are attached to posts.
		$all_the_cool_cats = get_categories( array(
			'fields'     => 'ids',
			'hide_empty' => 1,

			// We only need to know if there is more than one category.
			'number'     => 2,
		) );

		// Count the number of categories that are attached to the posts.
		$all_the_cool_cats = count( $all_the_cool_cats );

		set_transient( 'accesspress_basic_categories', $all_the_cool_cats );
	}

	if ( $all_the_cool_cats > 1 ) {
		// This blog has more than 1 category so accesspress_basic_categorized_blog should return true.
		return true;
	} else {
		// This blog has only 1 category so accesspress_basic_categorized_blog should return false.
		return false;
	}
}

/**
 * Flush out the transients used in accesspress_basic_categorized_blog.
 */
function accesspress_basic_category_transient_flusher() {
	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
		return;
	}
	// Like, beat it. Dig?
	delete_transient( 'accesspress_basic_categories' );
}
add_action( 'edit_category', 'accesspress_basic_category_transient_flusher' );
add_action( 'save_post',     'accesspress_basic_category_transient_flusher' );
