<?php

declare (strict_types=1);
namespace IAWPSCOPED\Doctrine\Inflector\Rules\Spanish;

use IAWPSCOPED\Doctrine\Inflector\Rules\Patterns;
use IAWPSCOPED\Doctrine\Inflector\Rules\Ruleset;
use IAWPSCOPED\Doctrine\Inflector\Rules\Substitutions;
use IAWPSCOPED\Doctrine\Inflector\Rules\Transformations;
/** @internal */
final class Rules
{
    public static function getSingularRuleset() : Ruleset
    {
        return new Ruleset(new Transformations(...Inflectible::getSingular()), new Patterns(...Uninflected::getSingular()), (new Substitutions(...Inflectible::getIrregular()))->getFlippedSubstitutions());
    }
    public static function getPluralRuleset() : Ruleset
    {
        return new Ruleset(new Transformations(...Inflectible::getPlural()), new Patterns(...Uninflected::getPlural()), new Substitutions(...Inflectible::getIrregular()));
    }
}
