-- Softaculous SQL Dump
-- http://www.softaculous.com
--
-- Host: localhost
-- Generation Time: October 9, 2024, 2:14 am
-- Server version: 10.6.19
-- PHP Version: 8.3.11

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `todoen9_yanba`
--

-- --------------------------------------------------------

--
-- Table structure for table `hpp_commentmeta`
--

CREATE TABLE `hpp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `hpp_comments`
--

CREATE TABLE `hpp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `hpp_independent_analytics_campaigns`
--

CREATE TABLE `hpp_independent_analytics_campaigns` (
  `campaign_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `landing_page_title` varchar(128) DEFAULT NULL,
  `utm_source` varchar(2048) NOT NULL,
  `utm_medium` varchar(2048) NOT NULL,
  `utm_campaign` varchar(2048) NOT NULL,
  `utm_term` varchar(2048) DEFAULT NULL,
  `utm_content` varchar(2048) DEFAULT NULL,
  PRIMARY KEY (`campaign_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- --------------------------------------------------------

--
-- Table structure for table `hpp_independent_analytics_campaign_urls`
--

CREATE TABLE `hpp_independent_analytics_campaign_urls` (
  `campaign_url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `path` varchar(2048) DEFAULT NULL,
  `utm_source` varchar(2048) NOT NULL,
  `utm_medium` varchar(2048) NOT NULL,
  `utm_campaign` varchar(2048) NOT NULL,
  `utm_term` varchar(2048) DEFAULT NULL,
  `utm_content` varchar(2048) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`campaign_url_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- --------------------------------------------------------

--
-- Table structure for table `hpp_independent_analytics_cities`
--

CREATE TABLE `hpp_independent_analytics_cities` (
  `city_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `country_id` bigint(20) unsigned NOT NULL,
  `subdivision` varchar(64) DEFAULT NULL,
  `city` varchar(64) NOT NULL,
  PRIMARY KEY (`city_id`),
  UNIQUE KEY `cities_unique_index` (`country_id`,`subdivision`,`city`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

--
-- Dumping data for table `hpp_independent_analytics_cities`
--

INSERT INTO `hpp_independent_analytics_cities` VALUES
(1, 1, 'Antioquia', 'Medellín'),
(2, 1, 'Bogota D.C.', 'Bogotá'),
(3, 2, 'California', 'Santa Clara'),
(4, 3, 'Hauts-de-France', 'Douai'),
(5, 2, 'Texas', 'El Paso'),
(6, 2, 'California', 'Los Angeles'),
(7, 4, 'Brussels Capital', 'Brussels'),
(8, 1, 'Tolima', 'Espinal'),
(9, 1, 'Santander', 'Barrancabermeja'),
(10, 1, 'Cundinamarca', 'El Rosal'),
(11, 1, 'Cundinamarca', 'Cota'),
(12, 5, 'New South Wales', 'Sydney'),
(13, 6, 'Panamá', 'Panama City'),
(14, 2, 'Oregon', 'The Dalles'),
(15, 7, 'Tsuen Wan', 'Tsuen Wan'),
(16, 1, 'Norte de Santander Department', 'Cúcuta'),
(17, 8, 'Vaduz', 'Vaduz'),
(18, 1, 'Cundinamarca', 'La Calera'),
(19, 1, 'Cundinamarca', 'Soacha'),
(20, 1, 'Cundinamarca', 'Villa de San Diego de Ubaté'),
(21, 1, 'Cundinamarca', 'El Colegio'),
(22, 1, 'Bogota D.C.', 'Barrio San Luis'),
(23, 9, 'Guangdong', 'Shenzhen'),
(24, 1, 'Cundinamarca', 'Funza'),
(25, 10, 'Ōsaka', 'Osaka'),
(26, 9, 'Henan', 'Zhengzhou'),
(27, 11, 'Guayas', 'Guayaquil'),
(28, 1, 'Meta', 'Puerto Gaitán'),
(29, 1, 'Antioquia', 'Bello'),
(30, 1, 'Bolívar', 'Cartagena'),
(31, 1, 'Magdalena Department', 'Prado-Sevilla'),
(32, 12, 'Bern', 'Bern'),
(33, 2, 'Texas', 'Dallas'),
(34, 2, 'Iowa', 'Council Bluffs'),
(35, 1, 'Cundinamarca', 'Girardot City'),
(36, 1, 'Santander Department', 'Lebrija'),
(37, 1, 'Meta Department', 'Villavicencio'),
(38, 1, 'Antioquia', 'Itagüí'),
(39, 13, 'Jakarta', 'Jakarta');

-- --------------------------------------------------------

--
-- Table structure for table `hpp_independent_analytics_countries`
--

CREATE TABLE `hpp_independent_analytics_countries` (
  `country_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `country_code` varchar(4) NOT NULL,
  `country` varchar(64) NOT NULL,
  `continent` varchar(16) NOT NULL,
  PRIMARY KEY (`country_id`),
  UNIQUE KEY `countries_unique_index` (`country_code`,`country`,`continent`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

--
-- Dumping data for table `hpp_independent_analytics_countries`
--

INSERT INTO `hpp_independent_analytics_countries` VALUES
(1, 'CO', 'Colombia', 'South America'),
(2, 'US', 'United States', 'North America'),
(3, 'FR', 'France', 'Europe'),
(4, 'BE', 'Belgium', 'Europe'),
(5, 'AU', 'Australia', 'Oceania'),
(6, 'PA', 'Panama', 'North America'),
(7, 'HK', 'Hong Kong', 'Asia'),
(8, 'LI', 'Liechtenstein', 'Europe'),
(9, 'CN', 'China', 'Asia'),
(10, 'JP', 'Japan', 'Asia'),
(11, 'EC', 'Ecuador', 'South America'),
(12, 'CH', 'Switzerland', 'Europe'),
(13, 'ID', 'Indonesia', 'Asia');

-- --------------------------------------------------------

--
-- Table structure for table `hpp_independent_analytics_device_browsers`
--

CREATE TABLE `hpp_independent_analytics_device_browsers` (
  `device_browser_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `device_browser` varchar(64) NOT NULL,
  PRIMARY KEY (`device_browser_id`),
  UNIQUE KEY `device_browser` (`device_browser`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

--
-- Dumping data for table `hpp_independent_analytics_device_browsers`
--

INSERT INTO `hpp_independent_analytics_device_browsers` VALUES
(1, 'Chrome'),
(2, 'Jsdom'),
(3, 'Safari'),
(4, 'Google Search App');

-- --------------------------------------------------------

--
-- Table structure for table `hpp_independent_analytics_device_oss`
--

CREATE TABLE `hpp_independent_analytics_device_oss` (
  `device_os_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `device_os` varchar(64) NOT NULL,
  PRIMARY KEY (`device_os_id`),
  UNIQUE KEY `device_os` (`device_os`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

--
-- Dumping data for table `hpp_independent_analytics_device_oss`
--

INSERT INTO `hpp_independent_analytics_device_oss` VALUES
(1, 'Android'),
(2, 'GNU/Linux'),
(3, 'Windows'),
(4, 'Mac'),
(5, 'iOS');

-- --------------------------------------------------------

--
-- Table structure for table `hpp_independent_analytics_device_types`
--

CREATE TABLE `hpp_independent_analytics_device_types` (
  `device_type_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `device_type` varchar(64) NOT NULL,
  PRIMARY KEY (`device_type_id`),
  UNIQUE KEY `device_type` (`device_type`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

--
-- Dumping data for table `hpp_independent_analytics_device_types`
--

INSERT INTO `hpp_independent_analytics_device_types` VALUES
(1, 'Desktop'),
(2, 'Mobile');

-- --------------------------------------------------------

--
-- Table structure for table `hpp_independent_analytics_forms`
--

CREATE TABLE `hpp_independent_analytics_forms` (
  `form_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `plugin_id` bigint(20) unsigned NOT NULL,
  `plugin_form_id` bigint(20) unsigned NOT NULL,
  `cached_form_title` varchar(64) NOT NULL,
  PRIMARY KEY (`form_id`),
  UNIQUE KEY `plugin_id` (`plugin_id`,`plugin_form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- --------------------------------------------------------

--
-- Table structure for table `hpp_independent_analytics_form_submissions`
--

CREATE TABLE `hpp_independent_analytics_form_submissions` (
  `form_submission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) unsigned NOT NULL,
  `session_id` bigint(20) unsigned NOT NULL,
  `view_id` bigint(20) unsigned NOT NULL,
  `initial_view_id` bigint(20) unsigned NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`form_submission_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- --------------------------------------------------------

--
-- Table structure for table `hpp_independent_analytics_orders`
--

CREATE TABLE `hpp_independent_analytics_orders` (
  `order_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `is_included_in_analytics` tinyint(1) NOT NULL,
  `woocommerce_order_id` bigint(20) unsigned DEFAULT NULL,
  `woocommerce_order_status` varchar(64) DEFAULT NULL,
  `surecart_order_id` varchar(36) DEFAULT NULL,
  `surecart_order_status` varchar(64) DEFAULT NULL,
  `view_id` bigint(20) unsigned NOT NULL,
  `initial_view_id` bigint(20) unsigned NOT NULL,
  `total` int(11) NOT NULL,
  `total_refunded` int(11) NOT NULL,
  `total_refunds` smallint(6) NOT NULL,
  `is_discounted` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `view_id` (`view_id`),
  KEY `initial_view_id` (`initial_view_id`),
  KEY `created_at` (`created_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- --------------------------------------------------------

--
-- Table structure for table `hpp_independent_analytics_referrers`
--

CREATE TABLE `hpp_independent_analytics_referrers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `domain` varchar(128) NOT NULL,
  `type` enum('Ad','Direct','Referrer','Search','Social') DEFAULT NULL,
  `referrer` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `referrers_domain_index` (`domain`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

--
-- Dumping data for table `hpp_independent_analytics_referrers`
--

INSERT INTO `hpp_independent_analytics_referrers` VALUES
(1, 'www.google.com', 'Search', 'Google'),
(2, 'yanbal.directorioempresascolombia.com', 'Referrer', 'yanbal.directorioempresascolombia.com'),
(3, 'directorioempresascolombia.com', 'Referrer', 'directorioempresascolombia.com'),
(4, '', 'Direct', 'Direct');

-- --------------------------------------------------------

--
-- Table structure for table `hpp_independent_analytics_reports`
--

CREATE TABLE `hpp_independent_analytics_reports` (
  `report_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_created_report` tinyint(1) NOT NULL DEFAULT 1,
  `name` varchar(255) NOT NULL,
  `type` varchar(64) NOT NULL,
  `exact_start` datetime DEFAULT NULL,
  `exact_end` datetime DEFAULT NULL,
  `relative_range_id` varchar(64) DEFAULT NULL,
  `sort_column` varchar(64) DEFAULT NULL,
  `sort_direction` varchar(64) DEFAULT NULL,
  `group_name` varchar(64) DEFAULT NULL,
  `quick_stats` text DEFAULT NULL,
  `chart_interval` varchar(64) DEFAULT NULL,
  `columns` text DEFAULT NULL,
  `filters` text DEFAULT NULL,
  `position` int(11) DEFAULT NULL,
  `primary_chart_metric_id` varchar(255) DEFAULT NULL,
  `secondary_chart_metric_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`report_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

--
-- Dumping data for table `hpp_independent_analytics_reports`
--

INSERT INTO `hpp_independent_analytics_reports` VALUES
(1, 0, 'Blog Posts', 'views', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[{"inclusion":"include","column":"type","operator":"is","operand":"post"}]', NULL, NULL, NULL),
(2, 0, 'Top Landing Pages', 'views', NULL, NULL, NULL, 'entrances', 'desc', NULL, NULL, NULL, '["title","visitors","views","average_view_duration","bounce_rate","entrances","url","type"]', NULL, NULL, NULL, NULL),
(3, 0, 'Fastest-Growing Pages', 'views', NULL, NULL, NULL, 'visitors_growth', 'desc', NULL, NULL, NULL, '["title","visitors","views","average_view_duration","bounce_rate","visitors_growth","url","type"]', '[{"inclusion":"exclude","column":"visitors","operator":"lesser","operand":"5"}]', NULL, NULL, NULL),
(4, 0, 'Today', 'views', NULL, NULL, 'TODAY', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(5, 0, 'Search Engine Traffic', 'referrers', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[{"inclusion":"include","column":"referrer_type","operator":"is","operand":"Search"}]', NULL, NULL, NULL),
(6, 0, 'Social Media Traffic', 'referrers', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[{"inclusion":"include","column":"referrer_type","operator":"is","operand":"Social"}]', NULL, NULL, NULL),
(7, 0, 'Fastest-Growing Referrers', 'referrers', NULL, NULL, NULL, 'visitors_growth', 'desc', NULL, NULL, NULL, '["referrer","referrer_type","visitors","views","average_session_duration","bounce_rate","visitors_growth"]', '[{"inclusion":"exclude","column":"visitors","operator":"lesser","operand":"5"}]', NULL, NULL, NULL),
(8, 0, 'Last 7 Days', 'referrers', NULL, NULL, 'LAST_SEVEN', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(9, 0, 'Cities', 'geo', NULL, NULL, NULL, NULL, NULL, 'city', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(10, 0, 'European Countries', 'geo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[{"inclusion":"include","column":"continent","operator":"exact","operand":"Europe"}]', NULL, NULL, NULL),
(11, 0, 'Browsers', 'devices', NULL, NULL, NULL, NULL, NULL, 'browser', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(12, 0, 'OS', 'devices', NULL, NULL, NULL, NULL, NULL, 'os', NULL, NULL, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `hpp_independent_analytics_resources`
--

CREATE TABLE `hpp_independent_analytics_resources` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `resource` varchar(256) NOT NULL,
  `singular_id` bigint(20) unsigned DEFAULT NULL,
  `author_id` bigint(20) unsigned DEFAULT NULL,
  `virtual_page_id` varchar(64) DEFAULT NULL,
  `date_archive` varchar(256) DEFAULT NULL,
  `search_query` varchar(256) DEFAULT NULL,
  `post_type` varchar(256) DEFAULT NULL,
  `term_id` bigint(20) unsigned DEFAULT NULL,
  `not_found_url` varchar(256) DEFAULT NULL,
  `cached_title` varchar(256) DEFAULT NULL,
  `cached_url` varchar(256) DEFAULT NULL,
  `cached_type` varchar(256) DEFAULT NULL,
  `cached_type_label` varchar(256) DEFAULT NULL,
  `cached_author_id` bigint(20) unsigned DEFAULT NULL,
  `cached_author` varchar(256) DEFAULT NULL,
  `cached_category` varchar(256) DEFAULT NULL,
  `cached_date` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cached_author_id` (`cached_author_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

--
-- Dumping data for table `hpp_independent_analytics_resources`
--

INSERT INTO `hpp_independent_analytics_resources` VALUES
(1, 'singular', 6, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INICIO', 'https://yanbal.directorioempresascolombia.com/', 'page', 'Page', 1, '14Pinto21', NULL, '2023-09-15'),
(2, 'singular', 14, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Productos Caballero', 'https://yanbal.directorioempresascolombia.com/productos-caballero/', 'page', 'Page', 1, '14Pinto21', NULL, '2023-09-15'),
(3, 'singular', 28, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Catalogo Yanbal 2025', 'https://yanbal.directorioempresascolombia.com/catalogo-yanbal/', 'page', 'Page', 1, '14Pinto21', NULL, '2023-09-15'),
(4, 'singular', 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Contacto', 'https://yanbal.directorioempresascolombia.com/contacto/', 'page', 'Page', 1, '14Pinto21', NULL, '2023-09-15'),
(5, 'singular', 16, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Niños y Bebes', 'https://yanbal.directorioempresascolombia.com/ninos-y-bebes/', 'page', 'Page', 1, '14Pinto21', NULL, '2023-09-15'),
(6, 'singular', 115, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Oferta del Mes', 'https://yanbal.directorioempresascolombia.com/oferta-del-mes/', 'page', 'Page', 1, '14Pinto21', NULL, '2023-09-15'),
(7, '404', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://yanbal.directorioempresascolombia.com/about.php', '404', 'https://yanbal.directorioempresascolombia.com/BogotA/http://yanbal.directorioempresascolombia.com/about.php', 'not-found', '404', NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `hpp_independent_analytics_sessions`
--

CREATE TABLE `hpp_independent_analytics_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `old_visitor_id` varchar(32) DEFAULT NULL,
  `visitor_id` bigint(20) unsigned DEFAULT NULL,
  `initial_view_id` bigint(20) unsigned DEFAULT NULL,
  `referrer_id` bigint(20) unsigned DEFAULT NULL,
  `campaign_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `legacy_view` tinyint(1) NOT NULL DEFAULT 0,
  `final_view_id` bigint(20) unsigned DEFAULT NULL,
  `ended_at` datetime DEFAULT NULL,
  `city_id` bigint(20) unsigned DEFAULT NULL,
  `country_id` bigint(20) unsigned DEFAULT NULL,
  `total_views` int(11) DEFAULT NULL,
  `device_type_id` bigint(20) unsigned DEFAULT NULL,
  `device_os_id` bigint(20) unsigned DEFAULT NULL,
  `device_browser_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `sessions_summary_index` (`created_at`,`session_id`,`visitor_id`,`referrer_id`,`total_views`),
  UNIQUE KEY `sessions_country_summary_index` (`created_at`,`session_id`,`visitor_id`,`country_id`,`total_views`),
  UNIQUE KEY `sessions_city_summary_index` (`created_at`,`session_id`,`visitor_id`,`city_id`,`total_views`),
  UNIQUE KEY `sessions_device_type_summary_index` (`created_at`,`session_id`,`visitor_id`,`device_type_id`,`total_views`),
  UNIQUE KEY `sessions_device_browser_summary_index` (`created_at`,`session_id`,`visitor_id`,`device_browser_id`,`total_views`),
  UNIQUE KEY `sessions_device_os_summary_index` (`created_at`,`session_id`,`visitor_id`,`device_os_id`,`total_views`),
  UNIQUE KEY `sessions_campaign_summary_index` (`created_at`,`session_id`,`visitor_id`,`campaign_id`,`total_views`),
  KEY `visitor_id` (`old_visitor_id`),
  KEY `initial_view_id` (`initial_view_id`),
  KEY `referrer_id` (`referrer_id`),
  KEY `campaign_id` (`campaign_id`),
  KEY `sessions_created_at_index` (`created_at`),
  KEY `city_id` (`city_id`),
  KEY `country_id` (`country_id`),
  KEY `device_type_id` (`device_type_id`),
  KEY `device_os_id` (`device_os_id`),
  KEY `device_browser_id` (`device_browser_id`),
  KEY `new_bigint_visitor_id` (`visitor_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

--
-- Dumping data for table `hpp_independent_analytics_sessions`
--

INSERT INTO `hpp_independent_analytics_sessions` VALUES
(1, 'ee3d96e75462c0fa1792e9a8c8d17a3f', 31, 1, 1, NULL, '2023-09-23 18:48:25', 0, NULL, NULL, 1, 1, 1, 2, 1, 1),
(2, 'ee3d96e75462c0fa1792e9a8c8d17a3f', 31, 2, 1, NULL, '2023-09-23 18:50:01', 0, NULL, NULL, 1, 1, 1, 2, 1, 1),
(3, 'ee3d96e75462c0fa1792e9a8c8d17a3f', 31, 3, 2, NULL, '2023-09-23 18:50:45', 0, NULL, NULL, 1, 1, 1, 2, 1, 1),
(4, 'c708c24d5610b3c44c82f3b9a93fa33e', 27, 4, 1, NULL, '2023-09-25 00:46:27', 0, NULL, NULL, 2, 1, 1, 2, 1, 1),
(5, '38a6b19f36602c8ed5c4ef081525296e', 8, 5, 1, NULL, '2023-09-25 12:16:43', 0, NULL, NULL, 2, 1, 1, 1, 3, 1),
(6, '38a6b19f36602c8ed5c4ef081525296e', 8, 6, 1, NULL, '2023-09-25 12:37:11', 0, NULL, NULL, 2, 1, 1, 1, 3, 1),
(7, 'ff311395db04c3d1d44f0a2332a20580', 33, 7, 4, NULL, '2023-09-27 05:33:15', 0, NULL, NULL, 3, 2, 1, 1, 2, 1),
(8, '0f115332aefdbdfaea8bb6d444bd4c66', 3, 8, 2, NULL, '2023-10-11 07:52:00', 0, NULL, NULL, 4, 3, 1, 1, 3, 1),
(9, 'bd388961cab7b7edb4ddfd9548e2cf96', 24, 9, 4, NULL, '2023-10-11 16:27:16', 0, NULL, NULL, 5, 2, 1, 2, 1, 1),
(10, '6768234a6928a34b41ff0811b42ffbe2', 11, 10, 4, NULL, '2023-10-11 20:39:39', 0, NULL, NULL, 6, 2, 1, 2, 1, 1),
(11, 'cb535fdd8685ba358971280d15480297', 28, 11, 1, NULL, '2023-10-12 19:29:20', 0, NULL, NULL, 2, 1, 1, 2, 1, 1),
(12, 'c2c2e796c2215c4a9060e88baaf84cbe', 26, 12, 4, NULL, '2023-10-15 22:31:15', 0, NULL, NULL, 7, 4, 1, 1, 2, 2),
(13, '32bcd2c237c69dcc145f08b687ae293b', 7, 13, 4, NULL, '2023-10-18 05:19:55', 0, NULL, NULL, 3, 2, 1, 1, 2, 1),
(14, '9e5032fb5a2230a5e8c4c001d04ad6f8', 20, 14, 4, NULL, '2023-10-18 05:29:29', 0, NULL, NULL, 3, 2, 1, 1, 2, 1),
(15, 'dbc833f79979a1e56dd217e4e4c5dfe4', 30, 15, 1, NULL, '2023-10-19 14:58:42', 0, NULL, NULL, 8, 1, 1, 1, 3, 1),
(16, '7c8b33740234bd3d6fce8a981cebfd1f', 15, 16, 3, NULL, '2023-10-20 03:53:28', 0, NULL, NULL, 9, 1, 1, 2, 1, 1),
(17, '7c8b33740234bd3d6fce8a981cebfd1f', 15, 17, 2, NULL, '2023-10-20 03:53:45', 0, NULL, NULL, 9, 1, 1, 2, 1, 1),
(18, '7c8b33740234bd3d6fce8a981cebfd1f', 15, 18, 2, NULL, '2023-10-20 03:54:12', 0, NULL, NULL, 9, 1, 1, 2, 1, 1),
(19, '7c8b33740234bd3d6fce8a981cebfd1f', 15, 19, 2, NULL, '2023-10-20 03:54:36', 0, NULL, NULL, 9, 1, 1, 2, 1, 1),
(20, '559408be619f8557068d6b853e814a4d', 10, 20, 2, NULL, '2023-11-01 02:41:11', 0, NULL, NULL, 4, 3, 1, 1, 3, 1),
(21, '25e2a6c055e95f899035a76a109c22bb', 6, 22, 1, NULL, '2023-11-07 21:13:12', 0, NULL, NULL, 2, 1, 1, 1, 3, 1),
(22, '25e2a6c055e95f899035a76a109c22bb', 6, 21, 1, NULL, '2023-11-07 21:13:12', 0, NULL, NULL, 2, 1, 1, 1, 3, 1),
(23, '25e2a6c055e95f899035a76a109c22bb', 6, 23, 1, NULL, '2023-11-07 21:13:12', 0, NULL, NULL, 2, 1, 1, 1, 3, 1),
(24, '25e2a6c055e95f899035a76a109c22bb', 6, 24, 1, NULL, '2023-11-07 21:13:20', 0, NULL, NULL, 2, 1, 1, 1, 3, 1),
(25, 'dbc75861d67b380208be34051a12d14b', 29, 25, 1, NULL, '2023-11-12 03:15:34', 0, NULL, NULL, 10, 1, 1, 2, 1, 1),
(26, '559408be619f8557068d6b853e814a4d', 10, 26, 2, NULL, '2023-11-15 03:50:32', 0, NULL, NULL, 4, 3, 1, 1, 3, 1),
(27, '18f4d82d23fff2c4b9adcc5181d28fec', 4, 27, 1, NULL, '2023-11-17 22:09:47', 0, NULL, NULL, 11, 1, 1, 1, 3, 1),
(28, '80510102bf1f5155454abdbe781d0e1c', 16, 28, 4, NULL, '2023-11-21 22:17:54', 0, NULL, NULL, 12, 5, 1, 1, 2, 2),
(29, '6bb7c44302b4f328591831e9f6addd99', 13, 29, 1, NULL, '2023-11-24 22:24:29', 0, NULL, NULL, 13, 6, 1, 2, 1, 1),
(30, 'a62d2654c55eebdc430208629a16ed4a', 21, 30, 1, NULL, '2023-12-20 18:28:06', 0, NULL, NULL, 2, 1, 1, 2, 1, 1),
(31, '43ec56d787959580c0440dc74205707c', 9, 31, 4, NULL, '2024-01-06 21:42:48', 0, NULL, NULL, 14, 2, 1, 1, 2, 2),
(32, '82c70e3eef71286f8fb3151786c4c661', 18, 32, 4, NULL, '2024-01-24 17:01:43', 0, NULL, NULL, 15, 7, 1, 2, 1, 1),
(33, '00248fefc63ef1c589ac5f1e3c95511a', 1, 33, 4, NULL, '2024-01-24 17:01:44', 0, NULL, NULL, 15, 7, 1, 1, 2, 1),
(34, '82c70e3eef71286f8fb3151786c4c661', 18, 34, 4, NULL, '2024-01-24 19:37:19', 0, NULL, NULL, 15, 7, 1, 2, 1, 1),
(35, 'b64e8fdf21a5d0407707903b5af67698', 23, 35, 4, NULL, '2024-02-26 19:23:21', 0, NULL, NULL, 3, 2, 1, 1, 3, 1),
(36, 'f2f902e800867fe056f8de9e004e9f32', 32, 36, 4, NULL, '2024-02-27 14:47:45', 0, NULL, NULL, 6, 2, 1, 1, 2, 2),
(37, '6da64af89936260f23ce70e5e91f4357', 14, 37, 1, NULL, '2024-03-01 00:55:11', 0, NULL, NULL, 16, 1, 1, 2, 1, 1),
(38, '1d3a48d52ba3a903a3980e5131ddf1c2', 5, 38, 4, NULL, '2024-03-03 23:47:08', 0, NULL, NULL, 17, 8, 1, 1, 4, 1),
(39, 'c0839e99ff2a3c14248507b7416aa4ad', 25, 39, 1, NULL, '2024-03-07 13:28:43', 0, NULL, NULL, 2, 1, 1, 2, 1, 1),
(40, '01fca0327424f9e7eade64d143ac6a2d', 2, 40, 1, NULL, '2024-03-13 00:58:28', 0, NULL, NULL, 18, 1, 1, 2, 1, 1),
(41, '951481593b0df355a77bac70f8e6f0ca', 19, 41, 1, NULL, '2024-03-14 00:26:32', 0, NULL, NULL, 19, 1, 1, 2, 1, 1),
(42, '1d3a48d52ba3a903a3980e5131ddf1c2', 5, 42, 4, NULL, '2024-03-28 08:11:01', 0, NULL, NULL, 17, 8, 1, 1, 4, 1),
(43, '6a589c0e11de285ad6d150a5529f8f16', 12, 43, 1, NULL, '2024-03-29 16:34:56', 0, 44, '2024-03-29 16:35:24', 20, 1, 2, 2, 1, 1),
(44, 'af039f8978625882e659cb949acfa1c5', 22, 45, 1, NULL, '2024-04-01 22:28:08', 0, NULL, NULL, 21, 1, 1, 2, 1, 1),
(45, 'af039f8978625882e659cb949acfa1c5', 22, 46, 2, NULL, '2024-04-01 22:28:39', 0, NULL, NULL, 21, 1, 1, 2, 1, 1),
(46, 'af039f8978625882e659cb949acfa1c5', 22, 47, 2, NULL, '2024-04-01 22:29:09', 0, NULL, NULL, 21, 1, 1, 2, 1, 1),
(47, '8242e71bcdfebd39853b1c1395a2a2a8', 17, 48, 1, NULL, '2024-04-07 03:43:16', 0, NULL, NULL, 22, 1, 1, 2, 1, 1),
(48, NULL, 34, 49, 4, NULL, '2024-04-18 18:11:16', 0, NULL, NULL, 23, 9, 1, 1, 4, 1),
(49, NULL, 35, 50, 4, NULL, '2024-04-29 23:24:21', 0, NULL, NULL, 2, 1, 1, 2, 1, 1),
(50, NULL, 36, 51, 4, NULL, '2024-05-03 19:56:22', 0, NULL, NULL, 23, 9, 1, 1, 4, 1),
(51, NULL, 37, 52, 1, NULL, '2024-05-05 20:38:44', 0, NULL, NULL, 24, 1, 1, 2, 1, 1),
(52, NULL, 37, 53, 2, NULL, '2024-05-05 20:39:07', 0, NULL, NULL, 24, 1, 1, 2, 1, 1),
(53, NULL, 38, 54, 4, NULL, '2024-05-12 05:25:20', 0, NULL, NULL, 3, 2, 1, 1, 3, 1),
(54, NULL, 39, 55, 4, NULL, '2024-05-12 05:25:24', 0, NULL, NULL, 25, 10, 1, 1, 2, 1),
(55, NULL, 40, 56, 1, NULL, '2024-05-14 18:12:04', 0, NULL, NULL, 2, 1, 1, 2, 1, 1),
(56, NULL, 41, 57, 4, NULL, '2024-05-25 11:34:05', 0, NULL, NULL, 26, 9, 1, 1, 4, 1),
(57, NULL, 42, 58, 4, NULL, '2024-06-02 01:28:07', 0, NULL, NULL, 26, 9, 1, 1, 4, 1),
(58, NULL, 43, 59, 4, NULL, '2024-06-02 01:28:26', 0, NULL, NULL, 23, 9, 1, 1, 4, 1),
(59, NULL, 44, 60, 4, NULL, '2024-06-02 05:14:52', 0, NULL, NULL, 3, 2, 1, 1, 3, 1),
(60, NULL, 44, 61, 4, NULL, '2024-06-02 17:09:49', 0, NULL, NULL, 3, 2, 1, 1, 3, 1),
(61, NULL, 45, 62, 1, NULL, '2024-06-03 15:27:19', 0, NULL, NULL, 2, 1, 1, 2, 5, 3),
(62, NULL, 46, 63, 1, NULL, '2024-06-05 23:30:45', 0, NULL, NULL, 27, 11, 1, 1, 3, 1),
(63, NULL, 47, 64, 4, NULL, '2024-06-18 02:37:02', 0, NULL, NULL, 2, 1, 1, 2, 1, 1),
(64, NULL, 48, 65, 1, NULL, '2024-06-22 17:20:05', 0, NULL, NULL, 28, 1, 1, 2, 1, 1),
(65, NULL, 49, 66, 4, NULL, '2024-06-22 21:10:12', 0, NULL, NULL, 23, 9, 1, 1, 4, 1),
(66, NULL, 42, 67, 4, NULL, '2024-06-25 02:06:09', 0, NULL, NULL, 26, 9, 1, 1, 4, 1),
(67, NULL, 50, 68, 4, NULL, '2024-07-05 21:18:37', 0, NULL, NULL, 26, 9, 1, 1, 4, 1),
(68, NULL, 51, 69, 1, NULL, '2024-07-10 16:47:36', 0, NULL, NULL, 29, 1, 1, 2, 1, 1),
(69, NULL, 52, 70, 4, NULL, '2024-07-10 18:40:39', 0, NULL, NULL, 2, 1, 1, 1, 3, 1),
(70, NULL, 53, 71, 4, NULL, '2024-07-10 19:08:52', 0, 72, '2024-07-10 19:09:21', 30, 1, 2, 2, 1, 1),
(71, NULL, 54, 73, 4, NULL, '2024-07-12 15:42:39', 0, NULL, NULL, 23, 9, 1, 1, 4, 1),
(72, NULL, 55, 74, 4, NULL, '2024-07-15 23:34:40', 0, 75, '2024-07-15 23:35:38', 31, 1, 2, 2, 1, 1),
(73, NULL, 56, 76, 1, NULL, '2024-07-17 12:54:08', 0, NULL, NULL, 32, 12, 1, 1, 3, 1),
(74, NULL, 57, 77, 4, NULL, '2024-07-27 08:51:21', 0, NULL, NULL, 33, 2, 1, 1, 3, 1),
(75, NULL, 58, 78, 4, NULL, '2024-07-27 08:51:22', 0, NULL, NULL, 34, 2, 1, 1, 2, 1),
(76, NULL, 59, 79, 4, NULL, '2024-07-31 01:38:42', 0, NULL, NULL, 23, 9, 1, 1, 4, 1),
(77, NULL, 60, 80, 4, NULL, '2024-08-01 12:14:20', 0, NULL, NULL, 35, 1, 1, 2, 1, 1),
(78, NULL, 61, 81, 1, NULL, '2024-08-15 12:09:01', 0, NULL, NULL, 1, 1, 1, 2, 1, 1),
(79, NULL, 62, 82, 4, NULL, '2024-08-17 08:01:04', 0, NULL, NULL, 33, 2, 1, 1, 3, 1),
(80, NULL, 63, 83, 1, NULL, '2024-08-21 16:01:07', 0, NULL, NULL, 2, 1, 1, 1, 3, 1),
(81, NULL, 64, 84, 4, NULL, '2024-08-27 03:50:20', 0, NULL, NULL, 2, 1, 1, 1, 4, 3),
(82, NULL, 64, 85, 2, NULL, '2024-08-27 03:53:14', 0, 86, '2024-08-27 03:53:25', 2, 1, 2, 1, 4, 3),
(83, NULL, 65, 87, 1, NULL, '2024-08-28 23:18:55', 0, NULL, NULL, 2, 1, 1, 2, 1, 1),
(84, NULL, 66, 88, 1, NULL, '2024-09-02 17:42:03', 0, NULL, NULL, 36, 1, 1, 2, 1, 1),
(85, NULL, 67, 89, 1, NULL, '2024-09-02 21:13:42', 0, NULL, NULL, 2, 1, 1, 2, 1, 1),
(86, NULL, 68, 90, 1, NULL, '2024-09-08 14:50:39', 0, NULL, NULL, 37, 1, 1, 2, 1, 1),
(87, NULL, 69, 91, 1, NULL, '2024-09-09 18:46:11', 0, NULL, NULL, 38, 1, 1, 2, 1, 1),
(88, NULL, 64, 92, 4, NULL, '2024-09-10 13:43:58', 0, NULL, NULL, 2, 1, 1, 1, 4, 3),
(89, NULL, 70, 93, 4, NULL, '2024-09-10 16:44:02', 0, NULL, NULL, 39, 13, 1, 1, 3, 1),
(90, NULL, 71, 94, 1, NULL, '2024-09-19 20:03:44', 0, NULL, NULL, 2, 1, 1, 2, 5, 4),
(91, NULL, 72, 95, 4, NULL, '2024-09-25 12:53:40', 0, NULL, NULL, 26, 9, 1, 1, 4, 1);

-- --------------------------------------------------------

--
-- Table structure for table `hpp_independent_analytics_views`
--

CREATE TABLE `hpp_independent_analytics_views` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `resource_id` bigint(20) unsigned NOT NULL,
  `viewed_at` datetime DEFAULT NULL,
  `page` bigint(20) unsigned NOT NULL DEFAULT 1,
  `session_id` bigint(20) unsigned DEFAULT NULL,
  `next_view_id` bigint(20) unsigned DEFAULT NULL,
  `next_viewed_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `session_id` (`session_id`),
  KEY `views_viewed_at_index` (`viewed_at`),
  KEY `views_resource_id_index` (`resource_id`),
  KEY `session_id_2` (`session_id`,`viewed_at`),
  KEY `views_summary_index` (`session_id`,`viewed_at`,`resource_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

--
-- Dumping data for table `hpp_independent_analytics_views`
--

INSERT INTO `hpp_independent_analytics_views` VALUES
(1, 1, '2023-09-23 18:48:25', 1, 1, NULL, NULL),
(2, 1, '2023-09-23 18:50:01', 1, 2, NULL, NULL),
(3, 2, '2023-09-23 18:50:45', 1, 3, NULL, NULL),
(4, 1, '2023-09-25 00:46:27', 1, 4, NULL, NULL),
(5, 1, '2023-09-25 12:16:43', 1, 5, NULL, NULL),
(6, 1, '2023-09-25 12:37:11', 1, 6, NULL, NULL),
(7, 1, '2023-09-27 05:33:15', 1, 7, NULL, NULL),
(8, 1, '2023-10-11 07:52:00', 1, 8, NULL, NULL),
(9, 1, '2023-10-11 16:27:16', 1, 9, NULL, NULL),
(10, 1, '2023-10-11 20:39:39', 1, 10, NULL, NULL),
(11, 1, '2023-10-12 19:29:20', 1, 11, NULL, NULL),
(12, 1, '2023-10-15 22:31:15', 1, 12, NULL, NULL),
(13, 1, '2023-10-18 05:19:55', 1, 13, NULL, NULL),
(14, 1, '2023-10-18 05:29:29', 1, 14, NULL, NULL),
(15, 1, '2023-10-19 14:58:42', 1, 15, NULL, NULL),
(16, 1, '2023-10-20 03:53:28', 1, 16, NULL, NULL),
(17, 2, '2023-10-20 03:53:45', 1, 17, NULL, NULL),
(18, 3, '2023-10-20 03:54:12', 1, 18, NULL, NULL),
(19, 2, '2023-10-20 03:54:36', 1, 19, NULL, NULL),
(20, 1, '2023-11-01 02:41:11', 1, 20, NULL, NULL),
(21, 1, '2023-11-07 21:13:12', 1, 22, NULL, NULL),
(22, 1, '2023-11-07 21:13:12', 1, 21, NULL, NULL),
(23, 1, '2023-11-07 21:13:12', 1, 23, NULL, NULL),
(24, 1, '2023-11-07 21:13:20', 1, 24, NULL, NULL),
(25, 1, '2023-11-12 03:15:34', 1, 25, NULL, NULL),
(26, 1, '2023-11-15 03:50:32', 1, 26, NULL, NULL),
(27, 1, '2023-11-17 22:09:47', 1, 27, NULL, NULL),
(28, 1, '2023-11-21 22:17:54', 1, 28, NULL, NULL),
(29, 1, '2023-11-24 22:24:29', 1, 29, NULL, NULL),
(30, 1, '2023-12-20 18:28:06', 1, 30, NULL, NULL),
(31, 1, '2024-01-06 21:42:48', 1, 31, NULL, NULL),
(32, 1, '2024-01-24 17:01:43', 1, 32, NULL, NULL),
(33, 4, '2024-01-24 17:01:44', 1, 33, NULL, NULL),
(34, 1, '2024-01-24 19:37:19', 1, 34, NULL, NULL),
(35, 1, '2024-02-26 19:23:21', 1, 35, NULL, NULL),
(36, 1, '2024-02-27 14:47:45', 1, 36, NULL, NULL),
(37, 1, '2024-03-01 00:55:11', 1, 37, NULL, NULL),
(38, 1, '2024-03-03 23:47:08', 1, 38, NULL, NULL),
(39, 5, '2024-03-07 13:28:43', 1, 39, NULL, NULL),
(40, 1, '2024-03-13 00:58:28', 1, 40, NULL, NULL),
(41, 5, '2024-03-14 00:26:32', 1, 41, NULL, NULL),
(42, 1, '2024-03-28 08:11:01', 1, 42, NULL, NULL),
(43, 1, '2024-03-29 16:34:56', 1, 43, 44, '2024-03-29 16:35:24'),
(44, 1, '2024-03-29 16:35:24', 1, 43, NULL, NULL),
(45, 1, '2024-04-01 22:28:08', 1, 44, NULL, NULL),
(46, 3, '2024-04-01 22:28:39', 1, 45, NULL, NULL),
(47, 6, '2024-04-01 22:29:09', 1, 46, NULL, NULL),
(48, 1, '2024-04-07 03:43:16', 1, 47, NULL, NULL),
(49, 1, '2024-04-18 18:11:16', 1, 48, NULL, NULL),
(50, 1, '2024-04-29 23:24:21', 1, 49, NULL, NULL),
(51, 1, '2024-05-03 19:56:22', 1, 50, NULL, NULL),
(52, 1, '2024-05-05 20:38:44', 1, 51, NULL, NULL),
(53, 2, '2024-05-05 20:39:07', 1, 52, NULL, NULL),
(54, 1, '2024-05-12 05:25:20', 1, 53, NULL, NULL),
(55, 1, '2024-05-12 05:25:24', 1, 54, NULL, NULL),
(56, 1, '2024-05-14 18:12:04', 1, 55, NULL, NULL),
(57, 1, '2024-05-25 11:34:05', 1, 56, NULL, NULL),
(58, 1, '2024-06-02 01:28:07', 1, 57, NULL, NULL),
(59, 1, '2024-06-02 01:28:26', 1, 58, NULL, NULL),
(60, 1, '2024-06-02 05:14:52', 1, 59, NULL, NULL),
(61, 1, '2024-06-02 17:09:49', 1, 60, NULL, NULL),
(62, 1, '2024-06-03 15:27:19', 1, 61, NULL, NULL),
(63, 1, '2024-06-05 23:30:45', 1, 62, NULL, NULL),
(64, 1, '2024-06-18 02:37:02', 1, 63, NULL, NULL),
(65, 1, '2024-06-22 17:20:05', 1, 64, NULL, NULL),
(66, 1, '2024-06-22 21:10:12', 1, 65, NULL, NULL),
(67, 1, '2024-06-25 02:06:09', 1, 66, NULL, NULL),
(68, 1, '2024-07-05 21:18:37', 1, 67, NULL, NULL),
(69, 1, '2024-07-10 16:47:36', 1, 68, NULL, NULL),
(70, 1, '2024-07-10 18:40:39', 1, 69, NULL, NULL),
(71, 1, '2024-07-10 19:08:52', 1, 70, 72, '2024-07-10 19:09:21'),
(72, 4, '2024-07-10 19:09:21', 1, 70, NULL, NULL),
(73, 1, '2024-07-12 15:42:39', 1, 71, NULL, NULL),
(74, 1, '2024-07-15 23:34:40', 1, 72, 75, '2024-07-15 23:35:38'),
(75, 1, '2024-07-15 23:35:38', 1, 72, NULL, NULL),
(76, 1, '2024-07-17 12:54:08', 1, 73, NULL, NULL),
(77, 1, '2024-07-27 08:51:21', 1, 74, NULL, NULL),
(78, 1, '2024-07-27 08:51:22', 1, 75, NULL, NULL),
(79, 1, '2024-07-31 01:38:42', 1, 76, NULL, NULL),
(80, 1, '2024-08-01 12:14:20', 1, 77, NULL, NULL),
(81, 1, '2024-08-15 12:09:01', 1, 78, NULL, NULL),
(82, 1, '2024-08-17 08:01:04', 1, 79, NULL, NULL),
(83, 1, '2024-08-21 16:01:07', 1, 80, NULL, NULL),
(84, 1, '2024-08-27 03:50:20', 1, 81, NULL, NULL),
(85, 3, '2024-08-27 03:53:14', 1, 82, 86, '2024-08-27 03:53:25'),
(86, 6, '2024-08-27 03:53:25', 1, 82, NULL, NULL),
(87, 1, '2024-08-28 23:18:55', 1, 83, NULL, NULL),
(88, 1, '2024-09-02 17:42:03', 1, 84, NULL, NULL),
(89, 1, '2024-09-02 21:13:42', 1, 85, NULL, NULL),
(90, 1, '2024-09-08 14:50:39', 1, 86, NULL, NULL),
(91, 1, '2024-09-09 18:46:11', 1, 87, NULL, NULL),
(92, 1, '2024-09-10 13:43:58', 1, 88, NULL, NULL),
(93, 7, '2024-09-10 16:44:02', 1, 89, NULL, NULL),
(94, 1, '2024-09-19 20:03:44', 1, 90, NULL, NULL),
(95, 1, '2024-09-25 12:53:40', 1, 91, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `hpp_independent_analytics_visitors`
--

CREATE TABLE `hpp_independent_analytics_visitors` (
  `visitor_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hash` varchar(32) NOT NULL,
  PRIMARY KEY (`visitor_id`),
  UNIQUE KEY `hash` (`hash`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

--
-- Dumping data for table `hpp_independent_analytics_visitors`
--

INSERT INTO `hpp_independent_analytics_visitors` VALUES
(1, '00248fefc63ef1c589ac5f1e3c95511a'),
(2, '01fca0327424f9e7eade64d143ac6a2d'),
(3, '0f115332aefdbdfaea8bb6d444bd4c66'),
(4, '18f4d82d23fff2c4b9adcc5181d28fec'),
(5, '1d3a48d52ba3a903a3980e5131ddf1c2'),
(6, '25e2a6c055e95f899035a76a109c22bb'),
(7, '32bcd2c237c69dcc145f08b687ae293b'),
(8, '38a6b19f36602c8ed5c4ef081525296e'),
(9, '43ec56d787959580c0440dc74205707c'),
(10, '559408be619f8557068d6b853e814a4d'),
(11, '6768234a6928a34b41ff0811b42ffbe2'),
(12, '6a589c0e11de285ad6d150a5529f8f16'),
(13, '6bb7c44302b4f328591831e9f6addd99'),
(14, '6da64af89936260f23ce70e5e91f4357'),
(15, '7c8b33740234bd3d6fce8a981cebfd1f'),
(16, '80510102bf1f5155454abdbe781d0e1c'),
(17, '8242e71bcdfebd39853b1c1395a2a2a8'),
(18, '82c70e3eef71286f8fb3151786c4c661'),
(19, '951481593b0df355a77bac70f8e6f0ca'),
(20, '9e5032fb5a2230a5e8c4c001d04ad6f8'),
(21, 'a62d2654c55eebdc430208629a16ed4a'),
(22, 'af039f8978625882e659cb949acfa1c5'),
(23, 'b64e8fdf21a5d0407707903b5af67698'),
(24, 'bd388961cab7b7edb4ddfd9548e2cf96'),
(25, 'c0839e99ff2a3c14248507b7416aa4ad'),
(26, 'c2c2e796c2215c4a9060e88baaf84cbe'),
(27, 'c708c24d5610b3c44c82f3b9a93fa33e'),
(28, 'cb535fdd8685ba358971280d15480297'),
(29, 'dbc75861d67b380208be34051a12d14b'),
(30, 'dbc833f79979a1e56dd217e4e4c5dfe4'),
(31, 'ee3d96e75462c0fa1792e9a8c8d17a3f'),
(32, 'f2f902e800867fe056f8de9e004e9f32'),
(33, 'ff311395db04c3d1d44f0a2332a20580'),
(34, '63a27d470a3a0630f896f9b3526d40cd'),
(35, '8dda2cf2739294ce0f48a7c315bf0b22'),
(36, '46ea62a0215b4b7525678c7d9dabffe9'),
(37, '2460fc372da822a341fbf6ac9b3c59b0'),
(38, 'c0aa02edc24029d1f10b472311e01a9e'),
(39, '10b1e8c9387a41a15082cbc2a9b38f7f'),
(40, 'dc387f8408c2db4aac37ea8f4712057b'),
(41, '64a3ed8c33b2a44e97c83bd9ae9f7607'),
(42, 'ba571c3d10a6219f88586301dfe2fd22'),
(43, 'bfa5e433be5de81e9ba43d14c0b5de43'),
(44, 'a58f8324a7527fc6d163e6ebed974370'),
(45, '3a1777b5abe524e06922e56278b1b849'),
(46, 'bc36a620cd96e648ab03a661af75f4c1'),
(47, '7271db67fc9a722a9fbb9d9657555d93'),
(48, '5548a348e3c176433d415c6c6e14d16c'),
(49, '35dfef4b0769947fe0729c52e2299ebe'),
(50, '3c5bbd621b1b634e976f6613d4701d1e'),
(51, '4ffaac94c7899a7409c9c3c9c2208dae'),
(52, 'd767c0b7311c1cbabb52f5680bccd002'),
(53, '096c90517145df1385444e978d02bd02'),
(54, '49eb8092f2b2ff3d9df410407b55dcd6'),
(55, '5d0630e19da131cbd1c6b4a5919f8f22'),
(56, '4cab0a62cc7328a564a6efa997f32551'),
(57, '93b495db35bc7219fc7052d887f2c823'),
(58, '4963e59953154cafbd005c44269955f4'),
(59, 'c00123fba47e269b3b706856a43ae92b'),
(60, 'b2006c267ac874ffc465a64edd1d00cb'),
(61, 'a2303cdaea2724bc3dc9c4dfc0b140f8'),
(62, '4e638885bf0e1a7f2832c444861bef5c'),
(63, '8d1dc5a766254251ceb5e554fe3775d0'),
(64, '3345336a9bdbc686390c93ef986af7fb'),
(65, 'feab94c011e00ea4ec8a08fca5a658eb'),
(66, 'dfb9bad0a5e34af3781e640f3006638f'),
(67, '6203a77ae418d7e65aedaac43fd4bf2e'),
(68, 'f3e63d27ffa6f7d5e94b80af83fe9b85'),
(69, 'ec25adfbe16705d149ad47c101298b90'),
(70, '658a7602d3c101fc41204cfedfe2b03c'),
(71, '957f82418d68e31fb2978b07210ee73e'),
(72, 'e6206be062c9ec7ba2d98f380423f0c5');

-- --------------------------------------------------------

--
-- Table structure for table `hpp_independent_analytics_wc_orders`
--

CREATE TABLE `hpp_independent_analytics_wc_orders` (
  `order_id` bigint(20) unsigned NOT NULL,
  `view_id` bigint(20) unsigned NOT NULL,
  `initial_view_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `total` double DEFAULT NULL,
  `total_refunded` double DEFAULT NULL,
  `total_refunds` smallint(6) DEFAULT NULL,
  `status` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`order_id`),
  KEY `wc_orders_view_id_index` (`view_id`),
  KEY `wc_orders_created_at_index` (`created_at`),
  KEY `initial_view_id` (`initial_view_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- --------------------------------------------------------

--
-- Table structure for table `hpp_links`
--

CREATE TABLE `hpp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `hpp_options`
--

CREATE TABLE `hpp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `hpp_options`
--

INSERT INTO `hpp_options` VALUES
(1, 'siteurl', 'https://yanbal.directorioempresascolombia.com/BogotA', 'yes'),
(2, 'home', 'https://yanbal.directorioempresascolombia.com/', 'yes'),
(3, 'blogname', 'Productos Belleza Yanbal en Bucaramanga', 'yes'),
(4, 'blogdescription', 'Perfumes, lociones, cremas y todo para mujeres. hombres y niños. Directora y Consultora Wilma Jaimes.', 'yes'),
(5, 'users_can_register', '0', 'yes'),
(6, 'admin_email', 'pintoherman44@gmail.com', 'yes'),
(7, 'start_of_week', '1', 'yes'),
(8, 'use_balanceTags', '0', 'yes'),
(9, 'use_smilies', '1', 'yes'),
(10, 'require_name_email', '1', 'yes'),
(11, 'comments_notify', '1', 'yes'),
(12, 'posts_per_rss', '10', 'yes'),
(13, 'rss_use_excerpt', '1', 'yes'),
(14, 'mailserver_url', 'mail.example.com', 'yes'),
(15, 'mailserver_login', 'login@example.com', 'yes'),
(16, 'mailserver_pass', 'password', 'yes'),
(17, 'mailserver_port', '110', 'yes'),
(18, 'default_category', '1', 'yes'),
(19, 'default_comment_status', 'open', 'yes'),
(20, 'default_ping_status', 'open', 'yes'),
(21, 'default_pingback_flag', '1', 'yes'),
(22, 'posts_per_page', '10', 'yes'),
(23, 'date_format', 'F j, Y', 'yes'),
(24, 'time_format', 'g:i a', 'yes'),
(25, 'links_updated_date_format', 'F j, Y g:i a', 'yes'),
(26, 'comment_moderation', '0', 'yes'),
(27, 'moderation_notify', '1', 'yes'),
(28, 'permalink_structure', '/%postname%/', 'yes'),
(29, 'rewrite_rules', 'a:111:{s:11:"^wp-json/?$";s:22:"index.php?rest_route=/";s:14:"^wp-json/(.*)?";s:33:"index.php?rest_route=/$matches[1]";s:21:"^index.php/wp-json/?$";s:22:"index.php?rest_route=/";s:24:"^index.php/wp-json/(.*)?";s:33:"index.php?rest_route=/$matches[1]";s:17:"^wp-sitemap\\.xml$";s:23:"index.php?sitemap=index";s:17:"^wp-sitemap\\.xsl$";s:36:"index.php?sitemap-stylesheet=sitemap";s:23:"^wp-sitemap-index\\.xsl$";s:34:"index.php?sitemap-stylesheet=index";s:48:"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$";s:75:"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]";s:34:"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$";s:47:"index.php?sitemap=$matches[1]&paged=$matches[2]";s:47:"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?category_name=$matches[1]&feed=$matches[2]";s:42:"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?category_name=$matches[1]&feed=$matches[2]";s:23:"category/(.+?)/embed/?$";s:46:"index.php?category_name=$matches[1]&embed=true";s:35:"category/(.+?)/page/?([0-9]{1,})/?$";s:53:"index.php?category_name=$matches[1]&paged=$matches[2]";s:17:"category/(.+?)/?$";s:35:"index.php?category_name=$matches[1]";s:44:"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?tag=$matches[1]&feed=$matches[2]";s:39:"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?tag=$matches[1]&feed=$matches[2]";s:20:"tag/([^/]+)/embed/?$";s:36:"index.php?tag=$matches[1]&embed=true";s:32:"tag/([^/]+)/page/?([0-9]{1,})/?$";s:43:"index.php?tag=$matches[1]&paged=$matches[2]";s:14:"tag/([^/]+)/?$";s:25:"index.php?tag=$matches[1]";s:45:"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?post_format=$matches[1]&feed=$matches[2]";s:40:"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?post_format=$matches[1]&feed=$matches[2]";s:21:"type/([^/]+)/embed/?$";s:44:"index.php?post_format=$matches[1]&embed=true";s:33:"type/([^/]+)/page/?([0-9]{1,})/?$";s:51:"index.php?post_format=$matches[1]&paged=$matches[2]";s:15:"type/([^/]+)/?$";s:33:"index.php?post_format=$matches[1]";s:40:"kadence-form/[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:50:"kadence-form/[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:70:"kadence-form/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:65:"kadence-form/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:65:"kadence-form/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:46:"kadence-form/[^/]+/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:29:"kadence-form/([^/]+)/embed/?$";s:45:"index.php?kadence_form=$matches[1]&embed=true";s:33:"kadence-form/([^/]+)/trackback/?$";s:39:"index.php?kadence_form=$matches[1]&tb=1";s:41:"kadence-form/([^/]+)/page/?([0-9]{1,})/?$";s:52:"index.php?kadence_form=$matches[1]&paged=$matches[2]";s:48:"kadence-form/([^/]+)/comment-page-([0-9]{1,})/?$";s:52:"index.php?kadence_form=$matches[1]&cpage=$matches[2]";s:37:"kadence-form/([^/]+)(?:/([0-9]+))?/?$";s:51:"index.php?kadence_form=$matches[1]&page=$matches[2]";s:29:"kadence-form/[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:39:"kadence-form/[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:59:"kadence-form/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:54:"kadence-form/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:54:"kadence-form/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:35:"kadence-form/[^/]+/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:12:"robots\\.txt$";s:18:"index.php?robots=1";s:13:"favicon\\.ico$";s:19:"index.php?favicon=1";s:48:".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$";s:18:"index.php?feed=old";s:20:".*wp-app\\.php(/.*)?$";s:19:"index.php?error=403";s:18:".*wp-register.php$";s:23:"index.php?register=true";s:32:"feed/(feed|rdf|rss|rss2|atom)/?$";s:27:"index.php?&feed=$matches[1]";s:27:"(feed|rdf|rss|rss2|atom)/?$";s:27:"index.php?&feed=$matches[1]";s:8:"embed/?$";s:21:"index.php?&embed=true";s:20:"page/?([0-9]{1,})/?$";s:28:"index.php?&paged=$matches[1]";s:27:"comment-page-([0-9]{1,})/?$";s:38:"index.php?&page_id=6&cpage=$matches[1]";s:41:"comments/feed/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?&feed=$matches[1]&withcomments=1";s:36:"comments/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?&feed=$matches[1]&withcomments=1";s:17:"comments/embed/?$";s:21:"index.php?&embed=true";s:44:"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:40:"index.php?s=$matches[1]&feed=$matches[2]";s:39:"search/(.+)/(feed|rdf|rss|rss2|atom)/?$";s:40:"index.php?s=$matches[1]&feed=$matches[2]";s:20:"search/(.+)/embed/?$";s:34:"index.php?s=$matches[1]&embed=true";s:32:"search/(.+)/page/?([0-9]{1,})/?$";s:41:"index.php?s=$matches[1]&paged=$matches[2]";s:14:"search/(.+)/?$";s:23:"index.php?s=$matches[1]";s:47:"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?author_name=$matches[1]&feed=$matches[2]";s:42:"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?author_name=$matches[1]&feed=$matches[2]";s:23:"author/([^/]+)/embed/?$";s:44:"index.php?author_name=$matches[1]&embed=true";s:35:"author/([^/]+)/page/?([0-9]{1,})/?$";s:51:"index.php?author_name=$matches[1]&paged=$matches[2]";s:17:"author/([^/]+)/?$";s:33:"index.php?author_name=$matches[1]";s:69:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$";s:80:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]";s:64:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$";s:80:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]";s:45:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$";s:74:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true";s:57:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$";s:81:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]";s:39:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$";s:63:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]";s:56:"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$";s:64:"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]";s:51:"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$";s:64:"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]";s:32:"([0-9]{4})/([0-9]{1,2})/embed/?$";s:58:"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true";s:44:"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$";s:65:"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]";s:26:"([0-9]{4})/([0-9]{1,2})/?$";s:47:"index.php?year=$matches[1]&monthnum=$matches[2]";s:43:"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?year=$matches[1]&feed=$matches[2]";s:38:"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?year=$matches[1]&feed=$matches[2]";s:19:"([0-9]{4})/embed/?$";s:37:"index.php?year=$matches[1]&embed=true";s:31:"([0-9]{4})/page/?([0-9]{1,})/?$";s:44:"index.php?year=$matches[1]&paged=$matches[2]";s:13:"([0-9]{4})/?$";s:26:"index.php?year=$matches[1]";s:27:".?.+?/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:37:".?.+?/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:57:".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:33:".?.+?/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:16:"(.?.+?)/embed/?$";s:41:"index.php?pagename=$matches[1]&embed=true";s:20:"(.?.+?)/trackback/?$";s:35:"index.php?pagename=$matches[1]&tb=1";s:40:"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:47:"index.php?pagename=$matches[1]&feed=$matches[2]";s:35:"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$";s:47:"index.php?pagename=$matches[1]&feed=$matches[2]";s:28:"(.?.+?)/page/?([0-9]{1,})/?$";s:48:"index.php?pagename=$matches[1]&paged=$matches[2]";s:35:"(.?.+?)/comment-page-([0-9]{1,})/?$";s:48:"index.php?pagename=$matches[1]&cpage=$matches[2]";s:24:"(.?.+?)(?:/([0-9]+))?/?$";s:47:"index.php?pagename=$matches[1]&page=$matches[2]";s:27:"[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:37:"[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:57:"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:33:"[^/]+/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:16:"([^/]+)/embed/?$";s:37:"index.php?name=$matches[1]&embed=true";s:20:"([^/]+)/trackback/?$";s:31:"index.php?name=$matches[1]&tb=1";s:40:"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?name=$matches[1]&feed=$matches[2]";s:35:"([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?name=$matches[1]&feed=$matches[2]";s:28:"([^/]+)/page/?([0-9]{1,})/?$";s:44:"index.php?name=$matches[1]&paged=$matches[2]";s:35:"([^/]+)/comment-page-([0-9]{1,})/?$";s:44:"index.php?name=$matches[1]&cpage=$matches[2]";s:24:"([^/]+)(?:/([0-9]+))?/?$";s:43:"index.php?name=$matches[1]&page=$matches[2]";s:16:"[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:26:"[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:46:"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:41:"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:41:"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:22:"[^/]+/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";}', 'yes'),
(30, 'hack_file', '0', 'yes'),
(31, 'blog_charset', 'UTF-8', 'yes'),
(32, 'moderation_keys', '', 'no'),
(33, 'active_plugins', 'a:5:{i:0;s:51:"all-in-one-wp-migration/all-in-one-wp-migration.php";i:1;s:35:"google-site-kit/google-site-kit.php";i:2;s:30:"independent-analytics/iawp.php";i:3;s:33:"kadence-blocks/kadence-blocks.php";i:4;s:24:"wordpress-seo/wp-seo.php";}', 'yes'),
(34, 'category_base', '', 'yes'),
(35, 'ping_sites', 'http://rpc.pingomatic.com/', 'yes'),
(36, 'comment_max_links', '2', 'yes'),
(37, 'gmt_offset', '0', 'yes'),
(38, 'default_email_category', '1', 'yes'),
(39, 'recently_edited', '', 'no'),
(40, 'template', 'kadence', 'yes'),
(41, 'stylesheet', 'kadence', 'yes'),
(42, 'comment_registration', '0', 'yes'),
(43, 'html_type', 'text/html', 'yes'),
(44, 'use_trackback', '0', 'yes'),
(45, 'default_role', 'subscriber', 'yes'),
(46, 'db_version', '57155', 'yes'),
(47, 'uploads_use_yearmonth_folders', '1', 'yes'),
(48, 'upload_path', '', 'yes'),
(49, 'blog_public', '1', 'yes'),
(50, 'default_link_category', '2', 'yes'),
(51, 'show_on_front', 'page', 'yes'),
(52, 'tag_base', '', 'yes'),
(53, 'show_avatars', '1', 'yes'),
(54, 'avatar_rating', 'G', 'yes'),
(55, 'upload_url_path', '', 'yes'),
(56, 'thumbnail_size_w', '150', 'yes'),
(57, 'thumbnail_size_h', '150', 'yes'),
(58, 'thumbnail_crop', '1', 'yes'),
(59, 'medium_size_w', '300', 'yes'),
(60, 'medium_size_h', '300', 'yes'),
(61, 'avatar_default', 'mystery', 'yes'),
(62, 'large_size_w', '1024', 'yes'),
(63, 'large_size_h', '1024', 'yes'),
(64, 'image_default_link_type', 'none', 'yes'),
(65, 'image_default_size', '', 'yes'),
(66, 'image_default_align', '', 'yes'),
(67, 'close_comments_for_old_posts', '0', 'yes'),
(68, 'close_comments_days_old', '14', 'yes'),
(69, 'thread_comments', '1', 'yes'),
(70, 'thread_comments_depth', '5', 'yes'),
(71, 'page_comments', '0', 'yes'),
(72, 'comments_per_page', '50', 'yes'),
(73, 'default_comments_page', 'newest', 'yes'),
(74, 'comment_order', 'asc', 'yes'),
(75, 'sticky_posts', 'a:0:{}', 'yes'),
(76, 'widget_categories', 'a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}', 'yes'),
(77, 'widget_text', 'a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}', 'yes'),
(78, 'widget_rss', 'a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}', 'yes'),
(79, 'uninstall_plugins', 'a:1:{s:24:"wordpress-seo/wp-seo.php";s:14:"__return_false";}', 'no'),
(80, 'timezone_string', '', 'yes'),
(81, 'page_for_posts', '10', 'yes'),
(82, 'page_on_front', '6', 'yes'),
(83, 'default_post_format', '0', 'yes'),
(84, 'link_manager_enabled', '0', 'yes'),
(85, 'finished_splitting_shared_terms', '1', 'yes'),
(86, 'site_icon', '0', 'yes'),
(87, 'medium_large_size_w', '768', 'yes'),
(88, 'medium_large_size_h', '0', 'yes'),
(89, 'wp_page_for_privacy_policy', '3', 'yes'),
(90, 'show_comments_cookies_opt_in', '1', 'yes'),
(91, 'admin_email_lifespan', '1736188920', 'yes'),
(92, 'disallowed_keys', '', 'no'),
(93, 'comment_previously_approved', '1', 'yes'),
(94, 'auto_plugin_theme_update_emails', 'a:0:{}', 'no'),
(95, 'auto_update_core_dev', 'enabled', 'yes'),
(96, 'auto_update_core_minor', 'enabled', 'yes'),
(97, 'auto_update_core_major', 'enabled', 'yes'),
(98, 'wp_force_deactivated_plugins', 'a:0:{}', 'yes'),
(99, 'initial_db_version', '55853', 'yes'),
(100, 'hpp_user_roles', 'a:7:{s:13:"administrator";a:2:{s:4:"name";s:13:"Administrator";s:12:"capabilities";a:62:{s:13:"switch_themes";b:1;s:11:"edit_themes";b:1;s:16:"activate_plugins";b:1;s:12:"edit_plugins";b:1;s:10:"edit_users";b:1;s:10:"edit_files";b:1;s:14:"manage_options";b:1;s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:6:"import";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:8:"level_10";b:1;s:7:"level_9";b:1;s:7:"level_8";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;s:12:"delete_users";b:1;s:12:"create_users";b:1;s:17:"unfiltered_upload";b:1;s:14:"edit_dashboard";b:1;s:14:"update_plugins";b:1;s:14:"delete_plugins";b:1;s:15:"install_plugins";b:1;s:13:"update_themes";b:1;s:14:"install_themes";b:1;s:11:"update_core";b:1;s:10:"list_users";b:1;s:12:"remove_users";b:1;s:13:"promote_users";b:1;s:18:"edit_theme_options";b:1;s:13:"delete_themes";b:1;s:6:"export";b:1;s:20:"wpseo_manage_options";b:1;}}s:6:"editor";a:2:{s:4:"name";s:6:"Editor";s:12:"capabilities";a:36:{s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;s:15:"wpseo_bulk_edit";b:1;s:28:"wpseo_edit_advanced_metadata";b:1;}}s:6:"author";a:2:{s:4:"name";s:6:"Author";s:12:"capabilities";a:10:{s:12:"upload_files";b:1;s:10:"edit_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:4:"read";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:12:"delete_posts";b:1;s:22:"delete_published_posts";b:1;}}s:11:"contributor";a:2:{s:4:"name";s:11:"Contributor";s:12:"capabilities";a:5:{s:10:"edit_posts";b:1;s:4:"read";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:12:"delete_posts";b:1;}}s:10:"subscriber";a:2:{s:4:"name";s:10:"Subscriber";s:12:"capabilities";a:2:{s:4:"read";b:1;s:7:"level_0";b:1;}}s:13:"wpseo_manager";a:2:{s:4:"name";s:11:"SEO Manager";s:12:"capabilities";a:38:{s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;s:15:"wpseo_bulk_edit";b:1;s:28:"wpseo_edit_advanced_metadata";b:1;s:20:"wpseo_manage_options";b:1;s:23:"view_site_health_checks";b:1;}}s:12:"wpseo_editor";a:2:{s:4:"name";s:10:"SEO Editor";s:12:"capabilities";a:36:{s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;s:15:"wpseo_bulk_edit";b:1;s:28:"wpseo_edit_advanced_metadata";b:1;}}}', 'yes'),
(101, 'fresh_site', '0', 'yes'),
(102, 'user_count', '2', 'no'),
(103, 'widget_block', 'a:6:{i:2;a:1:{s:7:"content";s:19:"<!-- wp:search /-->";}i:3;a:1:{s:7:"content";s:154:"<!-- wp:group --><div class="wp-block-group"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->";}i:4;a:1:{s:7:"content";s:227:"<!-- wp:group --><div class="wp-block-group"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {"displayAvatar":false,"displayDate":false,"displayExcerpt":false} /--></div><!-- /wp:group -->";}i:5;a:1:{s:7:"content";s:146:"<!-- wp:group --><div class="wp-block-group"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->";}i:6;a:1:{s:7:"content";s:150:"<!-- wp:group --><div class="wp-block-group"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->";}s:12:"_multiwidget";i:1;}', 'yes'),
(104, 'sidebars_widgets', 'a:10:{s:19:"wp_inactive_widgets";a:0:{}s:15:"sidebar-primary";a:3:{i:0;s:7:"block-2";i:1;s:7:"block-3";i:2;s:7:"block-4";}s:17:"sidebar-secondary";a:2:{i:0;s:7:"block-5";i:1;s:7:"block-6";}s:7:"footer1";a:0:{}s:7:"footer2";a:0:{}s:7:"footer3";a:0:{}s:7:"footer4";a:0:{}s:7:"footer5";a:0:{}s:7:"footer6";a:0:{}s:13:"array_version";i:3;}', 'yes'),
(105, 'cron', 'a:12:{i:1726868002;a:1:{s:34:"wp_privacy_delete_old_export_files";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"hourly";s:4:"args";a:0:{}s:8:"interval";i:3600;}}}i:1726875202;a:3:{s:16:"wp_version_check";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:17:"wp_update_plugins";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:16:"wp_update_themes";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}}i:1726875212;a:1:{s:21:"wp_update_user_counts";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}}i:1726893340;a:1:{s:41:"googlesitekit_cron_update_remote_features";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}}i:1726918402;a:2:{s:30:"wp_site_health_scheduled_check";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"weekly";s:4:"args";a:0:{}s:8:"interval";i:604800;}}s:32:"recovery_mode_clean_expired_keys";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1726918412;a:3:{s:20:"jetpack_v2_heartbeat";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}s:19:"wp_scheduled_delete";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}s:25:"delete_expired_transients";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1726918414;a:1:{s:30:"wp_scheduled_auto_draft_delete";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1726918483;a:2:{s:13:"wpseo-reindex";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}s:31:"wpseo_permalink_structure_check";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1726929690;a:1:{s:21:"ai1wm_storage_cleanup";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1727436830;a:1:{s:30:"wp_delete_temp_updater_backups";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"weekly";s:4:"args";a:0:{}s:8:"interval";i:604800;}}}i:1729003286;a:1:{s:27:"delete_block_library_folder";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:7:"monthly";s:4:"args";a:0:{}s:8:"interval";i:2592000;}}}s:7:"version";i:2;}', 'yes'),
(106, 'widget_pages', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
(107, 'widget_calendar', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
(108, 'widget_archives', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
(109, 'widget_media_audio', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
(110, 'widget_media_image', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
(111, 'widget_media_gallery', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
(112, 'widget_media_video', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
(113, 'widget_meta', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
(114, 'widget_search', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
(115, 'widget_recent-posts', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
(116, 'widget_recent-comments', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
(117, 'widget_tag_cloud', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
(118, 'widget_nav_menu', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
(119, 'widget_custom_html', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
(120, 'recovery_keys', 'a:0:{}', 'yes'),
(121, 'theme_mods_twentytwentythree', 'a:2:{s:18:"custom_css_post_id";i:-1;s:18:"nav_menu_locations";a:0:{}}', 'no'),
(122, '_transient_wp_core_block_css_files', 'a:496:{i:0;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/archives/editor-rtl.css";i:1;s:105:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/archives/editor-rtl.min.css";i:2;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/archives/editor.css";i:3;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/archives/editor.min.css";i:4;s:100:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/archives/style-rtl.css";i:5;s:104:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/archives/style-rtl.min.css";i:6;s:96:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/archives/style.css";i:7;s:100:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/archives/style.min.css";i:8;s:98:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/audio/editor-rtl.css";i:9;s:102:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/audio/editor-rtl.min.css";i:10;s:94:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/audio/editor.css";i:11;s:98:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/audio/editor.min.css";i:12;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/audio/style-rtl.css";i:13;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/audio/style-rtl.min.css";i:14;s:93:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/audio/style.css";i:15;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/audio/style.min.css";i:16;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/audio/theme-rtl.css";i:17;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/audio/theme-rtl.min.css";i:18;s:93:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/audio/theme.css";i:19;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/audio/theme.min.css";i:20;s:99:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/avatar/editor-rtl.css";i:21;s:103:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/avatar/editor-rtl.min.css";i:22;s:95:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/avatar/editor.css";i:23;s:99:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/avatar/editor.min.css";i:24;s:98:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/avatar/style-rtl.css";i:25;s:102:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/avatar/style-rtl.min.css";i:26;s:94:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/avatar/style.css";i:27;s:98:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/avatar/style.min.css";i:28;s:98:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/block/editor-rtl.css";i:29;s:102:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/block/editor-rtl.min.css";i:30;s:94:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/block/editor.css";i:31;s:98:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/block/editor.min.css";i:32;s:99:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/button/editor-rtl.css";i:33;s:103:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/button/editor-rtl.min.css";i:34;s:95:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/button/editor.css";i:35;s:99:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/button/editor.min.css";i:36;s:98:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/button/style-rtl.css";i:37;s:102:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/button/style-rtl.min.css";i:38;s:94:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/button/style.css";i:39;s:98:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/button/style.min.css";i:40;s:100:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/buttons/editor-rtl.css";i:41;s:104:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/buttons/editor-rtl.min.css";i:42;s:96:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/buttons/editor.css";i:43;s:100:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/buttons/editor.min.css";i:44;s:99:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/buttons/style-rtl.css";i:45;s:103:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/buttons/style-rtl.min.css";i:46;s:95:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/buttons/style.css";i:47;s:99:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/buttons/style.min.css";i:48;s:100:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/calendar/style-rtl.css";i:49;s:104:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/calendar/style-rtl.min.css";i:50;s:96:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/calendar/style.css";i:51;s:100:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/calendar/style.min.css";i:52;s:103:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/categories/editor-rtl.css";i:53;s:107:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/categories/editor-rtl.min.css";i:54;s:99:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/categories/editor.css";i:55;s:103:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/categories/editor.min.css";i:56;s:102:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/categories/style-rtl.css";i:57;s:106:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/categories/style-rtl.min.css";i:58;s:98:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/categories/style.css";i:59;s:102:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/categories/style.min.css";i:60;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/code/editor-rtl.css";i:61;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/code/editor-rtl.min.css";i:62;s:93:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/code/editor.css";i:63;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/code/editor.min.css";i:64;s:96:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/code/style-rtl.css";i:65;s:100:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/code/style-rtl.min.css";i:66;s:92:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/code/style.css";i:67;s:96:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/code/style.min.css";i:68;s:96:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/code/theme-rtl.css";i:69;s:100:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/code/theme-rtl.min.css";i:70;s:92:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/code/theme.css";i:71;s:96:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/code/theme.min.css";i:72;s:100:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/columns/editor-rtl.css";i:73;s:104:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/columns/editor-rtl.min.css";i:74;s:96:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/columns/editor.css";i:75;s:100:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/columns/editor.min.css";i:76;s:99:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/columns/style-rtl.css";i:77;s:103:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/columns/style-rtl.min.css";i:78;s:95:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/columns/style.css";i:79;s:99:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/columns/style.min.css";i:80;s:107:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/comment-content/style-rtl.css";i:81;s:111:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/comment-content/style-rtl.min.css";i:82;s:103:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/comment-content/style.css";i:83;s:107:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/comment-content/style.min.css";i:84;s:108:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/comment-template/style-rtl.css";i:85;s:112:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/comment-template/style-rtl.min.css";i:86;s:104:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/comment-template/style.css";i:87;s:108:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/comment-template/style.min.css";i:88;s:120:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/comments-pagination-numbers/editor-rtl.css";i:89;s:124:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/comments-pagination-numbers/editor-rtl.min.css";i:90;s:116:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/comments-pagination-numbers/editor.css";i:91;s:120:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/comments-pagination-numbers/editor.min.css";i:92;s:112:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/comments-pagination/editor-rtl.css";i:93;s:116:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/comments-pagination/editor-rtl.min.css";i:94;s:108:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/comments-pagination/editor.css";i:95;s:112:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/comments-pagination/editor.min.css";i:96;s:111:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/comments-pagination/style-rtl.css";i:97;s:115:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/comments-pagination/style-rtl.min.css";i:98;s:107:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/comments-pagination/style.css";i:99;s:111:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/comments-pagination/style.min.css";i:100;s:107:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/comments-title/editor-rtl.css";i:101;s:111:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/comments-title/editor-rtl.min.css";i:102;s:103:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/comments-title/editor.css";i:103;s:107:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/comments-title/editor.min.css";i:104;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/comments/editor-rtl.css";i:105;s:105:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/comments/editor-rtl.min.css";i:106;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/comments/editor.css";i:107;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/comments/editor.min.css";i:108;s:100:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/comments/style-rtl.css";i:109;s:104:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/comments/style-rtl.min.css";i:110;s:96:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/comments/style.css";i:111;s:100:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/comments/style.min.css";i:112;s:98:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/cover/editor-rtl.css";i:113;s:102:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/cover/editor-rtl.min.css";i:114;s:94:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/cover/editor.css";i:115;s:98:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/cover/editor.min.css";i:116;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/cover/style-rtl.css";i:117;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/cover/style-rtl.min.css";i:118;s:93:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/cover/style.css";i:119;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/cover/style.min.css";i:120;s:100:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/details/editor-rtl.css";i:121;s:104:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/details/editor-rtl.min.css";i:122;s:96:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/details/editor.css";i:123;s:100:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/details/editor.min.css";i:124;s:99:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/details/style-rtl.css";i:125;s:103:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/details/style-rtl.min.css";i:126;s:95:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/details/style.css";i:127;s:99:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/details/style.min.css";i:128;s:98:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/embed/editor-rtl.css";i:129;s:102:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/embed/editor-rtl.min.css";i:130;s:94:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/embed/editor.css";i:131;s:98:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/embed/editor.min.css";i:132;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/embed/style-rtl.css";i:133;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/embed/style-rtl.min.css";i:134;s:93:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/embed/style.css";i:135;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/embed/style.min.css";i:136;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/embed/theme-rtl.css";i:137;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/embed/theme-rtl.min.css";i:138;s:93:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/embed/theme.css";i:139;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/embed/theme.min.css";i:140;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/file/editor-rtl.css";i:141;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/file/editor-rtl.min.css";i:142;s:93:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/file/editor.css";i:143;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/file/editor.min.css";i:144;s:96:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/file/style-rtl.css";i:145;s:100:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/file/style-rtl.min.css";i:146;s:92:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/file/style.css";i:147;s:96:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/file/style.min.css";i:148;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/footnotes/style-rtl.css";i:149;s:105:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/footnotes/style-rtl.min.css";i:150;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/footnotes/style.css";i:151;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/footnotes/style.min.css";i:152;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/freeform/editor-rtl.css";i:153;s:105:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/freeform/editor-rtl.min.css";i:154;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/freeform/editor.css";i:155;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/freeform/editor.min.css";i:156;s:100:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/gallery/editor-rtl.css";i:157;s:104:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/gallery/editor-rtl.min.css";i:158;s:96:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/gallery/editor.css";i:159;s:100:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/gallery/editor.min.css";i:160;s:99:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/gallery/style-rtl.css";i:161;s:103:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/gallery/style-rtl.min.css";i:162;s:95:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/gallery/style.css";i:163;s:99:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/gallery/style.min.css";i:164;s:99:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/gallery/theme-rtl.css";i:165;s:103:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/gallery/theme-rtl.min.css";i:166;s:95:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/gallery/theme.css";i:167;s:99:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/gallery/theme.min.css";i:168;s:98:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/group/editor-rtl.css";i:169;s:102:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/group/editor-rtl.min.css";i:170;s:94:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/group/editor.css";i:171;s:98:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/group/editor.min.css";i:172;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/group/style-rtl.css";i:173;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/group/style-rtl.min.css";i:174;s:93:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/group/style.css";i:175;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/group/style.min.css";i:176;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/group/theme-rtl.css";i:177;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/group/theme-rtl.min.css";i:178;s:93:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/group/theme.css";i:179;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/group/theme.min.css";i:180;s:99:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/heading/style-rtl.css";i:181;s:103:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/heading/style-rtl.min.css";i:182;s:95:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/heading/style.css";i:183;s:99:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/heading/style.min.css";i:184;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/html/editor-rtl.css";i:185;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/html/editor-rtl.min.css";i:186;s:93:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/html/editor.css";i:187;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/html/editor.min.css";i:188;s:98:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/image/editor-rtl.css";i:189;s:102:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/image/editor-rtl.min.css";i:190;s:94:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/image/editor.css";i:191;s:98:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/image/editor.min.css";i:192;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/image/style-rtl.css";i:193;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/image/style-rtl.min.css";i:194;s:93:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/image/style.css";i:195;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/image/style.min.css";i:196;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/image/theme-rtl.css";i:197;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/image/theme-rtl.min.css";i:198;s:93:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/image/theme.css";i:199;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/image/theme.min.css";i:200;s:107:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/latest-comments/style-rtl.css";i:201;s:111:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/latest-comments/style-rtl.min.css";i:202;s:103:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/latest-comments/style.css";i:203;s:107:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/latest-comments/style.min.css";i:204;s:105:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/latest-posts/editor-rtl.css";i:205;s:109:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/latest-posts/editor-rtl.min.css";i:206;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/latest-posts/editor.css";i:207;s:105:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/latest-posts/editor.min.css";i:208;s:104:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/latest-posts/style-rtl.css";i:209;s:108:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/latest-posts/style-rtl.min.css";i:210;s:100:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/latest-posts/style.css";i:211;s:104:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/latest-posts/style.min.css";i:212;s:96:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/list/style-rtl.css";i:213;s:100:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/list/style-rtl.min.css";i:214;s:92:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/list/style.css";i:215;s:96:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/list/style.min.css";i:216;s:103:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/media-text/editor-rtl.css";i:217;s:107:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/media-text/editor-rtl.min.css";i:218;s:99:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/media-text/editor.css";i:219;s:103:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/media-text/editor.min.css";i:220;s:102:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/media-text/style-rtl.css";i:221;s:106:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/media-text/style-rtl.min.css";i:222;s:98:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/media-text/style.css";i:223;s:102:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/media-text/style.min.css";i:224;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/more/editor-rtl.css";i:225;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/more/editor-rtl.min.css";i:226;s:93:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/more/editor.css";i:227;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/more/editor.min.css";i:228;s:108:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/navigation-link/editor-rtl.css";i:229;s:112:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/navigation-link/editor-rtl.min.css";i:230;s:104:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/navigation-link/editor.css";i:231;s:108:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/navigation-link/editor.min.css";i:232;s:107:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/navigation-link/style-rtl.css";i:233;s:111:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/navigation-link/style-rtl.min.css";i:234;s:103:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/navigation-link/style.css";i:235;s:107:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/navigation-link/style.min.css";i:236;s:111:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/navigation-submenu/editor-rtl.css";i:237;s:115:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/navigation-submenu/editor-rtl.min.css";i:238;s:107:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/navigation-submenu/editor.css";i:239;s:111:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/navigation-submenu/editor.min.css";i:240;s:103:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/navigation/editor-rtl.css";i:241;s:107:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/navigation/editor-rtl.min.css";i:242;s:99:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/navigation/editor.css";i:243;s:103:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/navigation/editor.min.css";i:244;s:102:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/navigation/style-rtl.css";i:245;s:106:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/navigation/style-rtl.min.css";i:246;s:98:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/navigation/style.css";i:247;s:102:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/navigation/style.min.css";i:248;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/nextpage/editor-rtl.css";i:249;s:105:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/nextpage/editor-rtl.min.css";i:250;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/nextpage/editor.css";i:251;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/nextpage/editor.min.css";i:252;s:102:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/page-list/editor-rtl.css";i:253;s:106:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/page-list/editor-rtl.min.css";i:254;s:98:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/page-list/editor.css";i:255;s:102:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/page-list/editor.min.css";i:256;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/page-list/style-rtl.css";i:257;s:105:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/page-list/style-rtl.min.css";i:258;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/page-list/style.css";i:259;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/page-list/style.min.css";i:260;s:102:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/paragraph/editor-rtl.css";i:261;s:106:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/paragraph/editor-rtl.min.css";i:262;s:98:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/paragraph/editor.css";i:263;s:102:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/paragraph/editor.min.css";i:264;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/paragraph/style-rtl.css";i:265;s:105:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/paragraph/style-rtl.min.css";i:266;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/paragraph/style.css";i:267;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/paragraph/style.min.css";i:268;s:103:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-author/style-rtl.css";i:269;s:107:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-author/style-rtl.min.css";i:270;s:99:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-author/style.css";i:271;s:103:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-author/style.min.css";i:272;s:111:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-comments-form/editor-rtl.css";i:273;s:115:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-comments-form/editor-rtl.min.css";i:274;s:107:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-comments-form/editor.css";i:275;s:111:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-comments-form/editor.min.css";i:276;s:110:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-comments-form/style-rtl.css";i:277;s:114:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-comments-form/style-rtl.min.css";i:278;s:106:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-comments-form/style.css";i:279;s:110:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-comments-form/style.min.css";i:280;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-date/style-rtl.css";i:281;s:105:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-date/style-rtl.min.css";i:282;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-date/style.css";i:283;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-date/style.min.css";i:284;s:105:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-excerpt/editor-rtl.css";i:285;s:109:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-excerpt/editor-rtl.min.css";i:286;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-excerpt/editor.css";i:287;s:105:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-excerpt/editor.min.css";i:288;s:104:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-excerpt/style-rtl.css";i:289;s:108:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-excerpt/style-rtl.min.css";i:290;s:100:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-excerpt/style.css";i:291;s:104:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-excerpt/style.min.css";i:292;s:112:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-featured-image/editor-rtl.css";i:293;s:116:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-featured-image/editor-rtl.min.css";i:294;s:108:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-featured-image/editor.css";i:295;s:112:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-featured-image/editor.min.css";i:296;s:111:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-featured-image/style-rtl.css";i:297;s:115:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-featured-image/style-rtl.min.css";i:298;s:107:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-featured-image/style.css";i:299;s:111:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-featured-image/style.min.css";i:300;s:112:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-navigation-link/style-rtl.css";i:301;s:116:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-navigation-link/style-rtl.min.css";i:302;s:108:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-navigation-link/style.css";i:303;s:112:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-navigation-link/style.min.css";i:304;s:106:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-template/editor-rtl.css";i:305;s:110:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-template/editor-rtl.min.css";i:306;s:102:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-template/editor.css";i:307;s:106:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-template/editor.min.css";i:308;s:105:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-template/style-rtl.css";i:309;s:109:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-template/style-rtl.min.css";i:310;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-template/style.css";i:311;s:105:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-template/style.min.css";i:312;s:102:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-terms/style-rtl.css";i:313;s:106:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-terms/style-rtl.min.css";i:314;s:98:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-terms/style.css";i:315;s:102:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-terms/style.min.css";i:316;s:102:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-title/style-rtl.css";i:317;s:106:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-title/style-rtl.min.css";i:318;s:98:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-title/style.css";i:319;s:102:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/post-title/style.min.css";i:320;s:104:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/preformatted/style-rtl.css";i:321;s:108:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/preformatted/style-rtl.min.css";i:322;s:100:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/preformatted/style.css";i:323;s:104:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/preformatted/style.min.css";i:324;s:102:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/pullquote/editor-rtl.css";i:325;s:106:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/pullquote/editor-rtl.min.css";i:326;s:98:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/pullquote/editor.css";i:327;s:102:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/pullquote/editor.min.css";i:328;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/pullquote/style-rtl.css";i:329;s:105:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/pullquote/style-rtl.min.css";i:330;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/pullquote/style.css";i:331;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/pullquote/style.min.css";i:332;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/pullquote/theme-rtl.css";i:333;s:105:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/pullquote/theme-rtl.min.css";i:334;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/pullquote/theme.css";i:335;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/pullquote/theme.min.css";i:336;s:117:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/query-pagination-numbers/editor-rtl.css";i:337;s:121:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/query-pagination-numbers/editor-rtl.min.css";i:338;s:113:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/query-pagination-numbers/editor.css";i:339;s:117:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/query-pagination-numbers/editor.min.css";i:340;s:109:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/query-pagination/editor-rtl.css";i:341;s:113:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/query-pagination/editor-rtl.min.css";i:342;s:105:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/query-pagination/editor.css";i:343;s:109:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/query-pagination/editor.min.css";i:344;s:108:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/query-pagination/style-rtl.css";i:345;s:112:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/query-pagination/style-rtl.min.css";i:346;s:104:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/query-pagination/style.css";i:347;s:108:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/query-pagination/style.min.css";i:348;s:103:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/query-title/style-rtl.css";i:349;s:107:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/query-title/style-rtl.min.css";i:350;s:99:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/query-title/style.css";i:351;s:103:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/query-title/style.min.css";i:352;s:98:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/query/editor-rtl.css";i:353;s:102:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/query/editor-rtl.min.css";i:354;s:94:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/query/editor.css";i:355;s:98:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/query/editor.min.css";i:356;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/quote/style-rtl.css";i:357;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/quote/style-rtl.min.css";i:358;s:93:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/quote/style.css";i:359;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/quote/style.min.css";i:360;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/quote/theme-rtl.css";i:361;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/quote/theme-rtl.min.css";i:362;s:93:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/quote/theme.css";i:363;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/quote/theme.min.css";i:364;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/read-more/style-rtl.css";i:365;s:105:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/read-more/style-rtl.min.css";i:366;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/read-more/style.css";i:367;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/read-more/style.min.css";i:368;s:96:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/rss/editor-rtl.css";i:369;s:100:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/rss/editor-rtl.min.css";i:370;s:92:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/rss/editor.css";i:371;s:96:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/rss/editor.min.css";i:372;s:95:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/rss/style-rtl.css";i:373;s:99:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/rss/style-rtl.min.css";i:374;s:91:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/rss/style.css";i:375;s:95:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/rss/style.min.css";i:376;s:99:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/search/editor-rtl.css";i:377;s:103:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/search/editor-rtl.min.css";i:378;s:95:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/search/editor.css";i:379;s:99:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/search/editor.min.css";i:380;s:98:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/search/style-rtl.css";i:381;s:102:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/search/style-rtl.min.css";i:382;s:94:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/search/style.css";i:383;s:98:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/search/style.min.css";i:384;s:98:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/search/theme-rtl.css";i:385;s:102:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/search/theme-rtl.min.css";i:386;s:94:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/search/theme.css";i:387;s:98:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/search/theme.min.css";i:388;s:102:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/separator/editor-rtl.css";i:389;s:106:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/separator/editor-rtl.min.css";i:390;s:98:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/separator/editor.css";i:391;s:102:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/separator/editor.min.css";i:392;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/separator/style-rtl.css";i:393;s:105:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/separator/style-rtl.min.css";i:394;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/separator/style.css";i:395;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/separator/style.min.css";i:396;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/separator/theme-rtl.css";i:397;s:105:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/separator/theme-rtl.min.css";i:398;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/separator/theme.css";i:399;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/separator/theme.min.css";i:400;s:102:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/shortcode/editor-rtl.css";i:401;s:106:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/shortcode/editor-rtl.min.css";i:402;s:98:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/shortcode/editor.css";i:403;s:102:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/shortcode/editor.min.css";i:404;s:102:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/site-logo/editor-rtl.css";i:405;s:106:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/site-logo/editor-rtl.min.css";i:406;s:98:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/site-logo/editor.css";i:407;s:102:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/site-logo/editor.min.css";i:408;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/site-logo/style-rtl.css";i:409;s:105:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/site-logo/style-rtl.min.css";i:410;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/site-logo/style.css";i:411;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/site-logo/style.min.css";i:412;s:105:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/site-tagline/editor-rtl.css";i:413;s:109:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/site-tagline/editor-rtl.min.css";i:414;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/site-tagline/editor.css";i:415;s:105:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/site-tagline/editor.min.css";i:416;s:103:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/site-title/editor-rtl.css";i:417;s:107:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/site-title/editor-rtl.min.css";i:418;s:99:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/site-title/editor.css";i:419;s:103:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/site-title/editor.min.css";i:420;s:102:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/site-title/style-rtl.css";i:421;s:106:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/site-title/style-rtl.min.css";i:422;s:98:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/site-title/style.css";i:423;s:102:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/site-title/style.min.css";i:424;s:104:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/social-link/editor-rtl.css";i:425;s:108:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/social-link/editor-rtl.min.css";i:426;s:100:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/social-link/editor.css";i:427;s:104:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/social-link/editor.min.css";i:428;s:105:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/social-links/editor-rtl.css";i:429;s:109:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/social-links/editor-rtl.min.css";i:430;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/social-links/editor.css";i:431;s:105:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/social-links/editor.min.css";i:432;s:104:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/social-links/style-rtl.css";i:433;s:108:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/social-links/style-rtl.min.css";i:434;s:100:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/social-links/style.css";i:435;s:104:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/social-links/style.min.css";i:436;s:99:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/spacer/editor-rtl.css";i:437;s:103:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/spacer/editor-rtl.min.css";i:438;s:95:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/spacer/editor.css";i:439;s:99:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/spacer/editor.min.css";i:440;s:98:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/spacer/style-rtl.css";i:441;s:102:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/spacer/style-rtl.min.css";i:442;s:94:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/spacer/style.css";i:443;s:98:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/spacer/style.min.css";i:444;s:98:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/table/editor-rtl.css";i:445;s:102:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/table/editor-rtl.min.css";i:446;s:94:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/table/editor.css";i:447;s:98:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/table/editor.min.css";i:448;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/table/style-rtl.css";i:449;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/table/style-rtl.min.css";i:450;s:93:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/table/style.css";i:451;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/table/style.min.css";i:452;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/table/theme-rtl.css";i:453;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/table/theme-rtl.min.css";i:454;s:93:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/table/theme.css";i:455;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/table/theme.min.css";i:456;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/tag-cloud/style-rtl.css";i:457;s:105:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/tag-cloud/style-rtl.min.css";i:458;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/tag-cloud/style.css";i:459;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/tag-cloud/style.min.css";i:460;s:106:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/template-part/editor-rtl.css";i:461;s:110:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/template-part/editor-rtl.min.css";i:462;s:102:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/template-part/editor.css";i:463;s:106:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/template-part/editor.min.css";i:464;s:105:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/template-part/theme-rtl.css";i:465;s:109:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/template-part/theme-rtl.min.css";i:466;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/template-part/theme.css";i:467;s:105:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/template-part/theme.min.css";i:468;s:108:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/term-description/style-rtl.css";i:469;s:112:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/term-description/style-rtl.min.css";i:470;s:104:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/term-description/style.css";i:471;s:108:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/term-description/style.min.css";i:472;s:105:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/text-columns/editor-rtl.css";i:473;s:109:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/text-columns/editor-rtl.min.css";i:474;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/text-columns/editor.css";i:475;s:105:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/text-columns/editor.min.css";i:476;s:104:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/text-columns/style-rtl.css";i:477;s:108:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/text-columns/style-rtl.min.css";i:478;s:100:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/text-columns/style.css";i:479;s:104:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/text-columns/style.min.css";i:480;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/verse/style-rtl.css";i:481;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/verse/style-rtl.min.css";i:482;s:93:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/verse/style.css";i:483;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/verse/style.min.css";i:484;s:98:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/video/editor-rtl.css";i:485;s:102:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/video/editor-rtl.min.css";i:486;s:94:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/video/editor.css";i:487;s:98:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/video/editor.min.css";i:488;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/video/style-rtl.css";i:489;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/video/style-rtl.min.css";i:490;s:93:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/video/style.css";i:491;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/video/style.min.css";i:492;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/video/theme-rtl.css";i:493;s:101:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/video/theme-rtl.min.css";i:494;s:93:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/video/theme.css";i:495;s:97:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/wp-includes/blocks/video/theme.min.css";}', 'yes');
INSERT INTO `hpp_options` VALUES
(124, 'https_detection_errors', 'a:0:{}', 'yes'),
(1377, 'auto_core_update_notified', 'a:4:{s:4:"type";s:7:"success";s:5:"email";s:23:"pintoherman44@gmail.com";s:7:"version";s:5:"6.6.2";s:9:"timestamp";i:1726011314;}', 'off'),
(14003, '_site_transient_timeout_theme_roots', '1726868281', 'off'),
(14004, '_site_transient_theme_roots', 'a:2:{s:7:"kadence";s:7:"/themes";s:16:"twentytwentyfour";s:7:"/themes";}', 'off'),
(13843, '_site_transient_timeout_php_check_990bfacb848fa087bcfc06850f5e4447', '1726929507', 'off'),
(202, '_site_transient_boldgrid_plugins_filtered', 'a:2:{s:35:"boldgrid-backup/boldgrid-backup.php";a:14:{s:4:"Name";s:12:"Total Upkeep";s:9:"PluginURI";s:41:"https://www.boldgrid.com/boldgrid-backup/";s:7:"Version";s:6:"1.15.2";s:11:"Description";s:159:"Automated backups, remote backup to Amazon S3 and Google Drive, stop website crashes before they happen and more. Total Upkeep is the backup solution you need.";s:6:"Author";s:8:"BoldGrid";s:9:"AuthorURI";s:25:"https://www.boldgrid.com/";s:10:"TextDomain";s:15:"boldgrid-backup";s:10:"DomainPath";s:10:"/languages";s:7:"Network";b:0;s:10:"RequiresWP";s:0:"";s:11:"RequiresPHP";s:0:"";s:9:"UpdateURI";s:0:"";s:5:"Title";s:12:"Total Upkeep";s:10:"AuthorName";s:8:"BoldGrid";}s:51:"boldgrid-backup-premium/boldgrid-backup-premium.php";a:14:{s:4:"Name";s:20:"Total Upkeep Premium";s:9:"PluginURI";s:41:"https://www.boldgrid.com/boldgrid-backup/";s:7:"Version";s:5:"1.5.9";s:11:"Description";s:46:"Premium extension for the Total Upkeep plugin.";s:6:"Author";s:8:"BoldGrid";s:9:"AuthorURI";s:25:"https://www.boldgrid.com/";s:10:"TextDomain";s:15:"boldgrid-backup";s:10:"DomainPath";s:10:"/languages";s:7:"Network";b:0;s:10:"RequiresWP";s:0:"";s:11:"RequiresPHP";s:0:"";s:9:"UpdateURI";s:0:"";s:5:"Title";s:20:"Total Upkeep Premium";s:10:"AuthorName";s:8:"BoldGrid";}}', 'no'),
(131, 'rt_wp_nginx_helper_options', 'a:18:{s:9:"log_level";s:4:"INFO";s:12:"log_filesize";i:5;s:12:"enable_purge";i:1;s:10:"enable_map";i:0;s:10:"enable_log";i:0;s:12:"enable_stamp";i:0;s:21:"purge_homepage_on_new";i:1;s:22:"purge_homepage_on_edit";i:1;s:21:"purge_homepage_on_del";i:1;s:20:"purge_archive_on_new";i:1;s:21:"purge_archive_on_edit";i:1;s:20:"purge_archive_on_del";i:1;s:28:"purge_archive_on_new_comment";i:0;s:32:"purge_archive_on_deleted_comment";i:0;s:17:"purge_page_on_mod";i:1;s:25:"purge_page_on_new_comment";i:1;s:29:"purge_page_on_deleted_comment";i:1;s:12:"purge_method";s:11:"get_request";}', 'yes'),
(400, 'ai1wm_status', 'a:2:{s:4:"type";s:8:"download";s:7:"message";s:444:"<a href="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/ai1wm-backups/yanbal.directorioempresascolombia.com-bogota-20230915-144134-eepnxt.wpress" class="ai1wm-button-green ai1wm-emphasize ai1wm-button-download" title="yanbal.directorioempresascolombia.com" download="yanbal.directorioempresascolombia.com-bogota-20230915-144134-eepnxt.wpress"><span>Download yanbal.directorioempresascolombia.com</span><em>Size: 186 MB</em></a>";}', 'yes'),
(147, 'jetpack_connection_active_plugins', 'a:1:{s:7:"jetpack";a:1:{s:4:"name";s:7:"Jetpack";}}', 'yes'),
(164, '_transient_jetpack_autoloader_plugin_paths', 'a:0:{}', 'yes'),
(352, 'fs_api_cache', 'a:0:{}', 'no'),
(358, 'iawp_is_database_downloading', '0', 'yes'),
(355, 'iawp_is_migrating', '0', 'on'),
(356, 'iawp_db_version', '36', 'on'),
(133, 'boldgrid_settings', 'a:2:{s:7:"library";a:0:{}s:15:"plugins_checked";a:2:{s:35:"boldgrid-backup/boldgrid-backup.php";a:1:{s:6:"1.15.2";i:1694777612;}s:51:"boldgrid-backup-premium/boldgrid-backup-premium.php";a:1:{s:5:"1.5.9";i:1694777612;}}}', 'yes'),
(137, 'boldgrid_backup_id', '1d65f3bc', 'no'),
(4619, 'iawp_last_updated_post_type_cache', '2024-04-18T14:44:04+00:00', 'yes'),
(398, 'ai1wm_secret_key', 'xlmhaMvIujhw', 'yes'),
(349, 'fs_active_plugins', 'O:8:"stdClass":3:{s:7:"plugins";a:1:{s:30:"independent-analytics/freemius";O:8:"stdClass":4:{s:7:"version";s:5:"2.7.2";s:4:"type";s:6:"plugin";s:9:"timestamp";i:1716386794;s:11:"plugin_path";s:30:"independent-analytics/iawp.php";}}s:7:"abspath";s:59:"/home/todoen9/yanbal.directorioempresascolombia.com/BogotA/";s:6:"newest";O:8:"stdClass":5:{s:11:"plugin_path";s:30:"independent-analytics/iawp.php";s:8:"sdk_path";s:30:"independent-analytics/freemius";s:7:"version";s:5:"2.7.2";s:13:"in_activation";b:0;s:9:"timestamp";i:1716386794;}}', 'yes'),
(350, 'fs_debug_mode', '', 'yes'),
(351, 'fs_accounts', 'a:7:{s:21:"id_slug_type_path_map";a:1:{i:9944;a:3:{s:4:"slug";s:21:"independent-analytics";s:4:"type";s:6:"plugin";s:4:"path";s:30:"independent-analytics/iawp.php";}}s:11:"plugin_data";a:1:{s:21:"independent-analytics";a:17:{s:16:"plugin_main_file";O:8:"stdClass":1:{s:4:"path";s:30:"independent-analytics/iawp.php";}s:20:"is_network_activated";b:0;s:17:"install_timestamp";i:1694785821;s:17:"was_plugin_loaded";b:1;s:21:"is_plugin_new_install";b:0;s:16:"sdk_last_version";s:5:"2.6.2";s:11:"sdk_version";s:5:"2.7.2";s:16:"sdk_upgrade_mode";b:1;s:18:"sdk_downgrade_mode";b:0;s:19:"plugin_last_version";s:5:"2.8.6";s:14:"plugin_version";s:5:"2.8.8";s:19:"plugin_upgrade_mode";b:1;s:21:"plugin_downgrade_mode";b:0;s:17:"connectivity_test";a:6:{s:12:"is_connected";N;s:4:"host";s:37:"yanbal.directorioempresascolombia.com";s:9:"server_ip";s:14:"209.182.196.37";s:9:"is_active";b:1;s:9:"timestamp";i:1694785821;s:7:"version";s:6:"1.29.0";}s:15:"prev_is_premium";b:0;s:12:"is_anonymous";a:3:{s:2:"is";b:1;s:9:"timestamp";i:1694785828;s:7:"version";s:6:"1.29.0";}s:19:"last_load_timestamp";i:1728349241;}}s:13:"file_slug_map";a:1:{s:30:"independent-analytics/iawp.php";s:21:"independent-analytics";}s:7:"plugins";a:1:{s:21:"independent-analytics";O:9:"FS_Plugin":24:{s:16:"parent_plugin_id";N;s:5:"title";s:21:"Independent Analytics";s:4:"slug";s:21:"independent-analytics";s:12:"premium_slug";s:25:"independent-analytics-pro";s:4:"type";s:6:"plugin";s:20:"affiliate_moderation";b:0;s:19:"is_wp_org_compliant";b:1;s:22:"premium_releases_count";N;s:4:"file";s:30:"independent-analytics/iawp.php";s:7:"version";s:5:"2.8.8";s:11:"auto_update";N;s:4:"info";N;s:10:"is_premium";b:0;s:14:"premium_suffix";s:3:"Pro";s:7:"is_live";b:1;s:9:"bundle_id";N;s:17:"bundle_public_key";N;s:17:"opt_in_moderation";N;s:10:"public_key";s:32:"pk_c228acaa28759b55d58766b1076d4";s:10:"secret_key";N;s:2:"id";s:4:"9944";s:7:"updated";N;s:7:"created";N;s:22:"\0FS_Entity\0_is_updated";b:1;}}s:9:"unique_id";s:32:"64a354a361a4f6551f7775e104cddd57";s:12:"gc_timestamp";a:0:{}s:10:"theme_data";a:0:{}}', 'yes'),
(150, 'do_activate', '0', 'yes'),
(159, 'boldgrid_backup_environment', 'a:3:{s:8:"hostname";s:28:"ecngx342.inmotionhosting.com";s:10:"phpversion";s:6:"7.4.33";s:9:"wpversion";s:5:"6.3.1";}', 'yes'),
(9570, 'can_compress_scripts', '1', 'yes'),
(2211, 'wp_attachment_pages_enabled', '1', 'yes'),
(200, 'finished_updating_comment_type', '1', 'yes'),
(183, 'current_theme', 'Kadence', 'yes'),
(184, 'theme_mods_kadence', 'a:24:{i:0;b:0;s:18:"nav_menu_locations";a:1:{s:7:"primary";i:2;}s:18:"custom_css_post_id";i:-1;s:11:"logo_layout";a:3:{s:7:"include";a:3:{s:6:"mobile";s:0:"";s:6:"tablet";s:0:"";s:7:"desktop";s:18:"logo_title_tagline";}s:6:"layout";a:3:{s:6:"mobile";s:0:"";s:6:"tablet";s:0:"";s:7:"desktop";s:8:"standard";}s:4:"flag";b:0;}s:18:"header_main_height";a:3:{s:4:"size";a:3:{s:6:"mobile";s:0:"";s:6:"tablet";s:0:"";s:7:"desktop";i:144;}s:4:"unit";a:3:{s:6:"mobile";s:2:"px";s:6:"tablet";s:2:"px";s:7:"desktop";s:2:"px";}s:4:"flag";b:1;}s:22:"header_main_background";a:2:{s:7:"desktop";a:2:{s:5:"color";s:8:"palette1";s:4:"type";s:5:"color";}s:4:"flag";b:0;}s:20:"header_desktop_items";a:4:{s:3:"top";a:5:{s:8:"top_left";a:0:{}s:15:"top_left_center";a:0:{}s:10:"top_center";a:0:{}s:16:"top_right_center";a:0:{}s:9:"top_right";a:0:{}}s:4:"main";a:5:{s:9:"main_left";a:1:{i:0;s:4:"logo";}s:16:"main_left_center";a:0:{}s:11:"main_center";a:0:{}s:17:"main_right_center";a:0:{}s:10:"main_right";a:1:{i:0;s:6:"button";}}s:6:"bottom";a:5:{s:11:"bottom_left";a:0:{}s:18:"bottom_left_center";a:0:{}s:13:"bottom_center";a:1:{i:0;s:10:"navigation";}s:19:"bottom_right_center";a:0:{}s:12:"bottom_right";a:0:{}}s:4:"flag";b:1;}s:24:"header_bottom_background";a:2:{s:7:"desktop";a:2:{s:5:"color";s:8:"palette3";s:4:"type";s:5:"color";}s:4:"flag";b:0;}s:25:"header_main_bottom_border";a:2:{s:7:"desktop";a:4:{s:5:"width";i:2;s:4:"unit";s:2:"px";s:5:"style";s:6:"double";s:5:"color";s:8:"palette3";}s:4:"flag";b:0;}s:26:"primary_navigation_spacing";a:2:{s:4:"size";d:1.6100000000000000976996261670137755572795867919921875;s:4:"unit";s:2:"em";}s:24:"primary_navigation_color";a:3:{s:5:"color";s:8:"palette9";s:5:"hover";s:8:"palette6";s:6:"active";s:8:"palette8";}s:16:"brand_typography";a:15:{s:4:"size";a:1:{s:7:"desktop";i:40;}s:10:"lineHeight";a:1:{s:7:"desktop";d:1.1999999999999999555910790149937383830547332763671875;}s:6:"family";s:7:"Lobster";s:6:"google";b:1;s:6:"weight";s:6:"normal";s:7:"variant";s:7:"regular";s:5:"color";s:8:"palette3";s:8:"sizeType";s:2:"px";s:8:"lineType";s:1:"-";s:13:"letterSpacing";a:1:{s:7:"desktop";s:0:"";}s:11:"spacingType";s:2:"em";s:5:"style";s:6:"normal";s:9:"transform";s:0:"";s:8:"fallback";s:7:"display";s:4:"flag";b:1;}s:7:"h1_font";a:15:{s:4:"size";a:1:{s:7:"desktop";i:32;}s:10:"lineHeight";a:1:{s:7:"desktop";d:1.5;}s:6:"family";s:7:"Lobster";s:6:"google";b:1;s:6:"weight";s:6:"normal";s:7:"variant";s:7:"regular";s:5:"color";s:8:"palette3";s:8:"sizeType";s:2:"px";s:8:"lineType";s:1:"-";s:13:"letterSpacing";a:1:{s:7:"desktop";s:0:"";}s:11:"spacingType";s:2:"em";s:5:"style";s:6:"normal";s:9:"transform";s:0:"";s:8:"fallback";s:7:"display";s:4:"flag";b:1;}s:10:"page_title";b:0;s:10:"post_title";b:0;s:19:"header_button_label";s:20:"WHATSAPP 310 2605493";s:18:"header_button_link";s:26:"https://wa.me/573102605493";s:20:"header_button_target";b:1;s:18:"header_button_size";s:5:"large";s:27:"header_button_border_colors";a:5:{s:5:"width";i:2;s:4:"unit";s:2:"px";s:5:"style";s:4:"none";s:5:"color";s:7:"#40b90c";s:5:"hover";s:0:"";}s:20:"header_button_border";a:4:{s:5:"width";i:2;s:4:"unit";s:2:"px";s:5:"style";s:5:"solid";s:5:"color";s:12:"currentColor";}s:20:"header_button_radius";a:4:{s:4:"size";a:4:{i:0;i:15;i:1;i:15;i:2;i:15;i:3;i:15;}s:4:"unit";s:2:"px";s:6:"locked";b:1;s:4:"flag";b:0;}s:22:"header_button_nofollow";b:1;s:19:"header_button_color";a:2:{s:5:"color";s:8:"palette3";s:5:"hover";s:0:"";}}', 'yes'),
(185, 'theme_switched', '', 'yes'),
(357, 'iawp_need_clear_cache', '', 'yes'),
(359, 'iawp_geo_database_download_last_attempted_at', '2024-08-10T23:59:50', 'on'),
(360, 'iawp_dow', '1', 'yes'),
(363, 'iawp_blocked_ips', 'a:3:{i:0;s:12:"186.84.21.56";i:1;s:13:"186.84.20.155";i:2;s:12:"186.84.88.77";}', 'yes'),
(366, 'iawp_blocked_roles', 'a:1:{i:0;s:13:"administrator";}', 'yes'),
(369, 'iawp_view_counter_enable', '1', 'yes'),
(370, 'iawp_view_counter_post_types', 'a:2:{i:0;s:4:"post";i:1;s:4:"page";}', 'yes'),
(197, 'kadenceblocks_data_settings', 'a:4:{s:10:"db_version";i:0;s:15:"version_history";a:6:{i:1723334390;s:6:"3.2.50";i:1720636934;s:6:"3.2.48";i:1703640968;s:6:"3.1.26";i:1695343469;s:6:"3.1.19";i:1695210733;s:6:"3.1.16";i:0;s:3:"new";}s:13:"prior_version";s:6:"3.2.48";s:15:"current_version";s:6:"3.2.50";}', 'yes'),
(192, 'recently_activated', 'a:4:{s:51:"boldgrid-backup-premium/boldgrid-backup-premium.php";i:1694785771;s:35:"boldgrid-backup/boldgrid-backup.php";i:1694785765;s:29:"nginx-helper/nginx-helper.php";i:1694785755;s:19:"jetpack/jetpack.php";i:1694785740;}', 'yes'),
(193, 'kadence_blocks_schema_version', '1', 'yes'),
(194, 'stellarwp_telemetry_last_send', '', 'yes'),
(195, 'stellarwp_telemetry', 'a:1:{s:7:"plugins";a:1:{s:14:"kadence-blocks";a:2:{s:7:"wp_slug";s:33:"kadence-blocks/kadence-blocks.php";s:5:"optin";b:0;}}}', 'yes'),
(196, 'stellarwp_telemetry_kadence-blocks_show_optin', '1', 'yes'),
(204, 'yoast_migrations_free', 'a:1:{s:7:"version";s:4:"23.5";}', 'yes'),
(205, 'wpseo', 'a:105:{s:8:"tracking";b:0;s:16:"toggled_tracking";b:0;s:22:"license_server_version";b:0;s:15:"ms_defaults_set";b:0;s:40:"ignore_search_engines_discouraged_notice";b:0;s:19:"indexing_first_time";b:1;s:16:"indexing_started";b:0;s:15:"indexing_reason";s:23:"home_url_option_changed";s:29:"indexables_indexing_completed";b:1;s:13:"index_now_key";s:0:"";s:7:"version";s:4:"23.5";s:16:"previous_version";s:4:"23.4";s:20:"disableadvanced_meta";b:1;s:30:"enable_headless_rest_endpoints";b:1;s:17:"ryte_indexability";b:0;s:11:"baiduverify";s:0:"";s:12:"googleverify";s:0:"";s:8:"msverify";s:0:"";s:12:"yandexverify";s:0:"";s:9:"site_type";s:0:"";s:20:"has_multiple_authors";s:0:"";s:16:"environment_type";s:0:"";s:23:"content_analysis_active";b:1;s:23:"keyword_analysis_active";b:1;s:34:"inclusive_language_analysis_active";b:0;s:21:"enable_admin_bar_menu";b:1;s:26:"enable_cornerstone_content";b:1;s:18:"enable_xml_sitemap";b:1;s:24:"enable_text_link_counter";b:1;s:16:"enable_index_now";b:1;s:19:"enable_ai_generator";b:0;s:22:"ai_enabled_pre_default";b:0;s:22:"show_onboarding_notice";b:1;s:18:"first_activated_on";i:1694777683;s:13:"myyoast-oauth";b:0;s:26:"semrush_integration_active";b:1;s:14:"semrush_tokens";a:0:{}s:20:"semrush_country_code";s:2:"us";s:19:"permalink_structure";s:12:"/%postname%/";s:8:"home_url";s:45:"https://yanbal.directorioempresascolombia.com";s:18:"dynamic_permalinks";b:0;s:17:"category_base_url";s:0:"";s:12:"tag_base_url";s:0:"";s:21:"custom_taxonomy_slugs";a:0:{}s:29:"enable_enhanced_slack_sharing";b:1;s:23:"enable_metabox_insights";b:1;s:23:"enable_link_suggestions";b:1;s:26:"algolia_integration_active";b:0;s:14:"import_cursors";a:0:{}s:13:"workouts_data";a:1:{s:13:"configuration";a:1:{s:13:"finishedSteps";a:0:{}}}s:28:"configuration_finished_steps";a:0:{}s:36:"dismiss_configuration_workout_notice";b:0;s:34:"dismiss_premium_deactivated_notice";b:0;s:19:"importing_completed";a:0:{}s:26:"wincher_integration_active";b:1;s:14:"wincher_tokens";a:0:{}s:36:"wincher_automatically_add_keyphrases";b:0;s:18:"wincher_website_id";s:0:"";s:18:"first_time_install";b:1;s:34:"should_redirect_after_install_free";b:0;s:34:"activation_redirect_timestamp_free";i:1694777683;s:18:"remove_feed_global";b:0;s:27:"remove_feed_global_comments";b:0;s:25:"remove_feed_post_comments";b:0;s:19:"remove_feed_authors";b:0;s:22:"remove_feed_categories";b:0;s:16:"remove_feed_tags";b:0;s:29:"remove_feed_custom_taxonomies";b:0;s:22:"remove_feed_post_types";b:0;s:18:"remove_feed_search";b:0;s:21:"remove_atom_rdf_feeds";b:0;s:17:"remove_shortlinks";b:0;s:21:"remove_rest_api_links";b:0;s:20:"remove_rsd_wlw_links";b:0;s:19:"remove_oembed_links";b:0;s:16:"remove_generator";b:0;s:20:"remove_emoji_scripts";b:0;s:24:"remove_powered_by_header";b:0;s:22:"remove_pingback_header";b:0;s:28:"clean_campaign_tracking_urls";b:0;s:16:"clean_permalinks";b:0;s:32:"clean_permalinks_extra_variables";s:0:"";s:14:"search_cleanup";b:0;s:20:"search_cleanup_emoji";b:0;s:23:"search_cleanup_patterns";b:0;s:22:"search_character_limit";i:50;s:20:"deny_search_crawling";b:0;s:21:"deny_wp_json_crawling";b:0;s:20:"deny_adsbot_crawling";b:0;s:19:"deny_ccbot_crawling";b:0;s:29:"deny_google_extended_crawling";b:0;s:20:"deny_gptbot_crawling";b:0;s:27:"redirect_search_pretty_urls";b:0;s:29:"least_readability_ignore_list";a:0:{}s:27:"least_seo_score_ignore_list";a:0:{}s:23:"most_linked_ignore_list";a:0:{}s:24:"least_linked_ignore_list";a:0:{}s:28:"indexables_page_reading_list";a:5:{i:0;b:0;i:1;b:0;i:2;b:0;i:3;b:0;i:4;b:0;}s:25:"indexables_overview_state";s:21:"dashboard-not-visited";s:28:"last_known_public_post_types";a:2:{i:0;s:4:"post";i:1;s:4:"page";}s:28:"last_known_public_taxonomies";a:3:{i:0;s:8:"category";i:1;s:8:"post_tag";i:2;s:11:"post_format";}s:23:"last_known_no_unindexed";a:4:{s:40:"wpseo_total_unindexed_post_type_archives";i:1723334390;s:31:"wpseo_unindexed_post_link_count";i:1723334390;s:31:"wpseo_unindexed_term_link_count";i:1723334390;s:35:"wpseo_total_unindexed_general_items";i:1723334390;}s:14:"new_post_types";a:0:{}s:14:"new_taxonomies";a:0:{}s:34:"show_new_content_type_notification";b:0;}', 'yes'),
(206, 'wpseo_titles', 'a:117:{s:17:"forcerewritetitle";b:0;s:9:"separator";s:7:"sc-dash";s:16:"title-home-wpseo";s:42:"%%sitename%% %%page%% %%sep%% %%sitedesc%%";s:18:"title-author-wpseo";s:41:"%%name%%, Author at %%sitename%% %%page%%";s:19:"title-archive-wpseo";s:38:"%%date%% %%page%% %%sep%% %%sitename%%";s:18:"title-search-wpseo";s:63:"You searched for %%searchphrase%% %%page%% %%sep%% %%sitename%%";s:15:"title-404-wpseo";s:35:"Page not found %%sep%% %%sitename%%";s:25:"social-title-author-wpseo";s:8:"%%name%%";s:26:"social-title-archive-wpseo";s:8:"%%date%%";s:31:"social-description-author-wpseo";s:0:"";s:32:"social-description-archive-wpseo";s:0:"";s:29:"social-image-url-author-wpseo";s:0:"";s:30:"social-image-url-archive-wpseo";s:0:"";s:28:"social-image-id-author-wpseo";i:0;s:29:"social-image-id-archive-wpseo";i:0;s:19:"metadesc-home-wpseo";s:0:"";s:21:"metadesc-author-wpseo";s:0:"";s:22:"metadesc-archive-wpseo";s:0:"";s:9:"rssbefore";s:0:"";s:8:"rssafter";s:53:"The post %%POSTLINK%% appeared first on %%BLOGLINK%%.";s:20:"noindex-author-wpseo";b:0;s:28:"noindex-author-noposts-wpseo";b:1;s:21:"noindex-archive-wpseo";b:1;s:14:"disable-author";b:0;s:12:"disable-date";b:0;s:19:"disable-post_format";b:0;s:18:"disable-attachment";b:1;s:20:"breadcrumbs-404crumb";s:25:"Error 404: Page not found";s:29:"breadcrumbs-display-blog-page";b:1;s:20:"breadcrumbs-boldlast";b:0;s:25:"breadcrumbs-archiveprefix";s:12:"Archives for";s:18:"breadcrumbs-enable";b:1;s:16:"breadcrumbs-home";s:4:"Home";s:18:"breadcrumbs-prefix";s:0:"";s:24:"breadcrumbs-searchprefix";s:16:"You searched for";s:15:"breadcrumbs-sep";s:2:"»";s:12:"website_name";s:0:"";s:11:"person_name";s:0:"";s:11:"person_logo";s:0:"";s:22:"alternate_website_name";s:0:"";s:12:"company_logo";s:0:"";s:12:"company_name";s:0:"";s:22:"company_alternate_name";s:0:"";s:17:"company_or_person";s:7:"company";s:25:"company_or_person_user_id";b:0;s:17:"stripcategorybase";b:0;s:26:"open_graph_frontpage_title";s:12:"%%sitename%%";s:25:"open_graph_frontpage_desc";s:0:"";s:26:"open_graph_frontpage_image";s:0:"";s:24:"publishing_principles_id";i:0;s:25:"ownership_funding_info_id";i:0;s:29:"actionable_feedback_policy_id";i:0;s:21:"corrections_policy_id";i:0;s:16:"ethics_policy_id";i:0;s:19:"diversity_policy_id";i:0;s:28:"diversity_staffing_report_id";i:0;s:10:"title-post";s:39:"%%title%% %%page%% %%sep%% %%sitename%%";s:13:"metadesc-post";s:0:"";s:12:"noindex-post";b:0;s:23:"display-metabox-pt-post";b:1;s:23:"post_types-post-maintax";i:0;s:21:"schema-page-type-post";s:7:"WebPage";s:24:"schema-article-type-post";s:7:"Article";s:17:"social-title-post";s:9:"%%title%%";s:23:"social-description-post";s:0:"";s:21:"social-image-url-post";s:0:"";s:20:"social-image-id-post";i:0;s:10:"title-page";s:39:"%%title%% %%page%% %%sep%% %%sitename%%";s:13:"metadesc-page";s:0:"";s:12:"noindex-page";b:0;s:23:"display-metabox-pt-page";b:1;s:23:"post_types-page-maintax";i:0;s:21:"schema-page-type-page";s:7:"WebPage";s:24:"schema-article-type-page";s:4:"None";s:17:"social-title-page";s:9:"%%title%%";s:23:"social-description-page";s:0:"";s:21:"social-image-url-page";s:0:"";s:20:"social-image-id-page";i:0;s:16:"title-attachment";s:39:"%%title%% %%page%% %%sep%% %%sitename%%";s:19:"metadesc-attachment";s:0:"";s:18:"noindex-attachment";b:0;s:29:"display-metabox-pt-attachment";b:1;s:29:"post_types-attachment-maintax";i:0;s:27:"schema-page-type-attachment";s:7:"WebPage";s:30:"schema-article-type-attachment";s:4:"None";s:18:"title-tax-category";s:53:"%%term_title%% Archives %%page%% %%sep%% %%sitename%%";s:21:"metadesc-tax-category";s:0:"";s:28:"display-metabox-tax-category";b:1;s:20:"noindex-tax-category";b:0;s:25:"social-title-tax-category";s:23:"%%term_title%% Archives";s:31:"social-description-tax-category";s:0:"";s:29:"social-image-url-tax-category";s:0:"";s:28:"social-image-id-tax-category";i:0;s:26:"taxonomy-category-ptparent";i:0;s:18:"title-tax-post_tag";s:53:"%%term_title%% Archives %%page%% %%sep%% %%sitename%%";s:21:"metadesc-tax-post_tag";s:0:"";s:28:"display-metabox-tax-post_tag";b:1;s:20:"noindex-tax-post_tag";b:0;s:25:"social-title-tax-post_tag";s:23:"%%term_title%% Archives";s:31:"social-description-tax-post_tag";s:0:"";s:29:"social-image-url-tax-post_tag";s:0:"";s:28:"social-image-id-tax-post_tag";i:0;s:26:"taxonomy-post_tag-ptparent";i:0;s:21:"title-tax-post_format";s:53:"%%term_title%% Archives %%page%% %%sep%% %%sitename%%";s:24:"metadesc-tax-post_format";s:0:"";s:31:"display-metabox-tax-post_format";b:1;s:23:"noindex-tax-post_format";b:1;s:28:"social-title-tax-post_format";s:23:"%%term_title%% Archives";s:34:"social-description-tax-post_format";s:0:"";s:32:"social-image-url-tax-post_format";s:0:"";s:31:"social-image-id-tax-post_format";i:0;s:29:"taxonomy-post_format-ptparent";i:0;s:14:"person_logo_id";i:0;s:15:"company_logo_id";i:0;s:17:"company_logo_meta";b:0;s:16:"person_logo_meta";b:0;s:29:"open_graph_frontpage_image_id";i:0;}', 'yes'),
(207, 'wpseo_social', 'a:20:{s:13:"facebook_site";s:0:"";s:13:"instagram_url";s:0:"";s:12:"linkedin_url";s:0:"";s:11:"myspace_url";s:0:"";s:16:"og_default_image";s:0:"";s:19:"og_default_image_id";s:0:"";s:18:"og_frontpage_title";s:0:"";s:17:"og_frontpage_desc";s:0:"";s:18:"og_frontpage_image";s:0:"";s:21:"og_frontpage_image_id";s:0:"";s:9:"opengraph";b:1;s:13:"pinterest_url";s:0:"";s:15:"pinterestverify";s:0:"";s:7:"twitter";b:1;s:12:"twitter_site";s:0:"";s:17:"twitter_card_type";s:19:"summary_large_image";s:11:"youtube_url";s:0:"";s:13:"wikipedia_url";s:0:"";s:17:"other_social_urls";a:0:{}s:12:"mastodon_url";s:0:"";}', 'yes'),
(9539, 'iawp_attempted_to_delete_mu_plugin', '1', 'yes'),
(776, 'iawp_salt', 'aSfxq9Xlh5SE0Batt.LJ2ALRtDs8mdel.X6XEjCpvkc=', 'yes'),
(4070, 'stellarwp_uplink_update_status_kadence-blocks', 'O:8:"stdClass":3:{s:10:"last_check";i:1705578209;s:15:"checked_version";s:6:"3.2.17";s:6:"update";O:8:"stdClass":0:{}}', 'yes'),
(2212, 'db_upgraded', '', 'yes'),
(13619, '_site_transient_update_core', 'O:8:"stdClass":4:{s:7:"updates";a:1:{i:0;O:8:"stdClass":10:{s:8:"response";s:6:"latest";s:8:"download";s:59:"https://downloads.wordpress.org/release/wordpress-6.6.2.zip";s:6:"locale";s:5:"en_US";s:8:"packages";O:8:"stdClass":5:{s:4:"full";s:59:"https://downloads.wordpress.org/release/wordpress-6.6.2.zip";s:10:"no_content";s:70:"https://downloads.wordpress.org/release/wordpress-6.6.2-no-content.zip";s:11:"new_bundled";s:71:"https://downloads.wordpress.org/release/wordpress-6.6.2-new-bundled.zip";s:7:"partial";s:0:"";s:8:"rollback";s:0:"";}s:7:"current";s:5:"6.6.2";s:7:"version";s:5:"6.6.2";s:11:"php_version";s:6:"7.2.24";s:13:"mysql_version";s:5:"5.5.5";s:11:"new_bundled";s:3:"6.4";s:15:"partial_version";s:0:"";}}s:12:"last_checked";i:1726866481;s:15:"version_checked";s:5:"6.6.2";s:12:"translations";a:0:{}}', 'off'),
(13844, '_site_transient_php_check_990bfacb848fa087bcfc06850f5e4447', 'a:5:{s:19:"recommended_version";s:3:"7.4";s:15:"minimum_version";s:6:"7.2.24";s:12:"is_supported";b:1;s:9:"is_secure";b:1;s:13:"is_acceptable";b:1;}', 'off'),
(14005, '_site_transient_update_themes', 'O:8:"stdClass":5:{s:12:"last_checked";i:1726866481;s:7:"checked";a:2:{s:7:"kadence";s:6:"1.1.50";s:16:"twentytwentyfour";s:3:"1.0";}s:8:"response";a:2:{s:7:"kadence";a:6:{s:5:"theme";s:7:"kadence";s:11:"new_version";s:5:"1.2.9";s:3:"url";s:37:"https://wordpress.org/themes/kadence/";s:7:"package";s:55:"https://downloads.wordpress.org/theme/kadence.1.2.9.zip";s:8:"requires";s:3:"6.3";s:12:"requires_php";s:3:"7.4";}s:16:"twentytwentyfour";a:6:{s:5:"theme";s:16:"twentytwentyfour";s:11:"new_version";s:3:"1.2";s:3:"url";s:46:"https://wordpress.org/themes/twentytwentyfour/";s:7:"package";s:62:"https://downloads.wordpress.org/theme/twentytwentyfour.1.2.zip";s:8:"requires";s:3:"6.4";s:12:"requires_php";s:3:"7.0";}}s:9:"no_update";a:0:{}s:12:"translations";a:0:{}}', 'off'),
(14081, '_site_transient_timeout_wp_theme_files_patterns-2c1eb4f7e9ca11e58fe7f38c527cb454', '1728424374', 'off'),
(14082, '_site_transient_wp_theme_files_patterns-2c1eb4f7e9ca11e58fe7f38c527cb454', 'a:2:{s:7:"version";s:6:"1.1.50";s:8:"patterns";a:0:{}}', 'off'),
(14010, '_transient_doing_cron', '1728422574.2691469192504882812500', 'on'),
(13275, 'iawp_beginning_of_time', '2023-09-23 18:48:25', 'auto'),
(238, 'nav_menu_options', 'a:2:{i:0;b:0;s:8:"auto_add";a:0:{}}', 'yes'),
(236, 'category_children', 'a:0:{}', 'yes'),
(258, 'kadence_global_palette', '{"palette":[{"color":"#e47b02","slug":"palette1","name":"Palette Color 1"},{"color":"#ed8f0c","slug":"palette2","name":"Palette Color 2"},{"color":"#1f2933","slug":"palette3","name":"Palette Color 3"},{"color":"#3e4c59","slug":"palette4","name":"Palette Color 4"},{"color":"#52606d","slug":"palette5","name":"Palette Color 5"},{"color":"#7b8794","slug":"palette6","name":"Palette Color 6"},{"color":"#f3f4f7","slug":"palette7","name":"Palette Color 7"},{"color":"#f9f9fb","slug":"palette8","name":"Palette Color 8"},{"color":"#ffffff","slug":"palette9","name":"Palette Color 9"}],"second-palette":[{"color":"#2B6CB0","slug":"palette1","name":"Palette Color 1"},{"color":"#215387","slug":"palette2","name":"Palette Color 2"},{"color":"#1A202C","slug":"palette3","name":"Palette Color 3"},{"color":"#2D3748","slug":"palette4","name":"Palette Color 4"},{"color":"#4A5568","slug":"palette5","name":"Palette Color 5"},{"color":"#718096","slug":"palette6","name":"Palette Color 6"},{"color":"#EDF2F7","slug":"palette7","name":"Palette Color 7"},{"color":"#F7FAFC","slug":"palette8","name":"Palette Color 8"},{"color":"#ffffff","slug":"palette9","name":"Palette Color 9"}],"third-palette":[{"color":"#2B6CB0","slug":"palette1","name":"Palette Color 1"},{"color":"#215387","slug":"palette2","name":"Palette Color 2"},{"color":"#1A202C","slug":"palette3","name":"Palette Color 3"},{"color":"#2D3748","slug":"palette4","name":"Palette Color 4"},{"color":"#4A5568","slug":"palette5","name":"Palette Color 5"},{"color":"#718096","slug":"palette6","name":"Palette Color 6"},{"color":"#EDF2F7","slug":"palette7","name":"Palette Color 7"},{"color":"#F7FAFC","slug":"palette8","name":"Palette Color 8"},{"color":"#ffffff","slug":"palette9","name":"Palette Color 9"}],"active":"palette"}', 'yes'),
(246, 'WPLANG', '', 'yes'),
(247, 'new_admin_email', 'pintoherman44@gmail.com', 'yes'),
(382, 'iawp_request_payload_salt', 'sUKoTiW7o0gK9V1eMysxoRAJ3k2p08Yx5tbxIFDF8jE=', 'yes'),
(437, '_site_transient_ai1wm_last_check_for_updates', '1726866481', 'off'),
(438, 'ai1wm_updater', 'a:0:{}', 'yes'),
(446, 'googlesitekit_active_modules', 'a:3:{i:0;s:18:"pagespeed-insights";i:1;s:9:"analytics";i:2;s:11:"analytics-4";}', 'yes'),
(441, 'googlesitekit_db_version', '1.129.0', 'yes'),
(442, 'googlesitekit_has_connected_admins', '0', 'yes'),
(445, '_transient_googlesitekit_verification_meta_tags', 'a:0:{}', 'yes'),
(473, '_transient_health-check-site-status-result', '{"good":19,"recommended":4,"critical":1}', 'yes'),
(13815, '_site_transient_update_plugins', 'O:8:"stdClass":5:{s:12:"last_checked";i:1726866481;s:8:"response";a:0:{}s:12:"translations";a:0:{}s:9:"no_update";a:6:{s:51:"all-in-one-wp-migration/all-in-one-wp-migration.php";O:8:"stdClass":10:{s:2:"id";s:37:"w.org/plugins/all-in-one-wp-migration";s:4:"slug";s:23:"all-in-one-wp-migration";s:6:"plugin";s:51:"all-in-one-wp-migration/all-in-one-wp-migration.php";s:11:"new_version";s:4:"7.86";s:3:"url";s:54:"https://wordpress.org/plugins/all-in-one-wp-migration/";s:7:"package";s:71:"https://downloads.wordpress.org/plugin/all-in-one-wp-migration.7.86.zip";s:5:"icons";a:2:{s:2:"2x";s:76:"https://ps.w.org/all-in-one-wp-migration/assets/icon-256x256.png?rev=2458334";s:2:"1x";s:76:"https://ps.w.org/all-in-one-wp-migration/assets/icon-128x128.png?rev=2458334";}s:7:"banners";a:2:{s:2:"2x";s:79:"https://ps.w.org/all-in-one-wp-migration/assets/banner-1544x500.png?rev=3128878";s:2:"1x";s:78:"https://ps.w.org/all-in-one-wp-migration/assets/banner-772x250.png?rev=3128878";}s:11:"banners_rtl";a:0:{}s:8:"requires";s:3:"3.3";}s:30:"independent-analytics/iawp.php";O:8:"stdClass":10:{s:2:"id";s:35:"w.org/plugins/independent-analytics";s:4:"slug";s:21:"independent-analytics";s:6:"plugin";s:30:"independent-analytics/iawp.php";s:11:"new_version";s:5:"2.8.6";s:3:"url";s:52:"https://wordpress.org/plugins/independent-analytics/";s:7:"package";s:70:"https://downloads.wordpress.org/plugin/independent-analytics.2.8.6.zip";s:5:"icons";a:2:{s:2:"1x";s:66:"https://ps.w.org/independent-analytics/assets/icon.svg?rev=2734979";s:3:"svg";s:66:"https://ps.w.org/independent-analytics/assets/icon.svg?rev=2734979";}s:7:"banners";a:2:{s:2:"2x";s:77:"https://ps.w.org/independent-analytics/assets/banner-1544x500.png?rev=3064839";s:2:"1x";s:76:"https://ps.w.org/independent-analytics/assets/banner-772x250.png?rev=3064839";}s:11:"banners_rtl";a:0:{}s:8:"requires";s:3:"5.9";}s:33:"kadence-blocks/kadence-blocks.php";O:8:"stdClass":10:{s:2:"id";s:28:"w.org/plugins/kadence-blocks";s:4:"slug";s:14:"kadence-blocks";s:6:"plugin";s:33:"kadence-blocks/kadence-blocks.php";s:11:"new_version";s:6:"3.2.53";s:3:"url";s:45:"https://wordpress.org/plugins/kadence-blocks/";s:7:"package";s:64:"https://downloads.wordpress.org/plugin/kadence-blocks.3.2.53.zip";s:5:"icons";a:2:{s:2:"2x";s:67:"https://ps.w.org/kadence-blocks/assets/icon-256x256.png?rev=2502131";s:2:"1x";s:67:"https://ps.w.org/kadence-blocks/assets/icon-128x128.png?rev=2502131";}s:7:"banners";a:2:{s:2:"2x";s:70:"https://ps.w.org/kadence-blocks/assets/banner-1544x500.jpg?rev=1954109";s:2:"1x";s:69:"https://ps.w.org/kadence-blocks/assets/banner-772x250.jpg?rev=1954109";}s:11:"banners_rtl";a:0:{}s:8:"requires";s:3:"6.3";}s:35:"google-site-kit/google-site-kit.php";O:8:"stdClass":10:{s:2:"id";s:29:"w.org/plugins/google-site-kit";s:4:"slug";s:15:"google-site-kit";s:6:"plugin";s:35:"google-site-kit/google-site-kit.php";s:11:"new_version";s:7:"1.135.0";s:3:"url";s:46:"https://wordpress.org/plugins/google-site-kit/";s:7:"package";s:66:"https://downloads.wordpress.org/plugin/google-site-kit.1.135.0.zip";s:5:"icons";a:2:{s:2:"2x";s:68:"https://ps.w.org/google-site-kit/assets/icon-256x256.png?rev=3141863";s:2:"1x";s:68:"https://ps.w.org/google-site-kit/assets/icon-128x128.png?rev=3141863";}s:7:"banners";a:2:{s:2:"2x";s:71:"https://ps.w.org/google-site-kit/assets/banner-1544x500.png?rev=3141863";s:2:"1x";s:70:"https://ps.w.org/google-site-kit/assets/banner-772x250.png?rev=3141863";}s:11:"banners_rtl";a:0:{}s:8:"requires";s:3:"5.2";}s:19:"weforms/weforms.php";O:8:"stdClass":10:{s:2:"id";s:21:"w.org/plugins/weforms";s:4:"slug";s:7:"weforms";s:6:"plugin";s:19:"weforms/weforms.php";s:11:"new_version";s:6:"1.6.25";s:3:"url";s:38:"https://wordpress.org/plugins/weforms/";s:7:"package";s:57:"https://downloads.wordpress.org/plugin/weforms.1.6.25.zip";s:5:"icons";a:2:{s:2:"2x";s:60:"https://ps.w.org/weforms/assets/icon-256x256.png?rev=1978687";s:2:"1x";s:60:"https://ps.w.org/weforms/assets/icon-128x128.png?rev=1978687";}s:7:"banners";a:2:{s:2:"2x";s:63:"https://ps.w.org/weforms/assets/banner-1544x500.png?rev=2243402";s:2:"1x";s:62:"https://ps.w.org/weforms/assets/banner-772x250.png?rev=2243402";}s:11:"banners_rtl";a:0:{}s:8:"requires";s:3:"5.0";}s:24:"wordpress-seo/wp-seo.php";O:8:"stdClass":10:{s:2:"id";s:27:"w.org/plugins/wordpress-seo";s:4:"slug";s:13:"wordpress-seo";s:6:"plugin";s:24:"wordpress-seo/wp-seo.php";s:11:"new_version";s:4:"23.4";s:3:"url";s:44:"https://wordpress.org/plugins/wordpress-seo/";s:7:"package";s:61:"https://downloads.wordpress.org/plugin/wordpress-seo.23.4.zip";s:5:"icons";a:2:{s:2:"2x";s:66:"https://ps.w.org/wordpress-seo/assets/icon-256x256.gif?rev=3112542";s:2:"1x";s:66:"https://ps.w.org/wordpress-seo/assets/icon-128x128.gif?rev=3112542";}s:7:"banners";a:2:{s:2:"2x";s:69:"https://ps.w.org/wordpress-seo/assets/banner-1544x500.png?rev=2643727";s:2:"1x";s:68:"https://ps.w.org/wordpress-seo/assets/banner-772x250.png?rev=2643727";}s:11:"banners_rtl";a:2:{s:2:"2x";s:73:"https://ps.w.org/wordpress-seo/assets/banner-1544x500-rtl.png?rev=2643727";s:2:"1x";s:72:"https://ps.w.org/wordpress-seo/assets/banner-772x250-rtl.png?rev=2643727";}s:8:"requires";s:3:"6.4";}}s:7:"checked";a:6:{s:51:"all-in-one-wp-migration/all-in-one-wp-migration.php";s:4:"7.86";s:30:"independent-analytics/iawp.php";s:5:"2.8.6";s:33:"kadence-blocks/kadence-blocks.php";s:6:"3.2.53";s:35:"google-site-kit/google-site-kit.php";s:7:"1.135.0";s:19:"weforms/weforms.php";s:6:"1.6.25";s:24:"wordpress-seo/wp-seo.php";s:4:"23.4";}}', 'off');

-- --------------------------------------------------------

--
-- Table structure for table `hpp_postmeta`
--

CREATE TABLE `hpp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `hpp_postmeta`
--

INSERT INTO `hpp_postmeta` VALUES
(265, 148, 'footnotes', ''),
(264, 147, 'footnotes', ''),
(3, 6, '_edit_lock', '1721078198:1'),
(4, 6, '_edit_last', '1'),
(5, 6, '_yoast_wpseo_estimated-reading-time-minutes', '4'),
(6, 6, '_yoast_wpseo_wordproof_timestamp', ''),
(7, 8, '_edit_lock', '1694777904:1'),
(8, 8, '_edit_last', '1'),
(9, 8, '_yoast_wpseo_estimated-reading-time-minutes', '0'),
(10, 8, '_yoast_wpseo_wordproof_timestamp', ''),
(11, 10, '_edit_lock', '1694777927:1'),
(12, 10, '_edit_last', '1'),
(13, 10, '_yoast_wpseo_estimated-reading-time-minutes', '0'),
(14, 10, '_yoast_wpseo_wordproof_timestamp', ''),
(15, 12, '_edit_lock', '1694780501:1'),
(16, 12, '_edit_last', '1'),
(17, 12, '_yoast_wpseo_estimated-reading-time-minutes', '2'),
(18, 12, '_yoast_wpseo_wordproof_timestamp', ''),
(19, 14, '_edit_lock', '1694991179:1'),
(20, 14, '_edit_last', '1'),
(21, 14, '_yoast_wpseo_estimated-reading-time-minutes', '0'),
(22, 14, '_yoast_wpseo_wordproof_timestamp', ''),
(23, 16, '_edit_lock', '1694795715:1'),
(24, 16, '_edit_last', '1'),
(25, 16, '_yoast_wpseo_estimated-reading-time-minutes', '3'),
(26, 16, '_yoast_wpseo_wordproof_timestamp', ''),
(27, 18, '_edit_lock', '1694778168:1'),
(28, 18, '_edit_last', '1'),
(29, 18, '_yoast_wpseo_estimated-reading-time-minutes', '0'),
(30, 18, '_yoast_wpseo_wordproof_timestamp', ''),
(31, 20, '_menu_item_type', 'post_type'),
(32, 20, '_menu_item_menu_item_parent', '27'),
(33, 20, '_menu_item_object_id', '18'),
(34, 20, '_menu_item_object', 'page'),
(35, 20, '_menu_item_target', ''),
(36, 20, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(37, 20, '_menu_item_xfn', ''),
(38, 20, '_menu_item_url', ''),
(105, 28, '_yoast_wpseo_estimated-reading-time-minutes', '1'),
(40, 21, '_menu_item_type', 'post_type'),
(41, 21, '_menu_item_menu_item_parent', '27'),
(42, 21, '_menu_item_object_id', '16'),
(43, 21, '_menu_item_object', 'page'),
(44, 21, '_menu_item_target', ''),
(45, 21, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(46, 21, '_menu_item_xfn', ''),
(47, 21, '_menu_item_url', ''),
(49, 22, '_menu_item_type', 'post_type'),
(50, 22, '_menu_item_menu_item_parent', '27'),
(51, 22, '_menu_item_object_id', '14'),
(52, 22, '_menu_item_object', 'page'),
(53, 22, '_menu_item_target', ''),
(54, 22, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(55, 22, '_menu_item_xfn', ''),
(56, 22, '_menu_item_url', ''),
(106, 28, '_yoast_wpseo_wordproof_timestamp', ''),
(58, 23, '_menu_item_type', 'post_type'),
(59, 23, '_menu_item_menu_item_parent', '27'),
(60, 23, '_menu_item_object_id', '12'),
(61, 23, '_menu_item_object', 'page'),
(62, 23, '_menu_item_target', ''),
(63, 23, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(64, 23, '_menu_item_xfn', ''),
(65, 23, '_menu_item_url', ''),
(107, 30, '_menu_item_type', 'post_type'),
(67, 24, '_menu_item_type', 'post_type'),
(68, 24, '_menu_item_menu_item_parent', '0'),
(69, 24, '_menu_item_object_id', '10'),
(70, 24, '_menu_item_object', 'page'),
(71, 24, '_menu_item_target', ''),
(72, 24, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(73, 24, '_menu_item_xfn', ''),
(74, 24, '_menu_item_url', ''),
(104, 28, '_edit_last', '1'),
(294, 165, 'footnotes', ''),
(293, 164, 'footnotes', ''),
(291, 28, '_yoast_wpseo_content_score', '90'),
(290, 162, 'footnotes', ''),
(292, 163, 'footnotes', ''),
(288, 160, 'footnotes', ''),
(287, 159, 'footnotes', ''),
(103, 28, '_edit_lock', '1721078989:1'),
(85, 26, '_menu_item_type', 'post_type'),
(86, 26, '_menu_item_menu_item_parent', '0'),
(87, 26, '_menu_item_object_id', '6'),
(88, 26, '_menu_item_object', 'page'),
(89, 26, '_menu_item_target', ''),
(90, 26, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(91, 26, '_menu_item_xfn', ''),
(92, 26, '_menu_item_url', ''),
(109, 30, '_menu_item_object_id', '28'),
(94, 27, '_menu_item_type', 'custom'),
(95, 27, '_menu_item_menu_item_parent', '0'),
(96, 27, '_menu_item_object_id', '27'),
(97, 27, '_menu_item_object', 'custom'),
(98, 27, '_menu_item_target', ''),
(99, 27, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(100, 27, '_menu_item_xfn', ''),
(101, 27, '_menu_item_url', '#'),
(108, 30, '_menu_item_menu_item_parent', '0'),
(110, 30, '_menu_item_object', 'page'),
(111, 30, '_menu_item_target', ''),
(112, 30, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(113, 30, '_menu_item_xfn', ''),
(114, 30, '_menu_item_url', ''),
(285, 121, '_wp_old_date', '2023-09-15'),
(282, 22, '_wp_old_date', '2023-09-15'),
(283, 21, '_wp_old_date', '2023-09-15'),
(284, 20, '_wp_old_date', '2023-09-15'),
(121, 6, 'footnotes', ''),
(122, 6, '_kad_post_transparent', ''),
(123, 6, '_kad_post_title', 'hide'),
(124, 6, '_kad_post_layout', ''),
(125, 6, '_kad_post_sidebar_id', ''),
(126, 6, '_kad_post_content_style', ''),
(127, 6, '_kad_post_vertical_padding', ''),
(128, 6, '_kad_post_feature', ''),
(129, 6, '_kad_post_feature_position', ''),
(130, 6, '_kad_post_header', ''),
(131, 6, '_kad_post_footer', ''),
(132, 6, '_yoast_wpseo_content_score', '90'),
(281, 23, '_wp_old_date', '2023-09-15'),
(135, 14, '_yoast_wpseo_content_score', '90'),
(136, 12, '_yoast_wpseo_content_score', '90'),
(193, 75, '_wp_attached_file', '2023/09/yanbal-copy.webp'),
(194, 75, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:408;s:6:"height";i:400;s:4:"file";s:24:"2023/09/yanbal-copy.webp";s:8:"filesize";i:24310;s:5:"sizes";a:2:{s:6:"medium";a:5:{s:4:"file";s:24:"yanbal-copy-300x294.webp";s:5:"width";i:300;s:6:"height";i:294;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:10016;}s:9:"thumbnail";a:5:{s:4:"file";s:24:"yanbal-copy-150x150.webp";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:4380;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(169, 63, '_wp_attached_file', '2023/09/body-spa.webp'),
(170, 63, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:408;s:6:"height";i:400;s:4:"file";s:21:"2023/09/body-spa.webp";s:8:"filesize";i:35484;s:5:"sizes";a:2:{s:6:"medium";a:5:{s:4:"file";s:21:"body-spa-300x294.webp";s:5:"width";i:300;s:6:"height";i:294;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:13500;}s:9:"thumbnail";a:5:{s:4:"file";s:21:"body-spa-150x150.webp";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:5342;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(171, 64, '_wp_attached_file', '2023/09/cosmeticos-yanbal.webp'),
(172, 64, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:386;s:6:"height";i:400;s:4:"file";s:30:"2023/09/cosmeticos-yanbal.webp";s:8:"filesize";i:34156;s:5:"sizes";a:2:{s:6:"medium";a:5:{s:4:"file";s:30:"cosmeticos-yanbal-290x300.webp";s:5:"width";i:290;s:6:"height";i:300;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:14254;}s:9:"thumbnail";a:5:{s:4:"file";s:30:"cosmeticos-yanbal-150x150.webp";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:5908;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(173, 65, '_wp_attached_file', '2023/09/crema-de-cuerpo.webp'),
(174, 65, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:408;s:6:"height";i:400;s:4:"file";s:28:"2023/09/crema-de-cuerpo.webp";s:8:"filesize";i:23574;s:5:"sizes";a:2:{s:6:"medium";a:5:{s:4:"file";s:28:"crema-de-cuerpo-300x294.webp";s:5:"width";i:300;s:6:"height";i:294;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:9148;}s:9:"thumbnail";a:5:{s:4:"file";s:28:"crema-de-cuerpo-150x150.webp";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:3696;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(175, 66, '_wp_attached_file', '2023/09/crema-hidratante.webp'),
(176, 66, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:431;s:6:"height";i:400;s:4:"file";s:29:"2023/09/crema-hidratante.webp";s:8:"filesize";i:43468;s:5:"sizes";a:2:{s:6:"medium";a:5:{s:4:"file";s:29:"crema-hidratante-300x278.webp";s:5:"width";i:300;s:6:"height";i:278;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:15976;}s:9:"thumbnail";a:5:{s:4:"file";s:29:"crema-hidratante-150x150.webp";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:5686;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(177, 67, '_wp_attached_file', '2023/09/hidratante-yanbal.webp'),
(178, 67, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:408;s:6:"height";i:400;s:4:"file";s:30:"2023/09/hidratante-yanbal.webp";s:8:"filesize";i:23092;s:5:"sizes";a:2:{s:6:"medium";a:5:{s:4:"file";s:30:"hidratante-yanbal-300x294.webp";s:5:"width";i:300;s:6:"height";i:294;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:8508;}s:9:"thumbnail";a:5:{s:4:"file";s:30:"hidratante-yanbal-150x150.webp";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:3222;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(179, 68, '_wp_attached_file', '2023/09/jabones-yanbal.webp'),
(180, 68, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:408;s:6:"height";i:400;s:4:"file";s:27:"2023/09/jabones-yanbal.webp";s:8:"filesize";i:19326;s:5:"sizes";a:2:{s:6:"medium";a:5:{s:4:"file";s:27:"jabones-yanbal-300x294.webp";s:5:"width";i:300;s:6:"height";i:294;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:6824;}s:9:"thumbnail";a:5:{s:4:"file";s:27:"jabones-yanbal-150x150.webp";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:2790;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(181, 69, '_wp_attached_file', '2023/09/lociones-iluminadoras.webp'),
(182, 69, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:408;s:6:"height";i:400;s:4:"file";s:34:"2023/09/lociones-iluminadoras.webp";s:8:"filesize";i:19208;s:5:"sizes";a:2:{s:6:"medium";a:5:{s:4:"file";s:34:"lociones-iluminadoras-300x294.webp";s:5:"width";i:300;s:6:"height";i:294;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:6968;}s:9:"thumbnail";a:5:{s:4:"file";s:34:"lociones-iluminadoras-150x150.webp";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:3144;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(183, 70, '_wp_attached_file', '2023/09/manteca-corporal.webp'),
(184, 70, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:408;s:6:"height";i:400;s:4:"file";s:29:"2023/09/manteca-corporal.webp";s:8:"filesize";i:33582;s:5:"sizes";a:2:{s:6:"medium";a:5:{s:4:"file";s:29:"manteca-corporal-300x294.webp";s:5:"width";i:300;s:6:"height";i:294;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:13344;}s:9:"thumbnail";a:5:{s:4:"file";s:29:"manteca-corporal-150x150.webp";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:5280;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(185, 71, '_wp_attached_file', '2023/09/perfume-43N.webp'),
(186, 71, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:408;s:6:"height";i:400;s:4:"file";s:24:"2023/09/perfume-43N.webp";s:8:"filesize";i:24016;s:5:"sizes";a:2:{s:6:"medium";a:5:{s:4:"file";s:24:"perfume-43N-300x294.webp";s:5:"width";i:300;s:6:"height";i:294;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:10002;}s:9:"thumbnail";a:5:{s:4:"file";s:24:"perfume-43N-150x150.webp";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:4382;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(187, 72, '_wp_attached_file', '2023/09/perfume-dama.webp'),
(188, 72, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:369;s:6:"height";i:500;s:4:"file";s:25:"2023/09/perfume-dama.webp";s:8:"filesize";i:22092;s:5:"sizes";a:2:{s:6:"medium";a:5:{s:4:"file";s:25:"perfume-dama-221x300.webp";s:5:"width";i:221;s:6:"height";i:300;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:6788;}s:9:"thumbnail";a:5:{s:4:"file";s:25:"perfume-dama-150x150.webp";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:3700;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(189, 73, '_wp_attached_file', '2023/09/perfume-jaque.webp'),
(190, 73, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:408;s:6:"height";i:400;s:4:"file";s:26:"2023/09/perfume-jaque.webp";s:8:"filesize";i:27016;s:5:"sizes";a:2:{s:6:"medium";a:5:{s:4:"file";s:26:"perfume-jaque-300x294.webp";s:5:"width";i:300;s:6:"height";i:294;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:10192;}s:9:"thumbnail";a:5:{s:4:"file";s:26:"perfume-jaque-150x150.webp";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:4108;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(191, 74, '_wp_attached_file', '2023/09/productos-yanbal.webp'),
(192, 74, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:405;s:6:"height";i:459;s:4:"file";s:29:"2023/09/productos-yanbal.webp";s:8:"filesize";i:23172;s:5:"sizes";a:2:{s:6:"medium";a:5:{s:4:"file";s:29:"productos-yanbal-265x300.webp";s:5:"width";i:265;s:6:"height";i:300;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:8642;}s:9:"thumbnail";a:5:{s:4:"file";s:29:"productos-yanbal-150x150.webp";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:3904;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(278, 30, '_wp_old_date', '2023-09-15'),
(279, 122, '_wp_old_date', '2023-09-15'),
(280, 27, '_wp_old_date', '2023-09-15'),
(167, 61, '_wp_attached_file', '2023/09/crema-capilar.webp'),
(168, 61, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:408;s:6:"height";i:400;s:4:"file";s:26:"2023/09/crema-capilar.webp";s:8:"filesize";i:29808;s:5:"sizes";a:2:{s:6:"medium";a:5:{s:4:"file";s:26:"crema-capilar-300x294.webp";s:5:"width";i:300;s:6:"height";i:294;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:11034;}s:9:"thumbnail";a:5:{s:4:"file";s:26:"crema-capilar-150x150.webp";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/webp";s:8:"filesize";i:4336;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(195, 6, '_yoast_wpseo_focuskw', 'venta yanbal'),
(196, 6, '_yoast_wpseo_metadesc', 'Venta de productos de belleza Yanbal para mujeres, hombres y nños como perfumes, lociones, cremas y todo para el maquillaje femenino.'),
(197, 6, '_yoast_wpseo_linkdex', '64'),
(198, 95, '_wp_attached_file', '2023/09/COL_2023_C10.pdf'),
(199, 95, '_wp_attachment_metadata', 'a:2:{s:5:"sizes";a:4:{s:4:"full";a:5:{s:4:"file";s:20:"COL_2023_C10-pdf.jpg";s:5:"width";i:907;s:6:"height";i:1260;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:157256;}s:6:"medium";a:5:{s:4:"file";s:28:"COL_2023_C10-pdf-216x300.jpg";s:5:"width";i:216;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:14954;}s:5:"large";a:5:{s:4:"file";s:29:"COL_2023_C10-pdf-737x1024.jpg";s:5:"width";i:737;s:6:"height";i:1024;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:101117;}s:9:"thumbnail";a:5:{s:4:"file";s:28:"COL_2023_C10-pdf-108x150.jpg";s:5:"width";i:108;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:5689;}}s:8:"filesize";i:16194683;}'),
(200, 95, '_edit_lock', '1694789242:1'),
(201, 28, 'footnotes', ''),
(277, 26, '_wp_old_date', '2023-09-15'),
(276, 158, 'footnotes', ''),
(275, 157, 'footnotes', ''),
(274, 8, 'iawp_total_views', '2'),
(206, 115, '_edit_lock', '1694790539:1'),
(207, 115, '_edit_last', '1'),
(208, 115, '_yoast_wpseo_estimated-reading-time-minutes', '0'),
(209, 115, '_yoast_wpseo_wordproof_timestamp', ''),
(272, 155, 'footnotes', ''),
(270, 153, 'footnotes', ''),
(268, 151, 'footnotes', ''),
(273, 156, 'footnotes', ''),
(266, 149, 'footnotes', ''),
(216, 119, '_edit_lock', '1721077963:1'),
(217, 119, '_edit_last', '1'),
(218, 119, '_yoast_wpseo_estimated-reading-time-minutes', '1'),
(219, 119, '_yoast_wpseo_wordproof_timestamp', ''),
(220, 121, '_menu_item_type', 'post_type'),
(221, 121, '_menu_item_menu_item_parent', '0'),
(222, 121, '_menu_item_object_id', '119'),
(223, 121, '_menu_item_object', 'page'),
(224, 121, '_menu_item_target', ''),
(225, 121, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(226, 121, '_menu_item_xfn', ''),
(227, 121, '_menu_item_url', ''),
(238, 124, '_edit_lock', '1694795317:1'),
(229, 122, '_menu_item_type', 'post_type'),
(230, 122, '_menu_item_menu_item_parent', '0'),
(231, 122, '_menu_item_object_id', '115'),
(232, 122, '_menu_item_object', 'page'),
(233, 122, '_menu_item_target', ''),
(234, 122, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(235, 122, '_menu_item_xfn', ''),
(236, 122, '_menu_item_url', ''),
(239, 124, '_edit_last', '1'),
(240, 124, '_yoast_wpseo_primary_category', ''),
(241, 124, '_yoast_wpseo_content_score', '30'),
(242, 124, '_yoast_wpseo_estimated-reading-time-minutes', '2'),
(243, 124, '_yoast_wpseo_wordproof_timestamp', ''),
(244, 16, 'footnotes', ''),
(245, 16, '_yoast_wpseo_content_score', '60'),
(254, 6, 'iawp_total_views', '81'),
(286, 24, '_wp_old_date', '2023-09-15'),
(295, 166, 'footnotes', ''),
(299, 119, '_yoast_wpseo_focuskw', 'Oferta empleo Yanbal'),
(297, 169, 'footnotes', ''),
(298, 119, '_yoast_wpseo_content_score', '90'),
(300, 119, '_yoast_wpseo_linkdex', '28'),
(304, 115, 'iawp_total_views', '2'),
(303, 28, 'iawp_total_views', '3');

-- --------------------------------------------------------

--
-- Table structure for table `hpp_posts`
--

CREATE TABLE `hpp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `hpp_posts`
--

INSERT INTO `hpp_posts` VALUES
(4, 0, '2023-09-15 11:33:22', '2023-09-15 11:33:22', '<!-- wp:page-list /-->', 'Navigation', '', 'publish', 'closed', 'closed', '', 'navigation', '', '', '2023-09-15 11:33:22', '2023-09-15 11:33:22', '', 0, 'https://yanbal.directorioempresascolombia.com/BogotA/2023/09/15/navigation/', 0, 'wp_navigation', '', 0),
(6, 1, '2023-09-15 11:37:54', '2023-09-15 11:37:54', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_6f84d4-a9","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_f75b67-fa","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_f75b67-fa"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_54cc80-50","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_693eff-7c","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_693eff-7c"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_ed3399-61","align":"left","color":"palette5","padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_ed3399-61 wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_ed3399-61"><a href="https://directorioempresascolombia.com/" target="_blank" rel="noreferrer noopener nofollow">directorio Empresas Bogotá y Colombia</a></div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_a6cedd-b0","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_a6cedd-b0 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_a6cedd-b0">Venta <mark class="kt-highlight">Productos Belleza Yanbal </mark>en Bucaramanga  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p><strong>Wilma Jaimes, Directora de Yanbal, </strong>la asesora sobre todo lo que necesita para su cuidado personal y belleza para mujeres, hombres, niños y bebés. A un click de distancia. Estamos en sector Cedritos, localidad Usaquén de Bogotá, Colombia. Ver nuestro <strong><a href="https://docs.yanbal.com/cdigital/co/2024/c7/oficial/" target="_blank" rel="noreferrer noopener">CATÁLOGO</a></strong>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_6681d1-86"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_6681d1-86"><!-- wp:kadence/singlebtn {"uniqueID":"6_c950f3-8a","text":"310 2605493 ","link":"tel://3102605493","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_768ad7-bb","text":"\\u003cstrong\\u003eWHATSAPP\\u003c/strong\\u003e","link":"https://wa.me/573102605493","target":"_blank","noFollow":true,"sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_b4fec4-a4","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_b4fec4-a4"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"align":"right","id":61,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_68d5d8-00","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<div class="wp-block-kadence-image kb-image6_68d5d8-00 is-style-rounded"><figure class="alignright size-full"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-capilar.webp" alt="" class="kb-img wp-image-61"/><figcaption>Cremas capilares Yanbal en Bogotá</figcaption></figure></div>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_df1818-ab","columns":1,"colLayout":"equal","bgColor":"#d8b078","align":"full","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_81be5f-2f","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_81be5f-2f"><div class="kt-inside-inner-col"><!-- wp:heading {"textAlign":"center"} -->\n<h2 class="wp-block-heading has-text-align-center">Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en BUCARAMANGA</h2>\n<!-- /wp:heading -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_77a6b0-e3","columns":3,"customRowGutter":[30,"",""],"columnGutter":"wider","customGutter":[64,"",""],"colLayout":"equal","inheritMaxWidth":true,"padding":["xxl","","xxl",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_887cf3-11","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_887cf3-11 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":64,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/productos-damas/","linkDestination":"custom","uniqueID":"6_20ede3-32","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_20ede3-32 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/productos-damas/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/cosmeticos-yanbal.webp" alt="" class="kb-img wp-image-64"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_fea0e4-34","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_fea0e4-34 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_fea0e4-34"><a href="https://yanbal.directorioempresascolombia.com/productos-damas/">Cosméticos para Mujer</a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_c10595-42","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_c10595-42 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_c10595-42">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_1bd929-fb","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_1bd929-fb inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":73,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/productos-caballero/","linkDestination":"custom","uniqueID":"6_69f357-84","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_69f357-84 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/productos-caballero/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/perfume-jaque.webp" alt="" class="kb-img wp-image-73"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_c19f9d-74","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_c19f9d-74 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_c19f9d-74"><a href="https://yanbal.directorioempresascolombia.com/productos-caballero/">Productos para Hombre </a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_9da24d-48","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_9da24d-48 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_9da24d-48">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":3,"borderWidth":["","","",""],"uniqueID":"6_3baf88-7a","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_3baf88-7a"><div class="kt-inside-inner-col"><!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_5d35c2-a0","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_5d35c2-a0 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":69,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/ninos-y-bebes/","linkDestination":"custom","uniqueID":"6_31853d-d1","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_31853d-d1 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/ninos-y-bebes/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/lociones-iluminadoras.webp" alt="" class="kb-img wp-image-69"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_78f3eb-a5","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_78f3eb-a5 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_78f3eb-a5"><a href="https://yanbal.directorioempresascolombia.com/ninos-y-bebes/">Cuidado de Niños y Bebés</a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_200eb7-45","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_200eb7-45 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_200eb7-45">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading"><br>Descubre la Belleza Natural con los productos Yanbal en Bucaramanga</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. <br>Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading"><br>La calidad en productos de belleza no se improvisa</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>En Yanbal Bucaramanga, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading"><br>Fragancias Yanbal Exclusivas para Cada Ocasión</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading"><br>No se Pierda las Ofertas y Promociones Especiales todos los Meses</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading"><br>Consejos o Tips de Belleza y Cuidado Personal</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>En nuestro <strong><a href="https://www.yanbal.com/co//corporate/" target="_blank" rel="noreferrer noopener">blog Yambal</a></strong>, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading"><br>Compra tus Productos Yanbal en Bucaramanga y Colombia en el <a href="tl://3102605493">310 2605493</a></h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'publish', 'closed', 'closed', '', 'inicio', '', '', '2024-07-10 20:08:24', '2024-07-10 20:08:24', '', 0, 'https://yanbal.directorioempresascolombia.com/BogotA/?page_id=6', 0, 'page', '', 0),
(7, 1, '2023-09-15 11:37:54', '2023-09-15 11:37:54', '', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2023-09-15 11:37:54', '2023-09-15 11:37:54', '', 6, 'https://yanbal.directorioempresascolombia.com/BogotA/?p=7', 0, 'revision', '', 0),
(8, 1, '2023-09-15 11:38:19', '2023-09-15 11:38:19', '', 'Contacto', '', 'publish', 'closed', 'closed', '', 'contacto', '', '', '2023-09-15 11:38:23', '2023-09-15 11:38:23', '', 0, 'https://yanbal.directorioempresascolombia.com/BogotA/?page_id=8', 0, 'page', '', 0),
(9, 1, '2023-09-15 11:38:19', '2023-09-15 11:38:19', '', 'Contacto', '', 'inherit', 'closed', 'closed', '', '8-revision-v1', '', '', '2023-09-15 11:38:19', '2023-09-15 11:38:19', '', 8, 'https://yanbal.directorioempresascolombia.com/BogotA/?p=9', 0, 'revision', '', 0),
(10, 1, '2023-09-15 11:38:41', '2023-09-15 11:38:41', '', 'Blog', '', 'publish', 'closed', 'closed', '', 'blog', '', '', '2023-09-15 11:38:46', '2023-09-15 11:38:46', '', 0, 'https://yanbal.directorioempresascolombia.com/BogotA/?page_id=10', 0, 'page', '', 0),
(11, 1, '2023-09-15 11:38:41', '2023-09-15 11:38:41', '', 'Blog', '', 'inherit', 'closed', 'closed', '', '10-revision-v1', '', '', '2023-09-15 11:38:41', '2023-09-15 11:38:41', '', 10, 'https://yanbal.directorioempresascolombia.com/BogotA/?p=11', 0, 'revision', '', 0),
(12, 1, '2023-09-15 11:40:22', '2023-09-15 11:40:22', '<!-- wp:kadence/rowlayout {"uniqueID":"12_b5274a-bf","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"12_6db1ae-2e","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column12_6db1ae-2e"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p>¿Estás lista para deslumbrar con tu belleza? En nuestra tienda en línea, encontrarás una amplia gama de productos Yanbal especialmente diseñados para mujeres como tú. ¡Descubre el secreto de la belleza y el cuidado personal con nuestros productos de alta calidad!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Productos Yanbal Exclusivos para Ti</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Nuestra página web es tu destino número uno para encontrar los productos más exclusivos de Yanbal. Desde maquillaje de última tendencia hasta productos de cuidado de la piel que resaltan tu belleza natural, tenemos todo lo que necesitas para sentirte y lucir espectacular.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Ofertas y Descuentos Irresistibles</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>No solo ofrecemos productos de calidad, sino que también te brindamos oportunidades increíbles para ahorrar. Explora nuestras ofertas especiales y descuentos exclusivos que te permitirán obtener tus productos Yanbal favoritos a precios irresistibles. ¡Tu belleza no tiene por qué romper el banco!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Asesoramiento Personalizado</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Sabemos que cada mujer es única, y por eso te ofrecemos un servicio de asesoramiento personalizado. Nuestro equipo de expertos está listo para responder a todas tus preguntas y recomendarte los productos que se adapten a tus necesidades específicas. Nos preocupamos por tu bienestar y belleza.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Entrega Rápida y Segura</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Sabemos que no puedes esperar para probar tus productos Yanbal. Por eso, garantizamos una entrega rápida y segura directamente a tu puerta. Puedes confiar en nosotros para que tus productos lleguen en perfectas condiciones y en el menor tiempo posible.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Compra con Confianza</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>En nuestra página web, la satisfacción del cliente es nuestra prioridad número uno. Respaldamos la calidad de nuestros productos y ofrecemos una política de devolución sin complicaciones. Compra con confianza y descubre por qué miles de mujeres confían en nosotros para su cuidado personal y belleza.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>No esperes más. Visita nuestra página web hoy mismo y descubre la magia de Yanbal. ¡Tu belleza merece lo mejor!</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'Productos Damas', '', 'publish', 'closed', 'closed', '', 'productos-damas', '', '', '2023-09-15 12:10:58', '2023-09-15 12:10:58', '', 0, 'https://yanbal.directorioempresascolombia.com/BogotA/?page_id=12', 0, 'page', '', 0),
(13, 1, '2023-09-15 11:40:22', '2023-09-15 11:40:22', '', 'Productos Damas', '', 'inherit', 'closed', 'closed', '', '12-revision-v1', '', '', '2023-09-15 11:40:22', '2023-09-15 11:40:22', '', 12, 'https://yanbal.directorioempresascolombia.com/BogotA/?p=13', 0, 'revision', '', 0),
(14, 1, '2023-09-15 11:41:00', '2023-09-15 11:41:00', '<!-- wp:kadence/rowlayout {"uniqueID":"14_f8a2fe-33","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"14_326a70-fb","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column14_326a70-fb"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p><strong>Productos Yanbal Exclusivos para Hombres</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>En nuestra página web, encontrarás una exclusiva colección de productos Yanbal diseñados pensando en las necesidades específicas de los hombres. Desde fragancias elegantes hasta productos de cuidado de la piel y afeitado de primera calidad, tenemos todo lo que necesitas para mantenerte en tu mejor forma.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Ofertas y Descuentos Irresistibles</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>No solo te ofrecemos productos de calidad, sino que también te brindamos oportunidades increíbles para ahorrar. Explora nuestras ofertas especiales y descuentos exclusivos que te permitirán obtener tus productos Yanbal favoritos a precios irresistibles. Mantente atractivo sin gastar de más.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Asesoramiento Personalizado</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Reconocemos que cada hombre es único, por lo que te ofrecemos un servicio de asesoramiento personalizado. Nuestro equipo de expertos está dispuesto a responder a tus preguntas y recomendarte los productos que se adapten a tus necesidades específicas. Nos preocupamos por tu bienestar y apariencia personal.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Entrega Rápida y Segura</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Sabemos que no puedes esperar para disfrutar de tus productos Yanbal. Por eso, garantizamos una entrega rápida y segura directamente a tu puerta. Puedes confiar en nosotros para que tus productos lleguen en perfecto estado y en el menor tiempo posible.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Compra con Confianza</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>La satisfacción del cliente es nuestra máxima prioridad. Respaldamos la calidad de nuestros productos y ofrecemos una política de devolución sin complicaciones. Compra con confianza y descubre por qué miles de hombres confían en nosotros para su cuidado personal y estilo.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>No esperes más. Visita nuestra página web hoy mismo y descubre la excelencia de Yanbal en productos para hombres. Tu atractivo y bienestar merecen lo mejor.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:separator -->\n<hr class="wp-block-separator has-alpha-channel-opacity"/>\n<!-- /wp:separator -->\n\n<!-- wp:paragraph -->\n<p>Recuerda personalizar este texto con información específica sobre tu tienda y tus productos para hacerlo más efectivo. ¡Buena suerte con la promoción de tu página web de productos Yanbal para hombres!</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'Productos Caballero', '', 'publish', 'closed', 'closed', '', 'productos-caballero', '', '', '2023-09-15 12:08:25', '2023-09-15 12:08:25', '', 0, 'https://yanbal.directorioempresascolombia.com/BogotA/?page_id=14', 0, 'page', '', 0),
(15, 1, '2023-09-15 11:41:00', '2023-09-15 11:41:00', '', 'Productos Caballero', '', 'inherit', 'closed', 'closed', '', '14-revision-v1', '', '', '2023-09-15 11:41:00', '2023-09-15 11:41:00', '', 14, 'https://yanbal.directorioempresascolombia.com/BogotA/?p=15', 0, 'revision', '', 0),
(16, 1, '2023-09-15 11:41:41', '2023-09-15 11:41:41', '<!-- wp:kadence/rowlayout {"uniqueID":"16_08b686-b7","colLayout":"left-golden","bgColor":"palette8","firstColumnWidth":75,"secondColumnWidth":25,"bgColorClass":"theme-palette8","borderWidth":["","","",""],"borderRadius":[33,33,33,33],"padding":[25,"",20,""],"margin":["","",45,""],"borderStyle":[{"top":["palette6","",1],"right":["palette6","",1],"bottom":["palette6","",1],"left":["palette6","",1],"unit":"px"}],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"16_2e17d3-5e","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column16_2e17d3-5e inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"16_00699b-bd","align":"center","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletMarkBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"mobileMarkBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<h2 class="kt-adv-heading16_00699b-bd wp-block-kadence-advancedheading" data-kb-block="kb-adv-heading16_00699b-bd">Productos para Niños y Bebés en Bogotá</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph {"align":"center"} -->\n<p class="has-text-align-center">Productos Yanbal preparados especialmente para pieles delicadas</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"16_5d4a07-40","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-2"} -->\n<div class="wp-block-kadence-column kadence-column16_5d4a07-40 inner-column-2"><div class="kt-inside-inner-col"><!-- wp:buttons -->\n<div class="wp-block-buttons"><!-- wp:button {"width":100,"style":{"border":{"radius":"17px"}},"fontSize":"medium"} -->\n<div class="wp-block-button has-custom-width wp-block-button__width-100 has-custom-font-size has-medium-font-size"><a class="wp-block-button__link wp-element-button" href="tel://3203008533" style="border-radius:17px" target="_blank" rel="noreferrer noopener">Herman Pinto<br>320 3008533</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"16_ecb173-ef","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"16_d31177-5c","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column16_d31177-5c"><div class="kt-inside-inner-col"><!-- wp:heading -->\n<h2 class="wp-block-heading">Productos para el cuidado de niños y bebés</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Yanbal, conocida por sus productos de belleza y cuidado personal para adultos, también ofrece una línea especializada de productos diseñados para el cuidado y la higiene de niños y bebés. Hay que recordar que la empresa Yanbal cuenta con un departamento técnico de científicos conocedores de la delicadeza de los niños y bebés y, por lo tanto, los productos preparados ofrecen completa garantía y seguridad para los padres de familia que solo desean para sus hijos productos de primera calidad.<br>Estos productos están formulados con ingredientes suaves y seguros para la piel sensible de los más pequeños. A continuación, se enumeran algunos de los productos que Yanbal ofrece para niños y bebés:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li><strong>Shampoo y Acondicionador Infantil:</strong> <br>Yanbal produce shampoos y acondicionadores específicamente diseñados para el cabello de los niños. Estos productos están formulados para ser suaves con el cuero cabelludo delicado y no causar irritación.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Jabón Líquido y Gel de Baño para Bebés:</strong> <br>Yanbal ofrece jabones líquidos y geles de baño especialmente diseñados para bebés. Estos productos están enriquecidos con ingredientes que hidratan y cuidan la piel de los bebés mientras los limpian suavemente.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Crema Hidratante para Bebés:</strong> <br>La crema hidratante para bebés de Yanbal está diseñada para proporcionar una hidratación efectiva a la piel sensible de los bebés, ayudando a prevenir la resequedad y la irritación.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Colonia Infantil:</strong> <br>Yanbal también produce colonias con fragancias suaves y agradables diseñadas específicamente para los más pequeños. Estas colonias no contienen ingredientes irritantes y son ideales para después del baño.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Pañales Desechables:</strong> <br>La línea de productos para bebés de Yanbal también incluye pañales desechables de alta calidad que ofrecen comodidad y protección para los bebés. Estos pañales están diseñados para ajustarse de manera segura y mantener a los bebés secos.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Toallitas Húmedas para Bebés:</strong><br> Yanbal fabrica toallitas húmedas suaves y resistentes que son ideales para la limpieza rápida y efectiva de bebés y niños. Están diseñadas para ser suaves con la piel y no causar irritación.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Productos de Protección Solar:</strong><br> Para proteger la piel de los niños de los daños causados por el sol, Yanbal ofrece protectores solares diseñados específicamente para ellos. Estos productos proporcionan una protección eficaz contra los rayos UVA y UVB.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Línea de Cuidado Oral Infantil:</strong><br> Yanbal también ofrece productos de cuidado oral, como cepillos de dientes y pastas dentales, diseñados especialmente para niños. Estos productos ayudan a inculcar buenos hábitos de higiene oral desde una edad temprana.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>Los productos Yanbal para niños y bebés están formulados con la seguridad y el bienestar de los más pequeños en mente. Además, la marca se compromete a garantizar la calidad y la efectividad de sus productos, lo que la convierte en una opción confiable para los padres que buscan productos de cuidado infantil de alta calidad.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'Niños y Bebes', '', 'publish', 'closed', 'closed', '', 'ninos-y-bebes', '', '', '2023-09-15 16:22:43', '2023-09-15 16:22:43', '', 0, 'https://yanbal.directorioempresascolombia.com/BogotA/?page_id=16', 0, 'page', '', 0),
(17, 1, '2023-09-15 11:41:41', '2023-09-15 11:41:41', '', 'Niños y Bebes', '', 'inherit', 'closed', 'closed', '', '16-revision-v1', '', '', '2023-09-15 11:41:41', '2023-09-15 11:41:41', '', 16, 'https://yanbal.directorioempresascolombia.com/BogotA/?p=17', 0, 'revision', '', 0),
(18, 1, '2023-09-15 11:42:46', '2023-09-15 11:42:46', '', 'Bijouterie', '', 'publish', 'closed', 'closed', '', 'bijouterie', '', '', '2023-09-15 11:42:47', '2023-09-15 11:42:47', '', 0, 'https://yanbal.directorioempresascolombia.com/BogotA/?page_id=18', 0, 'page', '', 0),
(19, 1, '2023-09-15 11:42:46', '2023-09-15 11:42:46', '', 'Bijouterie', '', 'inherit', 'closed', 'closed', '', '18-revision-v1', '', '', '2023-09-15 11:42:46', '2023-09-15 11:42:46', '', 18, 'https://yanbal.directorioempresascolombia.com/BogotA/?p=19', 0, 'revision', '', 0),
(20, 1, '2024-07-10 20:06:52', '2023-09-15 11:44:55', ' ', '', '', 'publish', 'closed', 'closed', '', '20', '', '', '2024-07-10 20:06:52', '2024-07-10 20:06:52', '', 0, 'https://yanbal.directorioempresascolombia.com/BogotA/?p=20', 8, 'nav_menu_item', '', 0),
(21, 1, '2024-07-10 20:06:52', '2023-09-15 11:44:55', ' ', '', '', 'publish', 'closed', 'closed', '', '21', '', '', '2024-07-10 20:06:52', '2024-07-10 20:06:52', '', 0, 'https://yanbal.directorioempresascolombia.com/BogotA/?p=21', 7, 'nav_menu_item', '', 0),
(22, 1, '2024-07-10 20:06:52', '2023-09-15 11:44:55', ' ', '', '', 'publish', 'closed', 'closed', '', '22', '', '', '2024-07-10 20:06:52', '2024-07-10 20:06:52', '', 0, 'https://yanbal.directorioempresascolombia.com/BogotA/?p=22', 6, 'nav_menu_item', '', 0),
(23, 1, '2024-07-10 20:06:52', '2023-09-15 11:44:55', ' ', '', '', 'publish', 'closed', 'closed', '', '23', '', '', '2024-07-10 20:06:52', '2024-07-10 20:06:52', '', 0, 'https://yanbal.directorioempresascolombia.com/BogotA/?p=23', 5, 'nav_menu_item', '', 0),
(24, 1, '2024-07-10 20:06:52', '2023-09-15 11:44:56', ' ', '', '', 'publish', 'closed', 'closed', '', '24', '', '', '2024-07-10 20:06:52', '2024-07-10 20:06:52', '', 0, 'https://yanbal.directorioempresascolombia.com/BogotA/?p=24', 10, 'nav_menu_item', '', 0),
(26, 1, '2024-07-10 20:06:52', '2023-09-15 11:44:54', ' ', '', '', 'publish', 'closed', 'closed', '', '26', '', '', '2024-07-10 20:06:52', '2024-07-10 20:06:52', '', 0, 'https://yanbal.directorioempresascolombia.com/BogotA/?p=26', 1, 'nav_menu_item', '', 0),
(27, 1, '2024-07-10 20:06:52', '2023-09-15 11:44:54', '', 'PRODUCTOS', '', 'publish', 'closed', 'closed', '', 'productos', '', '', '2024-07-10 20:06:52', '2024-07-10 20:06:52', '', 0, 'https://yanbal.directorioempresascolombia.com/BogotA/?p=27', 4, 'nav_menu_item', '', 0),
(28, 1, '2023-09-15 11:45:20', '2023-09-15 11:45:20', '<!-- wp:kadence/rowlayout {"uniqueID":"28_ca6d6d-5e","columns":1,"colLayout":"equal","bgColor":"palette8","bgColorClass":"theme-palette8","borderRadius":[33,33,33,33],"padding":[25,"",20,""],"margin":["","",45,""],"borderStyle":[{"top":["palette6","",1],"right":["palette6","",1],"bottom":["palette6","",1],"left":["palette6","",1],"unit":"px"}],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"28_8da69a-42","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column28_8da69a-42 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"level":1,"uniqueID":"28_205d9d-74","align":"center","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletMarkBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"mobileMarkBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<h1 class="kt-adv-heading28_205d9d-74 wp-block-kadence-advancedheading" data-kb-block="kb-adv-heading28_205d9d-74">Catálogo de Productos Yanbal en Colombia y Bucaramanga</h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph {"align":"center"} -->\n<p class="has-text-align-center">Gran variedad de productos de belleza para dama, para caballeros y niños a un click de distancia. Comunicarse con la Directora y Consultora Wilma Jaimes.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"28_bd1e2c-57","kbVersion":2,"className":"inner-column-2"} -->\n<div class="wp-block-kadence-column kadence-column28_bd1e2c-57 inner-column-2"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedbtn {"uniqueID":"28_1e7ba6-f3"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns28_1e7ba6-f3"><!-- wp:kadence/singlebtn {"uniqueID":"28_f589c1-14","text":"310 2605493 ","link":"tel://3102605493","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"28_893782-3f","text":"\\u003cstrong\\u003eWHATSAPP\\u003c/strong\\u003e","link":"https://wa.me/573102605493","target":"_blank","noFollow":true,"sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"28_40f8da-63","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"28_3722b7-2b","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column28_3722b7-2b"><div class="kt-inside-inner-col"><!-- wp:file {"id":95,"href":"https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf","displayPreview":true,"previewHeight":1040} -->\n<div class="wp-block-file"><object class="wp-block-file__embed" data="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf" type="application/pdf" style="width:100%;height:1040px" aria-label="Catalogo Yanbal"></object><a id="wp-block-file--media-a53c01e9-207d-4225-8df1-93c8967b6d69" href="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf">Catalogo Yanbal</a><a href="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf" class="wp-block-file__button wp-element-button" download aria-describedby="wp-block-file--media-a53c01e9-207d-4225-8df1-93c8967b6d69">Download</a></div>\n<!-- /wp:file --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'Catalogo Yanbal 2025', '', 'publish', 'closed', 'closed', '', 'catalogo-yanbal', '', '', '2024-07-15 21:06:21', '2024-07-15 21:06:21', '', 0, 'https://yanbal.directorioempresascolombia.com/BogotA/?page_id=28', 0, 'page', '', 0),
(29, 1, '2023-09-15 11:45:20', '2023-09-15 11:45:20', '', 'Catalogo Yanbal', '', 'inherit', 'closed', 'closed', '', '28-revision-v1', '', '', '2023-09-15 11:45:20', '2023-09-15 11:45:20', '', 28, 'https://yanbal.directorioempresascolombia.com/BogotA/?p=29', 0, 'revision', '', 0),
(30, 1, '2024-07-10 20:06:52', '2023-09-15 11:46:41', ' ', '', '', 'publish', 'closed', 'closed', '', '30', '', '', '2024-07-10 20:06:52', '2024-07-10 20:06:52', '', 0, 'https://yanbal.directorioempresascolombia.com/BogotA/?p=30', 2, 'nav_menu_item', '', 0),
(33, 1, '2023-09-15 11:50:34', '2023-09-15 11:50:34', '<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p>Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en Bogotá</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><br>Descubre la Belleza Natural con Yanbal<br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.<br>Productos de Belleza de Calidad Superior<br>En Yanbal, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.<br>Fragancias Exclusivas para Cada Ocasión<br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.<br>Ofertas y Promociones Especiales<br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.<br>Consejos de Belleza y Cuidado Personal<br>En nuestro blog, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.<br>Compra tus Productos Yanbal en Línea<br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo en línea, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2023-09-15 11:50:34', '2023-09-15 11:50:34', '', 6, 'https://yanbal.directorioempresascolombia.com/BogotA/?p=33', 0, 'revision', '', 0),
(36, 1, '2023-09-15 12:02:25', '2023-09-15 12:02:25', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_fc6967-b0","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_dcc959-07","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_dcc959-07"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_5d2894-e6","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_e371eb-bf","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_e371eb-bf"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_e4adf1-8e","align":"left","color":"palette5","margin":["","","",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_e4adf1-8e wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_e4adf1-8e">directorio Empresas Bogotá y Colombia</div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_0e7d7d-1d","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_0e7d7d-1d wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_0e7d7d-1d">Venta Productos Belleza Yanbal en Bogotá  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p>Para estos trabajos es indispensable contar con el equipo adecuado y nosotros se lo alquilamos en la ciudad de Medellín. Si desea alquilar estos mismo equipo en Bogotá, le recmendamos visitar este sitio de <a href="https://directorioempresascolombia.com/alquiler-equipos-espacios-confinados/" target="_blank" rel="noreferrer noopener nofollow">ALQUILER EQUIPOS PROFESIONALES</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_852d6f-6c"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_852d6f-6c"><!-- wp:kadence/singlebtn {"uniqueID":"6_dbc6e6-98","text":"\\u003cstrong\\u003eSu CELULAR\\u003c/strong\\u003e ","link":"https://directorioempresascolombia.com/item/","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_d5b6c6-6f","text":"\\u003cstrong\\u003eSu CORREO\\u003c/strong\\u003e","link":"https://directorioempresascolombia.com/item/","target":"_blank","sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_4d0e4a-b0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_4d0e4a-b0"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":18597,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_47b10d-06","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<figure class="wp-block-kadence-image kb-image6_47b10d-06 size-full is-style-rounded"><img src="https://directorioempresascolombia.com/item/wp-content/uploads/DIR-anuncio-DISPONIBLE.jpg" alt="" class="kb-img wp-image-18597"/><figcaption>Inicie su campaña publicitaria AQUÍ.</figcaption></figure>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p>Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en Bogotá</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><br>Descubre la Belleza Natural con Yanbal<br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.<br>Productos de Belleza de Calidad Superior<br>En Yanbal, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.<br>Fragancias Exclusivas para Cada Ocasión<br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.<br>Ofertas y Promociones Especiales<br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.<br>Consejos de Belleza y Cuidado Personal<br>En nuestro blog, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.<br>Compra tus Productos Yanbal en Línea<br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo en línea, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2023-09-15 12:02:25', '2023-09-15 12:02:25', '', 6, 'https://yanbal.directorioempresascolombia.com/?p=36', 0, 'revision', '', 0),
(44, 1, '2023-09-15 12:25:49', '2023-09-15 12:25:49', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_fc6967-b0","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_dcc959-07","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_dcc959-07"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_5d2894-e6","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_e371eb-bf","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_e371eb-bf"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_e4adf1-8e","align":"left","color":"palette5","margin":["","","",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_e4adf1-8e wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_e4adf1-8e">directorio Empresas Bogotá y Colombia</div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_0e7d7d-1d","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_0e7d7d-1d wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_0e7d7d-1d">Venta <mark class="kt-highlight">Productos Belleza Yanbal </mark>en Bogotá  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p>Todo lo que necesita para su cuidado personal y belleza para mujeres, hombres, niños y bebés. A un click de distancia.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_852d6f-6c"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_852d6f-6c"><!-- wp:kadence/singlebtn {"uniqueID":"6_dbc6e6-98","text":"320 3008533 ","link":"tel://3203008533","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_d5b6c6-6f","text":"\\u003cstrong\\u003eCONTACTARNOS\\u003c/strong\\u003e","link":"/contacto","target":"_blank","sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_4d0e4a-b0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_4d0e4a-b0"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":18597,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_47b10d-06","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<figure class="wp-block-kadence-image kb-image6_47b10d-06 size-full is-style-rounded"><img src="https://directorioempresascolombia.com/item/wp-content/uploads/DIR-anuncio-DISPONIBLE.jpg" alt="" class="kb-img wp-image-18597"/><figcaption>Inicie su campaña publicitaria AQUÍ.</figcaption></figure>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p>Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en Bogotá</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><br>Descubre la Belleza Natural con Yanbal<br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.<br>Productos de Belleza de Calidad Superior<br>En Yanbal, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.<br>Fragancias Exclusivas para Cada Ocasión<br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.<br>Ofertas y Promociones Especiales<br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.<br>Consejos de Belleza y Cuidado Personal<br>En nuestro blog, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.<br>Compra tus Productos Yanbal en Línea<br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo en línea, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2023-09-15 12:25:49', '2023-09-15 12:25:49', '', 6, 'https://yanbal.directorioempresascolombia.com/?p=44', 0, 'revision', '', 0);
INSERT INTO `hpp_posts` VALUES
(35, 1, '2023-09-15 12:02:13', '2023-09-15 12:02:13', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_fc6967-b0","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_dcc959-07","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_dcc959-07"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_5d2894-e6","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_e371eb-bf","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_e371eb-bf"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_e4adf1-8e","align":"left","color":"palette5","margin":["","","",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_e4adf1-8e wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_e4adf1-8e">directorio Empresas Bogotá y Colombia</div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_0e7d7d-1d","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_0e7d7d-1d wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_0e7d7d-1d"> Venta Productos Belleza Yanbal en Bogotá  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p>Para estos trabajos es indispensable contar con el equipo adecuado y nosotros se lo alquilamos en la ciudad de Medellín. Si desea alquilar estos mismo equipo en Bogotá, le recmendamos visitar este sitio de <a href="https://directorioempresascolombia.com/alquiler-equipos-espacios-confinados/" target="_blank" rel="noreferrer noopener nofollow">ALQUILER EQUIPOS PROFESIONALES</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_852d6f-6c"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_852d6f-6c"><!-- wp:kadence/singlebtn {"uniqueID":"6_dbc6e6-98","text":"\\u003cstrong\\u003eSu CELULAR\\u003c/strong\\u003e ","link":"https://directorioempresascolombia.com/item/","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_d5b6c6-6f","text":"\\u003cstrong\\u003eSu CORREO\\u003c/strong\\u003e","link":"https://directorioempresascolombia.com/item/","target":"_blank","sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_4d0e4a-b0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_4d0e4a-b0"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":18597,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_47b10d-06","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<figure class="wp-block-kadence-image kb-image6_47b10d-06 size-full is-style-rounded"><img src="https://directorioempresascolombia.com/item/wp-content/uploads/DIR-anuncio-DISPONIBLE.jpg" alt="" class="kb-img wp-image-18597"/><figcaption>Inicie su campaña publicitaria AQUÍ.</figcaption></figure>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p>Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en Bogotá</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><br>Descubre la Belleza Natural con Yanbal<br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.<br>Productos de Belleza de Calidad Superior<br>En Yanbal, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.<br>Fragancias Exclusivas para Cada Ocasión<br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.<br>Ofertas y Promociones Especiales<br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.<br>Consejos de Belleza y Cuidado Personal<br>En nuestro blog, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.<br>Compra tus Productos Yanbal en Línea<br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo en línea, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2023-09-15 12:02:13', '2023-09-15 12:02:13', '', 6, 'https://yanbal.directorioempresascolombia.com/?p=35', 0, 'revision', '', 0),
(40, 1, '2023-09-15 12:06:32', '2023-09-15 12:06:32', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_fc6967-b0","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_dcc959-07","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_dcc959-07"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_5d2894-e6","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_e371eb-bf","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_e371eb-bf"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_e4adf1-8e","align":"left","color":"palette5","margin":["","","",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_e4adf1-8e wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_e4adf1-8e">directorio Empresas Bogotá y Colombia</div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_0e7d7d-1d","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_0e7d7d-1d wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_0e7d7d-1d">Venta <mark class="kt-highlight">Productos Belleza Yanbal </mark>en Bogotá  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p>Todo lo que necesita para su cuidado personal y belleza para mujeres, hombres, niños y bebés. A un click de distancia.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_852d6f-6c"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_852d6f-6c"><!-- wp:kadence/singlebtn {"uniqueID":"6_dbc6e6-98","text":"\\u003cstrong\\u003eSu CELULAR\\u003c/strong\\u003e ","link":"https://directorioempresascolombia.com/item/","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_d5b6c6-6f","text":"\\u003cstrong\\u003eSu CORREO\\u003c/strong\\u003e","link":"https://directorioempresascolombia.com/item/","target":"_blank","sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_4d0e4a-b0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_4d0e4a-b0"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":18597,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_47b10d-06","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<figure class="wp-block-kadence-image kb-image6_47b10d-06 size-full is-style-rounded"><img src="https://directorioempresascolombia.com/item/wp-content/uploads/DIR-anuncio-DISPONIBLE.jpg" alt="" class="kb-img wp-image-18597"/><figcaption>Inicie su campaña publicitaria AQUÍ.</figcaption></figure>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p>Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en Bogotá</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><br>Descubre la Belleza Natural con Yanbal<br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.<br>Productos de Belleza de Calidad Superior<br>En Yanbal, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.<br>Fragancias Exclusivas para Cada Ocasión<br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.<br>Ofertas y Promociones Especiales<br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.<br>Consejos de Belleza y Cuidado Personal<br>En nuestro blog, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.<br>Compra tus Productos Yanbal en Línea<br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo en línea, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2023-09-15 12:06:32', '2023-09-15 12:06:32', '', 6, 'https://yanbal.directorioempresascolombia.com/?p=40', 0, 'revision', '', 0),
(38, 1, '2023-09-15 12:03:33', '2023-09-15 12:03:33', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_fc6967-b0","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_dcc959-07","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_dcc959-07"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_5d2894-e6","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_e371eb-bf","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_e371eb-bf"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_e4adf1-8e","align":"left","color":"palette5","margin":["","","",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_e4adf1-8e wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_e4adf1-8e">directorio Empresas Bogotá y Colombia</div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_0e7d7d-1d","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_0e7d7d-1d wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_0e7d7d-1d">Venta <mark class="kt-highlight">Productos Belleza Yanbal </mark>en Bogotá  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p>Para estos trabajos es indispensable contar con el equipo adecuado y nosotros se lo alquilamos en la ciudad de Medellín. Si desea alquilar estos mismo equipo en Bogotá, le recmendamos visitar este sitio de <a href="https://directorioempresascolombia.com/alquiler-equipos-espacios-confinados/" target="_blank" rel="noreferrer noopener nofollow">ALQUILER EQUIPOS PROFESIONALES</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_852d6f-6c"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_852d6f-6c"><!-- wp:kadence/singlebtn {"uniqueID":"6_dbc6e6-98","text":"\\u003cstrong\\u003eSu CELULAR\\u003c/strong\\u003e ","link":"https://directorioempresascolombia.com/item/","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_d5b6c6-6f","text":"\\u003cstrong\\u003eSu CORREO\\u003c/strong\\u003e","link":"https://directorioempresascolombia.com/item/","target":"_blank","sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_4d0e4a-b0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_4d0e4a-b0"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":18597,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_47b10d-06","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<figure class="wp-block-kadence-image kb-image6_47b10d-06 size-full is-style-rounded"><img src="https://directorioempresascolombia.com/item/wp-content/uploads/DIR-anuncio-DISPONIBLE.jpg" alt="" class="kb-img wp-image-18597"/><figcaption>Inicie su campaña publicitaria AQUÍ.</figcaption></figure>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p>Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en Bogotá</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><br>Descubre la Belleza Natural con Yanbal<br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.<br>Productos de Belleza de Calidad Superior<br>En Yanbal, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.<br>Fragancias Exclusivas para Cada Ocasión<br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.<br>Ofertas y Promociones Especiales<br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.<br>Consejos de Belleza y Cuidado Personal<br>En nuestro blog, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.<br>Compra tus Productos Yanbal en Línea<br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo en línea, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2023-09-15 12:03:33', '2023-09-15 12:03:33', '', 6, 'https://yanbal.directorioempresascolombia.com/?p=38', 0, 'revision', '', 0),
(41, 1, '2023-09-15 12:08:24', '2023-09-15 12:08:24', '<!-- wp:kadence/rowlayout {"uniqueID":"14_f8a2fe-33","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"14_326a70-fb","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column14_326a70-fb"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p><strong>Productos Yanbal Exclusivos para Hombres</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>En nuestra página web, encontrarás una exclusiva colección de productos Yanbal diseñados pensando en las necesidades específicas de los hombres. Desde fragancias elegantes hasta productos de cuidado de la piel y afeitado de primera calidad, tenemos todo lo que necesitas para mantenerte en tu mejor forma.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Ofertas y Descuentos Irresistibles</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>No solo te ofrecemos productos de calidad, sino que también te brindamos oportunidades increíbles para ahorrar. Explora nuestras ofertas especiales y descuentos exclusivos que te permitirán obtener tus productos Yanbal favoritos a precios irresistibles. Mantente atractivo sin gastar de más.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Asesoramiento Personalizado</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Reconocemos que cada hombre es único, por lo que te ofrecemos un servicio de asesoramiento personalizado. Nuestro equipo de expertos está dispuesto a responder a tus preguntas y recomendarte los productos que se adapten a tus necesidades específicas. Nos preocupamos por tu bienestar y apariencia personal.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Entrega Rápida y Segura</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Sabemos que no puedes esperar para disfrutar de tus productos Yanbal. Por eso, garantizamos una entrega rápida y segura directamente a tu puerta. Puedes confiar en nosotros para que tus productos lleguen en perfecto estado y en el menor tiempo posible.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Compra con Confianza</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>La satisfacción del cliente es nuestra máxima prioridad. Respaldamos la calidad de nuestros productos y ofrecemos una política de devolución sin complicaciones. Compra con confianza y descubre por qué miles de hombres confían en nosotros para su cuidado personal y estilo.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>No esperes más. Visita nuestra página web hoy mismo y descubre la excelencia de Yanbal en productos para hombres. Tu atractivo y bienestar merecen lo mejor.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:separator -->\n<hr class="wp-block-separator has-alpha-channel-opacity"/>\n<!-- /wp:separator -->\n\n<!-- wp:paragraph -->\n<p>Recuerda personalizar este texto con información específica sobre tu tienda y tus productos para hacerlo más efectivo. ¡Buena suerte con la promoción de tu página web de productos Yanbal para hombres!</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'Productos Caballero', '', 'inherit', 'closed', 'closed', '', '14-revision-v1', '', '', '2023-09-15 12:08:24', '2023-09-15 12:08:24', '', 14, 'https://yanbal.directorioempresascolombia.com/?p=41', 0, 'revision', '', 0),
(42, 1, '2023-09-15 12:10:50', '2023-09-15 12:10:50', '<!-- wp:kadence/rowlayout {"uniqueID":"12_b5274a-bf","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"12_6db1ae-2e","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column12_6db1ae-2e"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p>¿Estás lista para deslumbrar con tu belleza? En nuestra tienda en línea, encontrarás una amplia gama de productos Yanbal especialmente diseñados para mujeres como tú. ¡Descubre el secreto de la belleza y el cuidado personal con nuestros productos de alta calidad!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Productos Yanbal Exclusivos para Ti</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Nuestra página web es tu destino número uno para encontrar los productos más exclusivos de Yanbal. Desde maquillaje de última tendencia hasta productos de cuidado de la piel que resaltan tu belleza natural, tenemos todo lo que necesitas para sentirte y lucir espectacular.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Ofertas y Descuentos Irresistibles</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>No solo ofrecemos productos de calidad, sino que también te brindamos oportunidades increíbles para ahorrar. Explora nuestras ofertas especiales y descuentos exclusivos que te permitirán obtener tus productos Yanbal favoritos a precios irresistibles. ¡Tu belleza no tiene por qué romper el banco!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Asesoramiento Personalizado</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Sabemos que cada mujer es única, y por eso te ofrecemos un servicio de asesoramiento personalizado. Nuestro equipo de expertos está listo para responder a todas tus preguntas y recomendarte los productos que se adapten a tus necesidades específicas. Nos preocupamos por tu bienestar y belleza.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Entrega Rápida y Segura</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Sabemos que no puedes esperar para probar tus productos Yanbal. Por eso, garantizamos una entrega rápida y segura directamente a tu puerta. Puedes confiar en nosotros para que tus productos lleguen en perfectas condiciones y en el menor tiempo posible.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Compra con Confianza</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>En nuestra página web, la satisfacción del cliente es nuestra prioridad número uno. Respaldamos la calidad de nuestros productos y ofrecemos una política de devolución sin complicaciones. Compra con confianza y descubre por qué miles de mujeres confían en nosotros para su cuidado personal y belleza.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>No esperes más. Visita nuestra página web hoy mismo y descubre la magia de Yanbal. ¡Tu belleza merece lo mejor!</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'Productos Damas', '', 'inherit', 'closed', 'closed', '', '12-revision-v1', '', '', '2023-09-15 12:10:50', '2023-09-15 12:10:50', '', 12, 'https://yanbal.directorioempresascolombia.com/?p=42', 0, 'revision', '', 0),
(63, 1, '2023-09-15 14:13:23', '2023-09-15 14:13:23', '', 'body-spa', '', 'inherit', 'open', 'closed', '', 'body-spa', '', '', '2023-09-15 14:13:23', '2023-09-15 14:13:23', '', 0, 'https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/body-spa.webp', 0, 'attachment', 'image/webp', 0),
(64, 1, '2023-09-15 14:13:23', '2023-09-15 14:13:23', '', 'cosmeticos-yanbal', '', 'inherit', 'open', 'closed', '', 'cosmeticos-yanbal', '', '', '2023-09-15 14:13:23', '2023-09-15 14:13:23', '', 0, 'https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/cosmeticos-yanbal.webp', 0, 'attachment', 'image/webp', 0),
(65, 1, '2023-09-15 14:13:24', '2023-09-15 14:13:24', '', 'crema-de-cuerpo', '', 'inherit', 'open', 'closed', '', 'crema-de-cuerpo', '', '', '2023-09-15 14:13:24', '2023-09-15 14:13:24', '', 0, 'https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-de-cuerpo.webp', 0, 'attachment', 'image/webp', 0),
(66, 1, '2023-09-15 14:13:24', '2023-09-15 14:13:24', '', 'crema-hidratante', '', 'inherit', 'open', 'closed', '', 'crema-hidratante', '', '', '2023-09-15 14:13:24', '2023-09-15 14:13:24', '', 0, 'https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-hidratante.webp', 0, 'attachment', 'image/webp', 0),
(67, 1, '2023-09-15 14:13:25', '2023-09-15 14:13:25', '', 'hidratante-yanbal', '', 'inherit', 'open', 'closed', '', 'hidratante-yanbal', '', '', '2023-09-15 14:13:25', '2023-09-15 14:13:25', '', 0, 'https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/hidratante-yanbal.webp', 0, 'attachment', 'image/webp', 0),
(68, 1, '2023-09-15 14:13:25', '2023-09-15 14:13:25', '', 'jabones-yanbal', '', 'inherit', 'open', 'closed', '', 'jabones-yanbal', '', '', '2023-09-15 14:13:25', '2023-09-15 14:13:25', '', 0, 'https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/jabones-yanbal.webp', 0, 'attachment', 'image/webp', 0),
(69, 1, '2023-09-15 14:13:26', '2023-09-15 14:13:26', '', 'lociones-iluminadoras', '', 'inherit', 'open', 'closed', '', 'lociones-iluminadoras', '', '', '2023-09-15 14:13:26', '2023-09-15 14:13:26', '', 0, 'https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/lociones-iluminadoras.webp', 0, 'attachment', 'image/webp', 0),
(70, 1, '2023-09-15 14:13:27', '2023-09-15 14:13:27', '', 'manteca-corporal', '', 'inherit', 'open', 'closed', '', 'manteca-corporal', '', '', '2023-09-15 14:13:27', '2023-09-15 14:13:27', '', 0, 'https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/manteca-corporal.webp', 0, 'attachment', 'image/webp', 0),
(71, 1, '2023-09-15 14:13:27', '2023-09-15 14:13:27', '', 'perfume-43N', '', 'inherit', 'open', 'closed', '', 'perfume-43n', '', '', '2023-09-15 14:13:27', '2023-09-15 14:13:27', '', 0, 'https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/perfume-43N.webp', 0, 'attachment', 'image/webp', 0),
(72, 1, '2023-09-15 14:13:28', '2023-09-15 14:13:28', '', 'perfume-dama', '', 'inherit', 'open', 'closed', '', 'perfume-dama', '', '', '2023-09-15 14:13:28', '2023-09-15 14:13:28', '', 0, 'https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/perfume-dama.webp', 0, 'attachment', 'image/webp', 0),
(73, 1, '2023-09-15 14:13:28', '2023-09-15 14:13:28', '', 'perfume-jaque', '', 'inherit', 'open', 'closed', '', 'perfume-jaque', '', '', '2023-09-15 14:13:28', '2023-09-15 14:13:28', '', 0, 'https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/perfume-jaque.webp', 0, 'attachment', 'image/webp', 0),
(74, 1, '2023-09-15 14:13:29', '2023-09-15 14:13:29', '', 'productos-yanbal', '', 'inherit', 'open', 'closed', '', 'productos-yanbal', '', '', '2023-09-15 14:13:29', '2023-09-15 14:13:29', '', 0, 'https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/productos-yanbal.webp', 0, 'attachment', 'image/webp', 0),
(148, 1, '2024-07-10 18:53:06', '2024-07-10 18:53:06', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_6f84d4-a9","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_f75b67-fa","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_f75b67-fa"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_54cc80-50","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_693eff-7c","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_693eff-7c"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_ed3399-61","align":"left","color":"palette5","padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_ed3399-61 wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_ed3399-61"><a href="https://directorioempresascolombia.com/" target="_blank" rel="noreferrer noopener nofollow">directorio Empresas Bogotá y Colombia</a></div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_a6cedd-b0","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_a6cedd-b0 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_a6cedd-b0">Venta <mark class="kt-highlight">Productos Belleza Yanbal </mark>en Bogotá  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p>Todo lo que necesita para su cuidado personal y belleza para mujeres, hombres, niños y bebés. A un click de distancia. Estamos en sector Cedritos, localidad Usaquén de Bogotá, Colombia.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_6681d1-86"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_6681d1-86"><!-- wp:kadence/singlebtn {"uniqueID":"6_c950f3-8a","text":"310 2605493 ","link":"tel://3102605493","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_768ad7-bb","text":"\\u003cstrong\\u003eWHTSAPP\\u003c/strong\\u003e","link":"https://wa.me/573102605493","target":"_blank","noFollow":true,"sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_b4fec4-a4","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_b4fec4-a4"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"align":"right","id":61,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_68d5d8-00","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<div class="wp-block-kadence-image kb-image6_68d5d8-00 is-style-rounded"><figure class="alignright size-full"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-capilar.webp" alt="" class="kb-img wp-image-61"/><figcaption>Cremas capilares Yanbal en Bogotá</figcaption></figure></div>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_df1818-ab","columns":1,"colLayout":"equal","bgColor":"#d8b078","align":"full","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_81be5f-2f","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_81be5f-2f"><div class="kt-inside-inner-col"><!-- wp:heading {"textAlign":"center"} -->\n<h2 class="wp-block-heading has-text-align-center">Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en Bogotá</h2>\n<!-- /wp:heading -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_77a6b0-e3","columns":3,"customRowGutter":[30,"",""],"columnGutter":"wider","customGutter":[64,"",""],"colLayout":"equal","inheritMaxWidth":true,"padding":["xxl","","xxl",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_887cf3-11","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_887cf3-11 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":64,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/productos-damas/","linkDestination":"custom","uniqueID":"6_20ede3-32","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_20ede3-32 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/productos-damas/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/cosmeticos-yanbal.webp" alt="" class="kb-img wp-image-64"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_fea0e4-34","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_fea0e4-34 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_fea0e4-34"><a href="https://yanbal.directorioempresascolombia.com/productos-damas/">Cosméticos para Mujer</a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_c10595-42","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_c10595-42 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_c10595-42">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_1bd929-fb","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_1bd929-fb inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":73,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/productos-caballero/","linkDestination":"custom","uniqueID":"6_69f357-84","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_69f357-84 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/productos-caballero/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/perfume-jaque.webp" alt="" class="kb-img wp-image-73"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_c19f9d-74","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_c19f9d-74 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_c19f9d-74"><a href="https://yanbal.directorioempresascolombia.com/productos-caballero/">Productos para Hombre </a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_9da24d-48","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_9da24d-48 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_9da24d-48">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":3,"borderWidth":["","","",""],"uniqueID":"6_3baf88-7a","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_3baf88-7a"><div class="kt-inside-inner-col"><!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_5d35c2-a0","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_5d35c2-a0 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":69,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/ninos-y-bebes/","linkDestination":"custom","uniqueID":"6_31853d-d1","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_31853d-d1 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/ninos-y-bebes/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/lociones-iluminadoras.webp" alt="" class="kb-img wp-image-69"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_78f3eb-a5","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_78f3eb-a5 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_78f3eb-a5"><a href="https://yanbal.directorioempresascolombia.com/ninos-y-bebes/">Cuidado de Niños y Bebés</a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_200eb7-45","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_200eb7-45 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_200eb7-45">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><br>Descubre la Belleza Natural con Yanbal<br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.<br>Productos de Belleza de Calidad Superior<br>En Yanbal, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.<br>Fragancias Exclusivas para Cada Ocasión<br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.<br>Ofertas y Promociones Especiales<br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.<br>Consejos de Belleza y Cuidado Personal<br>En nuestro blog, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.<br>Compra tus Productos Yanbal en Línea<br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo en línea, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2024-07-10 18:53:06', '2024-07-10 18:53:06', '', 6, 'https://yanbal.directorioempresascolombia.com/?p=148', 0, 'revision', '', 0),
(75, 1, '2023-09-15 14:13:30', '2023-09-15 14:13:30', '', 'yanbal-copy', '', 'inherit', 'open', 'closed', '', 'yanbal-copy', '', '', '2023-09-15 14:13:30', '2023-09-15 14:13:30', '', 0, 'https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/yanbal-copy.webp', 0, 'attachment', 'image/webp', 0),
(61, 1, '2023-09-15 14:10:11', '2023-09-15 14:10:11', '', 'crema-capilar', '', 'inherit', 'open', 'closed', '', 'crema-capilar-2', '', '', '2023-09-15 14:10:11', '2023-09-15 14:10:11', '', 6, 'https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-capilar.webp', 0, 'attachment', 'image/webp', 0),
(62, 1, '2023-09-15 14:10:16', '2023-09-15 14:10:16', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_fc6967-b0","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_dcc959-07","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_dcc959-07"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_5d2894-e6","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_e371eb-bf","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_e371eb-bf"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_e4adf1-8e","align":"left","color":"palette5","margin":["","","",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_e4adf1-8e wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_e4adf1-8e">directorio Empresas Bogotá y Colombia</div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_0e7d7d-1d","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_0e7d7d-1d wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_0e7d7d-1d">Venta <mark class="kt-highlight">Productos Belleza Yanbal </mark>en Bogotá  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p>Todo lo que necesita para su cuidado personal y belleza para mujeres, hombres, niños y bebés. A un click de distancia.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_852d6f-6c"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_852d6f-6c"><!-- wp:kadence/singlebtn {"uniqueID":"6_dbc6e6-98","text":"320 3008533 ","link":"tel://3203008533","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_d5b6c6-6f","text":"\\u003cstrong\\u003eCONTACTARNOS\\u003c/strong\\u003e","link":"/contacto","target":"_blank","sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_4d0e4a-b0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_4d0e4a-b0"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"align":"right","id":61,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_47b10d-06","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<div class="wp-block-kadence-image kb-image6_47b10d-06 is-style-rounded"><figure class="alignright size-full"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-capilar.webp" alt="" class="kb-img wp-image-61"/><figcaption>Cremas capilares Yanbal en Bogotá</figcaption></figure></div>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p>Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en Bogotá</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><br>Descubre la Belleza Natural con Yanbal<br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.<br>Productos de Belleza de Calidad Superior<br>En Yanbal, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.<br>Fragancias Exclusivas para Cada Ocasión<br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.<br>Ofertas y Promociones Especiales<br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.<br>Consejos de Belleza y Cuidado Personal<br>En nuestro blog, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.<br>Compra tus Productos Yanbal en Línea<br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo en línea, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2023-09-15 14:10:16', '2023-09-15 14:10:16', '', 6, 'https://yanbal.directorioempresascolombia.com/?p=62', 0, 'revision', '', 0);
INSERT INTO `hpp_posts` VALUES
(60, 1, '2023-09-15 14:06:09', '2023-09-15 14:06:09', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_fc6967-b0","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_dcc959-07","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_dcc959-07"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_5d2894-e6","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_e371eb-bf","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_e371eb-bf"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_e4adf1-8e","align":"left","color":"palette5","margin":["","","",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_e4adf1-8e wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_e4adf1-8e">directorio Empresas Bogotá y Colombia</div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_0e7d7d-1d","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_0e7d7d-1d wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_0e7d7d-1d">Venta <mark class="kt-highlight">Productos Belleza Yanbal </mark>en Bogotá  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p>Todo lo que necesita para su cuidado personal y belleza para mujeres, hombres, niños y bebés. A un click de distancia.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_852d6f-6c"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_852d6f-6c"><!-- wp:kadence/singlebtn {"uniqueID":"6_dbc6e6-98","text":"320 3008533 ","link":"tel://3203008533","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_d5b6c6-6f","text":"\\u003cstrong\\u003eCONTACTARNOS\\u003c/strong\\u003e","link":"/contacto","target":"_blank","sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_4d0e4a-b0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_4d0e4a-b0"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"align":"right","id":47,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_47b10d-06","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<div class="wp-block-kadence-image kb-image6_47b10d-06 is-style-rounded"><figure class="alignright size-full"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-capilar.jpg" alt="Cremas capilares Yanbal" class="kb-img wp-image-47"/><figcaption>Cremas capilares Yanbal en Bogotá</figcaption></figure></div>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p>Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en Bogotá</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><br>Descubre la Belleza Natural con Yanbal<br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.<br>Productos de Belleza de Calidad Superior<br>En Yanbal, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.<br>Fragancias Exclusivas para Cada Ocasión<br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.<br>Ofertas y Promociones Especiales<br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.<br>Consejos de Belleza y Cuidado Personal<br>En nuestro blog, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.<br>Compra tus Productos Yanbal en Línea<br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo en línea, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2023-09-15 14:06:09', '2023-09-15 14:06:09', '', 6, 'https://yanbal.directorioempresascolombia.com/?p=60', 0, 'revision', '', 0),
(81, 1, '2023-09-15 14:22:56', '2023-09-15 14:22:56', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_fc6967-b0","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_dcc959-07","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_dcc959-07"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_5d2894-e6","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_e371eb-bf","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_e371eb-bf"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_e4adf1-8e","align":"left","color":"palette5","margin":["","","",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_e4adf1-8e wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_e4adf1-8e">directorio Empresas Bogotá y Colombia</div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_0e7d7d-1d","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_0e7d7d-1d wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_0e7d7d-1d">Venta <mark class="kt-highlight">Productos Belleza Yanbal </mark>en Bogotá  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p>Todo lo que necesita para su cuidado personal y belleza para mujeres, hombres, niños y bebés. A un click de distancia.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_852d6f-6c"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_852d6f-6c"><!-- wp:kadence/singlebtn {"uniqueID":"6_dbc6e6-98","text":"320 3008533 ","link":"tel://3203008533","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_d5b6c6-6f","text":"\\u003cstrong\\u003eCONTACTARNOS\\u003c/strong\\u003e","link":"/contacto","target":"_blank","sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_4d0e4a-b0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_4d0e4a-b0"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"align":"right","id":61,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_47b10d-06","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<div class="wp-block-kadence-image kb-image6_47b10d-06 is-style-rounded"><figure class="alignright size-full"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-capilar.webp" alt="" class="kb-img wp-image-61"/><figcaption>Cremas capilares Yanbal en Bogotá</figcaption></figure></div>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_728947-ac","columns":3,"customRowGutter":[30,"",""],"columnGutter":"wider","customGutter":[64,"",""],"colLayout":"equal","bgColor":"palette9","align":"full","inheritMaxWidth":true,"bgColorClass":"theme-palette9","padding":["xxl","","xxl",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_2879ec-6d","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_2879ec-6d inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":64,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_6294b2-b4","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_6294b2-b4 size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/cosmeticos-yanbal.webp" alt="" class="kb-img wp-image-64"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_6a5ae8-ca","align":"left","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_6a5ae8-ca wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_6a5ae8-ca">Cosméticos para Mujer</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_8f33d8-85","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_8f33d8-85 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_8f33d8-85">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_f44421-df","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_f44421-df inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":73,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_def1ff-3f","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_def1ff-3f size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/perfume-jaque.webp" alt="" class="kb-img wp-image-73"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_bb4de1-8d","align":"left","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_bb4de1-8d wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_bb4de1-8d">Producto para Hombre </h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_bcb6d0-6b","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":["","",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_bcb6d0-6b wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_bcb6d0-6b">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":3,"borderWidth":["","","",""],"uniqueID":"6_784c0a-62","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_784c0a-62"><div class="kt-inside-inner-col"><!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_c383b9-43","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_c383b9-43 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":69,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_886db0-3a","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_886db0-3a size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/lociones-iluminadoras.webp" alt="" class="kb-img wp-image-69"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_d2b512-ea","align":"left","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_d2b512-ea wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_d2b512-ea">Cuidado de Niños y Bebés</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_5f241d-45","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_5f241d-45 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_5f241d-45">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p>Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en Bogotá</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><br>Descubre la Belleza Natural con Yanbal<br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.<br>Productos de Belleza de Calidad Superior<br>En Yanbal, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.<br>Fragancias Exclusivas para Cada Ocasión<br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.<br>Ofertas y Promociones Especiales<br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.<br>Consejos de Belleza y Cuidado Personal<br>En nuestro blog, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.<br>Compra tus Productos Yanbal en Línea<br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo en línea, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2023-09-15 14:22:56', '2023-09-15 14:22:56', '', 6, 'https://yanbal.directorioempresascolombia.com/?p=81', 0, 'revision', '', 0),
(79, 1, '2023-09-15 14:21:15', '2023-09-15 14:21:15', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_fc6967-b0","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_dcc959-07","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_dcc959-07"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_5d2894-e6","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_e371eb-bf","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_e371eb-bf"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_e4adf1-8e","align":"left","color":"palette5","margin":["","","",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_e4adf1-8e wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_e4adf1-8e">directorio Empresas Bogotá y Colombia</div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_0e7d7d-1d","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_0e7d7d-1d wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_0e7d7d-1d">Venta <mark class="kt-highlight">Productos Belleza Yanbal </mark>en Bogotá  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p>Todo lo que necesita para su cuidado personal y belleza para mujeres, hombres, niños y bebés. A un click de distancia.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_852d6f-6c"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_852d6f-6c"><!-- wp:kadence/singlebtn {"uniqueID":"6_dbc6e6-98","text":"320 3008533 ","link":"tel://3203008533","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_d5b6c6-6f","text":"\\u003cstrong\\u003eCONTACTARNOS\\u003c/strong\\u003e","link":"/contacto","target":"_blank","sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_4d0e4a-b0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_4d0e4a-b0"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"align":"right","id":61,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_47b10d-06","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<div class="wp-block-kadence-image kb-image6_47b10d-06 is-style-rounded"><figure class="alignright size-full"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-capilar.webp" alt="" class="kb-img wp-image-61"/><figcaption>Cremas capilares Yanbal en Bogotá</figcaption></figure></div>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p>Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en Bogotá</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><br>Descubre la Belleza Natural con Yanbal<br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.<br>Productos de Belleza de Calidad Superior<br>En Yanbal, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.<br>Fragancias Exclusivas para Cada Ocasión<br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.<br>Ofertas y Promociones Especiales<br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.<br>Consejos de Belleza y Cuidado Personal<br>En nuestro blog, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.<br>Compra tus Productos Yanbal en Línea<br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo en línea, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_728947-ac","columns":3,"customRowGutter":[30,"",""],"columnGutter":"wider","customGutter":[64,"",""],"colLayout":"equal","bgColor":"palette9","align":"full","inheritMaxWidth":true,"bgColorClass":"theme-palette9","padding":["xxl","","xxl",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_2879ec-6d","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_2879ec-6d inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":2864,"sizeSlug":"large","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_6294b2-b4","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_6294b2-b4 size-large kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://patterns.startertemplatecloud.com/wp-content/uploads/2023/02/Example-A-Roll-Image-1024x793.jpg" alt="" class="kb-img wp-image-2864"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_6a5ae8-ca","align":"left","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_6a5ae8-ca wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_6a5ae8-ca">Cosméticos para Mujer</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_8f33d8-85","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_8f33d8-85 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_8f33d8-85">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_f44421-df","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_f44421-df inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":2864,"sizeSlug":"large","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_def1ff-3f","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_def1ff-3f size-large kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://patterns.startertemplatecloud.com/wp-content/uploads/2023/02/Example-A-Roll-Image-1024x793.jpg" alt="" class="kb-img wp-image-2864"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_bb4de1-8d","align":"left","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_bb4de1-8d wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_bb4de1-8d">Producto para Hombre </h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_bcb6d0-6b","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":["","",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_bcb6d0-6b wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_bcb6d0-6b">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":3,"borderWidth":["","","",""],"uniqueID":"6_784c0a-62","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_784c0a-62"><div class="kt-inside-inner-col"><!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_c383b9-43","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_c383b9-43 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":2864,"sizeSlug":"large","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_886db0-3a","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_886db0-3a size-large kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://patterns.startertemplatecloud.com/wp-content/uploads/2023/02/Example-A-Roll-Image-1024x793.jpg" alt="" class="kb-img wp-image-2864"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_d2b512-ea","align":"left","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_d2b512-ea wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_d2b512-ea">Cuidado de Niños y Bebés</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_5f241d-45","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_5f241d-45 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_5f241d-45">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2023-09-15 14:21:15', '2023-09-15 14:21:15', '', 6, 'https://yanbal.directorioempresascolombia.com/?p=79', 0, 'revision', '', 0),
(77, 1, '2023-09-15 14:19:28', '2023-09-15 14:19:28', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_fc6967-b0","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_dcc959-07","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_dcc959-07"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_5d2894-e6","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_e371eb-bf","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_e371eb-bf"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_e4adf1-8e","align":"left","color":"palette5","margin":["","","",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_e4adf1-8e wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_e4adf1-8e">directorio Empresas Bogotá y Colombia</div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_0e7d7d-1d","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_0e7d7d-1d wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_0e7d7d-1d">Venta <mark class="kt-highlight">Productos Belleza Yanbal </mark>en Bogotá  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p>Todo lo que necesita para su cuidado personal y belleza para mujeres, hombres, niños y bebés. A un click de distancia.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_852d6f-6c"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_852d6f-6c"><!-- wp:kadence/singlebtn {"uniqueID":"6_dbc6e6-98","text":"320 3008533 ","link":"tel://3203008533","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_d5b6c6-6f","text":"\\u003cstrong\\u003eCONTACTARNOS\\u003c/strong\\u003e","link":"/contacto","target":"_blank","sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_4d0e4a-b0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_4d0e4a-b0"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"align":"right","id":61,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_47b10d-06","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<div class="wp-block-kadence-image kb-image6_47b10d-06 is-style-rounded"><figure class="alignright size-full"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-capilar.webp" alt="" class="kb-img wp-image-61"/><figcaption>Cremas capilares Yanbal en Bogotá</figcaption></figure></div>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p>Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en Bogotá</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><br>Descubre la Belleza Natural con Yanbal<br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.<br>Productos de Belleza de Calidad Superior<br>En Yanbal, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.<br>Fragancias Exclusivas para Cada Ocasión<br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.<br>Ofertas y Promociones Especiales<br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.<br>Consejos de Belleza y Cuidado Personal<br>En nuestro blog, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.<br>Compra tus Productos Yanbal en Línea<br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo en línea, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_728947-ac","columns":3,"customRowGutter":[30,"",""],"columnGutter":"wider","customGutter":[64,"",""],"colLayout":"equal","bgColor":"palette9","align":"full","inheritMaxWidth":true,"bgColorClass":"theme-palette9","padding":["xxl","","xxl",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_2879ec-6d","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_2879ec-6d inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":2864,"sizeSlug":"large","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_6294b2-b4","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_6294b2-b4 size-large kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://patterns.startertemplatecloud.com/wp-content/uploads/2023/02/Example-A-Roll-Image-1024x793.jpg" alt="" class="kb-img wp-image-2864"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_6a5ae8-ca","align":"left","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_6a5ae8-ca wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_6a5ae8-ca">Add a descriptive title for the column.</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_8f33d8-85","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_8f33d8-85 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_8f33d8-85">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_f44421-df","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_f44421-df inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":2864,"sizeSlug":"large","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_def1ff-3f","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_def1ff-3f size-large kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://patterns.startertemplatecloud.com/wp-content/uploads/2023/02/Example-A-Roll-Image-1024x793.jpg" alt="" class="kb-img wp-image-2864"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_bb4de1-8d","align":"left","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_bb4de1-8d wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_bb4de1-8d">Add a descriptive title for the column.</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_bcb6d0-6b","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":["","",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_bcb6d0-6b wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_bcb6d0-6b">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":3,"borderWidth":["","","",""],"uniqueID":"6_784c0a-62","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_784c0a-62"><div class="kt-inside-inner-col"><!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_c383b9-43","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_c383b9-43 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":2864,"sizeSlug":"large","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_886db0-3a","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_886db0-3a size-large kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://patterns.startertemplatecloud.com/wp-content/uploads/2023/02/Example-A-Roll-Image-1024x793.jpg" alt="" class="kb-img wp-image-2864"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_d2b512-ea","align":"left","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_d2b512-ea wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_d2b512-ea">Add a descriptive title for the column.</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_5f241d-45","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_5f241d-45 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_5f241d-45">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2023-09-15 14:19:28', '2023-09-15 14:19:28', '', 6, 'https://yanbal.directorioempresascolombia.com/?p=77', 0, 'revision', '', 0);
INSERT INTO `hpp_posts` VALUES
(80, 1, '2023-09-15 14:22:30', '2023-09-15 14:22:30', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_fc6967-b0","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_dcc959-07","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_dcc959-07"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_5d2894-e6","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_e371eb-bf","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_e371eb-bf"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_e4adf1-8e","align":"left","color":"palette5","margin":["","","",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_e4adf1-8e wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_e4adf1-8e">directorio Empresas Bogotá y Colombia</div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_0e7d7d-1d","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_0e7d7d-1d wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_0e7d7d-1d">Venta <mark class="kt-highlight">Productos Belleza Yanbal </mark>en Bogotá  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p>Todo lo que necesita para su cuidado personal y belleza para mujeres, hombres, niños y bebés. A un click de distancia.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_852d6f-6c"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_852d6f-6c"><!-- wp:kadence/singlebtn {"uniqueID":"6_dbc6e6-98","text":"320 3008533 ","link":"tel://3203008533","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_d5b6c6-6f","text":"\\u003cstrong\\u003eCONTACTARNOS\\u003c/strong\\u003e","link":"/contacto","target":"_blank","sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_4d0e4a-b0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_4d0e4a-b0"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"align":"right","id":61,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_47b10d-06","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<div class="wp-block-kadence-image kb-image6_47b10d-06 is-style-rounded"><figure class="alignright size-full"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-capilar.webp" alt="" class="kb-img wp-image-61"/><figcaption>Cremas capilares Yanbal en Bogotá</figcaption></figure></div>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p>Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en Bogotá</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><br>Descubre la Belleza Natural con Yanbal<br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.<br>Productos de Belleza de Calidad Superior<br>En Yanbal, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.<br>Fragancias Exclusivas para Cada Ocasión<br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.<br>Ofertas y Promociones Especiales<br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.<br>Consejos de Belleza y Cuidado Personal<br>En nuestro blog, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.<br>Compra tus Productos Yanbal en Línea<br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo en línea, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_728947-ac","columns":3,"customRowGutter":[30,"",""],"columnGutter":"wider","customGutter":[64,"",""],"colLayout":"equal","bgColor":"palette9","align":"full","inheritMaxWidth":true,"bgColorClass":"theme-palette9","padding":["xxl","","xxl",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_2879ec-6d","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_2879ec-6d inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":64,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_6294b2-b4","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_6294b2-b4 size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/cosmeticos-yanbal.webp" alt="" class="kb-img wp-image-64"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_6a5ae8-ca","align":"left","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_6a5ae8-ca wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_6a5ae8-ca">Cosméticos para Mujer</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_8f33d8-85","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_8f33d8-85 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_8f33d8-85">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_f44421-df","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_f44421-df inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":73,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_def1ff-3f","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_def1ff-3f size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/perfume-jaque.webp" alt="" class="kb-img wp-image-73"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_bb4de1-8d","align":"left","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_bb4de1-8d wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_bb4de1-8d">Producto para Hombre </h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_bcb6d0-6b","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":["","",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_bcb6d0-6b wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_bcb6d0-6b">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":3,"borderWidth":["","","",""],"uniqueID":"6_784c0a-62","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_784c0a-62"><div class="kt-inside-inner-col"><!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_c383b9-43","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_c383b9-43 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":69,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_886db0-3a","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_886db0-3a size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/lociones-iluminadoras.webp" alt="" class="kb-img wp-image-69"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_d2b512-ea","align":"left","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_d2b512-ea wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_d2b512-ea">Cuidado de Niños y Bebés</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_5f241d-45","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_5f241d-45 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_5f241d-45">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2023-09-15 14:22:30', '2023-09-15 14:22:30', '', 6, 'https://yanbal.directorioempresascolombia.com/?p=80', 0, 'revision', '', 0),
(84, 1, '2023-09-15 14:26:11', '2023-09-15 14:26:11', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_fc6967-b0","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_dcc959-07","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_dcc959-07"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_5d2894-e6","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_e371eb-bf","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_e371eb-bf"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_e4adf1-8e","align":"left","color":"palette5","margin":["","","",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_e4adf1-8e wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_e4adf1-8e">directorio Empresas Bogotá y Colombia</div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_0e7d7d-1d","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_0e7d7d-1d wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_0e7d7d-1d">Venta <mark class="kt-highlight">Productos Belleza Yanbal </mark>en Bogotá  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p>Todo lo que necesita para su cuidado personal y belleza para mujeres, hombres, niños y bebés. A un click de distancia.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_852d6f-6c"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_852d6f-6c"><!-- wp:kadence/singlebtn {"uniqueID":"6_dbc6e6-98","text":"320 3008533 ","link":"tel://3203008533","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_d5b6c6-6f","text":"\\u003cstrong\\u003eCONTACTARNOS\\u003c/strong\\u003e","link":"/contacto","target":"_blank","sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_4d0e4a-b0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_4d0e4a-b0"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"align":"right","id":61,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_47b10d-06","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<div class="wp-block-kadence-image kb-image6_47b10d-06 is-style-rounded"><figure class="alignright size-full"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-capilar.webp" alt="" class="kb-img wp-image-61"/><figcaption>Cremas capilares Yanbal en Bogotá</figcaption></figure></div>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading {"textAlign":"center"} -->\n<h2 class="wp-block-heading has-text-align-center">Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en Bogotá</h2>\n<!-- /wp:heading -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_728947-ac","columns":3,"customRowGutter":[30,"",""],"columnGutter":"wider","customGutter":[64,"",""],"colLayout":"equal","bgColor":"palette9","align":"full","inheritMaxWidth":true,"bgColorClass":"theme-palette9","padding":["xxl","","xxl",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_2879ec-6d","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_2879ec-6d inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":64,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_6294b2-b4","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_6294b2-b4 size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/cosmeticos-yanbal.webp" alt="" class="kb-img wp-image-64"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_6a5ae8-ca","align":"left","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_6a5ae8-ca wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_6a5ae8-ca">Cosméticos para Mujer</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_8f33d8-85","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_8f33d8-85 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_8f33d8-85">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_f44421-df","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_f44421-df inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":73,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_def1ff-3f","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_def1ff-3f size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/perfume-jaque.webp" alt="" class="kb-img wp-image-73"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_bb4de1-8d","align":"left","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_bb4de1-8d wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_bb4de1-8d">Producto para Hombre </h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_bcb6d0-6b","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":["","",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_bcb6d0-6b wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_bcb6d0-6b">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":3,"borderWidth":["","","",""],"uniqueID":"6_784c0a-62","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_784c0a-62"><div class="kt-inside-inner-col"><!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_c383b9-43","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_c383b9-43 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":69,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_886db0-3a","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_886db0-3a size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/lociones-iluminadoras.webp" alt="" class="kb-img wp-image-69"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_d2b512-ea","align":"left","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_d2b512-ea wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_d2b512-ea">Cuidado de Niños y Bebés</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_5f241d-45","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_5f241d-45 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_5f241d-45">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><br>Descubre la Belleza Natural con Yanbal<br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.<br>Productos de Belleza de Calidad Superior<br>En Yanbal, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.<br>Fragancias Exclusivas para Cada Ocasión<br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.<br>Ofertas y Promociones Especiales<br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.<br>Consejos de Belleza y Cuidado Personal<br>En nuestro blog, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.<br>Compra tus Productos Yanbal en Línea<br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo en línea, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2023-09-15 14:26:11', '2023-09-15 14:26:11', '', 6, 'https://yanbal.directorioempresascolombia.com/?p=84', 0, 'revision', '', 0),
(83, 1, '2023-09-15 14:24:44', '2023-09-15 14:24:44', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_fc6967-b0","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_dcc959-07","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_dcc959-07"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_5d2894-e6","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_e371eb-bf","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_e371eb-bf"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_e4adf1-8e","align":"left","color":"palette5","margin":["","","",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_e4adf1-8e wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_e4adf1-8e">directorio Empresas Bogotá y Colombia</div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_0e7d7d-1d","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_0e7d7d-1d wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_0e7d7d-1d">Venta <mark class="kt-highlight">Productos Belleza Yanbal </mark>en Bogotá  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p>Todo lo que necesita para su cuidado personal y belleza para mujeres, hombres, niños y bebés. A un click de distancia.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_852d6f-6c"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_852d6f-6c"><!-- wp:kadence/singlebtn {"uniqueID":"6_dbc6e6-98","text":"320 3008533 ","link":"tel://3203008533","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_d5b6c6-6f","text":"\\u003cstrong\\u003eCONTACTARNOS\\u003c/strong\\u003e","link":"/contacto","target":"_blank","sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_4d0e4a-b0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_4d0e4a-b0"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"align":"right","id":61,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_47b10d-06","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<div class="wp-block-kadence-image kb-image6_47b10d-06 is-style-rounded"><figure class="alignright size-full"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-capilar.webp" alt="" class="kb-img wp-image-61"/><figcaption>Cremas capilares Yanbal en Bogotá</figcaption></figure></div>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading {"textAlign":"center"} -->\n<h2 class="wp-block-heading has-text-align-center">Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en Bogotá</h2>\n<!-- /wp:heading -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_728947-ac","columns":3,"customRowGutter":[30,"",""],"columnGutter":"wider","customGutter":[64,"",""],"colLayout":"equal","bgColor":"palette9","align":"full","inheritMaxWidth":true,"bgColorClass":"theme-palette9","padding":["xxl","","xxl",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_2879ec-6d","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_2879ec-6d inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":64,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_6294b2-b4","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_6294b2-b4 size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/cosmeticos-yanbal.webp" alt="" class="kb-img wp-image-64"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_6a5ae8-ca","align":"left","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_6a5ae8-ca wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_6a5ae8-ca">Cosméticos para Mujer</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_8f33d8-85","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_8f33d8-85 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_8f33d8-85">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_f44421-df","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_f44421-df inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":73,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_def1ff-3f","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_def1ff-3f size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/perfume-jaque.webp" alt="" class="kb-img wp-image-73"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_bb4de1-8d","align":"left","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_bb4de1-8d wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_bb4de1-8d">Producto para Hombre </h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_bcb6d0-6b","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":["","",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_bcb6d0-6b wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_bcb6d0-6b">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":3,"borderWidth":["","","",""],"uniqueID":"6_784c0a-62","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_784c0a-62"><div class="kt-inside-inner-col"><!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_c383b9-43","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_c383b9-43 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":69,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_886db0-3a","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_886db0-3a size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/lociones-iluminadoras.webp" alt="" class="kb-img wp-image-69"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_d2b512-ea","align":"left","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_d2b512-ea wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_d2b512-ea">Cuidado de Niños y Bebés</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_5f241d-45","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_5f241d-45 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_5f241d-45">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p>Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en Bogotá</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><br>Descubre la Belleza Natural con Yanbal<br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.<br>Productos de Belleza de Calidad Superior<br>En Yanbal, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.<br>Fragancias Exclusivas para Cada Ocasión<br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.<br>Ofertas y Promociones Especiales<br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.<br>Consejos de Belleza y Cuidado Personal<br>En nuestro blog, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.<br>Compra tus Productos Yanbal en Línea<br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo en línea, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2023-09-15 14:24:44', '2023-09-15 14:24:44', '', 6, 'https://yanbal.directorioempresascolombia.com/?p=83', 0, 'revision', '', 0),
(89, 1, '2023-09-15 14:29:58', '2023-09-15 14:29:58', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_fc6967-b0","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_dcc959-07","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_dcc959-07"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_5d2894-e6","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_e371eb-bf","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_e371eb-bf"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_e4adf1-8e","align":"left","color":"palette5","margin":["","","",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_e4adf1-8e wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_e4adf1-8e">directorio Empresas Bogotá y Colombia</div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_0e7d7d-1d","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_0e7d7d-1d wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_0e7d7d-1d">Venta <mark class="kt-highlight">Productos Belleza Yanbal </mark>en Bogotá  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p>Todo lo que necesita para su cuidado personal y belleza para mujeres, hombres, niños y bebés. A un click de distancia.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_852d6f-6c"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_852d6f-6c"><!-- wp:kadence/singlebtn {"uniqueID":"6_dbc6e6-98","text":"320 3008533 ","link":"tel://3203008533","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_d5b6c6-6f","text":"\\u003cstrong\\u003eCONTACTARNOS\\u003c/strong\\u003e","link":"/contacto","target":"_blank","sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_4d0e4a-b0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_4d0e4a-b0"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"align":"right","id":61,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_47b10d-06","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<div class="wp-block-kadence-image kb-image6_47b10d-06 is-style-rounded"><figure class="alignright size-full"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-capilar.webp" alt="" class="kb-img wp-image-61"/><figcaption>Cremas capilares Yanbal en Bogotá</figcaption></figure></div>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading {"textAlign":"center"} -->\n<h2 class="wp-block-heading has-text-align-center">Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en Bogotá</h2>\n<!-- /wp:heading -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_df1818-ab","columns":1,"colLayout":"equal","bgColor":"#d8b078","align":"full","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_81be5f-2f","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_81be5f-2f"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_77a6b0-e3","columns":3,"customRowGutter":[30,"",""],"columnGutter":"wider","customGutter":[64,"",""],"colLayout":"equal","inheritMaxWidth":true,"padding":["xxl","","xxl",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_887cf3-11","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_887cf3-11 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":64,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_20ede3-32","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_20ede3-32 size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/cosmeticos-yanbal.webp" alt="" class="kb-img wp-image-64"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_fea0e4-34","align":"left","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_fea0e4-34 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_fea0e4-34">Cosméticos para Mujer</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_c10595-42","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_c10595-42 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_c10595-42">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_1bd929-fb","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_1bd929-fb inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":73,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_69f357-84","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_69f357-84 size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/perfume-jaque.webp" alt="" class="kb-img wp-image-73"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_c19f9d-74","align":"left","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_c19f9d-74 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_c19f9d-74">Producto para Hombre </h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_9da24d-48","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":["","",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_9da24d-48 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_9da24d-48">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":3,"borderWidth":["","","",""],"uniqueID":"6_3baf88-7a","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_3baf88-7a"><div class="kt-inside-inner-col"><!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_5d35c2-a0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_5d35c2-a0 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":69,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_31853d-d1","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_31853d-d1 size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/lociones-iluminadoras.webp" alt="" class="kb-img wp-image-69"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_78f3eb-a5","align":"left","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_78f3eb-a5 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_78f3eb-a5">Cuidado de Niños y Bebés</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_200eb7-45","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_200eb7-45 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_200eb7-45">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><br>Descubre la Belleza Natural con Yanbal<br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.<br>Productos de Belleza de Calidad Superior<br>En Yanbal, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.<br>Fragancias Exclusivas para Cada Ocasión<br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.<br>Ofertas y Promociones Especiales<br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.<br>Consejos de Belleza y Cuidado Personal<br>En nuestro blog, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.<br>Compra tus Productos Yanbal en Línea<br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo en línea, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2023-09-15 14:29:58', '2023-09-15 14:29:58', '', 6, 'https://yanbal.directorioempresascolombia.com/?p=89', 0, 'revision', '', 0);
INSERT INTO `hpp_posts` VALUES
(88, 1, '2023-09-15 14:29:27', '2023-09-15 14:29:27', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_fc6967-b0","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_dcc959-07","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_dcc959-07"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_5d2894-e6","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_e371eb-bf","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_e371eb-bf"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_e4adf1-8e","align":"left","color":"palette5","margin":["","","",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_e4adf1-8e wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_e4adf1-8e">directorio Empresas Bogotá y Colombia</div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_0e7d7d-1d","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_0e7d7d-1d wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_0e7d7d-1d">Venta <mark class="kt-highlight">Productos Belleza Yanbal </mark>en Bogotá  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p>Todo lo que necesita para su cuidado personal y belleza para mujeres, hombres, niños y bebés. A un click de distancia.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_852d6f-6c"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_852d6f-6c"><!-- wp:kadence/singlebtn {"uniqueID":"6_dbc6e6-98","text":"320 3008533 ","link":"tel://3203008533","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_d5b6c6-6f","text":"\\u003cstrong\\u003eCONTACTARNOS\\u003c/strong\\u003e","link":"/contacto","target":"_blank","sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_4d0e4a-b0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_4d0e4a-b0"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"align":"right","id":61,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_47b10d-06","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<div class="wp-block-kadence-image kb-image6_47b10d-06 is-style-rounded"><figure class="alignright size-full"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-capilar.webp" alt="" class="kb-img wp-image-61"/><figcaption>Cremas capilares Yanbal en Bogotá</figcaption></figure></div>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading {"textAlign":"center"} -->\n<h2 class="wp-block-heading has-text-align-center">Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en Bogotá</h2>\n<!-- /wp:heading -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_df1818-ab","columns":1,"colLayout":"equal","bgColor":"#d8b078","align":"full","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_81be5f-2f","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_81be5f-2f"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_77a6b0-e3","columns":3,"customRowGutter":[30,"",""],"columnGutter":"wider","customGutter":[64,"",""],"colLayout":"equal","inheritMaxWidth":true,"padding":["xxl","","xxl",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_887cf3-11","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_887cf3-11 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":64,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_20ede3-32","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_20ede3-32 size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/cosmeticos-yanbal.webp" alt="" class="kb-img wp-image-64"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_fea0e4-34","align":"left","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_fea0e4-34 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_fea0e4-34">Cosméticos para Mujer</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_c10595-42","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_c10595-42 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_c10595-42">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_1bd929-fb","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_1bd929-fb inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":73,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_69f357-84","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_69f357-84 size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/perfume-jaque.webp" alt="" class="kb-img wp-image-73"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_c19f9d-74","align":"left","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_c19f9d-74 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_c19f9d-74">Producto para Hombre </h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_9da24d-48","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":["","",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_9da24d-48 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_9da24d-48">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":3,"borderWidth":["","","",""],"uniqueID":"6_3baf88-7a","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_3baf88-7a"><div class="kt-inside-inner-col"><!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_5d35c2-a0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_5d35c2-a0 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":69,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_31853d-d1","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_31853d-d1 size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/lociones-iluminadoras.webp" alt="" class="kb-img wp-image-69"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_78f3eb-a5","align":"left","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_78f3eb-a5 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_78f3eb-a5">Cuidado de Niños y Bebés</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_200eb7-45","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_200eb7-45 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_200eb7-45">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_728947-ac","columns":3,"customRowGutter":[30,"",""],"columnGutter":"wider","customGutter":[64,"",""],"colLayout":"equal","bgColor":"palette9","inheritMaxWidth":true,"bgColorClass":"theme-palette9","padding":["xxl","","xxl",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_2879ec-6d","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_2879ec-6d inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":64,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_6294b2-b4","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_6294b2-b4 size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/cosmeticos-yanbal.webp" alt="" class="kb-img wp-image-64"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_6a5ae8-ca","align":"left","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_6a5ae8-ca wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_6a5ae8-ca">Cosméticos para Mujer</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_8f33d8-85","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_8f33d8-85 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_8f33d8-85">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_f44421-df","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_f44421-df inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":73,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_def1ff-3f","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_def1ff-3f size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/perfume-jaque.webp" alt="" class="kb-img wp-image-73"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_bb4de1-8d","align":"left","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_bb4de1-8d wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_bb4de1-8d">Producto para Hombre </h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_bcb6d0-6b","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":["","",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_bcb6d0-6b wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_bcb6d0-6b">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":3,"borderWidth":["","","",""],"uniqueID":"6_784c0a-62","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_784c0a-62"><div class="kt-inside-inner-col"><!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_c383b9-43","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_c383b9-43 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":69,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_886db0-3a","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_886db0-3a size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/lociones-iluminadoras.webp" alt="" class="kb-img wp-image-69"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_d2b512-ea","align":"left","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_d2b512-ea wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_d2b512-ea">Cuidado de Niños y Bebés</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_5f241d-45","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_5f241d-45 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_5f241d-45">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><br>Descubre la Belleza Natural con Yanbal<br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.<br>Productos de Belleza de Calidad Superior<br>En Yanbal, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.<br>Fragancias Exclusivas para Cada Ocasión<br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.<br>Ofertas y Promociones Especiales<br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.<br>Consejos de Belleza y Cuidado Personal<br>En nuestro blog, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.<br>Compra tus Productos Yanbal en Línea<br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo en línea, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2023-09-15 14:29:27', '2023-09-15 14:29:27', '', 6, 'https://yanbal.directorioempresascolombia.com/?p=88', 0, 'revision', '', 0),
(86, 1, '2023-09-15 14:28:00', '2023-09-15 14:28:00', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_fc6967-b0","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_dcc959-07","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_dcc959-07"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_5d2894-e6","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_e371eb-bf","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_e371eb-bf"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_e4adf1-8e","align":"left","color":"palette5","margin":["","","",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_e4adf1-8e wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_e4adf1-8e">directorio Empresas Bogotá y Colombia</div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_0e7d7d-1d","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_0e7d7d-1d wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_0e7d7d-1d">Venta <mark class="kt-highlight">Productos Belleza Yanbal </mark>en Bogotá  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p>Todo lo que necesita para su cuidado personal y belleza para mujeres, hombres, niños y bebés. A un click de distancia.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_852d6f-6c"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_852d6f-6c"><!-- wp:kadence/singlebtn {"uniqueID":"6_dbc6e6-98","text":"320 3008533 ","link":"tel://3203008533","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_d5b6c6-6f","text":"\\u003cstrong\\u003eCONTACTARNOS\\u003c/strong\\u003e","link":"/contacto","target":"_blank","sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_4d0e4a-b0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_4d0e4a-b0"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"align":"right","id":61,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_47b10d-06","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<div class="wp-block-kadence-image kb-image6_47b10d-06 is-style-rounded"><figure class="alignright size-full"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-capilar.webp" alt="" class="kb-img wp-image-61"/><figcaption>Cremas capilares Yanbal en Bogotá</figcaption></figure></div>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading {"textAlign":"center"} -->\n<h2 class="wp-block-heading has-text-align-center">Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en Bogotá</h2>\n<!-- /wp:heading -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_df1818-ab","columns":1,"colLayout":"equal","bgColor":"#d8b078","align":"full","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_81be5f-2f","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_81be5f-2f"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_77a6b0-e3","columns":3,"customRowGutter":[30,"",""],"columnGutter":"wider","customGutter":[64,"",""],"colLayout":"equal","bgColor":"palette9","align":"full","inheritMaxWidth":true,"bgColorClass":"theme-palette9","padding":["xxl","","xxl",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_887cf3-11","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_887cf3-11 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":64,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_20ede3-32","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_20ede3-32 size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/cosmeticos-yanbal.webp" alt="" class="kb-img wp-image-64"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_fea0e4-34","align":"left","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_fea0e4-34 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_fea0e4-34">Cosméticos para Mujer</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_c10595-42","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_c10595-42 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_c10595-42">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_1bd929-fb","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_1bd929-fb inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":73,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_69f357-84","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_69f357-84 size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/perfume-jaque.webp" alt="" class="kb-img wp-image-73"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_c19f9d-74","align":"left","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_c19f9d-74 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_c19f9d-74">Producto para Hombre </h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_9da24d-48","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":["","",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_9da24d-48 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_9da24d-48">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":3,"borderWidth":["","","",""],"uniqueID":"6_3baf88-7a","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_3baf88-7a"><div class="kt-inside-inner-col"><!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_5d35c2-a0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_5d35c2-a0 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":69,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_31853d-d1","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_31853d-d1 size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/lociones-iluminadoras.webp" alt="" class="kb-img wp-image-69"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_78f3eb-a5","align":"left","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_78f3eb-a5 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_78f3eb-a5">Cuidado de Niños y Bebés</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_200eb7-45","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_200eb7-45 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_200eb7-45">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_728947-ac","columns":3,"customRowGutter":[30,"",""],"columnGutter":"wider","customGutter":[64,"",""],"colLayout":"equal","bgColor":"palette9","inheritMaxWidth":true,"bgColorClass":"theme-palette9","padding":["xxl","","xxl",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_2879ec-6d","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_2879ec-6d inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":64,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_6294b2-b4","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_6294b2-b4 size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/cosmeticos-yanbal.webp" alt="" class="kb-img wp-image-64"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_6a5ae8-ca","align":"left","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_6a5ae8-ca wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_6a5ae8-ca">Cosméticos para Mujer</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_8f33d8-85","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_8f33d8-85 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_8f33d8-85">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_f44421-df","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_f44421-df inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":73,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_def1ff-3f","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_def1ff-3f size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/perfume-jaque.webp" alt="" class="kb-img wp-image-73"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_bb4de1-8d","align":"left","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_bb4de1-8d wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_bb4de1-8d">Producto para Hombre </h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_bcb6d0-6b","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":["","",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_bcb6d0-6b wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_bcb6d0-6b">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":3,"borderWidth":["","","",""],"uniqueID":"6_784c0a-62","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_784c0a-62"><div class="kt-inside-inner-col"><!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_c383b9-43","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_c383b9-43 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":69,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_886db0-3a","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_886db0-3a size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/lociones-iluminadoras.webp" alt="" class="kb-img wp-image-69"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_d2b512-ea","align":"left","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_d2b512-ea wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_d2b512-ea">Cuidado de Niños y Bebés</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_5f241d-45","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_5f241d-45 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_5f241d-45">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><br>Descubre la Belleza Natural con Yanbal<br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.<br>Productos de Belleza de Calidad Superior<br>En Yanbal, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.<br>Fragancias Exclusivas para Cada Ocasión<br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.<br>Ofertas y Promociones Especiales<br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.<br>Consejos de Belleza y Cuidado Personal<br>En nuestro blog, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.<br>Compra tus Productos Yanbal en Línea<br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo en línea, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2023-09-15 14:28:00', '2023-09-15 14:28:00', '', 6, 'https://yanbal.directorioempresascolombia.com/?p=86', 0, 'revision', '', 0),
(92, 1, '2023-09-15 14:32:29', '2023-09-15 14:32:29', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_fc6967-b0","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_dcc959-07","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_dcc959-07"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_5d2894-e6","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_e371eb-bf","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_e371eb-bf"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_e4adf1-8e","align":"left","color":"palette5","margin":["","","",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_e4adf1-8e wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_e4adf1-8e">directorio Empresas Bogotá y Colombia</div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_0e7d7d-1d","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_0e7d7d-1d wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_0e7d7d-1d">Venta <mark class="kt-highlight">Productos Belleza Yanbal </mark>en Bogotá  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p>Todo lo que necesita para su cuidado personal y belleza para mujeres, hombres, niños y bebés. A un click de distancia.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_852d6f-6c"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_852d6f-6c"><!-- wp:kadence/singlebtn {"uniqueID":"6_dbc6e6-98","text":"320 3008533 ","link":"tel://3203008533","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_d5b6c6-6f","text":"\\u003cstrong\\u003eCONTACTARNOS\\u003c/strong\\u003e","link":"/contacto","target":"_blank","sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_4d0e4a-b0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_4d0e4a-b0"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"align":"right","id":61,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_47b10d-06","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<div class="wp-block-kadence-image kb-image6_47b10d-06 is-style-rounded"><figure class="alignright size-full"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-capilar.webp" alt="" class="kb-img wp-image-61"/><figcaption>Cremas capilares Yanbal en Bogotá</figcaption></figure></div>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_df1818-ab","columns":1,"colLayout":"equal","bgColor":"#d8b078","align":"full","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_81be5f-2f","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_81be5f-2f"><div class="kt-inside-inner-col"><!-- wp:heading {"textAlign":"center"} -->\n<h2 class="wp-block-heading has-text-align-center">Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en Bogotá</h2>\n<!-- /wp:heading -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_77a6b0-e3","columns":3,"customRowGutter":[30,"",""],"columnGutter":"wider","customGutter":[64,"",""],"colLayout":"equal","inheritMaxWidth":true,"padding":["xxl","","xxl",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_887cf3-11","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_887cf3-11 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":64,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_20ede3-32","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_20ede3-32 size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/cosmeticos-yanbal.webp" alt="" class="kb-img wp-image-64"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_fea0e4-34","align":"left","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_fea0e4-34 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_fea0e4-34">Cosméticos para Mujer</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_c10595-42","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_c10595-42 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_c10595-42">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_1bd929-fb","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_1bd929-fb inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":73,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_69f357-84","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_69f357-84 size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/perfume-jaque.webp" alt="" class="kb-img wp-image-73"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_c19f9d-74","align":"left","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_c19f9d-74 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_c19f9d-74">Producto para Hombre </h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_9da24d-48","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":["","",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_9da24d-48 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_9da24d-48">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":3,"borderWidth":["","","",""],"uniqueID":"6_3baf88-7a","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_3baf88-7a"><div class="kt-inside-inner-col"><!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_5d35c2-a0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_5d35c2-a0 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":69,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_31853d-d1","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_31853d-d1 size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/lociones-iluminadoras.webp" alt="" class="kb-img wp-image-69"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_78f3eb-a5","align":"left","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_78f3eb-a5 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_78f3eb-a5">Cuidado de Niños y Bebés</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_200eb7-45","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_200eb7-45 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_200eb7-45">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><br>Descubre la Belleza Natural con Yanbal<br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.<br>Productos de Belleza de Calidad Superior<br>En Yanbal, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.<br>Fragancias Exclusivas para Cada Ocasión<br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.<br>Ofertas y Promociones Especiales<br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.<br>Consejos de Belleza y Cuidado Personal<br>En nuestro blog, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.<br>Compra tus Productos Yanbal en Línea<br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo en línea, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2023-09-15 14:32:29', '2023-09-15 14:32:29', '', 6, 'https://yanbal.directorioempresascolombia.com/?p=92', 0, 'revision', '', 0);
INSERT INTO `hpp_posts` VALUES
(91, 1, '2023-09-15 14:32:06', '2023-09-15 14:32:06', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_fc6967-b0","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_dcc959-07","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_dcc959-07"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_5d2894-e6","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_e371eb-bf","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_e371eb-bf"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_e4adf1-8e","align":"left","color":"palette5","margin":["","","",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_e4adf1-8e wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_e4adf1-8e">directorio Empresas Bogotá y Colombia</div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_0e7d7d-1d","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_0e7d7d-1d wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_0e7d7d-1d">Venta <mark class="kt-highlight">Productos Belleza Yanbal </mark>en Bogotá  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p>Todo lo que necesita para su cuidado personal y belleza para mujeres, hombres, niños y bebés. A un click de distancia.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_852d6f-6c"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_852d6f-6c"><!-- wp:kadence/singlebtn {"uniqueID":"6_dbc6e6-98","text":"320 3008533 ","link":"tel://3203008533","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_d5b6c6-6f","text":"\\u003cstrong\\u003eCONTACTARNOS\\u003c/strong\\u003e","link":"/contacto","target":"_blank","sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_4d0e4a-b0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_4d0e4a-b0"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"align":"right","id":61,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_47b10d-06","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<div class="wp-block-kadence-image kb-image6_47b10d-06 is-style-rounded"><figure class="alignright size-full"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-capilar.webp" alt="" class="kb-img wp-image-61"/><figcaption>Cremas capilares Yanbal en Bogotá</figcaption></figure></div>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_df1818-ab","columns":1,"colLayout":"equal","bgColor":"#d8b078","align":"full","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_81be5f-2f","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_81be5f-2f"><div class="kt-inside-inner-col"><!-- wp:heading {"textAlign":"center"} -->\n<h2 class="wp-block-heading has-text-align-center">Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en Bogotá</h2>\n<!-- /wp:heading -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_77a6b0-e3","columns":3,"customRowGutter":[30,"",""],"columnGutter":"wider","customGutter":[64,"",""],"colLayout":"equal","inheritMaxWidth":true,"padding":["xxl","","xxl",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_887cf3-11","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_887cf3-11 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":64,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_20ede3-32","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_20ede3-32 size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/cosmeticos-yanbal.webp" alt="" class="kb-img wp-image-64"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_fea0e4-34","align":"left","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_fea0e4-34 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_fea0e4-34">Cosméticos para Mujer</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_c10595-42","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_c10595-42 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_c10595-42">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_1bd929-fb","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_1bd929-fb inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":73,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_69f357-84","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_69f357-84 size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/perfume-jaque.webp" alt="" class="kb-img wp-image-73"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_c19f9d-74","align":"left","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_c19f9d-74 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_c19f9d-74">Producto para Hombre </h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_9da24d-48","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":["","",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_9da24d-48 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_9da24d-48">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":3,"borderWidth":["","","",""],"uniqueID":"6_3baf88-7a","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_3baf88-7a"><div class="kt-inside-inner-col"><!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_5d35c2-a0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_5d35c2-a0 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":69,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_31853d-d1","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_31853d-d1 size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/lociones-iluminadoras.webp" alt="" class="kb-img wp-image-69"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_78f3eb-a5","align":"left","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_78f3eb-a5 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_78f3eb-a5">Cuidado de Niños y Bebés</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_200eb7-45","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_200eb7-45 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_200eb7-45">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:heading {"textAlign":"center"} -->\n<h2 class="wp-block-heading has-text-align-center">Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en Bogotá</h2>\n<!-- /wp:heading -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><br>Descubre la Belleza Natural con Yanbal<br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.<br>Productos de Belleza de Calidad Superior<br>En Yanbal, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.<br>Fragancias Exclusivas para Cada Ocasión<br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.<br>Ofertas y Promociones Especiales<br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.<br>Consejos de Belleza y Cuidado Personal<br>En nuestro blog, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.<br>Compra tus Productos Yanbal en Línea<br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo en línea, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2023-09-15 14:32:06', '2023-09-15 14:32:06', '', 6, 'https://yanbal.directorioempresascolombia.com/?p=91', 0, 'revision', '', 0),
(95, 1, '2023-09-15 14:45:02', '2023-09-15 14:45:02', 'Catalogo productos belleza Yanbal Bogota', 'Catalogo Yanbal', 'Catalogo productos belleza Yanbal', 'inherit', 'open', 'closed', '', 'col_2023_c10', '', '', '2023-09-15 14:47:16', '2023-09-15 14:47:16', '', 0, 'https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf', 0, 'attachment', 'application/pdf', 0),
(160, 1, '2024-07-15 20:57:04', '2024-07-15 20:57:04', '<!-- wp:kadence/rowlayout {"uniqueID":"28_40f8da-63","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"28_3722b7-2b","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column28_3722b7-2b"><div class="kt-inside-inner-col"><!-- wp:file {"id":95,"href":"https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf","displayPreview":true,"previewHeight":1040} -->\n<div class="wp-block-file"><object class="wp-block-file__embed" data="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf" type="application/pdf" style="width:100%;height:1040px" aria-label="Catalogo Yanbal"></object><a id="wp-block-file--media-a53c01e9-207d-4225-8df1-93c8967b6d69" href="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf">Catalogo Yanbal</a><a href="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf" class="wp-block-file__button wp-element-button" download aria-describedby="wp-block-file--media-a53c01e9-207d-4225-8df1-93c8967b6d69">Download</a></div>\n<!-- /wp:file --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'Catalogo Yanbal 2025', '', 'inherit', 'closed', 'closed', '', '28-revision-v1', '', '', '2024-07-15 20:57:04', '2024-07-15 20:57:04', '', 28, 'https://yanbal.directorioempresascolombia.com/?p=160', 0, 'revision', '', 0),
(98, 1, '2023-09-15 14:48:08', '2023-09-15 14:48:08', '<!-- wp:kadence/rowlayout {"uniqueID":"28_40f8da-63","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"28_3722b7-2b","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column28_3722b7-2b"><div class="kt-inside-inner-col"><!-- wp:file {"id":95,"href":"https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf","displayPreview":true,"previewHeight":1010} -->\n<div class="wp-block-file"><object class="wp-block-file__embed" data="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf" type="application/pdf" style="width:100%;height:1010px" aria-label="Catalogo Yanbal"></object><a id="wp-block-file--media-a53c01e9-207d-4225-8df1-93c8967b6d69" href="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf">Catalogo Yanbal</a><a href="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf" class="wp-block-file__button wp-element-button" download aria-describedby="wp-block-file--media-a53c01e9-207d-4225-8df1-93c8967b6d69">Download</a></div>\n<!-- /wp:file --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'Catalogo Yanbal', '', 'inherit', 'closed', 'closed', '', '28-revision-v1', '', '', '2023-09-15 14:48:08', '2023-09-15 14:48:08', '', 28, 'https://yanbal.directorioempresascolombia.com/?p=98', 0, 'revision', '', 0),
(97, 1, '2023-09-15 14:47:22', '2023-09-15 14:47:22', '<!-- wp:kadence/rowlayout {"uniqueID":"28_40f8da-63","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"28_3722b7-2b","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column28_3722b7-2b"><div class="kt-inside-inner-col"><!-- wp:file {"id":95,"href":"https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf","displayPreview":true} -->\n<div class="wp-block-file"><object class="wp-block-file__embed" data="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf" type="application/pdf" style="width:100%;height:600px" aria-label="Catalogo Yanbal"></object><a id="wp-block-file--media-a53c01e9-207d-4225-8df1-93c8967b6d69" href="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf">Catalogo Yanbal</a><a href="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf" class="wp-block-file__button wp-element-button" download aria-describedby="wp-block-file--media-a53c01e9-207d-4225-8df1-93c8967b6d69">Download</a></div>\n<!-- /wp:file --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'Catalogo Yanbal', '', 'inherit', 'closed', 'closed', '', '28-revision-v1', '', '', '2023-09-15 14:47:22', '2023-09-15 14:47:22', '', 28, 'https://yanbal.directorioempresascolombia.com/?p=97', 0, 'revision', '', 0),
(94, 1, '2023-09-15 14:40:48', '2023-09-15 14:40:48', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_fc6967-b0","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_dcc959-07","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_dcc959-07"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_5d2894-e6","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_e371eb-bf","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_e371eb-bf"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_e4adf1-8e","align":"left","color":"palette5","margin":["","","",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_e4adf1-8e wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_e4adf1-8e">directorio Empresas Bogotá y Colombia</div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_0e7d7d-1d","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_0e7d7d-1d wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_0e7d7d-1d">Venta <mark class="kt-highlight">Productos Belleza Yanbal </mark>en Bogotá  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p>Todo lo que necesita para su cuidado personal y belleza para mujeres, hombres, niños y bebés. A un click de distancia.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_852d6f-6c"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_852d6f-6c"><!-- wp:kadence/singlebtn {"uniqueID":"6_dbc6e6-98","text":"320 3008533 ","link":"tel://3203008533","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_d5b6c6-6f","text":"\\u003cstrong\\u003eCONTACTARNOS\\u003c/strong\\u003e","link":"/contacto","target":"_blank","sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_4d0e4a-b0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_4d0e4a-b0"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"align":"right","id":61,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_47b10d-06","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<div class="wp-block-kadence-image kb-image6_47b10d-06 is-style-rounded"><figure class="alignright size-full"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-capilar.webp" alt="" class="kb-img wp-image-61"/><figcaption>Cremas capilares Yanbal en Bogotá</figcaption></figure></div>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_df1818-ab","columns":1,"colLayout":"equal","bgColor":"#d8b078","align":"full","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_81be5f-2f","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_81be5f-2f"><div class="kt-inside-inner-col"><!-- wp:heading {"textAlign":"center"} -->\n<h2 class="wp-block-heading has-text-align-center">Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en Bogotá</h2>\n<!-- /wp:heading -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_77a6b0-e3","columns":3,"customRowGutter":[30,"",""],"columnGutter":"wider","customGutter":[64,"",""],"colLayout":"equal","inheritMaxWidth":true,"padding":["xxl","","xxl",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_887cf3-11","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_887cf3-11 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":64,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_20ede3-32","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_20ede3-32 size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/cosmeticos-yanbal.webp" alt="" class="kb-img wp-image-64"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_fea0e4-34","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_fea0e4-34 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_fea0e4-34">Cosméticos para Mujer</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_c10595-42","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_c10595-42 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_c10595-42">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_1bd929-fb","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_1bd929-fb inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":73,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_69f357-84","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_69f357-84 size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/perfume-jaque.webp" alt="" class="kb-img wp-image-73"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_c19f9d-74","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_c19f9d-74 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_c19f9d-74">Producto para Hombre </h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_9da24d-48","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":["","",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_9da24d-48 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_9da24d-48">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":3,"borderWidth":["","","",""],"uniqueID":"6_3baf88-7a","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_3baf88-7a"><div class="kt-inside-inner-col"><!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_5d35c2-a0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_5d35c2-a0 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":69,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_31853d-d1","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_31853d-d1 size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/lociones-iluminadoras.webp" alt="" class="kb-img wp-image-69"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_78f3eb-a5","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_78f3eb-a5 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_78f3eb-a5">Cuidado de Niños y Bebés</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_200eb7-45","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_200eb7-45 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_200eb7-45">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><br>Descubre la Belleza Natural con Yanbal<br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.<br>Productos de Belleza de Calidad Superior<br>En Yanbal, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.<br>Fragancias Exclusivas para Cada Ocasión<br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.<br>Ofertas y Promociones Especiales<br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.<br>Consejos de Belleza y Cuidado Personal<br>En nuestro blog, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.<br>Compra tus Productos Yanbal en Línea<br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo en línea, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2023-09-15 14:40:48', '2023-09-15 14:40:48', '', 6, 'https://yanbal.directorioempresascolombia.com/?p=94', 0, 'revision', '', 0),
(107, 1, '2023-09-15 14:58:10', '2023-09-15 14:58:10', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_fc6967-b0","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_dcc959-07","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_dcc959-07"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_5d2894-e6","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_e371eb-bf","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_e371eb-bf"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_e4adf1-8e","align":"left","color":"palette5","margin":["","","",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_e4adf1-8e wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_e4adf1-8e">directorio Empresas Bogotá y Colombia</div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_0e7d7d-1d","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_0e7d7d-1d wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_0e7d7d-1d">Venta <mark class="kt-highlight">Productos Belleza Yanbal </mark>en Bogotá  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p>Todo lo que necesita para su cuidado personal y belleza para mujeres, hombres, niños y bebés. A un click de distancia.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_852d6f-6c"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_852d6f-6c"><!-- wp:kadence/singlebtn {"uniqueID":"6_dbc6e6-98","text":"320 3008533 ","link":"tel://3203008533","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_d5b6c6-6f","text":"\\u003cstrong\\u003eCONTACTARNOS\\u003c/strong\\u003e","link":"/contacto","target":"_blank","sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_4d0e4a-b0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_4d0e4a-b0"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"align":"right","id":61,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_47b10d-06","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<div class="wp-block-kadence-image kb-image6_47b10d-06 is-style-rounded"><figure class="alignright size-full"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-capilar.webp" alt="" class="kb-img wp-image-61"/><figcaption>Cremas capilares Yanbal en Bogotá</figcaption></figure></div>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_df1818-ab","columns":1,"colLayout":"equal","bgColor":"#d8b078","align":"full","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_81be5f-2f","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_81be5f-2f"><div class="kt-inside-inner-col"><!-- wp:heading {"textAlign":"center"} -->\n<h2 class="wp-block-heading has-text-align-center">Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en Bogotá</h2>\n<!-- /wp:heading -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_77a6b0-e3","columns":3,"customRowGutter":[30,"",""],"columnGutter":"wider","customGutter":[64,"",""],"colLayout":"equal","inheritMaxWidth":true,"padding":["xxl","","xxl",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_887cf3-11","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_887cf3-11 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":64,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/productos-damas/","linkDestination":"custom","uniqueID":"6_20ede3-32","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_20ede3-32 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/productos-damas/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/cosmeticos-yanbal.webp" alt="" class="kb-img wp-image-64"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_fea0e4-34","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_fea0e4-34 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_fea0e4-34"><a href="https://yanbal.directorioempresascolombia.com/productos-damas/">Cosméticos para Mujer</a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_c10595-42","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_c10595-42 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_c10595-42">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_1bd929-fb","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_1bd929-fb inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":73,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_69f357-84","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_69f357-84 size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/perfume-jaque.webp" alt="" class="kb-img wp-image-73"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_c19f9d-74","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_c19f9d-74 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_c19f9d-74">Productos para Hombre </h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_9da24d-48","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":["","",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_9da24d-48 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_9da24d-48">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":3,"borderWidth":["","","",""],"uniqueID":"6_3baf88-7a","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_3baf88-7a"><div class="kt-inside-inner-col"><!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_5d35c2-a0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_5d35c2-a0 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":69,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_31853d-d1","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_31853d-d1 size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/lociones-iluminadoras.webp" alt="" class="kb-img wp-image-69"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_78f3eb-a5","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_78f3eb-a5 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_78f3eb-a5">Cuidado de Niños y Bebés</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_200eb7-45","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_200eb7-45 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_200eb7-45">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><br>Descubre la Belleza Natural con Yanbal<br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.<br>Productos de Belleza de Calidad Superior<br>En Yanbal, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.<br>Fragancias Exclusivas para Cada Ocasión<br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.<br>Ofertas y Promociones Especiales<br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.<br>Consejos de Belleza y Cuidado Personal<br>En nuestro blog, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.<br>Compra tus Productos Yanbal en Línea<br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo en línea, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2023-09-15 14:58:10', '2023-09-15 14:58:10', '', 6, 'https://yanbal.directorioempresascolombia.com/?p=107', 0, 'revision', '', 0);
INSERT INTO `hpp_posts` VALUES
(102, 1, '2023-09-15 14:53:25', '2023-09-15 14:53:25', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_fc6967-b0","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_dcc959-07","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_dcc959-07"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_5d2894-e6","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_e371eb-bf","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_e371eb-bf"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_e4adf1-8e","align":"left","color":"palette5","margin":["","","",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_e4adf1-8e wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_e4adf1-8e">directorio Empresas Bogotá y Colombia</div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_0e7d7d-1d","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_0e7d7d-1d wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_0e7d7d-1d">Venta <mark class="kt-highlight">Productos Belleza Yanbal </mark>en Bogotá  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p>Todo lo que necesita para su cuidado personal y belleza para mujeres, hombres, niños y bebés. A un click de distancia.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_852d6f-6c"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_852d6f-6c"><!-- wp:kadence/singlebtn {"uniqueID":"6_dbc6e6-98","text":"320 3008533 ","link":"tel://3203008533","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_d5b6c6-6f","text":"\\u003cstrong\\u003eCONTACTARNOS\\u003c/strong\\u003e","link":"/contacto","target":"_blank","sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_4d0e4a-b0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_4d0e4a-b0"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"align":"right","id":61,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_47b10d-06","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<div class="wp-block-kadence-image kb-image6_47b10d-06 is-style-rounded"><figure class="alignright size-full"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-capilar.webp" alt="" class="kb-img wp-image-61"/><figcaption>Cremas capilares Yanbal en Bogotá</figcaption></figure></div>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_df1818-ab","columns":1,"colLayout":"equal","bgColor":"#d8b078","align":"full","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_81be5f-2f","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_81be5f-2f"><div class="kt-inside-inner-col"><!-- wp:heading {"textAlign":"center"} -->\n<h2 class="wp-block-heading has-text-align-center">Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en Bogotá</h2>\n<!-- /wp:heading -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_77a6b0-e3","columns":3,"customRowGutter":[30,"",""],"columnGutter":"wider","customGutter":[64,"",""],"colLayout":"equal","inheritMaxWidth":true,"padding":["xxl","","xxl",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_887cf3-11","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_887cf3-11 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":64,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/productos-damas/","linkDestination":"custom","uniqueID":"6_20ede3-32","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_20ede3-32 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/productos-damas/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/cosmeticos-yanbal.webp" alt="" class="kb-img wp-image-64"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_fea0e4-34","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_fea0e4-34 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_fea0e4-34">Cosméticos para Mujer</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_c10595-42","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_c10595-42 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_c10595-42">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_1bd929-fb","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_1bd929-fb inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":73,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_69f357-84","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_69f357-84 size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/perfume-jaque.webp" alt="" class="kb-img wp-image-73"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_c19f9d-74","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_c19f9d-74 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_c19f9d-74">Producto para Hombre </h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_9da24d-48","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":["","",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_9da24d-48 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_9da24d-48">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":3,"borderWidth":["","","",""],"uniqueID":"6_3baf88-7a","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_3baf88-7a"><div class="kt-inside-inner-col"><!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_5d35c2-a0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_5d35c2-a0 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":69,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_31853d-d1","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_31853d-d1 size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/lociones-iluminadoras.webp" alt="" class="kb-img wp-image-69"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_78f3eb-a5","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_78f3eb-a5 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_78f3eb-a5">Cuidado de Niños y Bebés</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_200eb7-45","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_200eb7-45 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_200eb7-45">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><br>Descubre la Belleza Natural con Yanbal<br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.<br>Productos de Belleza de Calidad Superior<br>En Yanbal, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.<br>Fragancias Exclusivas para Cada Ocasión<br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.<br>Ofertas y Promociones Especiales<br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.<br>Consejos de Belleza y Cuidado Personal<br>En nuestro blog, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.<br>Compra tus Productos Yanbal en Línea<br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo en línea, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2023-09-15 14:53:25', '2023-09-15 14:53:25', '', 6, 'https://yanbal.directorioempresascolombia.com/?p=102', 0, 'revision', '', 0),
(106, 1, '2023-09-15 14:57:26', '2023-09-15 14:57:26', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_fc6967-b0","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_dcc959-07","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_dcc959-07"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_5d2894-e6","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_e371eb-bf","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_e371eb-bf"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_e4adf1-8e","align":"left","color":"palette5","margin":["","","",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_e4adf1-8e wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_e4adf1-8e">directorio Empresas Bogotá y Colombia</div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_0e7d7d-1d","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_0e7d7d-1d wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_0e7d7d-1d">Venta <mark class="kt-highlight">Productos Belleza Yanbal </mark>en Bogotá  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p>Todo lo que necesita para su cuidado personal y belleza para mujeres, hombres, niños y bebés. A un click de distancia.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_852d6f-6c"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_852d6f-6c"><!-- wp:kadence/singlebtn {"uniqueID":"6_dbc6e6-98","text":"320 3008533 ","link":"tel://3203008533","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_d5b6c6-6f","text":"\\u003cstrong\\u003eCONTACTARNOS\\u003c/strong\\u003e","link":"/contacto","target":"_blank","sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_4d0e4a-b0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_4d0e4a-b0"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"align":"right","id":61,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_47b10d-06","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<div class="wp-block-kadence-image kb-image6_47b10d-06 is-style-rounded"><figure class="alignright size-full"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-capilar.webp" alt="" class="kb-img wp-image-61"/><figcaption>Cremas capilares Yanbal en Bogotá</figcaption></figure></div>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_df1818-ab","columns":1,"colLayout":"equal","bgColor":"#d8b078","align":"full","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_81be5f-2f","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_81be5f-2f"><div class="kt-inside-inner-col"><!-- wp:heading {"textAlign":"center"} -->\n<h2 class="wp-block-heading has-text-align-center">Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en Bogotá</h2>\n<!-- /wp:heading -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_77a6b0-e3","columns":3,"customRowGutter":[30,"",""],"columnGutter":"wider","customGutter":[64,"",""],"colLayout":"equal","inheritMaxWidth":true,"padding":["xxl","","xxl",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_887cf3-11","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_887cf3-11 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":64,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/productos-damas/","linkDestination":"custom","uniqueID":"6_20ede3-32","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_20ede3-32 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/productos-damas/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/cosmeticos-yanbal.webp" alt="" class="kb-img wp-image-64"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_fea0e4-34","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_fea0e4-34 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_fea0e4-34"><a href="https://yanbal.directorioempresascolombia.com/productos-damas/">Cosméticos para Mujer</a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_c10595-42","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_c10595-42 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_c10595-42">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_1bd929-fb","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_1bd929-fb inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":73,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_69f357-84","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_69f357-84 size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/perfume-jaque.webp" alt="" class="kb-img wp-image-73"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_c19f9d-74","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_c19f9d-74 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_c19f9d-74">Producto para Hombre </h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_9da24d-48","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":["","",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_9da24d-48 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_9da24d-48">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":3,"borderWidth":["","","",""],"uniqueID":"6_3baf88-7a","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_3baf88-7a"><div class="kt-inside-inner-col"><!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_5d35c2-a0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_5d35c2-a0 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":69,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_31853d-d1","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_31853d-d1 size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/lociones-iluminadoras.webp" alt="" class="kb-img wp-image-69"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_78f3eb-a5","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_78f3eb-a5 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_78f3eb-a5">Cuidado de Niños y Bebés</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_200eb7-45","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_200eb7-45 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_200eb7-45">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><br>Descubre la Belleza Natural con Yanbal<br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.<br>Productos de Belleza de Calidad Superior<br>En Yanbal, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.<br>Fragancias Exclusivas para Cada Ocasión<br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.<br>Ofertas y Promociones Especiales<br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.<br>Consejos de Belleza y Cuidado Personal<br>En nuestro blog, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.<br>Compra tus Productos Yanbal en Línea<br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo en línea, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2023-09-15 14:57:26', '2023-09-15 14:57:26', '', 6, 'https://yanbal.directorioempresascolombia.com/?p=106', 0, 'revision', '', 0),
(104, 1, '2023-09-15 14:56:05', '2023-09-15 14:56:05', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_fc6967-b0","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_dcc959-07","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_dcc959-07"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_5d2894-e6","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_e371eb-bf","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_e371eb-bf"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_e4adf1-8e","align":"left","color":"palette5","margin":["","","",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_e4adf1-8e wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_e4adf1-8e">directorio Empresas Bogotá y Colombia</div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_0e7d7d-1d","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_0e7d7d-1d wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_0e7d7d-1d">Venta <mark class="kt-highlight">Productos Belleza Yanbal </mark>en Bogotá  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p>Todo lo que necesita para su cuidado personal y belleza para mujeres, hombres, niños y bebés. A un click de distancia.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_852d6f-6c"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_852d6f-6c"><!-- wp:kadence/singlebtn {"uniqueID":"6_dbc6e6-98","text":"320 3008533 ","link":"tel://3203008533","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_d5b6c6-6f","text":"\\u003cstrong\\u003eCONTACTARNOS\\u003c/strong\\u003e","link":"/contacto","target":"_blank","sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_4d0e4a-b0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_4d0e4a-b0"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"align":"right","id":61,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_47b10d-06","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<div class="wp-block-kadence-image kb-image6_47b10d-06 is-style-rounded"><figure class="alignright size-full"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-capilar.webp" alt="" class="kb-img wp-image-61"/><figcaption>Cremas capilares Yanbal en Bogotá</figcaption></figure></div>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_df1818-ab","columns":1,"colLayout":"equal","bgColor":"#d8b078","align":"full","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_81be5f-2f","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_81be5f-2f"><div class="kt-inside-inner-col"><!-- wp:heading {"textAlign":"center"} -->\n<h2 class="wp-block-heading has-text-align-center">Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en Bogotá</h2>\n<!-- /wp:heading -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_77a6b0-e3","columns":3,"customRowGutter":[30,"",""],"columnGutter":"wider","customGutter":[64,"",""],"colLayout":"equal","inheritMaxWidth":true,"padding":["xxl","","xxl",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_887cf3-11","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_887cf3-11 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":64,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/productos-damas/","linkDestination":"custom","uniqueID":"6_20ede3-32","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_20ede3-32 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/productos-damas/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/cosmeticos-yanbal.webp" alt="" class="kb-img wp-image-64"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_fea0e4-34","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_fea0e4-34 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_fea0e4-34">Cosm<a href="https://yanbal.directorioempresascolombia.com/productos-damas/">Productos Damas</a>é<a href="https://yanbal.directorioempresascolombia.com/productos-damas/">Productos Damas</a>ticos para Mujer</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_c10595-42","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_c10595-42 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_c10595-42">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_1bd929-fb","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_1bd929-fb inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":73,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_69f357-84","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_69f357-84 size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/perfume-jaque.webp" alt="" class="kb-img wp-image-73"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_c19f9d-74","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_c19f9d-74 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_c19f9d-74">Producto para Hombre </h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_9da24d-48","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":["","",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_9da24d-48 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_9da24d-48">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":3,"borderWidth":["","","",""],"uniqueID":"6_3baf88-7a","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_3baf88-7a"><div class="kt-inside-inner-col"><!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_5d35c2-a0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_5d35c2-a0 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":69,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_31853d-d1","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_31853d-d1 size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/lociones-iluminadoras.webp" alt="" class="kb-img wp-image-69"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_78f3eb-a5","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_78f3eb-a5 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_78f3eb-a5">Cuidado de Niños y Bebés</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_200eb7-45","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_200eb7-45 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_200eb7-45">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><br>Descubre la Belleza Natural con Yanbal<br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.<br>Productos de Belleza de Calidad Superior<br>En Yanbal, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.<br>Fragancias Exclusivas para Cada Ocasión<br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.<br>Ofertas y Promociones Especiales<br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.<br>Consejos de Belleza y Cuidado Personal<br>En nuestro blog, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.<br>Compra tus Productos Yanbal en Línea<br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo en línea, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2023-09-15 14:56:05', '2023-09-15 14:56:05', '', 6, 'https://yanbal.directorioempresascolombia.com/?p=104', 0, 'revision', '', 0),
(109, 1, '2023-09-15 15:01:31', '2023-09-15 15:01:31', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_fc6967-b0","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_dcc959-07","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_dcc959-07"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_5d2894-e6","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_e371eb-bf","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_e371eb-bf"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_e4adf1-8e","align":"left","color":"palette5","margin":["","","",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_e4adf1-8e wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_e4adf1-8e">directorio Empresas Bogotá y Colombia</div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_0e7d7d-1d","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_0e7d7d-1d wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_0e7d7d-1d">Venta <mark class="kt-highlight">Productos Belleza Yanbal </mark>en Bogotá  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p>Todo lo que necesita para su cuidado personal y belleza para mujeres, hombres, niños y bebés. A un click de distancia.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_852d6f-6c"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_852d6f-6c"><!-- wp:kadence/singlebtn {"uniqueID":"6_dbc6e6-98","text":"320 3008533 ","link":"tel://3203008533","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_d5b6c6-6f","text":"\\u003cstrong\\u003eCONTACTARNOS\\u003c/strong\\u003e","link":"/contacto","target":"_blank","sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_4d0e4a-b0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_4d0e4a-b0"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"align":"right","id":61,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_47b10d-06","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<div class="wp-block-kadence-image kb-image6_47b10d-06 is-style-rounded"><figure class="alignright size-full"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-capilar.webp" alt="" class="kb-img wp-image-61"/><figcaption>Cremas capilares Yanbal en Bogotá</figcaption></figure></div>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_df1818-ab","columns":1,"colLayout":"equal","bgColor":"#d8b078","align":"full","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_81be5f-2f","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_81be5f-2f"><div class="kt-inside-inner-col"><!-- wp:heading {"textAlign":"center"} -->\n<h2 class="wp-block-heading has-text-align-center">Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en Bogotá</h2>\n<!-- /wp:heading -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_77a6b0-e3","columns":3,"customRowGutter":[30,"",""],"columnGutter":"wider","customGutter":[64,"",""],"colLayout":"equal","inheritMaxWidth":true,"padding":["xxl","","xxl",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_887cf3-11","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_887cf3-11 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":64,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/productos-damas/","linkDestination":"custom","uniqueID":"6_20ede3-32","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_20ede3-32 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/productos-damas/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/cosmeticos-yanbal.webp" alt="" class="kb-img wp-image-64"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_fea0e4-34","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_fea0e4-34 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_fea0e4-34"><a href="https://yanbal.directorioempresascolombia.com/productos-damas/">Cosméticos para Mujer</a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_c10595-42","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_c10595-42 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_c10595-42">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_1bd929-fb","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_1bd929-fb inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":73,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/productos-caballero/","linkDestination":"custom","uniqueID":"6_69f357-84","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_69f357-84 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/productos-caballero/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/perfume-jaque.webp" alt="" class="kb-img wp-image-73"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_c19f9d-74","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_c19f9d-74 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_c19f9d-74"><a href="https://yanbal.directorioempresascolombia.com/productos-caballero/">Productos para Hombre </a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_9da24d-48","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":["","",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_9da24d-48 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_9da24d-48">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":3,"borderWidth":["","","",""],"uniqueID":"6_3baf88-7a","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_3baf88-7a"><div class="kt-inside-inner-col"><!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_5d35c2-a0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_5d35c2-a0 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":69,"sizeSlug":"full","ratio":"land169","useRatio":true,"linkDestination":"none","uniqueID":"6_31853d-d1","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_31853d-d1 size-full kb-image-is-ratio-size"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/lociones-iluminadoras.webp" alt="" class="kb-img wp-image-69"/></div></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_78f3eb-a5","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_78f3eb-a5 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_78f3eb-a5">Cuidado de Niños y Bebés</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_200eb7-45","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_200eb7-45 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_200eb7-45">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><br>Descubre la Belleza Natural con Yanbal<br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.<br>Productos de Belleza de Calidad Superior<br>En Yanbal, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.<br>Fragancias Exclusivas para Cada Ocasión<br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.<br>Ofertas y Promociones Especiales<br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.<br>Consejos de Belleza y Cuidado Personal<br>En nuestro blog, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.<br>Compra tus Productos Yanbal en Línea<br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo en línea, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2023-09-15 15:01:31', '2023-09-15 15:01:31', '', 6, 'https://yanbal.directorioempresascolombia.com/?p=109', 0, 'revision', '', 0);
INSERT INTO `hpp_posts` VALUES
(111, 1, '2023-09-15 15:02:34', '2023-09-15 15:02:34', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_fc6967-b0","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_dcc959-07","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_dcc959-07"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_5d2894-e6","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_e371eb-bf","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_e371eb-bf"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_e4adf1-8e","align":"left","color":"palette5","margin":["","","",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_e4adf1-8e wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_e4adf1-8e">directorio Empresas Bogotá y Colombia</div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_0e7d7d-1d","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_0e7d7d-1d wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_0e7d7d-1d">Venta <mark class="kt-highlight">Productos Belleza Yanbal </mark>en Bogotá  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p>Todo lo que necesita para su cuidado personal y belleza para mujeres, hombres, niños y bebés. A un click de distancia.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_852d6f-6c"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_852d6f-6c"><!-- wp:kadence/singlebtn {"uniqueID":"6_dbc6e6-98","text":"320 3008533 ","link":"tel://3203008533","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_d5b6c6-6f","text":"\\u003cstrong\\u003eCONTACTARNOS\\u003c/strong\\u003e","link":"/contacto","target":"_blank","sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_4d0e4a-b0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_4d0e4a-b0"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"align":"right","id":61,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_47b10d-06","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<div class="wp-block-kadence-image kb-image6_47b10d-06 is-style-rounded"><figure class="alignright size-full"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-capilar.webp" alt="" class="kb-img wp-image-61"/><figcaption>Cremas capilares Yanbal en Bogotá</figcaption></figure></div>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_df1818-ab","columns":1,"colLayout":"equal","bgColor":"#d8b078","align":"full","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_81be5f-2f","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_81be5f-2f"><div class="kt-inside-inner-col"><!-- wp:heading {"textAlign":"center"} -->\n<h2 class="wp-block-heading has-text-align-center">Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en Bogotá</h2>\n<!-- /wp:heading -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_77a6b0-e3","columns":3,"customRowGutter":[30,"",""],"columnGutter":"wider","customGutter":[64,"",""],"colLayout":"equal","inheritMaxWidth":true,"padding":["xxl","","xxl",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_887cf3-11","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_887cf3-11 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":64,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/productos-damas/","linkDestination":"custom","uniqueID":"6_20ede3-32","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_20ede3-32 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/productos-damas/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/cosmeticos-yanbal.webp" alt="" class="kb-img wp-image-64"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_fea0e4-34","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_fea0e4-34 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_fea0e4-34"><a href="https://yanbal.directorioempresascolombia.com/productos-damas/">Cosméticos para Mujer</a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_c10595-42","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_c10595-42 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_c10595-42">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_1bd929-fb","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_1bd929-fb inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":73,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/productos-caballero/","linkDestination":"custom","uniqueID":"6_69f357-84","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_69f357-84 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/productos-caballero/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/perfume-jaque.webp" alt="" class="kb-img wp-image-73"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_c19f9d-74","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_c19f9d-74 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_c19f9d-74"><a href="https://yanbal.directorioempresascolombia.com/productos-caballero/">Productos para Hombre </a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_9da24d-48","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":["","",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_9da24d-48 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_9da24d-48">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":3,"borderWidth":["","","",""],"uniqueID":"6_3baf88-7a","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_3baf88-7a"><div class="kt-inside-inner-col"><!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_5d35c2-a0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_5d35c2-a0 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":69,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/ninos-y-bebes/","linkDestination":"custom","uniqueID":"6_31853d-d1","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_31853d-d1 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/ninos-y-bebes/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/lociones-iluminadoras.webp" alt="" class="kb-img wp-image-69"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_78f3eb-a5","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_78f3eb-a5 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_78f3eb-a5"><a href="https://yanbal.directorioempresascolombia.com/ninos-y-bebes/">Cuidado de Niños y Bebés</a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_200eb7-45","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_200eb7-45 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_200eb7-45">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><br>Descubre la Belleza Natural con Yanbal<br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.<br>Productos de Belleza de Calidad Superior<br>En Yanbal, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.<br>Fragancias Exclusivas para Cada Ocasión<br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.<br>Ofertas y Promociones Especiales<br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.<br>Consejos de Belleza y Cuidado Personal<br>En nuestro blog, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.<br>Compra tus Productos Yanbal en Línea<br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo en línea, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2023-09-15 15:02:34', '2023-09-15 15:02:34', '', 6, 'https://yanbal.directorioempresascolombia.com/?p=111', 0, 'revision', '', 0),
(114, 1, '2023-09-15 15:05:40', '2023-09-15 15:05:40', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_fc6967-b0","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_dcc959-07","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_dcc959-07"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_5d2894-e6","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_e371eb-bf","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_e371eb-bf"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_e4adf1-8e","align":"left","color":"palette5","margin":["","","",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_e4adf1-8e wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_e4adf1-8e"><a href="https://directorioempresascolombia.com/" target="_blank" rel="noreferrer noopener nofollow">directorio Empresas Bogotá y Colombia</a></div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_0e7d7d-1d","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_0e7d7d-1d wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_0e7d7d-1d">Venta <mark class="kt-highlight">Productos Belleza Yanbal </mark>en Bogotá  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p>Todo lo que necesita para su cuidado personal y belleza para mujeres, hombres, niños y bebés. A un click de distancia.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_852d6f-6c"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_852d6f-6c"><!-- wp:kadence/singlebtn {"uniqueID":"6_dbc6e6-98","text":"320 3008533 ","link":"tel://3203008533","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_d5b6c6-6f","text":"\\u003cstrong\\u003eCONTACTARNOS\\u003c/strong\\u003e","link":"/contacto","target":"_blank","sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_4d0e4a-b0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_4d0e4a-b0"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"align":"right","id":61,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_47b10d-06","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<div class="wp-block-kadence-image kb-image6_47b10d-06 is-style-rounded"><figure class="alignright size-full"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-capilar.webp" alt="" class="kb-img wp-image-61"/><figcaption>Cremas capilares Yanbal en Bogotá</figcaption></figure></div>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_df1818-ab","columns":1,"colLayout":"equal","bgColor":"#d8b078","align":"full","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_81be5f-2f","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_81be5f-2f"><div class="kt-inside-inner-col"><!-- wp:heading {"textAlign":"center"} -->\n<h2 class="wp-block-heading has-text-align-center">Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en Bogotá</h2>\n<!-- /wp:heading -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_77a6b0-e3","columns":3,"customRowGutter":[30,"",""],"columnGutter":"wider","customGutter":[64,"",""],"colLayout":"equal","inheritMaxWidth":true,"padding":["xxl","","xxl",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_887cf3-11","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_887cf3-11 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":64,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/productos-damas/","linkDestination":"custom","uniqueID":"6_20ede3-32","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_20ede3-32 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/productos-damas/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/cosmeticos-yanbal.webp" alt="" class="kb-img wp-image-64"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_fea0e4-34","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_fea0e4-34 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_fea0e4-34"><a href="https://yanbal.directorioempresascolombia.com/productos-damas/">Cosméticos para Mujer</a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_c10595-42","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_c10595-42 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_c10595-42">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_1bd929-fb","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_1bd929-fb inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":73,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/productos-caballero/","linkDestination":"custom","uniqueID":"6_69f357-84","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_69f357-84 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/productos-caballero/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/perfume-jaque.webp" alt="" class="kb-img wp-image-73"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_c19f9d-74","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_c19f9d-74 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_c19f9d-74"><a href="https://yanbal.directorioempresascolombia.com/productos-caballero/">Productos para Hombre </a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_9da24d-48","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":["","",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_9da24d-48 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_9da24d-48">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":3,"borderWidth":["","","",""],"uniqueID":"6_3baf88-7a","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_3baf88-7a"><div class="kt-inside-inner-col"><!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_5d35c2-a0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_5d35c2-a0 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":69,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/ninos-y-bebes/","linkDestination":"custom","uniqueID":"6_31853d-d1","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_31853d-d1 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/ninos-y-bebes/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/lociones-iluminadoras.webp" alt="" class="kb-img wp-image-69"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_78f3eb-a5","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_78f3eb-a5 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_78f3eb-a5"><a href="https://yanbal.directorioempresascolombia.com/ninos-y-bebes/">Cuidado de Niños y Bebés</a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_200eb7-45","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_200eb7-45 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_200eb7-45">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><br>Descubre la Belleza Natural con Yanbal<br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.<br>Productos de Belleza de Calidad Superior<br>En Yanbal, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.<br>Fragancias Exclusivas para Cada Ocasión<br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.<br>Ofertas y Promociones Especiales<br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.<br>Consejos de Belleza y Cuidado Personal<br>En nuestro blog, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.<br>Compra tus Productos Yanbal en Línea<br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo en línea, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2023-09-15 15:05:40', '2023-09-15 15:05:40', '', 6, 'https://yanbal.directorioempresascolombia.com/?p=114', 0, 'revision', '', 0),
(113, 1, '2023-09-15 15:04:45', '2023-09-15 15:04:45', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_fc6967-b0","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_dcc959-07","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_dcc959-07"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_5d2894-e6","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_e371eb-bf","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_e371eb-bf"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_e4adf1-8e","align":"left","color":"palette5","margin":["","","",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_e4adf1-8e wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_e4adf1-8e"><a href="https://directorioempresascolombia.com/">directorio Empresas Bogotá y Colombia</a></div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_0e7d7d-1d","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_0e7d7d-1d wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_0e7d7d-1d">Venta <mark class="kt-highlight">Productos Belleza Yanbal </mark>en Bogotá  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p>Todo lo que necesita para su cuidado personal y belleza para mujeres, hombres, niños y bebés. A un click de distancia.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_852d6f-6c"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_852d6f-6c"><!-- wp:kadence/singlebtn {"uniqueID":"6_dbc6e6-98","text":"320 3008533 ","link":"tel://3203008533","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_d5b6c6-6f","text":"\\u003cstrong\\u003eCONTACTARNOS\\u003c/strong\\u003e","link":"/contacto","target":"_blank","sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_4d0e4a-b0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_4d0e4a-b0"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"align":"right","id":61,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_47b10d-06","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<div class="wp-block-kadence-image kb-image6_47b10d-06 is-style-rounded"><figure class="alignright size-full"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-capilar.webp" alt="" class="kb-img wp-image-61"/><figcaption>Cremas capilares Yanbal en Bogotá</figcaption></figure></div>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_df1818-ab","columns":1,"colLayout":"equal","bgColor":"#d8b078","align":"full","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_81be5f-2f","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_81be5f-2f"><div class="kt-inside-inner-col"><!-- wp:heading {"textAlign":"center"} -->\n<h2 class="wp-block-heading has-text-align-center">Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en Bogotá</h2>\n<!-- /wp:heading -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_77a6b0-e3","columns":3,"customRowGutter":[30,"",""],"columnGutter":"wider","customGutter":[64,"",""],"colLayout":"equal","inheritMaxWidth":true,"padding":["xxl","","xxl",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_887cf3-11","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_887cf3-11 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":64,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/productos-damas/","linkDestination":"custom","uniqueID":"6_20ede3-32","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_20ede3-32 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/productos-damas/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/cosmeticos-yanbal.webp" alt="" class="kb-img wp-image-64"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_fea0e4-34","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_fea0e4-34 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_fea0e4-34"><a href="https://yanbal.directorioempresascolombia.com/productos-damas/">Cosméticos para Mujer</a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_c10595-42","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_c10595-42 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_c10595-42">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_1bd929-fb","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_1bd929-fb inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":73,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/productos-caballero/","linkDestination":"custom","uniqueID":"6_69f357-84","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_69f357-84 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/productos-caballero/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/perfume-jaque.webp" alt="" class="kb-img wp-image-73"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_c19f9d-74","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_c19f9d-74 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_c19f9d-74"><a href="https://yanbal.directorioempresascolombia.com/productos-caballero/">Productos para Hombre </a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_9da24d-48","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":["","",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_9da24d-48 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_9da24d-48">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":3,"borderWidth":["","","",""],"uniqueID":"6_3baf88-7a","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_3baf88-7a"><div class="kt-inside-inner-col"><!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_5d35c2-a0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_5d35c2-a0 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":69,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/ninos-y-bebes/","linkDestination":"custom","uniqueID":"6_31853d-d1","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_31853d-d1 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/ninos-y-bebes/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/lociones-iluminadoras.webp" alt="" class="kb-img wp-image-69"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_78f3eb-a5","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_78f3eb-a5 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_78f3eb-a5"><a href="https://yanbal.directorioempresascolombia.com/ninos-y-bebes/">Cuidado de Niños y Bebés</a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_200eb7-45","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_200eb7-45 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_200eb7-45">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><br>Descubre la Belleza Natural con Yanbal<br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.<br>Productos de Belleza de Calidad Superior<br>En Yanbal, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.<br>Fragancias Exclusivas para Cada Ocasión<br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.<br>Ofertas y Promociones Especiales<br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.<br>Consejos de Belleza y Cuidado Personal<br>En nuestro blog, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.<br>Compra tus Productos Yanbal en Línea<br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo en línea, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2023-09-15 15:04:45', '2023-09-15 15:04:45', '', 6, 'https://yanbal.directorioempresascolombia.com/?p=113', 0, 'revision', '', 0);
INSERT INTO `hpp_posts` VALUES
(115, 1, '2023-09-15 15:08:11', '2023-09-15 15:08:11', '', 'Oferta del Mes', '', 'publish', 'closed', 'closed', '', 'oferta-del-mes', '', '', '2023-09-15 15:08:12', '2023-09-15 15:08:12', '', 0, 'https://yanbal.directorioempresascolombia.com/?page_id=115', 0, 'page', '', 0),
(116, 1, '2023-09-15 15:08:11', '2023-09-15 15:08:11', '', 'Oferta del Mes', '', 'inherit', 'closed', 'closed', '', '115-revision-v1', '', '', '2023-09-15 15:08:11', '2023-09-15 15:08:11', '', 115, 'https://yanbal.directorioempresascolombia.com/?p=116', 0, 'revision', '', 0),
(119, 1, '2023-09-15 15:10:31', '2023-09-15 15:10:31', '<!-- wp:kadence/rowlayout {"uniqueID":"119_0da8d4-59","columns":1,"colLayout":"equal","bgColor":"palette8","bgColorClass":"theme-palette8","borderRadius":[33,33,33,33],"padding":[25,"",20,""],"margin":["","",45,""],"borderStyle":[{"top":["palette6","",1],"right":["palette6","",1],"bottom":["palette6","",1],"left":["palette6","",1],"unit":"px"}],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"119_74b8a8-3b","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column119_74b8a8-3b inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"level":1,"uniqueID":"119_d825c6-d0","align":"center","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletMarkBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"mobileMarkBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<h1 class="kt-adv-heading119_d825c6-d0 wp-block-kadence-advancedheading" data-kb-block="kb-adv-heading119_d825c6-d0">Oferta empleo como Consultora Yanbal</h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph {"align":"center"} -->\n<p class="has-text-align-center">Muy fácil convertirse de Consultora de Yanbal en Colombia y convertirse en emprendedora independiente. Favor comunicarse con la Directora y Consultora Wilma Jaimes.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"119_e5df77-1c","kbVersion":2,"className":"inner-column-2"} -->\n<div class="wp-block-kadence-column kadence-column119_e5df77-1c inner-column-2"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedbtn {"uniqueID":"119_8702c9-4b"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns119_8702c9-4b"><!-- wp:kadence/singlebtn {"uniqueID":"119_54c199-10","text":"310 2605493 ","link":"tel://3102605493","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"119_72d917-5b","text":"\\u003cstrong\\u003eWHATSAPP\\u003c/strong\\u003e","link":"https://wa.me/573102605493","target":"_blank","noFollow":true,"sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'Oferta Empleo', '', 'publish', 'closed', 'closed', '', 'oferta-empleo', '', '', '2024-07-15 21:12:42', '2024-07-15 21:12:42', '', 0, 'https://yanbal.directorioempresascolombia.com/?page_id=119', 0, 'page', '', 0),
(120, 1, '2023-09-15 15:10:31', '2023-09-15 15:10:31', '', 'Oferta Empleo', '', 'inherit', 'closed', 'closed', '', '119-revision-v1', '', '', '2023-09-15 15:10:31', '2023-09-15 15:10:31', '', 119, 'https://yanbal.directorioempresascolombia.com/?p=120', 0, 'revision', '', 0),
(121, 1, '2024-07-10 20:06:52', '2023-09-15 15:11:15', ' ', '', '', 'publish', 'closed', 'closed', '', '121', '', '', '2024-07-10 20:06:52', '2024-07-10 20:06:52', '', 0, 'https://yanbal.directorioempresascolombia.com/?p=121', 9, 'nav_menu_item', '', 0),
(122, 1, '2024-07-10 20:06:52', '2023-09-15 15:11:15', ' ', '', '', 'publish', 'closed', 'closed', '', '122', '', '', '2024-07-10 20:06:52', '2024-07-10 20:06:52', '', 0, 'https://yanbal.directorioempresascolombia.com/?p=122', 3, 'nav_menu_item', '', 0),
(123, 1, '2023-09-15 15:26:11', '2023-09-15 15:26:11', '<!-- wp:kadence/rowlayout {"uniqueID":"28_40f8da-63","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"28_3722b7-2b","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column28_3722b7-2b"><div class="kt-inside-inner-col"><!-- wp:file {"id":95,"href":"https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf","displayPreview":true,"previewHeight":1040} -->\n<div class="wp-block-file"><object class="wp-block-file__embed" data="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf" type="application/pdf" style="width:100%;height:1040px" aria-label="Catalogo Yanbal"></object><a id="wp-block-file--media-a53c01e9-207d-4225-8df1-93c8967b6d69" href="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf">Catalogo Yanbal</a><a href="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf" class="wp-block-file__button wp-element-button" download aria-describedby="wp-block-file--media-a53c01e9-207d-4225-8df1-93c8967b6d69">Download</a></div>\n<!-- /wp:file --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'Catalogo Yanbal', '', 'inherit', 'closed', 'closed', '', '28-revision-v1', '', '', '2023-09-15 15:26:11', '2023-09-15 15:26:11', '', 28, 'https://yanbal.directorioempresascolombia.com/?p=123', 0, 'revision', '', 0),
(124, 1, '2023-09-15 15:32:08', '0000-00-00 00:00:00', '<!-- wp:kadence/rowlayout {"uniqueID":"124_f9e1ed-5c","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"124_2cf84e-11","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column124_2cf84e-11"><div class="kt-inside-inner-col"><!-- wp:heading -->\n<h2 class="wp-block-heading">Historia de los cosméticos de Yanbal</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Yanbal es una empresa de origen peruano con una trayectoria destacada en la industria de la belleza y los productos cosméticos. Fundada en 1967 por Fernando Belmont Anderson, Yanbal se ha convertido en una marca reconocida a nivel internacional, con una presencia sólida en América Latina y otros mercados globales.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>La compañía comenzó su actividad empresarial produciendo joyería, pero rápidamente diversificó su portafolio para incluir productos de belleza, fragancias y cosméticos. Su enfoque en la innovación, la calidad y el compromiso con la satisfacción del cliente le permitieron crecer de manera constante a lo largo de los años.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Calidad de los productos Yanbal:</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Yanbal se ha ganado una reputación sólida en cuanto a la calidad de sus productos, especialmente en el área de perfumes y cosméticos. Aquí hay algunas razones que respaldan su excelencia en este aspecto:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li><strong>Investigación y Desarrollo:</strong> Yanbal invierte en investigación y desarrollo para crear fórmulas avanzadas y productos innovadores. Trabaja en colaboración con expertos en belleza y tecnología para garantizar que sus productos estén a la vanguardia de la industria.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Materias primas de alta calidad:</strong> La empresa se abastece de ingredientes de primera calidad, muchos de los cuales son seleccionados cuidadosamente de diversas partes del mundo. Esto asegura que sus productos tengan una base sólida desde el inicio.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Control de calidad riguroso:</strong> Yanbal se somete a estrictos controles de calidad en todas las etapas de producción. Desde la selección de ingredientes hasta el empaque final, cada producto es sometido a pruebas exhaustivas para garantizar su eficacia y seguridad.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Compromiso con la sostenibilidad:</strong> La empresa también se preocupa por la sostenibilidad y el medio ambiente. Ha implementado iniciativas para reducir su huella ambiental y contribuir a un mundo más limpio y saludable.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Feedback de los clientes:</strong> La satisfacción del cliente es una prioridad para Yanbal. Escuchan activamente a sus clientes y toman en cuenta sus comentarios para mejorar continuamente sus productos y servicios.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>En resumen, Yanbal es una empresa con una rica historia en la industria de la belleza y los productos cosméticos. Su compromiso con la calidad y la innovación la ha convertido en una elección confiable para aquellos que buscan perfumes y cosméticos de alta calidad. Su enfoque en la satisfacción del cliente y la sostenibilidad también respalda su posición como una marca líder en el mercado de la belleza.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'Empresa Yanbal', '', 'draft', 'open', 'open', '', '', '', '', '2023-09-15 15:32:08', '2023-09-15 15:32:08', '', 0, 'https://yanbal.directorioempresascolombia.com/?p=124', 0, 'post', '', 0),
(125, 1, '2023-09-15 15:29:59', '2023-09-15 15:29:59', '<!-- wp:kadence/rowlayout {"uniqueID":"124_f9e1ed-5c","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"124_2cf84e-11","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column124_2cf84e-11"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p>Yanbal es una empresa de origen peruano con una trayectoria destacada en la industria de la belleza y los productos cosméticos. Fundada en 1967 por Fernando Belmont Anderson, Yanbal se ha convertido en una marca reconocida a nivel internacional, con una presencia sólida en América Latina y otros mercados globales.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>La compañía comenzó su actividad empresarial produciendo joyería, pero rápidamente diversificó su portafolio para incluir productos de belleza, fragancias y cosméticos. Su enfoque en la innovación, la calidad y el compromiso con la satisfacción del cliente le permitieron crecer de manera constante a lo largo de los años.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Calidad de los productos Yanbal:</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Yanbal se ha ganado una reputación sólida en cuanto a la calidad de sus productos, especialmente en el área de perfumes y cosméticos. Aquí hay algunas razones que respaldan su excelencia en este aspecto:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list {"ordered":true} -->\n<ol><!-- wp:list-item -->\n<li><strong>Investigación y Desarrollo:</strong> Yanbal invierte en investigación y desarrollo para crear fórmulas avanzadas y productos innovadores. Trabaja en colaboración con expertos en belleza y tecnología para garantizar que sus productos estén a la vanguardia de la industria.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Materias primas de alta calidad:</strong> La empresa se abastece de ingredientes de primera calidad, muchos de los cuales son seleccionados cuidadosamente de diversas partes del mundo. Esto asegura que sus productos tengan una base sólida desde el inicio.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Control de calidad riguroso:</strong> Yanbal se somete a estrictos controles de calidad en todas las etapas de producción. Desde la selección de ingredientes hasta el empaque final, cada producto es sometido a pruebas exhaustivas para garantizar su eficacia y seguridad.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Compromiso con la sostenibilidad:</strong> La empresa también se preocupa por la sostenibilidad y el medio ambiente. Ha implementado iniciativas para reducir su huella ambiental y contribuir a un mundo más limpio y saludable.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Feedback de los clientes:</strong> La satisfacción del cliente es una prioridad para Yanbal. Escuchan activamente a sus clientes y toman en cuenta sus comentarios para mejorar continuamente sus productos y servicios.</li>\n<!-- /wp:list-item --></ol>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>En resumen, Yanbal es una empresa con una rica historia en la industria de la belleza y los productos cosméticos. Su compromiso con la calidad y la innovación la ha convertido en una elección confiable para aquellos que buscan perfumes y cosméticos de alta calidad. Su enfoque en la satisfacción del cliente y la sostenibilidad también respalda su posición como una marca líder en el mercado de la belleza.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'Empresa Yanbal', '', 'inherit', 'closed', 'closed', '', '124-revision-v1', '', '', '2023-09-15 15:29:59', '2023-09-15 15:29:59', '', 124, 'https://yanbal.directorioempresascolombia.com/?p=125', 0, 'revision', '', 0),
(126, 1, '2023-09-15 15:31:46', '2023-09-15 15:31:46', '<!-- wp:kadence/rowlayout {"uniqueID":"124_f9e1ed-5c","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"124_2cf84e-11","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column124_2cf84e-11"><div class="kt-inside-inner-col"><!-- wp:heading -->\n<h2 class="wp-block-heading">Historia de los cosméticos de Yanbal</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Yanbal es una empresa de origen peruano con una trayectoria destacada en la industria de la belleza y los productos cosméticos. Fundada en 1967 por Fernando Belmont Anderson, Yanbal se ha convertido en una marca reconocida a nivel internacional, con una presencia sólida en América Latina y otros mercados globales.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>La compañía comenzó su actividad empresarial produciendo joyería, pero rápidamente diversificó su portafolio para incluir productos de belleza, fragancias y cosméticos. Su enfoque en la innovación, la calidad y el compromiso con la satisfacción del cliente le permitieron crecer de manera constante a lo largo de los años.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Calidad de los productos Yanbal:</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Yanbal se ha ganado una reputación sólida en cuanto a la calidad de sus productos, especialmente en el área de perfumes y cosméticos. Aquí hay algunas razones que respaldan su excelencia en este aspecto:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list {"ordered":true} -->\n<ol><!-- wp:list-item -->\n<li><strong>Investigación y Desarrollo:</strong> Yanbal invierte en investigación y desarrollo para crear fórmulas avanzadas y productos innovadores. Trabaja en colaboración con expertos en belleza y tecnología para garantizar que sus productos estén a la vanguardia de la industria.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Materias primas de alta calidad:</strong> La empresa se abastece de ingredientes de primera calidad, muchos de los cuales son seleccionados cuidadosamente de diversas partes del mundo. Esto asegura que sus productos tengan una base sólida desde el inicio.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Control de calidad riguroso:</strong> Yanbal se somete a estrictos controles de calidad en todas las etapas de producción. Desde la selección de ingredientes hasta el empaque final, cada producto es sometido a pruebas exhaustivas para garantizar su eficacia y seguridad.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Compromiso con la sostenibilidad:</strong> La empresa también se preocupa por la sostenibilidad y el medio ambiente. Ha implementado iniciativas para reducir su huella ambiental y contribuir a un mundo más limpio y saludable.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Feedback de los clientes:</strong> La satisfacción del cliente es una prioridad para Yanbal. Escuchan activamente a sus clientes y toman en cuenta sus comentarios para mejorar continuamente sus productos y servicios.</li>\n<!-- /wp:list-item --></ol>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>En resumen, Yanbal es una empresa con una rica historia en la industria de la belleza y los productos cosméticos. Su compromiso con la calidad y la innovación la ha convertido en una elección confiable para aquellos que buscan perfumes y cosméticos de alta calidad. Su enfoque en la satisfacción del cliente y la sostenibilidad también respalda su posición como una marca líder en el mercado de la belleza.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'Empresa Yanbal', '', 'inherit', 'closed', 'closed', '', '124-revision-v1', '', '', '2023-09-15 15:31:46', '2023-09-15 15:31:46', '', 124, 'https://yanbal.directorioempresascolombia.com/?p=126', 0, 'revision', '', 0),
(127, 1, '2023-09-15 15:32:07', '2023-09-15 15:32:07', '<!-- wp:kadence/rowlayout {"uniqueID":"124_f9e1ed-5c","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"124_2cf84e-11","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column124_2cf84e-11"><div class="kt-inside-inner-col"><!-- wp:heading -->\n<h2 class="wp-block-heading">Historia de los cosméticos de Yanbal</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Yanbal es una empresa de origen peruano con una trayectoria destacada en la industria de la belleza y los productos cosméticos. Fundada en 1967 por Fernando Belmont Anderson, Yanbal se ha convertido en una marca reconocida a nivel internacional, con una presencia sólida en América Latina y otros mercados globales.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>La compañía comenzó su actividad empresarial produciendo joyería, pero rápidamente diversificó su portafolio para incluir productos de belleza, fragancias y cosméticos. Su enfoque en la innovación, la calidad y el compromiso con la satisfacción del cliente le permitieron crecer de manera constante a lo largo de los años.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Calidad de los productos Yanbal:</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Yanbal se ha ganado una reputación sólida en cuanto a la calidad de sus productos, especialmente en el área de perfumes y cosméticos. Aquí hay algunas razones que respaldan su excelencia en este aspecto:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li><strong>Investigación y Desarrollo:</strong> Yanbal invierte en investigación y desarrollo para crear fórmulas avanzadas y productos innovadores. Trabaja en colaboración con expertos en belleza y tecnología para garantizar que sus productos estén a la vanguardia de la industria.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Materias primas de alta calidad:</strong> La empresa se abastece de ingredientes de primera calidad, muchos de los cuales son seleccionados cuidadosamente de diversas partes del mundo. Esto asegura que sus productos tengan una base sólida desde el inicio.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Control de calidad riguroso:</strong> Yanbal se somete a estrictos controles de calidad en todas las etapas de producción. Desde la selección de ingredientes hasta el empaque final, cada producto es sometido a pruebas exhaustivas para garantizar su eficacia y seguridad.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Compromiso con la sostenibilidad:</strong> La empresa también se preocupa por la sostenibilidad y el medio ambiente. Ha implementado iniciativas para reducir su huella ambiental y contribuir a un mundo más limpio y saludable.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Feedback de los clientes:</strong> La satisfacción del cliente es una prioridad para Yanbal. Escuchan activamente a sus clientes y toman en cuenta sus comentarios para mejorar continuamente sus productos y servicios.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>En resumen, Yanbal es una empresa con una rica historia en la industria de la belleza y los productos cosméticos. Su compromiso con la calidad y la innovación la ha convertido en una elección confiable para aquellos que buscan perfumes y cosméticos de alta calidad. Su enfoque en la satisfacción del cliente y la sostenibilidad también respalda su posición como una marca líder en el mercado de la belleza.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'Empresa Yanbal', '', 'inherit', 'closed', 'closed', '', '124-revision-v1', '', '', '2023-09-15 15:32:07', '2023-09-15 15:32:07', '', 124, 'https://yanbal.directorioempresascolombia.com/?p=127', 0, 'revision', '', 0),
(147, 1, '2024-07-10 18:52:23', '2024-07-10 18:52:23', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_6f84d4-a9","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_f75b67-fa","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_f75b67-fa"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_54cc80-50","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_693eff-7c","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_693eff-7c"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_ed3399-61","align":"left","color":"palette5","padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_ed3399-61 wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_ed3399-61"><a href="https://directorioempresascolombia.com/" target="_blank" rel="noreferrer noopener nofollow">directorio Empresas Bogotá y Colombia</a></div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_a6cedd-b0","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_a6cedd-b0 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_a6cedd-b0">Venta <mark class="kt-highlight">Productos Belleza Yanbal </mark>en Bogotá  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p>Todo lo que necesita para su cuidado personal y belleza para mujeres, hombres, niños y bebés. A un click de distancia. Estamos en sector Cedritos, localidad Usaquén de Bogotá, Colombia.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_6681d1-86"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_6681d1-86"><!-- wp:kadence/singlebtn {"uniqueID":"6_c950f3-8a","text":"310 2605493 ","link":"tel://3203008533","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_768ad7-bb","text":"\\u003cstrong\\u003eWHTSAPP\\u003c/strong\\u003e","link":"https://wa.me/573102605493","target":"_blank","noFollow":true,"sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_b4fec4-a4","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_b4fec4-a4"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"align":"right","id":61,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_68d5d8-00","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<div class="wp-block-kadence-image kb-image6_68d5d8-00 is-style-rounded"><figure class="alignright size-full"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-capilar.webp" alt="" class="kb-img wp-image-61"/><figcaption>Cremas capilares Yanbal en Bogotá</figcaption></figure></div>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_df1818-ab","columns":1,"colLayout":"equal","bgColor":"#d8b078","align":"full","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_81be5f-2f","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_81be5f-2f"><div class="kt-inside-inner-col"><!-- wp:heading {"textAlign":"center"} -->\n<h2 class="wp-block-heading has-text-align-center">Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en Bogotá</h2>\n<!-- /wp:heading -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_77a6b0-e3","columns":3,"customRowGutter":[30,"",""],"columnGutter":"wider","customGutter":[64,"",""],"colLayout":"equal","inheritMaxWidth":true,"padding":["xxl","","xxl",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_887cf3-11","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_887cf3-11 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":64,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/productos-damas/","linkDestination":"custom","uniqueID":"6_20ede3-32","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_20ede3-32 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/productos-damas/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/cosmeticos-yanbal.webp" alt="" class="kb-img wp-image-64"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_fea0e4-34","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_fea0e4-34 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_fea0e4-34"><a href="https://yanbal.directorioempresascolombia.com/productos-damas/">Cosméticos para Mujer</a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_c10595-42","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_c10595-42 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_c10595-42">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_1bd929-fb","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_1bd929-fb inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":73,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/productos-caballero/","linkDestination":"custom","uniqueID":"6_69f357-84","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_69f357-84 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/productos-caballero/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/perfume-jaque.webp" alt="" class="kb-img wp-image-73"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_c19f9d-74","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_c19f9d-74 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_c19f9d-74"><a href="https://yanbal.directorioempresascolombia.com/productos-caballero/">Productos para Hombre </a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_9da24d-48","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_9da24d-48 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_9da24d-48">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":3,"borderWidth":["","","",""],"uniqueID":"6_3baf88-7a","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_3baf88-7a"><div class="kt-inside-inner-col"><!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_5d35c2-a0","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_5d35c2-a0 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":69,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/ninos-y-bebes/","linkDestination":"custom","uniqueID":"6_31853d-d1","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_31853d-d1 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/ninos-y-bebes/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/lociones-iluminadoras.webp" alt="" class="kb-img wp-image-69"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_78f3eb-a5","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_78f3eb-a5 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_78f3eb-a5"><a href="https://yanbal.directorioempresascolombia.com/ninos-y-bebes/">Cuidado de Niños y Bebés</a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_200eb7-45","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_200eb7-45 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_200eb7-45">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><br>Descubre la Belleza Natural con Yanbal<br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.<br>Productos de Belleza de Calidad Superior<br>En Yanbal, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.<br>Fragancias Exclusivas para Cada Ocasión<br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.<br>Ofertas y Promociones Especiales<br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.<br>Consejos de Belleza y Cuidado Personal<br>En nuestro blog, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.<br>Compra tus Productos Yanbal en Línea<br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo en línea, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2024-07-10 18:52:23', '2024-07-10 18:52:23', '', 6, 'https://yanbal.directorioempresascolombia.com/?p=147', 0, 'revision', '', 0),
(128, 1, '2023-09-15 15:35:03', '2023-09-15 15:35:03', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_fc6967-b0","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_dcc959-07","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_dcc959-07"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_5d2894-e6","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_e371eb-bf","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_e371eb-bf"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_e4adf1-8e","align":"left","color":"palette5","margin":["","","",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_e4adf1-8e wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_e4adf1-8e"><a href="https://directorioempresascolombia.com/" target="_blank" rel="noreferrer noopener nofollow">directorio Empresas Bogotá y Colombia</a></div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_0e7d7d-1d","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_0e7d7d-1d wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_0e7d7d-1d">Venta <mark class="kt-highlight">Productos Belleza Yanbal </mark>en Bogotá  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p>Todo lo que necesita para su cuidado personal y belleza para mujeres, hombres, niños y bebés. A un click de distancia. Estamos en sector Cedritos, localidad Usaquén de Bogotá, Colombia.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_852d6f-6c"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_852d6f-6c"><!-- wp:kadence/singlebtn {"uniqueID":"6_dbc6e6-98","text":"320 3008533 ","link":"tel://3203008533","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_d5b6c6-6f","text":"\\u003cstrong\\u003eCONTACTARNOS\\u003c/strong\\u003e","link":"/contacto","target":"_blank","sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_4d0e4a-b0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_4d0e4a-b0"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"align":"right","id":61,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_47b10d-06","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<div class="wp-block-kadence-image kb-image6_47b10d-06 is-style-rounded"><figure class="alignright size-full"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-capilar.webp" alt="" class="kb-img wp-image-61"/><figcaption>Cremas capilares Yanbal en Bogotá</figcaption></figure></div>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_df1818-ab","columns":1,"colLayout":"equal","bgColor":"#d8b078","align":"full","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_81be5f-2f","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_81be5f-2f"><div class="kt-inside-inner-col"><!-- wp:heading {"textAlign":"center"} -->\n<h2 class="wp-block-heading has-text-align-center">Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en Bogotá</h2>\n<!-- /wp:heading -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_77a6b0-e3","columns":3,"customRowGutter":[30,"",""],"columnGutter":"wider","customGutter":[64,"",""],"colLayout":"equal","inheritMaxWidth":true,"padding":["xxl","","xxl",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_887cf3-11","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_887cf3-11 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":64,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/productos-damas/","linkDestination":"custom","uniqueID":"6_20ede3-32","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_20ede3-32 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/productos-damas/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/cosmeticos-yanbal.webp" alt="" class="kb-img wp-image-64"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_fea0e4-34","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_fea0e4-34 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_fea0e4-34"><a href="https://yanbal.directorioempresascolombia.com/productos-damas/">Cosméticos para Mujer</a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_c10595-42","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_c10595-42 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_c10595-42">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_1bd929-fb","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_1bd929-fb inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":73,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/productos-caballero/","linkDestination":"custom","uniqueID":"6_69f357-84","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_69f357-84 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/productos-caballero/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/perfume-jaque.webp" alt="" class="kb-img wp-image-73"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_c19f9d-74","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_c19f9d-74 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_c19f9d-74"><a href="https://yanbal.directorioempresascolombia.com/productos-caballero/">Productos para Hombre </a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_9da24d-48","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":["","",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_9da24d-48 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_9da24d-48">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":3,"borderWidth":["","","",""],"uniqueID":"6_3baf88-7a","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_3baf88-7a"><div class="kt-inside-inner-col"><!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_5d35c2-a0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_5d35c2-a0 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":69,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/ninos-y-bebes/","linkDestination":"custom","uniqueID":"6_31853d-d1","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_31853d-d1 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/ninos-y-bebes/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/lociones-iluminadoras.webp" alt="" class="kb-img wp-image-69"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_78f3eb-a5","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_78f3eb-a5 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_78f3eb-a5"><a href="https://yanbal.directorioempresascolombia.com/ninos-y-bebes/">Cuidado de Niños y Bebés</a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_200eb7-45","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_200eb7-45 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_200eb7-45">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><br>Descubre la Belleza Natural con Yanbal<br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.<br>Productos de Belleza de Calidad Superior<br>En Yanbal, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.<br>Fragancias Exclusivas para Cada Ocasión<br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.<br>Ofertas y Promociones Especiales<br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.<br>Consejos de Belleza y Cuidado Personal<br>En nuestro blog, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.<br>Compra tus Productos Yanbal en Línea<br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo en línea, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2023-09-15 15:35:03', '2023-09-15 15:35:03', '', 6, 'https://yanbal.directorioempresascolombia.com/?p=128', 0, 'revision', '', 0);
INSERT INTO `hpp_posts` VALUES
(136, 1, '2023-09-15 16:22:43', '2023-09-15 16:22:43', '<!-- wp:kadence/rowlayout {"uniqueID":"16_08b686-b7","colLayout":"left-golden","bgColor":"palette8","firstColumnWidth":75,"secondColumnWidth":25,"bgColorClass":"theme-palette8","borderWidth":["","","",""],"borderRadius":[33,33,33,33],"padding":[25,"",20,""],"margin":["","",45,""],"borderStyle":[{"top":["palette6","",1],"right":["palette6","",1],"bottom":["palette6","",1],"left":["palette6","",1],"unit":"px"}],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"16_2e17d3-5e","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column16_2e17d3-5e inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"16_00699b-bd","align":"center","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletMarkBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"mobileMarkBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<h2 class="kt-adv-heading16_00699b-bd wp-block-kadence-advancedheading" data-kb-block="kb-adv-heading16_00699b-bd">Productos para Niños y Bebés en Bogotá</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph {"align":"center"} -->\n<p class="has-text-align-center">Productos Yanbal preparados especialmente para pieles delicadas</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"16_5d4a07-40","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-2"} -->\n<div class="wp-block-kadence-column kadence-column16_5d4a07-40 inner-column-2"><div class="kt-inside-inner-col"><!-- wp:buttons -->\n<div class="wp-block-buttons"><!-- wp:button {"width":100,"style":{"border":{"radius":"17px"}},"fontSize":"medium"} -->\n<div class="wp-block-button has-custom-width wp-block-button__width-100 has-custom-font-size has-medium-font-size"><a class="wp-block-button__link wp-element-button" href="tel://3203008533" style="border-radius:17px" target="_blank" rel="noreferrer noopener">Herman Pinto<br>320 3008533</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"16_ecb173-ef","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"16_d31177-5c","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column16_d31177-5c"><div class="kt-inside-inner-col"><!-- wp:heading -->\n<h2 class="wp-block-heading">Productos para el cuidado de niños y bebés</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Yanbal, conocida por sus productos de belleza y cuidado personal para adultos, también ofrece una línea especializada de productos diseñados para el cuidado y la higiene de niños y bebés. Hay que recordar que la empresa Yanbal cuenta con un departamento técnico de científicos conocedores de la delicadeza de los niños y bebés y, por lo tanto, los productos preparados ofrecen completa garantía y seguridad para los padres de familia que solo desean para sus hijos productos de primera calidad.<br>Estos productos están formulados con ingredientes suaves y seguros para la piel sensible de los más pequeños. A continuación, se enumeran algunos de los productos que Yanbal ofrece para niños y bebés:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li><strong>Shampoo y Acondicionador Infantil:</strong> <br>Yanbal produce shampoos y acondicionadores específicamente diseñados para el cabello de los niños. Estos productos están formulados para ser suaves con el cuero cabelludo delicado y no causar irritación.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Jabón Líquido y Gel de Baño para Bebés:</strong> <br>Yanbal ofrece jabones líquidos y geles de baño especialmente diseñados para bebés. Estos productos están enriquecidos con ingredientes que hidratan y cuidan la piel de los bebés mientras los limpian suavemente.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Crema Hidratante para Bebés:</strong> <br>La crema hidratante para bebés de Yanbal está diseñada para proporcionar una hidratación efectiva a la piel sensible de los bebés, ayudando a prevenir la resequedad y la irritación.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Colonia Infantil:</strong> <br>Yanbal también produce colonias con fragancias suaves y agradables diseñadas específicamente para los más pequeños. Estas colonias no contienen ingredientes irritantes y son ideales para después del baño.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Pañales Desechables:</strong> <br>La línea de productos para bebés de Yanbal también incluye pañales desechables de alta calidad que ofrecen comodidad y protección para los bebés. Estos pañales están diseñados para ajustarse de manera segura y mantener a los bebés secos.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Toallitas Húmedas para Bebés:</strong><br> Yanbal fabrica toallitas húmedas suaves y resistentes que son ideales para la limpieza rápida y efectiva de bebés y niños. Están diseñadas para ser suaves con la piel y no causar irritación.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Productos de Protección Solar:</strong><br> Para proteger la piel de los niños de los daños causados por el sol, Yanbal ofrece protectores solares diseñados específicamente para ellos. Estos productos proporcionan una protección eficaz contra los rayos UVA y UVB.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Línea de Cuidado Oral Infantil:</strong><br> Yanbal también ofrece productos de cuidado oral, como cepillos de dientes y pastas dentales, diseñados especialmente para niños. Estos productos ayudan a inculcar buenos hábitos de higiene oral desde una edad temprana.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>Los productos Yanbal para niños y bebés están formulados con la seguridad y el bienestar de los más pequeños en mente. Además, la marca se compromete a garantizar la calidad y la efectividad de sus productos, lo que la convierte en una opción confiable para los padres que buscan productos de cuidado infantil de alta calidad.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'Niños y Bebes', '', 'inherit', 'closed', 'closed', '', '16-revision-v1', '', '', '2023-09-15 16:22:43', '2023-09-15 16:22:43', '', 16, 'https://yanbal.directorioempresascolombia.com/?p=136', 0, 'revision', '', 0),
(130, 1, '2023-09-15 16:17:38', '2023-09-15 16:17:38', '<!-- wp:kadence/rowlayout {"uniqueID":"16_ecb173-ef","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"16_d31177-5c","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column16_d31177-5c"><div class="kt-inside-inner-col"><!-- wp:heading -->\n<h2 class="wp-block-heading">Productos para el cuidado de niños y bebés</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Yanbal, conocida por sus productos de belleza y cuidado personal para adultos, también ofrece una línea especializada de productos diseñados para el cuidado y la higiene de niños y bebés. Hay que recordar que la empresa Yanbal cuenta con un departamento técnico de científicos conocedores de la delicadeza de los niños y bebés y, por lo tanto, los productos preparados ofrecen completa garantía y seguridad para los padres de familia que solo desean para sus hijos productos de primera calidad.<br>Estos productos están formulados con ingredientes suaves y seguros para la piel sensible de los más pequeños. A continuación, se enumeran algunos de los productos que Yanbal ofrece para niños y bebés:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li><strong>Shampoo y Acondicionador Infantil:</strong> <br>Yanbal produce shampoos y acondicionadores específicamente diseñados para el cabello de los niños. Estos productos están formulados para ser suaves con el cuero cabelludo delicado y no causar irritación.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Jabón Líquido y Gel de Baño para Bebés:</strong> <br>Yanbal ofrece jabones líquidos y geles de baño especialmente diseñados para bebés. Estos productos están enriquecidos con ingredientes que hidratan y cuidan la piel de los bebés mientras los limpian suavemente.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Crema Hidratante para Bebés:</strong> <br>La crema hidratante para bebés de Yanbal está diseñada para proporcionar una hidratación efectiva a la piel sensible de los bebés, ayudando a prevenir la resequedad y la irritación.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Colonia Infantil:</strong> <br>Yanbal también produce colonias con fragancias suaves y agradables diseñadas específicamente para los más pequeños. Estas colonias no contienen ingredientes irritantes y son ideales para después del baño.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Pañales Desechables:</strong> <br>La línea de productos para bebés de Yanbal también incluye pañales desechables de alta calidad que ofrecen comodidad y protección para los bebés. Estos pañales están diseñados para ajustarse de manera segura y mantener a los bebés secos.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Toallitas Húmedas para Bebés:</strong><br> Yanbal fabrica toallitas húmedas suaves y resistentes que son ideales para la limpieza rápida y efectiva de bebés y niños. Están diseñadas para ser suaves con la piel y no causar irritación.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Productos de Protección Solar:</strong><br> Para proteger la piel de los niños de los daños causados por el sol, Yanbal ofrece protectores solares diseñados específicamente para ellos. Estos productos proporcionan una protección eficaz contra los rayos UVA y UVB.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Línea de Cuidado Oral Infantil:</strong><br> Yanbal también ofrece productos de cuidado oral, como cepillos de dientes y pastas dentales, diseñados especialmente para niños. Estos productos ayudan a inculcar buenos hábitos de higiene oral desde una edad temprana.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>Los productos Yanbal para niños y bebés están formulados con la seguridad y el bienestar de los más pequeños en mente. Además, la marca se compromete a garantizar la calidad y la efectividad de sus productos, lo que la convierte en una opción confiable para los padres que buscan productos de cuidado infantil de alta calidad.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'Niños y Bebes', '', 'inherit', 'closed', 'closed', '', '16-revision-v1', '', '', '2023-09-15 16:17:38', '2023-09-15 16:17:38', '', 16, 'https://yanbal.directorioempresascolombia.com/?p=130', 0, 'revision', '', 0),
(135, 1, '2023-09-15 16:22:33', '2023-09-15 16:22:33', '<!-- wp:kadence/rowlayout {"uniqueID":"16_63ee92-4d","colLayout":"left-golden","bgColor":"palette8","firstColumnWidth":75,"secondColumnWidth":25,"bgColorClass":"theme-palette8","borderWidth":["","","",""],"borderRadius":[33,33,33,33],"padding":[25,"",20,""],"margin":["","",45,""],"borderStyle":[{"top":["palette6","",1],"right":["palette6","",1],"bottom":["palette6","",1],"left":["palette6","",1],"unit":"px"}],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"16_d3d07a-e8","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column16_d3d07a-e8 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"16_b4b5b4-ed","align":"center","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletMarkBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"mobileMarkBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<h2 class="kt-adv-heading16_b4b5b4-ed wp-block-kadence-advancedheading" data-kb-block="kb-adv-heading16_b4b5b4-ed">Productos para Niños y Bebés en Bogotá</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph {"align":"center"} -->\n<p class="has-text-align-center">Productos Yanbal preparados especialmente para pieles delicadas</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"16_9b3220-35","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-2"} -->\n<div class="wp-block-kadence-column kadence-column16_9b3220-35 inner-column-2"><div class="kt-inside-inner-col"><!-- wp:buttons -->\n<div class="wp-block-buttons"><!-- wp:button {"width":100,"style":{"border":{"radius":"17px"}},"fontSize":"medium"} -->\n<div class="wp-block-button has-custom-width wp-block-button__width-100 has-custom-font-size has-medium-font-size"><a class="wp-block-button__link wp-element-button" href="tel://3203008533" style="border-radius:17px" target="_blank" rel="noreferrer noopener">Herman Pinto<br>320 3008533</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'H1  con tel y borde', '', 'publish', 'closed', 'closed', '', 'h1-con-tel-y-borde', '', '', '2023-09-15 16:22:33', '2023-09-15 16:22:33', '', 0, 'https://yanbal.directorioempresascolombia.com/h1-con-tel-y-borde/', 0, 'wp_block', '', 0),
(132, 1, '2023-09-15 16:21:10', '2023-09-15 16:21:10', '<!-- wp:kadence/rowlayout {"uniqueID":"16_63ee92-4d","colLayout":"left-golden","bgColor":"palette8","firstColumnWidth":75,"secondColumnWidth":25,"bgColorClass":"theme-palette8","borderWidth":["","","",""],"borderRadius":[33,33,33,33],"padding":[25,"",20,""],"margin":["","",45,""],"borderStyle":[{"top":["palette6","",1],"right":["palette6","",1],"bottom":["palette6","",1],"left":["palette6","",1],"unit":"px"}],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"16_d3d07a-e8","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column16_d3d07a-e8 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"16_b4b5b4-ed","align":"center","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletMarkBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"mobileMarkBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<h2 class="kt-adv-heading16_b4b5b4-ed wp-block-kadence-advancedheading" data-kb-block="kb-adv-heading16_b4b5b4-ed">Productos para Niños y Bebés en Bogotá</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph {"align":"center"} -->\n<p class="has-text-align-center">Productos Yanbal preparados especialmente para pieles delicadas</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"16_9b3220-35","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-2"} -->\n<div class="wp-block-kadence-column kadence-column16_9b3220-35 inner-column-2"><div class="kt-inside-inner-col"><!-- wp:buttons -->\n<div class="wp-block-buttons"><!-- wp:button {"width":100,"style":{"border":{"radius":"17px"}},"fontSize":"medium"} -->\n<div class="wp-block-button has-custom-width wp-block-button__width-100 has-custom-font-size has-medium-font-size"><a class="wp-block-button__link wp-element-button" href="tel://3203008533" style="border-radius:17px" target="_blank" rel="noreferrer noopener">Herman Pinto<br>320 3008533</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"16_ecb173-ef","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"16_d31177-5c","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column16_d31177-5c"><div class="kt-inside-inner-col"><!-- wp:heading -->\n<h2 class="wp-block-heading">Productos para el cuidado de niños y bebés</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Yanbal, conocida por sus productos de belleza y cuidado personal para adultos, también ofrece una línea especializada de productos diseñados para el cuidado y la higiene de niños y bebés. Hay que recordar que la empresa Yanbal cuenta con un departamento técnico de científicos conocedores de la delicadeza de los niños y bebés y, por lo tanto, los productos preparados ofrecen completa garantía y seguridad para los padres de familia que solo desean para sus hijos productos de primera calidad.<br>Estos productos están formulados con ingredientes suaves y seguros para la piel sensible de los más pequeños. A continuación, se enumeran algunos de los productos que Yanbal ofrece para niños y bebés:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li><strong>Shampoo y Acondicionador Infantil:</strong> <br>Yanbal produce shampoos y acondicionadores específicamente diseñados para el cabello de los niños. Estos productos están formulados para ser suaves con el cuero cabelludo delicado y no causar irritación.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Jabón Líquido y Gel de Baño para Bebés:</strong> <br>Yanbal ofrece jabones líquidos y geles de baño especialmente diseñados para bebés. Estos productos están enriquecidos con ingredientes que hidratan y cuidan la piel de los bebés mientras los limpian suavemente.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Crema Hidratante para Bebés:</strong> <br>La crema hidratante para bebés de Yanbal está diseñada para proporcionar una hidratación efectiva a la piel sensible de los bebés, ayudando a prevenir la resequedad y la irritación.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Colonia Infantil:</strong> <br>Yanbal también produce colonias con fragancias suaves y agradables diseñadas específicamente para los más pequeños. Estas colonias no contienen ingredientes irritantes y son ideales para después del baño.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Pañales Desechables:</strong> <br>La línea de productos para bebés de Yanbal también incluye pañales desechables de alta calidad que ofrecen comodidad y protección para los bebés. Estos pañales están diseñados para ajustarse de manera segura y mantener a los bebés secos.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Toallitas Húmedas para Bebés:</strong><br> Yanbal fabrica toallitas húmedas suaves y resistentes que son ideales para la limpieza rápida y efectiva de bebés y niños. Están diseñadas para ser suaves con la piel y no causar irritación.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Productos de Protección Solar:</strong><br> Para proteger la piel de los niños de los daños causados por el sol, Yanbal ofrece protectores solares diseñados específicamente para ellos. Estos productos proporcionan una protección eficaz contra los rayos UVA y UVB.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Línea de Cuidado Oral Infantil:</strong><br> Yanbal también ofrece productos de cuidado oral, como cepillos de dientes y pastas dentales, diseñados especialmente para niños. Estos productos ayudan a inculcar buenos hábitos de higiene oral desde una edad temprana.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>Los productos Yanbal para niños y bebés están formulados con la seguridad y el bienestar de los más pequeños en mente. Además, la marca se compromete a garantizar la calidad y la efectividad de sus productos, lo que la convierte en una opción confiable para los padres que buscan productos de cuidado infantil de alta calidad.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'Niños y Bebes', '', 'inherit', 'closed', 'closed', '', '16-revision-v1', '', '', '2023-09-15 16:21:10', '2023-09-15 16:21:10', '', 16, 'https://yanbal.directorioempresascolombia.com/?p=132', 0, 'revision', '', 0),
(137, 1, '2023-09-15 16:24:09', '2023-09-15 16:24:09', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_fc6967-b0","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_dcc959-07","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_dcc959-07"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_5d2894-e6","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_e371eb-bf","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_e371eb-bf"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_e4adf1-8e","align":"left","color":"palette5","margin":["","","",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_e4adf1-8e wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_e4adf1-8e"><a href="https://directorioempresascolombia.com/" target="_blank" rel="noreferrer noopener nofollow">directorio Empresas Bogotá y Colombia</a></div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_0e7d7d-1d","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_0e7d7d-1d wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_0e7d7d-1d">Venta <mark class="kt-highlight">Productos Belleza Yanbal </mark>en Bogotá  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p>Todo lo que necesita para su cuidado personal y belleza para mujeres, hombres, niños y bebés. A un click de distancia. Estamos en sector Cedritos, localidad Usaquén de Bogotá, Colombia.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_852d6f-6c"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_852d6f-6c"><!-- wp:kadence/singlebtn {"uniqueID":"6_dbc6e6-98","text":"320 3008533 ","link":"tel://3203008533","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_d5b6c6-6f","text":"\\u003cstrong\\u003eCONTACTARNOS\\u003c/strong\\u003e","link":"/contacto","target":"_blank","sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_4d0e4a-b0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_4d0e4a-b0"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"align":"right","id":61,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_47b10d-06","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<div class="wp-block-kadence-image kb-image6_47b10d-06 is-style-rounded"><figure class="alignright size-full"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-capilar.webp" alt="" class="kb-img wp-image-61"/><figcaption>Cremas capilares Yanbal en Bogotá</figcaption></figure></div>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->', 'H1 grupo con foto', '', 'publish', 'closed', 'closed', '', 'h1-grupo-con-foto', '', '', '2023-09-15 16:24:09', '2023-09-15 16:24:09', '', 0, 'https://yanbal.directorioempresascolombia.com/h1-grupo-con-foto/', 0, 'wp_block', '', 0),
(138, 1, '2023-09-15 16:24:24', '2023-09-15 16:24:24', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_6f84d4-a9","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_f75b67-fa","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_f75b67-fa"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_54cc80-50","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_693eff-7c","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_693eff-7c"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_ed3399-61","align":"left","color":"palette5","margin":["","","",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_ed3399-61 wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_ed3399-61"><a href="https://directorioempresascolombia.com/" target="_blank" rel="noreferrer noopener nofollow">directorio Empresas Bogotá y Colombia</a></div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_a6cedd-b0","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_a6cedd-b0 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_a6cedd-b0">Venta <mark class="kt-highlight">Productos Belleza Yanbal </mark>en Bogotá  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p>Todo lo que necesita para su cuidado personal y belleza para mujeres, hombres, niños y bebés. A un click de distancia. Estamos en sector Cedritos, localidad Usaquén de Bogotá, Colombia.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_6681d1-86"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_6681d1-86"><!-- wp:kadence/singlebtn {"uniqueID":"6_c950f3-8a","text":"320 3008533 ","link":"tel://3203008533","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_768ad7-bb","text":"\\u003cstrong\\u003eCONTACTARNOS\\u003c/strong\\u003e","link":"/contacto","target":"_blank","sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_b4fec4-a4","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_b4fec4-a4"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"align":"right","id":61,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_68d5d8-00","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<div class="wp-block-kadence-image kb-image6_68d5d8-00 is-style-rounded"><figure class="alignright size-full"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-capilar.webp" alt="" class="kb-img wp-image-61"/><figcaption>Cremas capilares Yanbal en Bogotá</figcaption></figure></div>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_df1818-ab","columns":1,"colLayout":"equal","bgColor":"#d8b078","align":"full","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_81be5f-2f","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_81be5f-2f"><div class="kt-inside-inner-col"><!-- wp:heading {"textAlign":"center"} -->\n<h2 class="wp-block-heading has-text-align-center">Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en Bogotá</h2>\n<!-- /wp:heading -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_77a6b0-e3","columns":3,"customRowGutter":[30,"",""],"columnGutter":"wider","customGutter":[64,"",""],"colLayout":"equal","inheritMaxWidth":true,"padding":["xxl","","xxl",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_887cf3-11","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_887cf3-11 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":64,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/productos-damas/","linkDestination":"custom","uniqueID":"6_20ede3-32","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_20ede3-32 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/productos-damas/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/cosmeticos-yanbal.webp" alt="" class="kb-img wp-image-64"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_fea0e4-34","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_fea0e4-34 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_fea0e4-34"><a href="https://yanbal.directorioempresascolombia.com/productos-damas/">Cosméticos para Mujer</a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_c10595-42","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_c10595-42 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_c10595-42">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_1bd929-fb","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_1bd929-fb inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":73,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/productos-caballero/","linkDestination":"custom","uniqueID":"6_69f357-84","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_69f357-84 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/productos-caballero/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/perfume-jaque.webp" alt="" class="kb-img wp-image-73"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_c19f9d-74","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_c19f9d-74 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_c19f9d-74"><a href="https://yanbal.directorioempresascolombia.com/productos-caballero/">Productos para Hombre </a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_9da24d-48","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":["","",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_9da24d-48 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_9da24d-48">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":3,"borderWidth":["","","",""],"uniqueID":"6_3baf88-7a","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_3baf88-7a"><div class="kt-inside-inner-col"><!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_5d35c2-a0","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_5d35c2-a0 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":69,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/ninos-y-bebes/","linkDestination":"custom","uniqueID":"6_31853d-d1","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}],"mobileBorderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_31853d-d1 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/ninos-y-bebes/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/lociones-iluminadoras.webp" alt="" class="kb-img wp-image-69"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_78f3eb-a5","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_78f3eb-a5 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_78f3eb-a5"><a href="https://yanbal.directorioempresascolombia.com/ninos-y-bebes/">Cuidado de Niños y Bebés</a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_200eb7-45","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeight":["","",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_200eb7-45 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_200eb7-45">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","borderStyle":[{"top":["","",""],"right":["","",""],"bottom":["","",""],"left":["","",""],"unit":"px"}]} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><br>Descubre la Belleza Natural con Yanbal<br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.<br>Productos de Belleza de Calidad Superior<br>En Yanbal, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.<br>Fragancias Exclusivas para Cada Ocasión<br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.<br>Ofertas y Promociones Especiales<br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.<br>Consejos de Belleza y Cuidado Personal<br>En nuestro blog, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.<br>Compra tus Productos Yanbal en Línea<br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo en línea, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2023-09-15 16:24:24', '2023-09-15 16:24:24', '', 6, 'https://yanbal.directorioempresascolombia.com/?p=138', 0, 'revision', '', 0),
(149, 1, '2024-07-10 18:54:52', '2024-07-10 18:54:52', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_6f84d4-a9","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_f75b67-fa","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_f75b67-fa"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_54cc80-50","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_693eff-7c","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_693eff-7c"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_ed3399-61","align":"left","color":"palette5","padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_ed3399-61 wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_ed3399-61"><a href="https://directorioempresascolombia.com/" target="_blank" rel="noreferrer noopener nofollow">directorio Empresas Bogotá y Colombia</a></div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_a6cedd-b0","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_a6cedd-b0 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_a6cedd-b0">Venta <mark class="kt-highlight">Productos Belleza Yanbal </mark>en Bogotá  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p>Todo lo que necesita para su cuidado personal y belleza para mujeres, hombres, niños y bebés. A un click de distancia. Estamos en sector Cedritos, localidad Usaquén de Bogotá, Colombia.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_6681d1-86"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_6681d1-86"><!-- wp:kadence/singlebtn {"uniqueID":"6_c950f3-8a","text":"310 2605493 ","link":"tel://3102605493","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_768ad7-bb","text":"\\u003cstrong\\u003eWHTSAPP\\u003c/strong\\u003e","link":"https://wa.me/573102605493","target":"_blank","noFollow":true,"sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_b4fec4-a4","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_b4fec4-a4"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"align":"right","id":61,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_68d5d8-00","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<div class="wp-block-kadence-image kb-image6_68d5d8-00 is-style-rounded"><figure class="alignright size-full"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-capilar.webp" alt="" class="kb-img wp-image-61"/><figcaption>Cremas capilares Yanbal en Bogotá</figcaption></figure></div>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_df1818-ab","columns":1,"colLayout":"equal","bgColor":"#d8b078","align":"full","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_81be5f-2f","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_81be5f-2f"><div class="kt-inside-inner-col"><!-- wp:heading {"textAlign":"center"} -->\n<h2 class="wp-block-heading has-text-align-center">Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en BUCARAMANGA</h2>\n<!-- /wp:heading -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_77a6b0-e3","columns":3,"customRowGutter":[30,"",""],"columnGutter":"wider","customGutter":[64,"",""],"colLayout":"equal","inheritMaxWidth":true,"padding":["xxl","","xxl",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_887cf3-11","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_887cf3-11 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":64,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/productos-damas/","linkDestination":"custom","uniqueID":"6_20ede3-32","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_20ede3-32 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/productos-damas/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/cosmeticos-yanbal.webp" alt="" class="kb-img wp-image-64"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_fea0e4-34","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_fea0e4-34 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_fea0e4-34"><a href="https://yanbal.directorioempresascolombia.com/productos-damas/">Cosméticos para Mujer</a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_c10595-42","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_c10595-42 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_c10595-42">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_1bd929-fb","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_1bd929-fb inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":73,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/productos-caballero/","linkDestination":"custom","uniqueID":"6_69f357-84","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_69f357-84 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/productos-caballero/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/perfume-jaque.webp" alt="" class="kb-img wp-image-73"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_c19f9d-74","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_c19f9d-74 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_c19f9d-74"><a href="https://yanbal.directorioempresascolombia.com/productos-caballero/">Productos para Hombre </a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_9da24d-48","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_9da24d-48 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_9da24d-48">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":3,"borderWidth":["","","",""],"uniqueID":"6_3baf88-7a","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_3baf88-7a"><div class="kt-inside-inner-col"><!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_5d35c2-a0","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_5d35c2-a0 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":69,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/ninos-y-bebes/","linkDestination":"custom","uniqueID":"6_31853d-d1","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_31853d-d1 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/ninos-y-bebes/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/lociones-iluminadoras.webp" alt="" class="kb-img wp-image-69"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_78f3eb-a5","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_78f3eb-a5 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_78f3eb-a5"><a href="https://yanbal.directorioempresascolombia.com/ninos-y-bebes/">Cuidado de Niños y Bebés</a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_200eb7-45","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_200eb7-45 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_200eb7-45">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><br>Descubre la Belleza Natural con Yanbal<br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.<br>Productos de Belleza de Calidad Superior<br>En Yanbal, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.<br>Fragancias Exclusivas para Cada Ocasión<br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.<br>Ofertas y Promociones Especiales<br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.<br>Consejos de Belleza y Cuidado Personal<br>En nuestro blog, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.<br>Compra tus Productos Yanbal en Línea<br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo en línea, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2024-07-10 18:54:52', '2024-07-10 18:54:52', '', 6, 'https://yanbal.directorioempresascolombia.com/?p=149', 0, 'revision', '', 0);
INSERT INTO `hpp_posts` VALUES
(156, 1, '2024-07-10 19:05:56', '2024-07-10 19:05:56', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_6f84d4-a9","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_f75b67-fa","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_f75b67-fa"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_54cc80-50","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_693eff-7c","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_693eff-7c"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_ed3399-61","align":"left","color":"palette5","padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_ed3399-61 wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_ed3399-61"><a href="https://directorioempresascolombia.com/" target="_blank" rel="noreferrer noopener nofollow">directorio Empresas Bogotá y Colombia</a></div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_a6cedd-b0","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_a6cedd-b0 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_a6cedd-b0">Venta <mark class="kt-highlight">Productos Belleza Yanbal </mark>en Bogotá  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p>Wilma Jaimes, Directora de Yanbal, la asesora sobre todo lo que necesita para su cuidado personal y belleza para mujeres, hombres, niños y bebés. A un click de distancia. Estamos en sector Cedritos, localidad Usaquén de Bogotá, Colombia.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_6681d1-86"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_6681d1-86"><!-- wp:kadence/singlebtn {"uniqueID":"6_c950f3-8a","text":"310 2605493 ","link":"tel://3102605493","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_768ad7-bb","text":"\\u003cstrong\\u003eWHTSAPP\\u003c/strong\\u003e","link":"https://wa.me/573102605493","target":"_blank","noFollow":true,"sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_b4fec4-a4","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_b4fec4-a4"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"align":"right","id":61,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_68d5d8-00","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<div class="wp-block-kadence-image kb-image6_68d5d8-00 is-style-rounded"><figure class="alignright size-full"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-capilar.webp" alt="" class="kb-img wp-image-61"/><figcaption>Cremas capilares Yanbal en Bogotá</figcaption></figure></div>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_df1818-ab","columns":1,"colLayout":"equal","bgColor":"#d8b078","align":"full","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_81be5f-2f","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_81be5f-2f"><div class="kt-inside-inner-col"><!-- wp:heading {"textAlign":"center"} -->\n<h2 class="wp-block-heading has-text-align-center">Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en BUCARAMANGA</h2>\n<!-- /wp:heading -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_77a6b0-e3","columns":3,"customRowGutter":[30,"",""],"columnGutter":"wider","customGutter":[64,"",""],"colLayout":"equal","inheritMaxWidth":true,"padding":["xxl","","xxl",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_887cf3-11","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_887cf3-11 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":64,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/productos-damas/","linkDestination":"custom","uniqueID":"6_20ede3-32","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_20ede3-32 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/productos-damas/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/cosmeticos-yanbal.webp" alt="" class="kb-img wp-image-64"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_fea0e4-34","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_fea0e4-34 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_fea0e4-34"><a href="https://yanbal.directorioempresascolombia.com/productos-damas/">Cosméticos para Mujer</a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_c10595-42","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_c10595-42 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_c10595-42">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_1bd929-fb","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_1bd929-fb inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":73,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/productos-caballero/","linkDestination":"custom","uniqueID":"6_69f357-84","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_69f357-84 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/productos-caballero/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/perfume-jaque.webp" alt="" class="kb-img wp-image-73"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_c19f9d-74","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_c19f9d-74 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_c19f9d-74"><a href="https://yanbal.directorioempresascolombia.com/productos-caballero/">Productos para Hombre </a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_9da24d-48","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_9da24d-48 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_9da24d-48">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":3,"borderWidth":["","","",""],"uniqueID":"6_3baf88-7a","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_3baf88-7a"><div class="kt-inside-inner-col"><!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_5d35c2-a0","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_5d35c2-a0 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":69,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/ninos-y-bebes/","linkDestination":"custom","uniqueID":"6_31853d-d1","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_31853d-d1 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/ninos-y-bebes/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/lociones-iluminadoras.webp" alt="" class="kb-img wp-image-69"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_78f3eb-a5","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_78f3eb-a5 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_78f3eb-a5"><a href="https://yanbal.directorioempresascolombia.com/ninos-y-bebes/">Cuidado de Niños y Bebés</a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_200eb7-45","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_200eb7-45 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_200eb7-45">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading"><br>Descubre la Belleza Natural con los productos Yanbal en Bucaramanga</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. <br>Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading"><br>La calidad en productos de belleza no se improvisa</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>En Yanbal Bucaramanga, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading"><br>Fragancias Yanbal Exclusivas para Cada Ocasión</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading"><br>No se Pierda las Ofertas y Promociones Especiales todos los Meses</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading"><br>Consejos o Tips de Belleza y Cuidado Personal</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>En nuestro <strong><a href="https://www.yanbal.com/co//corporate/" target="_blank" rel="noreferrer noopener">blog Yambal</a></strong>, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading"><br>Compra tus Productos Yanbal en Bucaramanga y Colombia en el <a href="tl://3102605493">310 2605493</a></h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2024-07-10 19:05:56', '2024-07-10 19:05:56', '', 6, 'https://yanbal.directorioempresascolombia.com/?p=156', 0, 'revision', '', 0),
(151, 1, '2024-07-10 18:59:30', '2024-07-10 18:59:30', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_6f84d4-a9","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_f75b67-fa","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_f75b67-fa"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_54cc80-50","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_693eff-7c","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_693eff-7c"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_ed3399-61","align":"left","color":"palette5","padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_ed3399-61 wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_ed3399-61"><a href="https://directorioempresascolombia.com/" target="_blank" rel="noreferrer noopener nofollow">directorio Empresas Bogotá y Colombia</a></div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_a6cedd-b0","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_a6cedd-b0 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_a6cedd-b0">Venta <mark class="kt-highlight">Productos Belleza Yanbal </mark>en Bogotá  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p>Todo lo que necesita para su cuidado personal y belleza para mujeres, hombres, niños y bebés. A un click de distancia. Estamos en sector Cedritos, localidad Usaquén de Bogotá, Colombia.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_6681d1-86"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_6681d1-86"><!-- wp:kadence/singlebtn {"uniqueID":"6_c950f3-8a","text":"310 2605493 ","link":"tel://3102605493","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_768ad7-bb","text":"\\u003cstrong\\u003eWHTSAPP\\u003c/strong\\u003e","link":"https://wa.me/573102605493","target":"_blank","noFollow":true,"sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_b4fec4-a4","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_b4fec4-a4"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"align":"right","id":61,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_68d5d8-00","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<div class="wp-block-kadence-image kb-image6_68d5d8-00 is-style-rounded"><figure class="alignright size-full"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-capilar.webp" alt="" class="kb-img wp-image-61"/><figcaption>Cremas capilares Yanbal en Bogotá</figcaption></figure></div>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_df1818-ab","columns":1,"colLayout":"equal","bgColor":"#d8b078","align":"full","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_81be5f-2f","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_81be5f-2f"><div class="kt-inside-inner-col"><!-- wp:heading {"textAlign":"center"} -->\n<h2 class="wp-block-heading has-text-align-center">Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en BUCARAMANGA</h2>\n<!-- /wp:heading -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_77a6b0-e3","columns":3,"customRowGutter":[30,"",""],"columnGutter":"wider","customGutter":[64,"",""],"colLayout":"equal","inheritMaxWidth":true,"padding":["xxl","","xxl",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_887cf3-11","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_887cf3-11 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":64,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/productos-damas/","linkDestination":"custom","uniqueID":"6_20ede3-32","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_20ede3-32 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/productos-damas/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/cosmeticos-yanbal.webp" alt="" class="kb-img wp-image-64"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_fea0e4-34","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_fea0e4-34 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_fea0e4-34"><a href="https://yanbal.directorioempresascolombia.com/productos-damas/">Cosméticos para Mujer</a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_c10595-42","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_c10595-42 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_c10595-42">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_1bd929-fb","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_1bd929-fb inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":73,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/productos-caballero/","linkDestination":"custom","uniqueID":"6_69f357-84","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_69f357-84 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/productos-caballero/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/perfume-jaque.webp" alt="" class="kb-img wp-image-73"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_c19f9d-74","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_c19f9d-74 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_c19f9d-74"><a href="https://yanbal.directorioempresascolombia.com/productos-caballero/">Productos para Hombre </a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_9da24d-48","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_9da24d-48 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_9da24d-48">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":3,"borderWidth":["","","",""],"uniqueID":"6_3baf88-7a","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_3baf88-7a"><div class="kt-inside-inner-col"><!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_5d35c2-a0","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_5d35c2-a0 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":69,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/ninos-y-bebes/","linkDestination":"custom","uniqueID":"6_31853d-d1","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_31853d-d1 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/ninos-y-bebes/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/lociones-iluminadoras.webp" alt="" class="kb-img wp-image-69"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_78f3eb-a5","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_78f3eb-a5 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_78f3eb-a5"><a href="https://yanbal.directorioempresascolombia.com/ninos-y-bebes/">Cuidado de Niños y Bebés</a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_200eb7-45","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_200eb7-45 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_200eb7-45">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading"><br>Descubre la Belleza Natural con los productos Yanbal en Bucaramanga</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. <br>Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading"><br>La calidad en productos de belleza no se improvisa</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>En Yanbal Bucaramanga, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading"><br>Fragancias Yanbal Exclusivas para Cada Ocasión</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading"><br>No se Pierda las Ofertas y Promociones Especiales todos los Meses</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading"><br>Consejos o Tips de Belleza y Cuidado Personal</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>En nuestro blog, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.<br>Compra tus Productos Yanbal en Línea<br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo en línea, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2024-07-10 18:59:30', '2024-07-10 18:59:30', '', 6, 'https://yanbal.directorioempresascolombia.com/?p=151', 0, 'revision', '', 0),
(153, 1, '2024-07-10 19:03:00', '2024-07-10 19:03:00', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_6f84d4-a9","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_f75b67-fa","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_f75b67-fa"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_54cc80-50","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_693eff-7c","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_693eff-7c"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_ed3399-61","align":"left","color":"palette5","padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_ed3399-61 wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_ed3399-61"><a href="https://directorioempresascolombia.com/" target="_blank" rel="noreferrer noopener nofollow">directorio Empresas Bogotá y Colombia</a></div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_a6cedd-b0","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_a6cedd-b0 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_a6cedd-b0">Venta <mark class="kt-highlight">Productos Belleza Yanbal </mark>en Bogotá  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p>Todo lo que necesita para su cuidado personal y belleza para mujeres, hombres, niños y bebés. A un click de distancia. Estamos en sector Cedritos, localidad Usaquén de Bogotá, Colombia.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_6681d1-86"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_6681d1-86"><!-- wp:kadence/singlebtn {"uniqueID":"6_c950f3-8a","text":"310 2605493 ","link":"tel://3102605493","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_768ad7-bb","text":"\\u003cstrong\\u003eWHTSAPP\\u003c/strong\\u003e","link":"https://wa.me/573102605493","target":"_blank","noFollow":true,"sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_b4fec4-a4","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_b4fec4-a4"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"align":"right","id":61,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_68d5d8-00","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<div class="wp-block-kadence-image kb-image6_68d5d8-00 is-style-rounded"><figure class="alignright size-full"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-capilar.webp" alt="" class="kb-img wp-image-61"/><figcaption>Cremas capilares Yanbal en Bogotá</figcaption></figure></div>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_df1818-ab","columns":1,"colLayout":"equal","bgColor":"#d8b078","align":"full","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_81be5f-2f","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_81be5f-2f"><div class="kt-inside-inner-col"><!-- wp:heading {"textAlign":"center"} -->\n<h2 class="wp-block-heading has-text-align-center">Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en BUCARAMANGA</h2>\n<!-- /wp:heading -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_77a6b0-e3","columns":3,"customRowGutter":[30,"",""],"columnGutter":"wider","customGutter":[64,"",""],"colLayout":"equal","inheritMaxWidth":true,"padding":["xxl","","xxl",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_887cf3-11","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_887cf3-11 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":64,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/productos-damas/","linkDestination":"custom","uniqueID":"6_20ede3-32","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_20ede3-32 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/productos-damas/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/cosmeticos-yanbal.webp" alt="" class="kb-img wp-image-64"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_fea0e4-34","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_fea0e4-34 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_fea0e4-34"><a href="https://yanbal.directorioempresascolombia.com/productos-damas/">Cosméticos para Mujer</a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_c10595-42","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_c10595-42 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_c10595-42">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_1bd929-fb","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_1bd929-fb inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":73,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/productos-caballero/","linkDestination":"custom","uniqueID":"6_69f357-84","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_69f357-84 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/productos-caballero/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/perfume-jaque.webp" alt="" class="kb-img wp-image-73"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_c19f9d-74","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_c19f9d-74 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_c19f9d-74"><a href="https://yanbal.directorioempresascolombia.com/productos-caballero/">Productos para Hombre </a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_9da24d-48","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_9da24d-48 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_9da24d-48">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":3,"borderWidth":["","","",""],"uniqueID":"6_3baf88-7a","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_3baf88-7a"><div class="kt-inside-inner-col"><!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_5d35c2-a0","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_5d35c2-a0 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":69,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/ninos-y-bebes/","linkDestination":"custom","uniqueID":"6_31853d-d1","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_31853d-d1 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/ninos-y-bebes/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/lociones-iluminadoras.webp" alt="" class="kb-img wp-image-69"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_78f3eb-a5","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_78f3eb-a5 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_78f3eb-a5"><a href="https://yanbal.directorioempresascolombia.com/ninos-y-bebes/">Cuidado de Niños y Bebés</a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_200eb7-45","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_200eb7-45 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_200eb7-45">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading"><br>Descubre la Belleza Natural con los productos Yanbal en Bucaramanga</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. <br>Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading"><br>La calidad en productos de belleza no se improvisa</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>En Yanbal Bucaramanga, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading"><br>Fragancias Yanbal Exclusivas para Cada Ocasión</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading"><br>No se Pierda las Ofertas y Promociones Especiales todos los Meses</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading"><br>Consejos o Tips de Belleza y Cuidado Personal</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>En nuestro <strong><a href="https://www.yanbal.com/co//corporate/" target="_blank" rel="noreferrer noopener">blog Yambal</a></strong>, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading"><br>Compra tus Productos Yanbal en Bucaramanga y Colombia en el <a href="tl://3102605493">310 2605493</a></h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo en línea, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2024-07-10 19:03:00', '2024-07-10 19:03:00', '', 6, 'https://yanbal.directorioempresascolombia.com/?p=153', 0, 'revision', '', 0),
(155, 1, '2024-07-10 19:03:25', '2024-07-10 19:03:25', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_6f84d4-a9","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_f75b67-fa","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_f75b67-fa"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_54cc80-50","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_693eff-7c","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_693eff-7c"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_ed3399-61","align":"left","color":"palette5","padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_ed3399-61 wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_ed3399-61"><a href="https://directorioempresascolombia.com/" target="_blank" rel="noreferrer noopener nofollow">directorio Empresas Bogotá y Colombia</a></div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_a6cedd-b0","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_a6cedd-b0 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_a6cedd-b0">Venta <mark class="kt-highlight">Productos Belleza Yanbal </mark>en Bogotá  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p>Todo lo que necesita para su cuidado personal y belleza para mujeres, hombres, niños y bebés. A un click de distancia. Estamos en sector Cedritos, localidad Usaquén de Bogotá, Colombia.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_6681d1-86"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_6681d1-86"><!-- wp:kadence/singlebtn {"uniqueID":"6_c950f3-8a","text":"310 2605493 ","link":"tel://3102605493","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_768ad7-bb","text":"\\u003cstrong\\u003eWHTSAPP\\u003c/strong\\u003e","link":"https://wa.me/573102605493","target":"_blank","noFollow":true,"sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_b4fec4-a4","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_b4fec4-a4"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"align":"right","id":61,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_68d5d8-00","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<div class="wp-block-kadence-image kb-image6_68d5d8-00 is-style-rounded"><figure class="alignright size-full"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-capilar.webp" alt="" class="kb-img wp-image-61"/><figcaption>Cremas capilares Yanbal en Bogotá</figcaption></figure></div>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_df1818-ab","columns":1,"colLayout":"equal","bgColor":"#d8b078","align":"full","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_81be5f-2f","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_81be5f-2f"><div class="kt-inside-inner-col"><!-- wp:heading {"textAlign":"center"} -->\n<h2 class="wp-block-heading has-text-align-center">Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en BUCARAMANGA</h2>\n<!-- /wp:heading -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_77a6b0-e3","columns":3,"customRowGutter":[30,"",""],"columnGutter":"wider","customGutter":[64,"",""],"colLayout":"equal","inheritMaxWidth":true,"padding":["xxl","","xxl",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_887cf3-11","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_887cf3-11 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":64,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/productos-damas/","linkDestination":"custom","uniqueID":"6_20ede3-32","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_20ede3-32 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/productos-damas/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/cosmeticos-yanbal.webp" alt="" class="kb-img wp-image-64"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_fea0e4-34","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_fea0e4-34 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_fea0e4-34"><a href="https://yanbal.directorioempresascolombia.com/productos-damas/">Cosméticos para Mujer</a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_c10595-42","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_c10595-42 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_c10595-42">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_1bd929-fb","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_1bd929-fb inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":73,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/productos-caballero/","linkDestination":"custom","uniqueID":"6_69f357-84","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_69f357-84 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/productos-caballero/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/perfume-jaque.webp" alt="" class="kb-img wp-image-73"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_c19f9d-74","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_c19f9d-74 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_c19f9d-74"><a href="https://yanbal.directorioempresascolombia.com/productos-caballero/">Productos para Hombre </a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_9da24d-48","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_9da24d-48 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_9da24d-48">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":3,"borderWidth":["","","",""],"uniqueID":"6_3baf88-7a","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_3baf88-7a"><div class="kt-inside-inner-col"><!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_5d35c2-a0","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_5d35c2-a0 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":69,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/ninos-y-bebes/","linkDestination":"custom","uniqueID":"6_31853d-d1","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_31853d-d1 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/ninos-y-bebes/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/lociones-iluminadoras.webp" alt="" class="kb-img wp-image-69"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_78f3eb-a5","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_78f3eb-a5 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_78f3eb-a5"><a href="https://yanbal.directorioempresascolombia.com/ninos-y-bebes/">Cuidado de Niños y Bebés</a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_200eb7-45","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_200eb7-45 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_200eb7-45">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading"><br>Descubre la Belleza Natural con los productos Yanbal en Bucaramanga</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. <br>Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading"><br>La calidad en productos de belleza no se improvisa</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>En Yanbal Bucaramanga, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading"><br>Fragancias Yanbal Exclusivas para Cada Ocasión</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading"><br>No se Pierda las Ofertas y Promociones Especiales todos los Meses</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading"><br>Consejos o Tips de Belleza y Cuidado Personal</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>En nuestro <strong><a href="https://www.yanbal.com/co//corporate/" target="_blank" rel="noreferrer noopener">blog Yambal</a></strong>, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading"><br>Compra tus Productos Yanbal en Bucaramanga y Colombia en el <a href="tl://3102605493">310 2605493</a></h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2024-07-10 19:03:25', '2024-07-10 19:03:25', '', 6, 'https://yanbal.directorioempresascolombia.com/?p=155', 0, 'revision', '', 0);
INSERT INTO `hpp_posts` VALUES
(157, 1, '2024-07-10 19:13:52', '2024-07-10 19:13:52', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_6f84d4-a9","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_f75b67-fa","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_f75b67-fa"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_54cc80-50","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_693eff-7c","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_693eff-7c"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_ed3399-61","align":"left","color":"palette5","padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_ed3399-61 wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_ed3399-61"><a href="https://directorioempresascolombia.com/" target="_blank" rel="noreferrer noopener nofollow">directorio Empresas Bogotá y Colombia</a></div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_a6cedd-b0","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_a6cedd-b0 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_a6cedd-b0">Venta <mark class="kt-highlight">Productos Belleza Yanbal </mark>en Bucaramanga  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p><strong>Wilma Jaimes, Directora de Yanbal, </strong>la asesora sobre todo lo que necesita para su cuidado personal y belleza para mujeres, hombres, niños y bebés. A un click de distancia. Estamos en sector Cedritos, localidad Usaquén de Bogotá, Colombia.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_6681d1-86"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_6681d1-86"><!-- wp:kadence/singlebtn {"uniqueID":"6_c950f3-8a","text":"310 2605493 ","link":"tel://3102605493","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_768ad7-bb","text":"\\u003cstrong\\u003eWHTSAPP\\u003c/strong\\u003e","link":"https://wa.me/573102605493","target":"_blank","noFollow":true,"sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_b4fec4-a4","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_b4fec4-a4"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"align":"right","id":61,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_68d5d8-00","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<div class="wp-block-kadence-image kb-image6_68d5d8-00 is-style-rounded"><figure class="alignright size-full"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-capilar.webp" alt="" class="kb-img wp-image-61"/><figcaption>Cremas capilares Yanbal en Bogotá</figcaption></figure></div>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_df1818-ab","columns":1,"colLayout":"equal","bgColor":"#d8b078","align":"full","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_81be5f-2f","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_81be5f-2f"><div class="kt-inside-inner-col"><!-- wp:heading {"textAlign":"center"} -->\n<h2 class="wp-block-heading has-text-align-center">Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en BUCARAMANGA</h2>\n<!-- /wp:heading -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_77a6b0-e3","columns":3,"customRowGutter":[30,"",""],"columnGutter":"wider","customGutter":[64,"",""],"colLayout":"equal","inheritMaxWidth":true,"padding":["xxl","","xxl",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_887cf3-11","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_887cf3-11 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":64,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/productos-damas/","linkDestination":"custom","uniqueID":"6_20ede3-32","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_20ede3-32 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/productos-damas/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/cosmeticos-yanbal.webp" alt="" class="kb-img wp-image-64"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_fea0e4-34","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_fea0e4-34 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_fea0e4-34"><a href="https://yanbal.directorioempresascolombia.com/productos-damas/">Cosméticos para Mujer</a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_c10595-42","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_c10595-42 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_c10595-42">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_1bd929-fb","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_1bd929-fb inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":73,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/productos-caballero/","linkDestination":"custom","uniqueID":"6_69f357-84","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_69f357-84 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/productos-caballero/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/perfume-jaque.webp" alt="" class="kb-img wp-image-73"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_c19f9d-74","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_c19f9d-74 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_c19f9d-74"><a href="https://yanbal.directorioempresascolombia.com/productos-caballero/">Productos para Hombre </a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_9da24d-48","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_9da24d-48 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_9da24d-48">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":3,"borderWidth":["","","",""],"uniqueID":"6_3baf88-7a","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_3baf88-7a"><div class="kt-inside-inner-col"><!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_5d35c2-a0","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_5d35c2-a0 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":69,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/ninos-y-bebes/","linkDestination":"custom","uniqueID":"6_31853d-d1","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_31853d-d1 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/ninos-y-bebes/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/lociones-iluminadoras.webp" alt="" class="kb-img wp-image-69"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_78f3eb-a5","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_78f3eb-a5 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_78f3eb-a5"><a href="https://yanbal.directorioempresascolombia.com/ninos-y-bebes/">Cuidado de Niños y Bebés</a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_200eb7-45","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_200eb7-45 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_200eb7-45">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading"><br>Descubre la Belleza Natural con los productos Yanbal en Bucaramanga</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. <br>Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading"><br>La calidad en productos de belleza no se improvisa</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>En Yanbal Bucaramanga, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading"><br>Fragancias Yanbal Exclusivas para Cada Ocasión</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading"><br>No se Pierda las Ofertas y Promociones Especiales todos los Meses</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading"><br>Consejos o Tips de Belleza y Cuidado Personal</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>En nuestro <strong><a href="https://www.yanbal.com/co//corporate/" target="_blank" rel="noreferrer noopener">blog Yambal</a></strong>, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading"><br>Compra tus Productos Yanbal en Bucaramanga y Colombia en el <a href="tl://3102605493">310 2605493</a></h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2024-07-10 19:13:52', '2024-07-10 19:13:52', '', 6, 'https://yanbal.directorioempresascolombia.com/?p=157', 0, 'revision', '', 0),
(158, 1, '2024-07-10 19:14:55', '2024-07-10 19:14:55', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_6f84d4-a9","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_f75b67-fa","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_f75b67-fa"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_54cc80-50","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_693eff-7c","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_693eff-7c"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_ed3399-61","align":"left","color":"palette5","padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_ed3399-61 wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_ed3399-61"><a href="https://directorioempresascolombia.com/" target="_blank" rel="noreferrer noopener nofollow">directorio Empresas Bogotá y Colombia</a></div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_a6cedd-b0","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_a6cedd-b0 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_a6cedd-b0">Venta <mark class="kt-highlight">Productos Belleza Yanbal </mark>en Bucaramanga  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p><strong>Wilma Jaimes, Directora de Yanbal, </strong>la asesora sobre todo lo que necesita para su cuidado personal y belleza para mujeres, hombres, niños y bebés. A un click de distancia. Estamos en sector Cedritos, localidad Usaquén de Bogotá, Colombia.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_6681d1-86"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_6681d1-86"><!-- wp:kadence/singlebtn {"uniqueID":"6_c950f3-8a","text":"310 2605493 ","link":"tel://3102605493","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_768ad7-bb","text":"\\u003cstrong\\u003eWHATSAPP\\u003c/strong\\u003e","link":"https://wa.me/573102605493","target":"_blank","noFollow":true,"sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_b4fec4-a4","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_b4fec4-a4"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"align":"right","id":61,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_68d5d8-00","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<div class="wp-block-kadence-image kb-image6_68d5d8-00 is-style-rounded"><figure class="alignright size-full"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-capilar.webp" alt="" class="kb-img wp-image-61"/><figcaption>Cremas capilares Yanbal en Bogotá</figcaption></figure></div>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_df1818-ab","columns":1,"colLayout":"equal","bgColor":"#d8b078","align":"full","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_81be5f-2f","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_81be5f-2f"><div class="kt-inside-inner-col"><!-- wp:heading {"textAlign":"center"} -->\n<h2 class="wp-block-heading has-text-align-center">Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en BUCARAMANGA</h2>\n<!-- /wp:heading -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_77a6b0-e3","columns":3,"customRowGutter":[30,"",""],"columnGutter":"wider","customGutter":[64,"",""],"colLayout":"equal","inheritMaxWidth":true,"padding":["xxl","","xxl",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_887cf3-11","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_887cf3-11 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":64,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/productos-damas/","linkDestination":"custom","uniqueID":"6_20ede3-32","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_20ede3-32 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/productos-damas/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/cosmeticos-yanbal.webp" alt="" class="kb-img wp-image-64"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_fea0e4-34","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_fea0e4-34 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_fea0e4-34"><a href="https://yanbal.directorioempresascolombia.com/productos-damas/">Cosméticos para Mujer</a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_c10595-42","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_c10595-42 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_c10595-42">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_1bd929-fb","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_1bd929-fb inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":73,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/productos-caballero/","linkDestination":"custom","uniqueID":"6_69f357-84","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_69f357-84 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/productos-caballero/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/perfume-jaque.webp" alt="" class="kb-img wp-image-73"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_c19f9d-74","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_c19f9d-74 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_c19f9d-74"><a href="https://yanbal.directorioempresascolombia.com/productos-caballero/">Productos para Hombre </a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_9da24d-48","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_9da24d-48 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_9da24d-48">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":3,"borderWidth":["","","",""],"uniqueID":"6_3baf88-7a","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_3baf88-7a"><div class="kt-inside-inner-col"><!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_5d35c2-a0","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_5d35c2-a0 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":69,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/ninos-y-bebes/","linkDestination":"custom","uniqueID":"6_31853d-d1","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_31853d-d1 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/ninos-y-bebes/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/lociones-iluminadoras.webp" alt="" class="kb-img wp-image-69"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_78f3eb-a5","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_78f3eb-a5 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_78f3eb-a5"><a href="https://yanbal.directorioempresascolombia.com/ninos-y-bebes/">Cuidado de Niños y Bebés</a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_200eb7-45","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_200eb7-45 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_200eb7-45">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading"><br>Descubre la Belleza Natural con los productos Yanbal en Bucaramanga</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. <br>Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading"><br>La calidad en productos de belleza no se improvisa</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>En Yanbal Bucaramanga, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading"><br>Fragancias Yanbal Exclusivas para Cada Ocasión</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading"><br>No se Pierda las Ofertas y Promociones Especiales todos los Meses</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading"><br>Consejos o Tips de Belleza y Cuidado Personal</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>En nuestro <strong><a href="https://www.yanbal.com/co//corporate/" target="_blank" rel="noreferrer noopener">blog Yambal</a></strong>, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading"><br>Compra tus Productos Yanbal en Bucaramanga y Colombia en el <a href="tl://3102605493">310 2605493</a></h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2024-07-10 19:14:55', '2024-07-10 19:14:55', '', 6, 'https://yanbal.directorioempresascolombia.com/?p=158', 0, 'revision', '', 0),
(159, 1, '2024-07-10 20:08:23', '2024-07-10 20:08:23', '<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->\n<div class="wp-block-group alignfull"><!-- wp:kadence/rowlayout {"uniqueID":"6_6f84d4-a9","columns":1,"colLayout":"equal","align":"full","padding":["","","sm",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_f75b67-fa","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_f75b67-fa"><div class="kt-inside-inner-col"><!-- wp:kadence/rowlayout {"uniqueID":"6_54cc80-50","colLayout":"left-golden","align":"","verticalAlignment":"middle","firstColumnWidth":65,"secondColumnWidth":35,"inheritMaxWidth":true,"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_693eff-7c","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_693eff-7c"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"6_ed3399-61","align":"left","color":"palette5","padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"textTransform":"uppercase","colorClass":"theme-palette5","htmlTag":"div","fontSize":["sm","",""]} -->\n<div class="kt-adv-heading6_ed3399-61 wp-block-kadence-advancedheading has-theme-palette-5-color has-text-color" data-kb-block="kb-adv-heading6_ed3399-61"><a href="https://directorioempresascolombia.com/" target="_blank" rel="noreferrer noopener nofollow">directorio Empresas Bogotá y Colombia</a></div>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":1,"uniqueID":"6_a6cedd-b0","color":"palette3","margin":["0","","sm",""],"padding":["","","0",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["xxl","",""],"fontHeight":[1.1,"",""]} -->\n<h1 class="kt-adv-heading6_a6cedd-b0 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_a6cedd-b0">Venta <mark class="kt-highlight">Productos Belleza Yanbal </mark>en Bucaramanga  </h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph -->\n<p><strong>Wilma Jaimes, Directora de Yanbal, </strong>la asesora sobre todo lo que necesita para su cuidado personal y belleza para mujeres, hombres, niños y bebés. A un click de distancia. Estamos en sector Cedritos, localidad Usaquén de Bogotá, Colombia. Ver nuestro <strong><a href="https://docs.yanbal.com/cdigital/co/2024/c7/oficial/" target="_blank" rel="noreferrer noopener">CATÁLOGO</a></strong>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:kadence/advancedbtn {"uniqueID":"6_6681d1-86"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns6_6681d1-86"><!-- wp:kadence/singlebtn {"uniqueID":"6_c950f3-8a","text":"310 2605493 ","link":"tel://3102605493","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"6_768ad7-bb","text":"\\u003cstrong\\u003eWHATSAPP\\u003c/strong\\u003e","link":"https://wa.me/573102605493","target":"_blank","noFollow":true,"sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_b4fec4-a4","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_b4fec4-a4"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"align":"right","id":61,"imgMaxWidth":377,"sizeSlug":"full","linkDestination":"none","uniqueID":"6_68d5d8-00","borderRadius":[35,35,"",""],"displayBoxShadow":true,"className":"is-style-rounded"} -->\n<div class="wp-block-kadence-image kb-image6_68d5d8-00 is-style-rounded"><figure class="alignright size-full"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-capilar.webp" alt="" class="kb-img wp-image-61"/><figcaption>Cremas capilares Yanbal en Bogotá</figcaption></figure></div>\n<!-- /wp:kadence/image --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div>\n<!-- /wp:group -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_df1818-ab","columns":1,"colLayout":"equal","bgColor":"#d8b078","align":"full","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_81be5f-2f","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_81be5f-2f"><div class="kt-inside-inner-col"><!-- wp:heading {"textAlign":"center"} -->\n<h2 class="wp-block-heading has-text-align-center">Bienvenido a Yanbal Cosméticos: Tu Destino para la Belleza en BUCARAMANGA</h2>\n<!-- /wp:heading -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_77a6b0-e3","columns":3,"customRowGutter":[30,"",""],"columnGutter":"wider","customGutter":[64,"",""],"colLayout":"equal","inheritMaxWidth":true,"padding":["xxl","","xxl",""],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_887cf3-11","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_887cf3-11 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":64,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/productos-damas/","linkDestination":"custom","uniqueID":"6_20ede3-32","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_20ede3-32 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/productos-damas/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/cosmeticos-yanbal.webp" alt="" class="kb-img wp-image-64"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_fea0e4-34","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_fea0e4-34 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_fea0e4-34"><a href="https://yanbal.directorioempresascolombia.com/productos-damas/">Cosméticos para Mujer</a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_c10595-42","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_c10595-42 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_c10595-42">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"6_1bd929-fb","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_1bd929-fb inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":73,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/productos-caballero/","linkDestination":"custom","uniqueID":"6_69f357-84","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_69f357-84 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/productos-caballero/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/perfume-jaque.webp" alt="" class="kb-img wp-image-73"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_c19f9d-74","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_c19f9d-74 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_c19f9d-74"><a href="https://yanbal.directorioempresascolombia.com/productos-caballero/">Productos para Hombre </a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_9da24d-48","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_9da24d-48 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_9da24d-48">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":3,"borderWidth":["","","",""],"uniqueID":"6_3baf88-7a","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_3baf88-7a"><div class="kt-inside-inner-col"><!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_5d35c2-a0","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column6_5d35c2-a0 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/image {"id":69,"sizeSlug":"full","ratio":"land169","useRatio":true,"link":"https://yanbal.directorioempresascolombia.com/ninos-y-bebes/","linkDestination":"custom","uniqueID":"6_31853d-d1","marginDesktop":["","","sm",""],"borderStyle":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<figure class="wp-block-kadence-image kb-image6_31853d-d1 size-full kb-image-is-ratio-size"><a href="https://yanbal.directorioempresascolombia.com/ninos-y-bebes/" class="kb-advanced-image-link"><div class="kb-is-ratio-image kb-image-ratio-land169"><img src="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/lociones-iluminadoras.webp" alt="" class="kb-img wp-image-69"/></div></a></figure>\n<!-- /wp:kadence/image -->\n\n<!-- wp:kadence/advancedheading {"uniqueID":"6_78f3eb-a5","align":"center","color":"palette3","margin":["0","","xs",""],"markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette3","fontSize":["lg","",""],"fontHeight":[1.2,"",""],"maxWidth":[480,"",""]} -->\n<h2 class="kt-adv-heading6_78f3eb-a5 wp-block-kadence-advancedheading has-theme-palette-3-color has-text-color" data-kb-block="kb-adv-heading6_78f3eb-a5"><a href="https://yanbal.directorioempresascolombia.com/ninos-y-bebes/">Cuidado de Niños y Bebés</a></h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:kadence/advancedheading {"level":3,"uniqueID":"6_200eb7-45","color":"palette4","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"colorClass":"theme-palette4","htmlTag":"p","fontSize":[null,"",""],"fontHeightType":"em","maxWidth":[375,"",""]} -->\n<p class="kt-adv-heading6_200eb7-45 wp-block-kadence-advancedheading has-theme-palette-4-color has-text-color" data-kb-block="kb-adv-heading6_200eb7-45">Add context to your column. Help visitors understand the value they can get from your products and services.</p>\n<!-- /wp:kadence/advancedheading --></div></div>\n<!-- /wp:kadence/column --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"6_dab910-6a","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"6_0c61eb-71","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column6_0c61eb-71"><div class="kt-inside-inner-col"><!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading"><br>Descubre la Belleza Natural con los productos Yanbal en Bucaramanga</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>En Yanbal, estamos comprometidos en brindarte productos de belleza de alta calidad que realzan tu naturalidad y resaltan tu belleza única. Nuestro amplio catálogo de cosméticos Yanbal es la respuesta a tus necesidades de cuidado de la piel, maquillaje y fragancias exclusivas. <br>Explora nuestra gama de productos y sumérgete en el mundo de la belleza con Yanbal.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading"><br>La calidad en productos de belleza no se improvisa</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>En Yanbal Bucaramanga, nos enorgullecemos de ofrecer una amplia selección de productos de belleza que cumplen con los más altos estándares de calidad. Nuestros maquillajes Yanbal están diseñados para durar todo el día, manteniendo tu aspecto fresco y radiante. Además, nuestros productos para el cuidado de la piel Yanbal están formulados con ingredientes de última generación para brindarte una piel sana y luminosa.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading"><br>Fragancias Yanbal Exclusivas para Cada Ocasión</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>¿Buscas la fragancia perfecta para cada ocasión? En Yanbal, tenemos una variedad de perfumes Yanbal que se adaptan a tu estilo y personalidad. Desde fragancias sutiles y frescas hasta aromas más intensos y sensuales, encontrarás la elección perfecta para cada momento de tu vida. Tenemos excelentes opciones tanto para mujeres como para hombre.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading"><br>No se Pierda las Ofertas y Promociones Especiales todos los Meses</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>No te pierdas nuestras increíbles ofertas Yanbal y promociones especiales. Estamos comprometidos en ofrecerte productos de belleza de alta calidad a precios accesibles. Consulta nuestro catálogo Yanbal en línea y descubre las oportunidades que tenemos para ti.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading"><br>Consejos o Tips de Belleza y Cuidado Personal</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>En nuestro <strong><a href="https://www.yanbal.com/co//corporate/" target="_blank" rel="noreferrer noopener">blog Yambal</a></strong>, encontrarás una amplia gama de consejos de belleza y cuidado personal para ayudarte a sacar el máximo provecho de tus productos Yanbal. Desde tutoriales de maquillaje hasta rutinas de cuidado de la piel, estamos aquí para brindarte orientación y consejos para realzar tu belleza natural.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {"level":3} -->\n<h3 class="wp-block-heading"><br>Compra tus Productos Yanbal en Bucaramanga y Colombia en el <a href="tl://3102605493">310 2605493</a></h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p><br>En Yanbal, facilitamos la compra de nuestros productos. Explora nuestro catálogo, elige tus productos favoritos y disfruta de la comodidad de comprar desde la comodidad de tu hogar. Con envío seguro y rápido, tu belleza está a solo un clic de distancia.<br>Yanbal Cosméticos, tu destino para la belleza natural. Descubre la diferencia Yanbal hoy mismo. Para mayor información puedes ver aquí nuestro catálogo de productos. Incluso.si lo desea, puedes descargarlo a tu computador.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'INICIO', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2024-07-10 20:08:23', '2024-07-10 20:08:23', '', 6, 'https://yanbal.directorioempresascolombia.com/?p=159', 0, 'revision', '', 0),
(164, 1, '2024-07-15 21:05:40', '2024-07-15 21:05:40', '<!-- wp:kadence/rowlayout {"uniqueID":"28_ca6d6d-5e","columns":1,"colLayout":"equal","bgColor":"palette8","bgColorClass":"theme-palette8","borderRadius":[33,33,33,33],"padding":[25,"",20,""],"margin":["","",45,""],"borderStyle":[{"top":["palette6","",1],"right":["palette6","",1],"bottom":["palette6","",1],"left":["palette6","",1],"unit":"px"}],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"28_8da69a-42","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column28_8da69a-42 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"28_205d9d-74","align":"center","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletMarkBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"mobileMarkBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<h2 class="kt-adv-heading28_205d9d-74 wp-block-kadence-advancedheading" data-kb-block="kb-adv-heading28_205d9d-74">Catálogo de Productos Yanbal en Colombia y Bucaramanga</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph {"align":"center"} -->\n<p class="has-text-align-center">Gran variedad de productos de belleza para dama, para caballeros y niños a un click de distancia. Comunicarse con la Directora y Consultora Wilma Jaiames.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"28_bd1e2c-57","kbVersion":2,"className":"inner-column-2"} -->\n<div class="wp-block-kadence-column kadence-column28_bd1e2c-57 inner-column-2"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedbtn {"uniqueID":"28_1e7ba6-f3"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns28_1e7ba6-f3"><!-- wp:kadence/singlebtn {"uniqueID":"28_f589c1-14","text":"310 2605493 ","link":"tel://3102605493","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"28_893782-3f","text":"\\u003cstrong\\u003eWHATSAPP\\u003c/strong\\u003e","link":"https://wa.me/573102605493","target":"_blank","noFollow":true,"sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"28_40f8da-63","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"28_3722b7-2b","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column28_3722b7-2b"><div class="kt-inside-inner-col"><!-- wp:file {"id":95,"href":"https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf","displayPreview":true,"previewHeight":1040} -->\n<div class="wp-block-file"><object class="wp-block-file__embed" data="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf" type="application/pdf" style="width:100%;height:1040px" aria-label="Catalogo Yanbal"></object><a id="wp-block-file--media-a53c01e9-207d-4225-8df1-93c8967b6d69" href="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf">Catalogo Yanbal</a><a href="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf" class="wp-block-file__button wp-element-button" download aria-describedby="wp-block-file--media-a53c01e9-207d-4225-8df1-93c8967b6d69">Download</a></div>\n<!-- /wp:file --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'Catalogo Yanbal 2025', '', 'inherit', 'closed', 'closed', '', '28-revision-v1', '', '', '2024-07-15 21:05:40', '2024-07-15 21:05:40', '', 28, 'https://yanbal.directorioempresascolombia.com/?p=164', 0, 'revision', '', 0);
INSERT INTO `hpp_posts` VALUES
(163, 1, '2024-07-15 21:05:15', '2024-07-15 21:05:15', '<!-- wp:kadence/rowlayout {"uniqueID":"28_ca6d6d-5e","colLayout":"left-golden","bgColor":"palette8","firstColumnWidth":75,"secondColumnWidth":25,"bgColorClass":"theme-palette8","borderRadius":[33,33,33,33],"padding":[25,"",20,""],"margin":["","",45,""],"borderStyle":[{"top":["palette6","",1],"right":["palette6","",1],"bottom":["palette6","",1],"left":["palette6","",1],"unit":"px"}],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"28_8da69a-42","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column28_8da69a-42 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"28_205d9d-74","align":"center","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletMarkBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"mobileMarkBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<h2 class="kt-adv-heading28_205d9d-74 wp-block-kadence-advancedheading" data-kb-block="kb-adv-heading28_205d9d-74">Catálogo de Productos Yanbal en Colombia y Bucaramanga</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph {"align":"center"} -->\n<p class="has-text-align-center">Gran variedad de productos de belleza para dama, para caballeros y niños a un click de distancia. Comunicarse con la Directora y Consultora Wilma Jaiames.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"28_bd1e2c-57","kbVersion":2,"className":"inner-column-2"} -->\n<div class="wp-block-kadence-column kadence-column28_bd1e2c-57 inner-column-2"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedbtn {"uniqueID":"28_1e7ba6-f3"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns28_1e7ba6-f3"><!-- wp:kadence/singlebtn {"uniqueID":"28_f589c1-14","text":"310 2605493 ","link":"tel://3102605493","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"28_893782-3f","text":"\\u003cstrong\\u003eWHATSAPP\\u003c/strong\\u003e","link":"https://wa.me/573102605493","target":"_blank","noFollow":true,"sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"28_40f8da-63","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"28_3722b7-2b","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column28_3722b7-2b"><div class="kt-inside-inner-col"><!-- wp:file {"id":95,"href":"https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf","displayPreview":true,"previewHeight":1040} -->\n<div class="wp-block-file"><object class="wp-block-file__embed" data="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf" type="application/pdf" style="width:100%;height:1040px" aria-label="Catalogo Yanbal"></object><a id="wp-block-file--media-a53c01e9-207d-4225-8df1-93c8967b6d69" href="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf">Catalogo Yanbal</a><a href="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf" class="wp-block-file__button wp-element-button" download aria-describedby="wp-block-file--media-a53c01e9-207d-4225-8df1-93c8967b6d69">Download</a></div>\n<!-- /wp:file --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'Catalogo Yanbal 2025', '', 'inherit', 'closed', 'closed', '', '28-revision-v1', '', '', '2024-07-15 21:05:15', '2024-07-15 21:05:15', '', 28, 'https://yanbal.directorioempresascolombia.com/?p=163', 0, 'revision', '', 0),
(162, 1, '2024-07-15 21:02:56', '2024-07-15 21:02:56', '<!-- wp:kadence/rowlayout {"uniqueID":"28_ca6d6d-5e","colLayout":"left-golden","bgColor":"palette8","firstColumnWidth":75,"secondColumnWidth":25,"bgColorClass":"theme-palette8","borderRadius":[33,33,33,33],"padding":[25,"",20,""],"margin":["","",45,""],"borderStyle":[{"top":["palette6","",1],"right":["palette6","",1],"bottom":["palette6","",1],"left":["palette6","",1],"unit":"px"}],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"28_8da69a-42","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column28_8da69a-42 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"28_205d9d-74","align":"center","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletMarkBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"mobileMarkBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<h2 class="kt-adv-heading28_205d9d-74 wp-block-kadence-advancedheading" data-kb-block="kb-adv-heading28_205d9d-74">Catálogo de Productos Yanbal en Colombia y Bucaramanga</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph {"align":"center"} -->\n<p class="has-text-align-center">Gran variedad de productos de belleza para dama, para caballeros y niños a un click de distancia. Comunicarse con la Directora y Consultora Wilma Jaiames.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"28_bd1e2c-57","kbVersion":2,"className":"inner-column-2"} -->\n<div class="wp-block-kadence-column kadence-column28_bd1e2c-57 inner-column-2"><div class="kt-inside-inner-col"><!-- wp:buttons -->\n<div class="wp-block-buttons"><!-- wp:button {"width":100,"style":{"border":{"radius":"17px"}},"fontSize":"medium"} -->\n<div class="wp-block-button has-custom-width wp-block-button__width-100 has-custom-font-size has-medium-font-size"><a class="wp-block-button__link wp-element-button" href="tel://3203008533" style="border-radius:17px" target="_blank" rel="noreferrer noopener">Herman Pinto Pabón<br>320 3008533</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"28_40f8da-63","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"28_3722b7-2b","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column28_3722b7-2b"><div class="kt-inside-inner-col"><!-- wp:file {"id":95,"href":"https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf","displayPreview":true,"previewHeight":1040} -->\n<div class="wp-block-file"><object class="wp-block-file__embed" data="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf" type="application/pdf" style="width:100%;height:1040px" aria-label="Catalogo Yanbal"></object><a id="wp-block-file--media-a53c01e9-207d-4225-8df1-93c8967b6d69" href="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf">Catalogo Yanbal</a><a href="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf" class="wp-block-file__button wp-element-button" download aria-describedby="wp-block-file--media-a53c01e9-207d-4225-8df1-93c8967b6d69">Download</a></div>\n<!-- /wp:file --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'Catalogo Yanbal 2025', '', 'inherit', 'closed', 'closed', '', '28-revision-v1', '', '', '2024-07-15 21:02:56', '2024-07-15 21:02:56', '', 28, 'https://yanbal.directorioempresascolombia.com/?p=162', 0, 'revision', '', 0),
(165, 1, '2024-07-15 21:05:49', '2024-07-15 21:05:49', '<!-- wp:kadence/rowlayout {"uniqueID":"28_ca6d6d-5e","columns":1,"colLayout":"equal","bgColor":"palette8","bgColorClass":"theme-palette8","borderRadius":[33,33,33,33],"padding":[25,"",20,""],"margin":["","",45,""],"borderStyle":[{"top":["palette6","",1],"right":["palette6","",1],"bottom":["palette6","",1],"left":["palette6","",1],"unit":"px"}],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"28_8da69a-42","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column28_8da69a-42 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"uniqueID":"28_205d9d-74","align":"center","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletMarkBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"mobileMarkBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<h2 class="kt-adv-heading28_205d9d-74 wp-block-kadence-advancedheading" data-kb-block="kb-adv-heading28_205d9d-74">Catálogo de Productos Yanbal en Colombia y Bucaramanga</h2>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph {"align":"center"} -->\n<p class="has-text-align-center">Gran variedad de productos de belleza para dama, para caballeros y niños a un click de distancia. Comunicarse con la Directora y Consultora Wilma Jaimes.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"28_bd1e2c-57","kbVersion":2,"className":"inner-column-2"} -->\n<div class="wp-block-kadence-column kadence-column28_bd1e2c-57 inner-column-2"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedbtn {"uniqueID":"28_1e7ba6-f3"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns28_1e7ba6-f3"><!-- wp:kadence/singlebtn {"uniqueID":"28_f589c1-14","text":"310 2605493 ","link":"tel://3102605493","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"28_893782-3f","text":"\\u003cstrong\\u003eWHATSAPP\\u003c/strong\\u003e","link":"https://wa.me/573102605493","target":"_blank","noFollow":true,"sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"28_40f8da-63","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"28_3722b7-2b","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column28_3722b7-2b"><div class="kt-inside-inner-col"><!-- wp:file {"id":95,"href":"https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf","displayPreview":true,"previewHeight":1040} -->\n<div class="wp-block-file"><object class="wp-block-file__embed" data="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf" type="application/pdf" style="width:100%;height:1040px" aria-label="Catalogo Yanbal"></object><a id="wp-block-file--media-a53c01e9-207d-4225-8df1-93c8967b6d69" href="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf">Catalogo Yanbal</a><a href="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf" class="wp-block-file__button wp-element-button" download aria-describedby="wp-block-file--media-a53c01e9-207d-4225-8df1-93c8967b6d69">Download</a></div>\n<!-- /wp:file --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'Catalogo Yanbal 2025', '', 'inherit', 'closed', 'closed', '', '28-revision-v1', '', '', '2024-07-15 21:05:49', '2024-07-15 21:05:49', '', 28, 'https://yanbal.directorioempresascolombia.com/?p=165', 0, 'revision', '', 0),
(166, 1, '2024-07-15 21:06:21', '2024-07-15 21:06:21', '<!-- wp:kadence/rowlayout {"uniqueID":"28_ca6d6d-5e","columns":1,"colLayout":"equal","bgColor":"palette8","bgColorClass":"theme-palette8","borderRadius":[33,33,33,33],"padding":[25,"",20,""],"margin":["","",45,""],"borderStyle":[{"top":["palette6","",1],"right":["palette6","",1],"bottom":["palette6","",1],"left":["palette6","",1],"unit":"px"}],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"28_8da69a-42","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column28_8da69a-42 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"level":1,"uniqueID":"28_205d9d-74","align":"center","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletMarkBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"mobileMarkBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<h1 class="kt-adv-heading28_205d9d-74 wp-block-kadence-advancedheading" data-kb-block="kb-adv-heading28_205d9d-74">Catálogo de Productos Yanbal en Colombia y Bucaramanga</h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph {"align":"center"} -->\n<p class="has-text-align-center">Gran variedad de productos de belleza para dama, para caballeros y niños a un click de distancia. Comunicarse con la Directora y Consultora Wilma Jaimes.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"28_bd1e2c-57","kbVersion":2,"className":"inner-column-2"} -->\n<div class="wp-block-kadence-column kadence-column28_bd1e2c-57 inner-column-2"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedbtn {"uniqueID":"28_1e7ba6-f3"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns28_1e7ba6-f3"><!-- wp:kadence/singlebtn {"uniqueID":"28_f589c1-14","text":"310 2605493 ","link":"tel://3102605493","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"28_893782-3f","text":"\\u003cstrong\\u003eWHATSAPP\\u003c/strong\\u003e","link":"https://wa.me/573102605493","target":"_blank","noFollow":true,"sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"28_40f8da-63","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"28_3722b7-2b","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column28_3722b7-2b"><div class="kt-inside-inner-col"><!-- wp:file {"id":95,"href":"https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf","displayPreview":true,"previewHeight":1040} -->\n<div class="wp-block-file"><object class="wp-block-file__embed" data="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf" type="application/pdf" style="width:100%;height:1040px" aria-label="Catalogo Yanbal"></object><a id="wp-block-file--media-a53c01e9-207d-4225-8df1-93c8967b6d69" href="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf">Catalogo Yanbal</a><a href="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf" class="wp-block-file__button wp-element-button" download aria-describedby="wp-block-file--media-a53c01e9-207d-4225-8df1-93c8967b6d69">Download</a></div>\n<!-- /wp:file --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'Catalogo Yanbal 2025', '', 'inherit', 'closed', 'closed', '', '28-revision-v1', '', '', '2024-07-15 21:06:21', '2024-07-15 21:06:21', '', 28, 'https://yanbal.directorioempresascolombia.com/?p=166', 0, 'revision', '', 0),
(168, 1, '2024-07-15 21:08:45', '2024-07-15 21:08:45', '<!-- wp:kadence/rowlayout {"uniqueID":"28_ca6d6d-5e","columns":1,"colLayout":"equal","bgColor":"palette8","bgColorClass":"theme-palette8","borderRadius":[33,33,33,33],"padding":[25,"",20,""],"margin":["","",45,""],"borderStyle":[{"top":["palette6","",1],"right":["palette6","",1],"bottom":["palette6","",1],"left":["palette6","",1],"unit":"px"}],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"28_8da69a-42","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column28_8da69a-42 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"level":1,"uniqueID":"28_205d9d-74","align":"center","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletMarkBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"mobileMarkBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<h1 class="kt-adv-heading28_205d9d-74 wp-block-kadence-advancedheading" data-kb-block="kb-adv-heading28_205d9d-74">Catálogo de Productos Yanbal en Colombia y Bucaramanga</h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph {"align":"center"} -->\n<p class="has-text-align-center">Gran variedad de productos de belleza para dama, para caballeros y niños a un click de distancia. Comunicarse con la Directora y Consultora Wilma Jaimes.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"28_bd1e2c-57","kbVersion":2,"className":"inner-column-2"} -->\n<div class="wp-block-kadence-column kadence-column28_bd1e2c-57 inner-column-2"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedbtn {"uniqueID":"28_1e7ba6-f3"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns28_1e7ba6-f3"><!-- wp:kadence/singlebtn {"uniqueID":"28_f589c1-14","text":"310 2605493 ","link":"tel://3102605493","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"28_893782-3f","text":"\\u003cstrong\\u003eWHATSAPP\\u003c/strong\\u003e","link":"https://wa.me/573102605493","target":"_blank","noFollow":true,"sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'H1 botones', '', 'publish', 'closed', 'closed', '', 'h1-botones', '', '', '2024-07-15 21:08:45', '2024-07-15 21:08:45', '', 0, 'https://yanbal.directorioempresascolombia.com/h1-botones/', 0, 'wp_block', '', 0),
(169, 1, '2024-07-15 21:09:25', '2024-07-15 21:09:25', '<!-- wp:kadence/rowlayout {"uniqueID":"28_e79c37-d7","columns":1,"colLayout":"equal","bgColor":"palette8","bgColorClass":"theme-palette8","borderRadius":[33,33,33,33],"padding":[25,"",20,""],"margin":["","",45,""],"borderStyle":[{"top":["palette6","",1],"right":["palette6","",1],"bottom":["palette6","",1],"left":["palette6","",1],"unit":"px"}],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"28_345e3b-c1","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column28_345e3b-c1 inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"level":1,"uniqueID":"28_4ee18c-ed","align":"center","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletMarkBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"mobileMarkBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<h1 class="kt-adv-heading28_4ee18c-ed wp-block-kadence-advancedheading" data-kb-block="kb-adv-heading28_4ee18c-ed">Catálogo de Productos Yanbal en Colombia y Bucaramanga</h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph {"align":"center"} -->\n<p class="has-text-align-center">Gran variedad de productos de belleza para dama, para caballeros y niños a un click de distancia. Comunicarse con la Directora y Consultora Wilma Jaimes.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"28_c41a87-b7","kbVersion":2,"className":"inner-column-2"} -->\n<div class="wp-block-kadence-column kadence-column28_c41a87-b7 inner-column-2"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedbtn {"uniqueID":"28_3e64a5-11"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns28_3e64a5-11"><!-- wp:kadence/singlebtn {"uniqueID":"28_0db9af-bd","text":"310 2605493 ","link":"tel://3102605493","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"28_9d975b-a9","text":"\\u003cstrong\\u003eWHATSAPP\\u003c/strong\\u003e","link":"https://wa.me/573102605493","target":"_blank","noFollow":true,"sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->\n\n<!-- wp:kadence/rowlayout {"uniqueID":"28_40f8da-63","columns":1,"colLayout":"equal","kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"28_3722b7-2b","kbVersion":2} -->\n<div class="wp-block-kadence-column kadence-column28_3722b7-2b"><div class="kt-inside-inner-col"><!-- wp:file {"id":95,"href":"https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf","displayPreview":true,"previewHeight":1040} -->\n<div class="wp-block-file"><object class="wp-block-file__embed" data="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf" type="application/pdf" style="width:100%;height:1040px" aria-label="Catalogo Yanbal"></object><a id="wp-block-file--media-a53c01e9-207d-4225-8df1-93c8967b6d69" href="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf">Catalogo Yanbal</a><a href="https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf" class="wp-block-file__button wp-element-button" download aria-describedby="wp-block-file--media-a53c01e9-207d-4225-8df1-93c8967b6d69">Download</a></div>\n<!-- /wp:file --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'Catalogo Yanbal 2025', '', 'inherit', 'closed', 'closed', '', '28-autosave-v1', '', '', '2024-07-15 21:09:25', '2024-07-15 21:09:25', '', 28, 'https://yanbal.directorioempresascolombia.com/?p=169', 0, 'revision', '', 0),
(170, 1, '2024-07-15 21:11:34', '2024-07-15 21:11:34', '<!-- wp:kadence/rowlayout {"uniqueID":"119_0da8d4-59","columns":1,"colLayout":"equal","bgColor":"palette8","bgColorClass":"theme-palette8","borderRadius":[33,33,33,33],"padding":[25,"",20,""],"margin":["","",45,""],"borderStyle":[{"top":["palette6","",1],"right":["palette6","",1],"bottom":["palette6","",1],"left":["palette6","",1],"unit":"px"}],"kbVersion":2} -->\n<!-- wp:kadence/column {"borderWidth":["","","",""],"uniqueID":"119_74b8a8-3b","kbVersion":2,"className":"inner-column-1"} -->\n<div class="wp-block-kadence-column kadence-column119_74b8a8-3b inner-column-1"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedheading {"level":1,"uniqueID":"119_d825c6-d0","align":"center","markBorder":"","markBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"tabletMarkBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}],"mobileMarkBorderStyles":[{"top":[null,"",""],"right":[null,"",""],"bottom":[null,"",""],"left":[null,"",""],"unit":"px"}]} -->\n<h1 class="kt-adv-heading119_d825c6-d0 wp-block-kadence-advancedheading" data-kb-block="kb-adv-heading119_d825c6-d0">Oferta empleo como Consultora Yanbal</h1>\n<!-- /wp:kadence/advancedheading -->\n\n<!-- wp:paragraph {"align":"center"} -->\n<p class="has-text-align-center">Muy fácil convertirse de Consultora de Yanbal en Colombia y convertirse en emprendedora independiente. Favor comunicarse con la Directora y Consultora Wilma Jaimes.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:kadence/column -->\n\n<!-- wp:kadence/column {"id":2,"borderWidth":["","","",""],"uniqueID":"119_e5df77-1c","kbVersion":2,"className":"inner-column-2"} -->\n<div class="wp-block-kadence-column kadence-column119_e5df77-1c inner-column-2"><div class="kt-inside-inner-col"><!-- wp:kadence/advancedbtn {"uniqueID":"119_8702c9-4b"} -->\n<div class="wp-block-kadence-advancedbtn kb-buttons-wrap kb-btns119_8702c9-4b"><!-- wp:kadence/singlebtn {"uniqueID":"119_54c199-10","text":"310 2605493 ","link":"tel://3102605493","target":"_blank","sizePreset":"large","backgroundHover":"palette3","icon":"fe_phoneMissed","iconSide":"left","inheritStyles":"inherit"} /-->\n\n<!-- wp:kadence/singlebtn {"uniqueID":"119_72d917-5b","text":"\\u003cstrong\\u003eWHATSAPP\\u003c/strong\\u003e","link":"https://wa.me/573102605493","target":"_blank","noFollow":true,"sizePreset":"large","inheritStyles":"inherit"} /--></div>\n<!-- /wp:kadence/advancedbtn --></div></div>\n<!-- /wp:kadence/column -->\n<!-- /wp:kadence/rowlayout -->', 'Oferta Empleo', '', 'inherit', 'closed', 'closed', '', '119-revision-v1', '', '', '2024-07-15 21:11:34', '2024-07-15 21:11:34', '', 119, 'https://yanbal.directorioempresascolombia.com/?p=170', 0, 'revision', '', 0);

-- --------------------------------------------------------

--
-- Table structure for table `hpp_termmeta`
--

CREATE TABLE `hpp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `hpp_terms`
--

CREATE TABLE `hpp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `hpp_terms`
--

INSERT INTO `hpp_terms` VALUES
(1, 'Uncategorized', 'uncategorized', 0),
(2, 'Principal', 'principal', 0);

-- --------------------------------------------------------

--
-- Table structure for table `hpp_term_relationships`
--

CREATE TABLE `hpp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `hpp_term_relationships`
--

INSERT INTO `hpp_term_relationships` VALUES
(26, 2, 0),
(27, 2, 0),
(23, 2, 0),
(22, 2, 0),
(21, 2, 0),
(20, 2, 0),
(24, 2, 0),
(30, 2, 0),
(122, 2, 0),
(121, 2, 0),
(124, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `hpp_term_taxonomy`
--

CREATE TABLE `hpp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `hpp_term_taxonomy`
--

INSERT INTO `hpp_term_taxonomy` VALUES
(1, 1, 'category', '', 0, 0),
(2, 2, 'nav_menu', '', 0, 10);

-- --------------------------------------------------------

--
-- Table structure for table `hpp_usermeta`
--

CREATE TABLE `hpp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `hpp_usermeta`
--

INSERT INTO `hpp_usermeta` VALUES
(1, 1, 'nickname', '14Pinto21'),
(2, 1, 'first_name', ''),
(3, 1, 'last_name', ''),
(4, 1, 'description', ''),
(5, 1, 'rich_editing', 'true'),
(6, 1, 'syntax_highlighting', 'true'),
(7, 1, 'comment_shortcuts', 'false'),
(8, 1, 'admin_color', 'fresh'),
(9, 1, 'use_ssl', '0'),
(10, 1, 'show_admin_bar_front', 'true'),
(11, 1, 'locale', ''),
(12, 1, 'hpp_capabilities', 'a:1:{s:13:"administrator";b:1;}'),
(13, 1, 'hpp_user_level', '10'),
(14, 1, 'dismissed_wp_pointers', ''),
(15, 1, 'show_welcome_panel', '1'),
(16, 1, 'session_tokens', 'a:1:{s:64:"ae90b06cf9b15b03b16340b496e8838a38fb018938f57bf865fe8c3b2c3be9af";a:4:{s:10:"expiration";i:1723507174;s:2:"ip";s:12:"186.84.88.77";s:2:"ua";s:111:"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36";s:5:"login";i:1723334374;}}'),
(17, 1, 'bglibDashboardOrder', '1'),
(18, 1, 'jetpack_tracks_anon_id', 'jetpack:Td2eT9QW5oELgCnW2jlQDZDH'),
(19, 1, 'hpp_dashboard_quick_press_last_post_id', '172'),
(20, 1, 'community-events-location', 'a:1:{s:2:"ip";s:11:"186.84.88.0";}'),
(35, 2, 'nickname', '59Pinto67'),
(36, 2, 'first_name', 'Herman'),
(37, 2, 'last_name', ''),
(38, 2, 'description', ''),
(39, 2, 'rich_editing', 'true'),
(40, 2, 'syntax_highlighting', 'true'),
(41, 2, 'comment_shortcuts', 'false'),
(42, 2, 'admin_color', 'fresh'),
(43, 2, 'use_ssl', '0'),
(44, 2, 'show_admin_bar_front', 'true'),
(45, 2, 'locale', ''),
(46, 2, 'hpp_capabilities', 'a:1:{s:13:"administrator";b:1;}'),
(47, 2, 'hpp_user_level', '10'),
(48, 2, '_yoast_wpseo_profile_updated', '1703641119'),
(49, 2, 'dismissed_wp_pointers', ''),
(28, 1, 'hpp_yoast_notifications', 'a:1:{i:0;a:2:{s:7:"message";s:319:"<p>Because of a change in your home URL setting, some of your SEO data needs to be reprocessed.</p><p>We estimate this will take less than a minute.</p><a class="button" href="https://yanbal.directorioempresascolombia.com/BogotA/wp-admin/admin.php?page=wpseo_tools&start-indexation=true">Start SEO data optimization</a>";s:7:"options";a:10:{s:4:"type";s:7:"warning";s:2:"id";s:13:"wpseo-reindex";s:7:"user_id";i:1;s:5:"nonce";N;s:8:"priority";d:0.8000000000000000444089209850062616169452667236328125;s:9:"data_json";a:0:{}s:13:"dismissal_key";N;s:12:"capabilities";s:20:"wpseo_manage_options";s:16:"capability_check";s:3:"all";s:14:"yoast_branding";b:0;}}}'),
(23, 1, 'hpp_persisted_preferences', 'a:4:{s:14:"core/edit-post";a:2:{s:26:"isComplementaryAreaVisible";b:1;s:12:"welcomeGuide";b:0;}s:9:"_modified";s:24:"2024-07-10T19:01:12.817Z";s:4:"core";a:1:{s:10:"openPanels";a:2:{i:0;s:11:"post-status";i:1;s:24:"yoast-seo/document-panel";}}s:17:"core/block-editor";a:1:{s:25:"linkControlSettingsDrawer";b:1;}}'),
(24, 1, '_yoast_wpseo_profile_updated', '1694777876'),
(25, 1, 'managenav-menuscolumnshidden', 'a:5:{i:0;s:11:"link-target";i:1;s:11:"css-classes";i:2;s:3:"xfn";i:3;s:11:"description";i:4;s:15:"title-attribute";}'),
(26, 1, 'metaboxhidden_nav-menus', 'a:1:{i:0;s:12:"add-post_tag";}'),
(27, 1, 'nav_menu_recently_edited', '2'),
(29, 1, 'hpp_user-settings', 'libraryContent=browse'),
(30, 1, 'hpp_user-settings-time', '1694786766'),
(31, 1, 'hpp_googlesitekit_redirect_url', 'https://yanbal.directorioempresascolombia.com/BogotA/wp-admin/admin.php?page=googlesitekit-dashboard&slug=analytics&reAuth=true'),
(33, 1, 'hpp_googlesitekit_site_verification_file', '37e943a406d42988'),
(34, 1, 'hpp_googlesitekit_tracking_optin', '1');

-- --------------------------------------------------------

--
-- Table structure for table `hpp_users`
--

CREATE TABLE `hpp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `hpp_users`
--

INSERT INTO `hpp_users` VALUES
(1, '14Pinto21', '$P$BV99wiCGZHsBmc1aRgo4m1xDQ1qWZb/', '14pinto21', 'pintoherman44@gmail.com', 'https://yanbal.directorioempresascolombia.com/BogotA', '2023-09-15 11:33:22', '', 0, '14Pinto21'),
(2, '59Pinto67', '$P$B9zQKNf2yrYubpuXKPw8LOCyBv6JcX/', '59pinto67', 'hpinto44@gmail.com', '', '2023-12-27 01:38:39', '1703641119:$P$BBXlX08xq7.hGXCverjhm0I3IpVym..', 0, 'Herman');

-- --------------------------------------------------------

--
-- Table structure for table `hpp_wpforms_lite`
--

CREATE TABLE `hpp_wpforms_lite` (
  `rid` int(10) NOT NULL AUTO_INCREMENT,
  `start` bigint(20) NOT NULL,
  `end` bigint(20) NOT NULL,
  `status` tinyint(2) NOT NULL DEFAULT 1,
  `date` int(10) NOT NULL,
  PRIMARY KEY (`rid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `hpp_yoast_indexable`
--

CREATE TABLE `hpp_yoast_indexable` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `permalink` longtext DEFAULT NULL,
  `permalink_hash` varchar(40) DEFAULT NULL,
  `object_id` bigint(20) DEFAULT NULL,
  `object_type` varchar(32) NOT NULL,
  `object_sub_type` varchar(32) DEFAULT NULL,
  `author_id` bigint(20) DEFAULT NULL,
  `post_parent` bigint(20) DEFAULT NULL,
  `title` text DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `breadcrumb_title` text DEFAULT NULL,
  `post_status` varchar(20) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT 0,
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int(11) unsigned DEFAULT NULL,
  `canonical` longtext DEFAULT NULL,
  `primary_focus_keyword` varchar(191) DEFAULT NULL,
  `primary_focus_keyword_score` int(3) DEFAULT NULL,
  `readability_score` int(3) DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT 0,
  `is_robots_noindex` tinyint(1) DEFAULT 0,
  `is_robots_nofollow` tinyint(1) DEFAULT 0,
  `is_robots_noarchive` tinyint(1) DEFAULT 0,
  `is_robots_noimageindex` tinyint(1) DEFAULT 0,
  `is_robots_nosnippet` tinyint(1) DEFAULT 0,
  `twitter_title` text DEFAULT NULL,
  `twitter_image` longtext DEFAULT NULL,
  `twitter_description` longtext DEFAULT NULL,
  `twitter_image_id` varchar(191) DEFAULT NULL,
  `twitter_image_source` text DEFAULT NULL,
  `open_graph_title` text DEFAULT NULL,
  `open_graph_description` longtext DEFAULT NULL,
  `open_graph_image` longtext DEFAULT NULL,
  `open_graph_image_id` varchar(191) DEFAULT NULL,
  `open_graph_image_source` text DEFAULT NULL,
  `open_graph_image_meta` mediumtext DEFAULT NULL,
  `link_count` int(11) DEFAULT NULL,
  `incoming_link_count` int(11) DEFAULT NULL,
  `prominent_words_version` int(11) unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  `schema_page_type` varchar(64) DEFAULT NULL,
  `schema_article_type` varchar(64) DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT 0,
  `estimated_reading_time_minutes` int(11) DEFAULT NULL,
  `version` int(11) DEFAULT 1,
  `object_last_modified` datetime DEFAULT NULL,
  `object_published_at` datetime DEFAULT NULL,
  `inclusive_language_score` int(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`),
  KEY `published_sitemap_index` (`object_published_at`,`is_robots_noindex`,`object_type`,`object_sub_type`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

--
-- Dumping data for table `hpp_yoast_indexable`
--

INSERT INTO `hpp_yoast_indexable` VALUES
(4, 'https://yanbal.directorioempresascolombia.com/', '46:ebb1a43945cc0284b316a8203da04c29', NULL, 'home-page', NULL, NULL, NULL, '%%sitename%% %%page%% %%sep%% %%sitedesc%%', 'Perfumes, lociones, cremas y todo para mujeres. hombres y niños. Directora y Consultora Wilma Jaimes.', 'Home', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, NULL, NULL, '%%sitename%%', '', '', '0', NULL, NULL, NULL, NULL, NULL, '2023-09-15 11:37:40', '2024-07-15 21:14:17', 1, NULL, NULL, NULL, NULL, 0, NULL, 2, '2024-07-15 21:14:17', NULL, NULL),
(5, 'https://yanbal.directorioempresascolombia.com/category/uncategorized/', '69:f3dc18f458878e147070fa7eca43bc7a', 1, 'term', 'category', NULL, NULL, NULL, NULL, 'Uncategorized', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, '2023-09-15 11:37:54', '2023-09-15 12:37:56', 1, NULL, NULL, NULL, NULL, 0, NULL, 2, '2023-09-15 11:33:22', '2023-09-15 11:33:22', NULL),
(6, 'https://yanbal.directorioempresascolombia.com/', '46:ebb1a43945cc0284b316a8203da04c29', 6, 'post', 'page', 1, 0, NULL, 'Venta de productos de belleza Yanbal para mujeres, hombres y nños como perfumes, lociones, cremas y todo para el maquillaje femenino.', 'INICIO', 'publish', NULL, 0, NULL, NULL, NULL, 'venta yanbal', 64, 90, 0, NULL, 0, NULL, NULL, NULL, NULL, 'https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-capilar.webp', NULL, NULL, 'first-content-image', NULL, NULL, 'https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-capilar.webp', NULL, 'first-content-image', NULL, 6, NULL, NULL, '2023-09-15 11:37:54', '2024-07-10 20:08:24', 1, NULL, NULL, NULL, NULL, 0, 4, 2, '2024-07-10 20:08:24', '2023-09-15 11:37:54', 0),
(7, 'https://yanbal.directorioempresascolombia.com/contacto/', '55:55ee03ffa7b5c8b1cb7dee8ddf2dcabb', 8, 'post', 'page', 1, 0, NULL, NULL, 'Contacto', 'publish', NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, NULL, '2023-09-15 11:38:19', '2024-07-10 14:52:23', 1, NULL, NULL, NULL, NULL, 0, 0, 2, '2023-09-15 11:38:23', '2023-09-15 11:38:19', 0),
(8, 'https://yanbal.directorioempresascolombia.com/blog/', '51:3459d66528de69512503e6ef7600248a', 10, 'post', 'page', 1, 0, NULL, NULL, 'Blog', 'publish', NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, '2023-09-15 11:38:41', '2023-09-15 12:01:04', 1, NULL, NULL, NULL, NULL, 0, 0, 2, '2023-09-15 11:38:46', '2023-09-15 11:38:41', 0),
(9, 'https://yanbal.directorioempresascolombia.com/productos-damas/', '62:89a131e004206dcb568df6b2eb4da61e', 12, 'post', 'page', 1, 0, NULL, NULL, 'Productos Damas', 'publish', NULL, 0, NULL, NULL, NULL, NULL, NULL, 90, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, NULL, '2023-09-15 11:40:22', '2023-09-15 10:53:25', 1, NULL, NULL, NULL, NULL, 0, 2, 2, '2023-09-15 12:10:58', '2023-09-15 11:40:22', 0),
(10, 'https://yanbal.directorioempresascolombia.com/productos-caballero/', '66:dc36bde889d0f01cb04061a5a038ae1d', 14, 'post', 'page', 1, 0, NULL, NULL, 'Productos Caballero', 'publish', NULL, 0, NULL, NULL, NULL, NULL, NULL, 90, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 2, NULL, '2023-09-15 11:41:00', '2023-09-15 11:01:31', 1, NULL, NULL, NULL, NULL, 0, 0, 2, '2023-09-15 12:08:25', '2023-09-15 11:41:00', 0),
(11, 'https://yanbal.directorioempresascolombia.com/ninos-y-bebes/', '60:d893ea47ecde99cc03fd87c609d0272c', 16, 'post', 'page', 1, 0, NULL, NULL, 'Niños y Bebes', 'publish', NULL, 0, NULL, NULL, NULL, NULL, NULL, 60, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 2, NULL, '2023-09-15 11:41:42', '2023-09-15 16:22:43', 1, NULL, NULL, NULL, NULL, 0, 3, 2, '2023-09-15 16:22:43', '2023-09-15 11:41:41', 0),
(12, 'https://yanbal.directorioempresascolombia.com/bijouterie/', '57:c81e23994fbcd0bbef3e96df235c9cf3', 18, 'post', 'page', 1, 0, NULL, NULL, 'Bijouterie', 'publish', NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, '2023-09-15 11:42:46', '2023-09-15 12:02:34', 1, NULL, NULL, NULL, NULL, 0, 0, 2, '2023-09-15 11:42:47', '2023-09-15 11:42:46', 0),
(13, 'https://yanbal.directorioempresascolombia.com/catalogo-yanbal/', '62:89eb3da29f31daa20cbb5e7772ff443a', 28, 'post', 'page', 1, 0, NULL, NULL, 'Catalogo Yanbal 2025', 'publish', NULL, 0, NULL, NULL, NULL, NULL, NULL, 90, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2, NULL, NULL, '2023-09-15 11:45:20', '2024-07-15 21:06:21', 1, NULL, NULL, NULL, NULL, 0, 1, 2, '2024-07-15 21:06:21', '2023-09-15 11:45:20', 0),
(15, NULL, NULL, NULL, 'system-page', '404', NULL, NULL, 'Page not found %%sep%% %%sitename%%', NULL, 'Error 404: Page not found', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 0, 0, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2023-09-15 11:56:32', '2023-09-15 11:56:32', 1, NULL, NULL, NULL, NULL, 0, NULL, 1, NULL, NULL, NULL),
(16, NULL, NULL, NULL, 'system-page', 'search-result', NULL, NULL, 'You searched for %%searchphrase%% %%page%% %%sep%% %%sitename%%', NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 0, 0, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2023-09-15 12:37:56', '2023-09-15 12:37:56', 1, NULL, NULL, NULL, NULL, 0, NULL, 1, NULL, NULL, NULL),
(17, NULL, NULL, NULL, 'date-archive', NULL, NULL, NULL, '%%date%% %%page%% %%sep%% %%sitename%%', '', NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 0, 0, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2023-09-15 12:37:56', '2023-09-15 12:37:56', 1, NULL, NULL, NULL, NULL, 0, NULL, 1, NULL, NULL, NULL),
(18, 'https://yanbal.directorioempresascolombia.com/oferta-del-mes/', '61:9c9da95073915924816ba666fc7636c3', 115, 'post', 'page', 1, 0, NULL, NULL, 'Oferta del Mes', 'publish', NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, '2023-09-15 15:08:11', '2023-09-15 15:08:12', 1, NULL, NULL, NULL, NULL, 0, 0, 2, '2023-09-15 15:08:12', '2023-09-15 15:08:11', 0),
(19, 'https://yanbal.directorioempresascolombia.com/oferta-empleo/', '60:3af72cba844b4a9a7525b9dca36cd5ff', 119, 'post', 'page', 1, 0, NULL, NULL, 'Oferta Empleo', 'publish', NULL, 0, NULL, NULL, NULL, 'Oferta empleo Yanbal', 28, 90, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, '2023-09-15 15:10:31', '2024-07-15 21:12:42', 1, NULL, NULL, NULL, NULL, 0, 1, 2, '2024-07-15 21:12:42', '2023-09-15 15:10:31', 0),
(20, 'https://yanbal.directorioempresascolombia.com/?p=124', '52:b7cd1d2f148362d49703037905e6e14e', 124, 'post', 'post', 1, 0, NULL, NULL, 'Empresa Yanbal', 'draft', 0, 0, NULL, NULL, NULL, NULL, NULL, 30, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2023-09-15 15:29:59', '2023-09-15 15:32:08', 1, NULL, NULL, NULL, NULL, 0, 2, 2, '2023-09-15 15:32:08', '0000-00-00 00:00:00', 0);

-- --------------------------------------------------------

--
-- Table structure for table `hpp_yoast_indexable_hierarchy`
--

CREATE TABLE `hpp_yoast_indexable_hierarchy` (
  `indexable_id` int(11) unsigned NOT NULL,
  `ancestor_id` int(11) unsigned NOT NULL,
  `depth` int(11) unsigned DEFAULT NULL,
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

--
-- Dumping data for table `hpp_yoast_indexable_hierarchy`
--

INSERT INTO `hpp_yoast_indexable_hierarchy` VALUES
(4, 0, 0, 1),
(16, 0, 0, 1),
(5, 0, 0, 1),
(6, 0, 0, 1),
(7, 0, 0, 1),
(8, 0, 0, 1),
(9, 0, 0, 1),
(10, 0, 0, 1),
(11, 0, 0, 1),
(12, 0, 0, 1),
(13, 0, 0, 1),
(18, 0, 0, 1),
(19, 0, 0, 1),
(20, 0, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `hpp_yoast_migrations`
--

CREATE TABLE `hpp_yoast_migrations` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hpp_yoast_migrations_version` (`version`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

--
-- Dumping data for table `hpp_yoast_migrations`
--

INSERT INTO `hpp_yoast_migrations` VALUES
(1, '20171228151840'),
(2, '20171228151841'),
(3, '20190529075038'),
(4, '20191011111109'),
(5, '20200408101900'),
(6, '20200420073606'),
(7, '20200428123747'),
(8, '20200428194858'),
(9, '20200429105310'),
(10, '20200430075614'),
(11, '20200430150130'),
(12, '20200507054848'),
(13, '20200513133401'),
(14, '20200609154515'),
(15, '20200616130143'),
(16, '20200617122511'),
(17, '20200702141921'),
(18, '20200728095334'),
(19, '20201202144329'),
(20, '20201216124002'),
(21, '20201216141134'),
(22, '20210817092415'),
(23, '20211020091404'),
(24, '20230417083836');

-- --------------------------------------------------------

--
-- Table structure for table `hpp_yoast_primary_term`
--

CREATE TABLE `hpp_yoast_primary_term` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) DEFAULT NULL,
  `term_id` bigint(20) DEFAULT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- --------------------------------------------------------

--
-- Table structure for table `hpp_yoast_seo_links`
--

CREATE TABLE `hpp_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) DEFAULT NULL,
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `target_post_id` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(8) DEFAULT NULL,
  `indexable_id` int(11) unsigned DEFAULT NULL,
  `target_indexable_id` int(11) unsigned DEFAULT NULL,
  `height` int(11) unsigned DEFAULT NULL,
  `width` int(11) unsigned DEFAULT NULL,
  `size` int(11) unsigned DEFAULT NULL,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

--
-- Dumping data for table `hpp_yoast_seo_links`
--

INSERT INTO `hpp_yoast_seo_links` VALUES
(27, 'https://www.yanbal.com/co//corporate/', 6, NULL, 'external', 6, NULL, NULL, NULL, NULL, NULL, NULL),
(25, 'https://wa.me/573102605493', 6, NULL, 'external', 6, NULL, NULL, NULL, NULL, NULL, NULL),
(26, 'tel://3102605493', 6, NULL, 'external', 6, NULL, NULL, NULL, NULL, NULL, NULL),
(9, 'https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/crema-capilar.webp', 6, 61, 'image-in', 6, NULL, 400, 408, 29808, NULL, NULL),
(15, 'https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/lociones-iluminadoras.webp', 6, 69, 'image-in', 6, NULL, 400, 408, 19208, NULL, NULL),
(14, 'https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/perfume-jaque.webp', 6, 73, 'image-in', 6, NULL, 400, 408, 27016, NULL, NULL),
(13, 'https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/cosmeticos-yanbal.webp', 6, 64, 'image-in', 6, NULL, 400, 386, 34156, NULL, NULL),
(16, 'https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf', 28, NULL, 'internal', 13, NULL, NULL, NULL, NULL, NULL, NULL),
(17, 'https://yanbal.directorioempresascolombia.com/BogotA/wp-content/uploads/2023/09/COL_2023_C10.pdf', 28, NULL, 'internal', 13, NULL, NULL, NULL, NULL, NULL, NULL),
(18, 'https://yanbal.directorioempresascolombia.com/productos-damas/', 6, 12, 'internal', 6, 9, NULL, NULL, NULL, NULL, NULL),
(19, 'https://yanbal.directorioempresascolombia.com/productos-caballero/', 6, 14, 'internal', 6, 10, NULL, NULL, NULL, NULL, NULL),
(20, 'https://yanbal.directorioempresascolombia.com/productos-caballero/', 6, 14, 'internal', 6, 10, NULL, NULL, NULL, NULL, NULL),
(21, 'https://yanbal.directorioempresascolombia.com/ninos-y-bebes/', 6, 16, 'internal', 6, 11, NULL, NULL, NULL, NULL, NULL),
(22, 'https://yanbal.directorioempresascolombia.com/ninos-y-bebes/', 6, 16, 'internal', 6, 11, NULL, NULL, NULL, NULL, NULL),
(23, 'https://directorioempresascolombia.com/', 6, NULL, 'external', 6, NULL, NULL, NULL, NULL, NULL, NULL),
(24, 'tel://3203008533', 16, NULL, 'external', 11, NULL, NULL, NULL, NULL, NULL, NULL),
(28, 'tl://3102605493', 6, NULL, 'external', 6, NULL, NULL, NULL, NULL, NULL, NULL),
(29, 'https://docs.yanbal.com/cdigital/co/2024/c7/oficial/', 6, NULL, 'external', 6, NULL, NULL, NULL, NULL, NULL, NULL),
(31, 'tel://3102605493', 28, NULL, 'external', 13, NULL, NULL, NULL, NULL, NULL, NULL),
(32, 'https://wa.me/573102605493', 28, NULL, 'external', 13, NULL, NULL, NULL, NULL, NULL, NULL),
(33, 'tel://3102605493', 119, NULL, 'external', 19, NULL, NULL, NULL, NULL, NULL, NULL),
(34, 'https://wa.me/573102605493', 119, NULL, 'external', 19, NULL, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
